/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SherlockException;
import com.coditory.sherlock.sql.SqlLockQueries;
import com.coditory.sherlock.sql.SqlTableInitializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;

class SqlDistributedLockConnector
implements DistributedLockConnector {
    private final SqlTableInitializer sqlTableInitializer;
    private final SqlLockQueries sqlQueries;
    private final Clock clock;

    SqlDistributedLockConnector(DataSource dataSource, String tableName, Clock clock) {
        Preconditions.expectNonNull((Object)dataSource, (String)"dataSource");
        Preconditions.expectNonEmpty((String)tableName, (String)"tableName");
        Preconditions.expectNonNull((Object)clock, (String)"clock");
        this.clock = clock;
        this.sqlQueries = new SqlLockQueries(tableName);
        this.sqlTableInitializer = new SqlTableInitializer(this.sqlQueries, dataSource);
    }

    public void initialize() {
        try {
            Connection connection = this.getInitializedConnection();
            connection.close();
        }
        catch (Throwable e) {
            throw new SherlockException("Could not initialize SQL table", e);
        }
    }

    public boolean acquire(@NotNull LockRequest lockRequest) {
        boolean bl;
        block8: {
            Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
            Instant now = this.now();
            Connection connection = this.getInitializedConnection();
            try {
                boolean bl2 = bl = this.updateReleasedLock(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not acquire lock: " + String.valueOf(lockRequest), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean acquireOrProlong(@NotNull LockRequest lockRequest) {
        boolean bl;
        block8: {
            Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
            Instant now = this.now();
            Connection connection = this.getInitializedConnection();
            try {
                boolean bl2 = bl = this.updateAcquiredOrReleasedLock(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not acquire or prolong lock: " + String.valueOf(lockRequest), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean forceAcquire(@NotNull LockRequest lockRequest) {
        boolean bl;
        block8: {
            Preconditions.expectNonNull((Object)lockRequest, (String)"lockRequest");
            Instant now = this.now();
            Connection connection = this.getInitializedConnection();
            try {
                boolean bl2 = bl = this.updateLockById(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not force acquire lock: " + String.valueOf(lockRequest), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    private boolean updateReleasedLock(Connection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.lockId();
        Instant expiresAt = this.expiresAt(now, lockRequest.duration());
        try (PreparedStatement statement = connection.prepareStatement(this.sqlQueries.updateReleasedLock());){
            statement.setString(1, lockRequest.ownerId());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            statement.setTimestamp(5, this.timestamp(now));
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean updateAcquiredOrReleasedLock(Connection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.lockId();
        Instant expiresAt = this.expiresAt(now, lockRequest.duration());
        try (PreparedStatement statement = connection.prepareStatement(this.sqlQueries.updateAcquiredOrReleasedLock());){
            statement.setString(1, lockRequest.ownerId());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            statement.setString(5, lockRequest.ownerId());
            statement.setTimestamp(6, this.timestamp(now));
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean updateLockById(Connection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.lockId();
        Instant expiresAt = this.expiresAt(now, lockRequest.duration());
        try (PreparedStatement statement = connection.prepareStatement(this.sqlQueries.updateLockById());){
            statement.setString(1, lockRequest.ownerId());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean insertLock(Connection connection, LockRequest lockRequest, Instant now) throws SQLException {
        boolean bl;
        block8: {
            String lockId = lockRequest.lockId();
            Instant expiresAt = this.expiresAt(now, lockRequest.duration());
            PreparedStatement statement = connection.prepareStatement(this.sqlQueries.insertLock());
            try {
                statement.setString(1, lockId);
                statement.setString(2, lockRequest.ownerId());
                statement.setTimestamp(3, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 4, expiresAt);
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean release(@NotNull String lockId, @NotNull String ownerId) {
        Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        Preconditions.expectNonNull((Object)ownerId, (String)"ownerId");
        try (Connection connection = this.getInitializedConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.sqlQueries.deleteAcquiredByIdAndOwnerId());
                try {
                    statement.setString(1, lockId);
                    statement.setString(2, ownerId);
                    statement.setTimestamp(3, this.timestamp(this.now()));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new SherlockException("Could not release lock: " + lockId + ", owner: " + ownerId, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean forceRelease(@NotNull String lockId) {
        Preconditions.expectNonNull((Object)lockId, (String)"lockId");
        try (Connection connection = this.getInitializedConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.sqlQueries.deleteAcquiredById());
                try {
                    statement.setString(1, lockId);
                    statement.setTimestamp(2, this.timestamp(this.now()));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release lock: " + lockId, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean forceReleaseAll() {
        try (Connection connection = this.getInitializedConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.sqlQueries.deleteAll());
                try {
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not force release all locks", e);
        }
    }

    private Instant now() {
        return this.clock.instant();
    }

    private Instant expiresAt(Instant now, Duration duration) {
        if (duration == null) {
            return null;
        }
        return now.plus(duration);
    }

    private void setupOptionalTimestamp(PreparedStatement statement, int index, Instant instant) throws SQLException {
        if (instant != null) {
            statement.setTimestamp(index, this.timestamp(instant));
        } else {
            statement.setNull(index, 93);
        }
    }

    private Timestamp timestamp(Instant instant) {
        return new Timestamp(instant.toEpochMilli());
    }

    private Connection getInitializedConnection() throws SQLException {
        return this.sqlTableInitializer.getInitializedConnection();
    }
}

