/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.coditory.sherlock.sql.SqlDistributedLockConnector;
import java.time.Clock;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;

public final class SqlSherlock
extends SherlockWithConnectorBuilder<SqlSherlock> {
    public static final String DEFAULT_LOCKS_TABLE_NAME = "locks";
    private String tableName = "locks";
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;
    private DataSource dataSource;

    @NotNull
    public static SqlSherlock builder() {
        return new SqlSherlock();
    }

    @NotNull
    public static Sherlock create(@NotNull DataSource dataSource) {
        Preconditions.expectNonNull((Object)dataSource, (String)"dataSource");
        return SqlSherlock.builder().withDataSource(dataSource).build();
    }

    private SqlSherlock() {
    }

    @NotNull
    public SqlSherlock withDataSource(@NotNull DataSource dataSource) {
        Preconditions.expectNonNull((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
        return this;
    }

    @NotNull
    public SqlSherlock withLocksTable(@NotNull String tableName) {
        this.tableName = Preconditions.expectNonEmpty((String)tableName, (String)"tableName");
        return this;
    }

    @NotNull
    public SqlSherlock withClock(@NotNull Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"clock");
        return this;
    }

    @NotNull
    public Sherlock build() {
        Preconditions.expectNonNull((Object)this.dataSource, (String)"dataSource");
        SqlDistributedLockConnector connector = new SqlDistributedLockConnector(this.dataSource, this.tableName, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

