/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock.sql;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.sql.SqlLockQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;

class SqlTableInitializer {
    private final SqlLockQueries sqlQueries;
    private final DataSource dataSource;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    SqlTableInitializer(SqlLockQueries sqlQueries, DataSource dataSource) {
        Preconditions.expectNonNull((Object)sqlQueries, (String)"sqlQueries");
        Preconditions.expectNonNull((Object)dataSource, (String)"dataSource");
        this.sqlQueries = sqlQueries;
        this.dataSource = dataSource;
    }

    Connection getInitializedConnection() throws SQLException {
        return this.initialized.compareAndSet(false, true) ? this.initialize() : this.getConnection();
    }

    private Connection initialize() throws SQLException {
        Connection connection = this.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(this.sqlQueries.createLocksTable());
            statement.executeUpdate(this.sqlQueries.createLocksIndex());
            connection.commit();
            this.initialized.set(true);
        }
        catch (SQLException e) {
            try (PreparedStatement statement2 = connection.prepareStatement(this.sqlQueries.checkTableExits());){
                statement2.executeQuery();
                this.initialized.set(true);
            }
            catch (SQLException checkException) {
                throw new IllegalStateException("Could not initialize locks table", e);
            }
        }
        return connection;
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }
}

