/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem;

import com.cognifide.qa.bb.guice.ThreadScoped;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.openqa.selenium.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadScoped
public class AemAuthCookieFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AemAuthCookieFactory.class);
    @Inject
    private Properties properties;
    @Inject
    private CloseableHttpClient httpClient;
    private final Map<String, Cookie> cookieJar = new HashMap<String, Cookie>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie getCookie(String url, String login, String password) {
        if (!this.cookieJar.containsKey(url)) {
            HttpPost loginPost = new HttpPost(url + "/libs/granite/core/content/login.html/j_security_check");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("_charset_", "utf-8"));
            nameValuePairs.add(new BasicNameValuePair("j_username", login));
            nameValuePairs.add(new BasicNameValuePair("j_password", password));
            nameValuePairs.add(new BasicNameValuePair("j_validate", "true"));
            BasicCookieStore cookieStore = new BasicCookieStore();
            HttpClientContext context = HttpClientContext.create();
            if ("true".equals(this.properties.getProperty("webdriver.secure.proxy.cookie"))) {
                this.addProxyCookie((CookieStore)cookieStore);
            }
            context.setCookieStore((CookieStore)cookieStore);
            try {
                loginPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                CloseableHttpResponse loginResponse = this.httpClient.execute((HttpUriRequest)loginPost, (HttpContext)context);
                loginResponse.close();
            }
            catch (IOException e) {
                LOG.error("Can't get AEM authentication cookie", (Throwable)e);
            }
            finally {
                loginPost.reset();
            }
            Cookie cookie = AemAuthCookieFactory.findAuthenticationCookie(cookieStore.getCookies());
            if (cookie != null) {
                this.cookieJar.put(url, cookie);
            }
        }
        return this.cookieJar.get(url);
    }

    public void removeCookie(String url) {
        this.cookieJar.remove(url);
    }

    private static Cookie findAuthenticationCookie(List<org.apache.http.cookie.Cookie> cookies) {
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            if (!"login-token".equals(cookie.getName())) continue;
            return new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getExpiryDate());
        }
        return null;
    }

    private void addProxyCookie(CookieStore cookieStore) {
        BasicClientCookie proxyCookie = new BasicClientCookie(this.properties.getProperty("webdriver.secure.proxy.cookie_name"), this.properties.getProperty("webdriver.secure.proxy.cookie_value"));
        proxyCookie.setDomain(this.properties.getProperty("webdriver.secure.proxy.cookie_domain"));
        proxyCookie.setPath("/");
        cookieStore.addCookie((org.apache.http.cookie.Cookie)proxyCookie);
    }
}

