/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem;

import com.cognifide.qa.bb.aem.AemAuthCookieFactory;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.openqa.selenium.WebDriver;

public class AemLogin {
    @Inject
    private WebDriver webDriver;
    @Inject
    private AemAuthCookieFactory aemAuthCookieFactory;
    @Inject
    @Named(value="author.url")
    private String authorUrl;
    @Inject
    @Named(value="author.login")
    private String authorLoginProperty;
    @Inject
    @Named(value="author.password")
    private String authorPassword;

    public void authorLogin(String login, String password) {
        this.login(this.authorUrl, login, password);
    }

    public void authorLogin() {
        this.login(this.authorUrl, this.authorLoginProperty, this.authorPassword);
    }

    public void authorLogout() {
        this.logout(this.authorUrl);
    }

    public void login(String url, String login, String password) {
        this.webDriver.get(url + "/libs/granite/core/content/login.html");
        this.webDriver.manage().addCookie(this.aemAuthCookieFactory.getCookie(url, login, password));
    }

    public void logout(String url) {
        this.webDriver.get(url + "/system/sling/logout.html");
        this.aemAuthCookieFactory.removeCookie(url);
    }
}

