/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem.content;

import com.cognifide.qa.bb.aem.content.CrxRequestSender;
import com.cognifide.qa.bb.aem.content.RequestBuilder;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class ContentInstaller {
    private static final String CONTENT_PATH = System.getProperty("content.path", "src/main/content");
    @Inject
    private CrxRequestSender sender;
    @Inject
    private RequestBuilder builder;

    public void installAemPackage(String packageName) throws IOException {
        String packagePath = String.format("/etc/packages/%s.zip", packageName);
        HttpPost request = this.builder.createInstallRequest(packagePath);
        this.sender.sendCrxRequest((HttpUriRequest)request);
    }

    public void activateAemPackage(String packageName) throws IOException {
        HttpPost upload = this.builder.createUploadRequest();
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("package", new File(CONTENT_PATH, packageName), ContentType.DEFAULT_BINARY, packageName);
        entityBuilder.addTextBody("force", "true");
        upload.setEntity(entityBuilder.build());
        JsonObject result = this.sender.sendCrxRequest((HttpUriRequest)upload);
        String path = result.get("path").getAsString();
        HttpPost install = this.builder.createInstallRequest(path);
        this.sender.sendCrxRequest((HttpUriRequest)install);
        HttpPost replicate = this.builder.createReplicateRequest(path);
        this.sender.sendCrxRequest((HttpUriRequest)replicate);
    }
}

