/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem.content;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class CrxRequestSender {
    @Inject
    private CloseableHttpClient httpClient;

    public JsonObject sendCrxRequest(HttpUriRequest request) throws IOException {
        JsonObject result;
        String resultJson;
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            resultJson = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        try {
            result = new JsonParser().parse(resultJson).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Unable to parse as Json: " + resultJson, (Throwable)e);
        }
        if (result.get("success").getAsBoolean()) {
            return result;
        }
        throw new IOException(result.get("msg").getAsString());
    }

    public void sendCrxRequest(HttpUriRequest request, String desiredMessage) throws IOException {
        String result;
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        if (!result.contains(desiredMessage)) {
            throw new IOException("crx request failure: " + result + " doesn't contain desired message: " + desiredMessage);
        }
    }
}

