/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem.content;

import com.cognifide.qa.bb.aem.content.CrxRequestSender;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class WcmCommandHandler {
    public static final String PATH_PROPERTY = "path";
    public static final String CMD_PROPERTY = "cmd";
    public static final String CHARSET_PROPERTY = "_charset_";
    public static final String PARENT_PATH_PROPERTY = "parentPath";
    public static final String TITLE_PROPERTY = "title";
    public static final String TEMPLATE_PROPERTY = "template";
    private static final String REPLICATION_STARTED_MESSAGE = "Replication started for ";
    private static final String ACTIVATE = "Activate";
    private static final String DEACTIVATE = "Deactivate";
    private static final String UTF_8 = "utf-8";
    private static final String CREATE_PAGE_COMMAND = "createPage";
    private static final String DELETE_PAGE_COMMAND = "deletePage";
    private static final String PAGE_CREATED_SUCCESS_MESSAGE = "Page created";
    private static final String PAGE_DELETED_SUCCESS_MESSAGE_FORMAT = "Deleted %s";
    private static final String REPLICATE_URL = "%s/bin/replicate.json";
    private static final String WCM_COMMAND_URL = "%s/bin/wcmcommand";
    @Inject
    private CrxRequestSender sender;
    @Inject
    @Named(value="author.ip")
    private String authorIp;

    public void activatePage(String assetPath) throws IOException {
        this.triggerAction(Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)PATH_PROPERTY, (Object)assetPath).put((Object)CMD_PROPERTY, (Object)ACTIVATE).put((Object)CHARSET_PROPERTY, (Object)UTF_8).build()), REPLICATE_URL, REPLICATION_STARTED_MESSAGE + assetPath);
    }

    public void deactivatePage(String assetPath) throws IOException {
        this.triggerAction(Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)PATH_PROPERTY, (Object)assetPath).put((Object)CMD_PROPERTY, (Object)DEACTIVATE).put((Object)CHARSET_PROPERTY, (Object)UTF_8).build()), REPLICATE_URL, REPLICATION_STARTED_MESSAGE + assetPath);
    }

    public void createPage(String parentPath, String title, String template) throws IOException {
        this.triggerAction(Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)CMD_PROPERTY, (Object)CREATE_PAGE_COMMAND).put((Object)CHARSET_PROPERTY, (Object)UTF_8).put((Object)PARENT_PATH_PROPERTY, (Object)parentPath).put((Object)TITLE_PROPERTY, (Object)title).put((Object)TEMPLATE_PROPERTY, (Object)template).build()), WCM_COMMAND_URL, PAGE_CREATED_SUCCESS_MESSAGE);
    }

    public void deletePage(String path) throws IOException {
        this.triggerAction(Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)CMD_PROPERTY, (Object)DELETE_PAGE_COMMAND).put((Object)CHARSET_PROPERTY, (Object)UTF_8).put((Object)PATH_PROPERTY, (Object)path.toLowerCase()).build()), WCM_COMMAND_URL, String.format(PAGE_DELETED_SUCCESS_MESSAGE_FORMAT, path.toLowerCase()));
    }

    public void triggerAction(Map<String, String> postProperties, String commandUrl, String successMessage) throws IOException {
        HttpPost request = new HttpPost(String.format(commandUrl, this.authorIp));
        ArrayList params = new ArrayList();
        postProperties.entrySet().stream().forEach(property -> params.add(new BasicNameValuePair((String)property.getKey(), (String)property.getValue())));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        this.sender.sendCrxRequest((HttpUriRequest)request, successMessage);
    }
}

