/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem.page;

import com.cognifide.qa.bb.aem.page.AbstractPage;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorPage
extends AbstractPage {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorPage.class);
    @Inject
    @Named(value="author.url")
    private String authorUrl;

    @Override
    public String getFullUrl() {
        return this.authorUrl + this.getContentPath();
    }

    public boolean openPageWithRefresh(int timeoutForRefreshing) {
        this.webDriver.get(this.getFullUrl());
        boolean success = this.isDisplayed();
        if (!success) {
            success = this.webElementUtils.isConditionMet(driver -> {
                LOG.debug("Error while loading page. Refreshing...");
                this.webDriver.navigate().refresh();
                return this.isDisplayed();
            }, timeoutForRefreshing);
        }
        return success;
    }
}

