/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JcrExpectedConditions {
    private static final String JCR_ERROR = "Jcr error";
    private static final Logger LOG = LoggerFactory.getLogger(JcrExpectedConditions.class);

    private JcrExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> nodeExist(Session session, String nodePath) {
        LOG.debug("Checking if node '{}' exists", (Object)nodePath);
        return input -> {
            Boolean result = null;
            try {
                session.refresh(true);
                result = session.nodeExists(nodePath);
            }
            catch (RepositoryException e) {
                LOG.error(JCR_ERROR, (Throwable)e);
            }
            return result;
        };
    }

    public static ExpectedCondition<Boolean> hasNodeProperty(Session session, String nodePath, String propertyName) {
        LOG.debug("Checking if node '{}' has property '{}'", (Object)nodePath, (Object)propertyName);
        return input -> {
            Boolean result = null;
            try {
                session.refresh(true);
                result = session.getNode(nodePath).hasProperty(propertyName);
            }
            catch (RepositoryException e) {
                LOG.error(JCR_ERROR, (Throwable)e);
            }
            return result;
        };
    }

    public static ExpectedCondition<Boolean> hasNodePropertyValue(Session session, String nodePath, String propertyName, String propertyValue) {
        LOG.debug("Checking if node '{}' has property '{}' with value '{}'", new Object[]{nodePath, propertyName, propertyValue});
        return input -> {
            Boolean result = null;
            try {
                session.refresh(true);
                result = session.getNode(nodePath).getProperty(propertyName).getValue().getString().equals(propertyValue);
            }
            catch (RepositoryException e) {
                LOG.error(JCR_ERROR, (Throwable)e);
            }
            return result;
        };
    }
}

