/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AemInstanceDetails {
    private static final Logger LOG = LoggerFactory.getLogger(AemInstanceDetails.class);
    @Inject
    @Named(value="author.ip")
    private String authorIp;
    @Inject
    private CloseableHttpClient httpClient;
    private DefaultArtifactVersion aemVersion;

    public synchronized DefaultArtifactVersion getAemVersion() {
        if (this.aemVersion == null) {
            String versionInfo = this.sendInfoRequests();
            this.aemVersion = this.parseVersionInfo(versionInfo);
        }
        return this.aemVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendInfoRequests() {
        HttpGet infoGet = new HttpGet(this.authorIp + "/libs/cq/core/productinfo.json");
        String resultJson = "";
        try (CloseableHttpResponse infoResponse = this.httpClient.execute((HttpUriRequest)infoGet);){
            resultJson = EntityUtils.toString((HttpEntity)infoResponse.getEntity());
        }
        catch (IOException e) {
            LOG.error("Can't get aem version", (Throwable)e);
        }
        finally {
            infoGet.reset();
        }
        return resultJson;
    }

    private DefaultArtifactVersion parseVersionInfo(String versionInfo) {
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(versionInfo, JsonElement.class);
        JsonObject jsonObj = element.getAsJsonObject();
        this.aemVersion = new DefaultArtifactVersion(jsonObj.get("version").getAsString());
        return this.aemVersion;
    }
}

