/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.aem.page;

import com.cognifide.qa.bb.utils.WebElementUtils;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;

abstract class AbstractPage {
    @Inject
    protected WebDriver webDriver;
    @Inject
    @Named(value="page.title.timeout")
    private int pageTitleTimeout;
    @Inject
    protected WebElementUtils webElementUtils;

    AbstractPage() {
    }

    public abstract String getContentPath();

    public abstract String getPageTitle();

    public abstract String getFullUrl();

    public boolean isDisplayed() {
        return this.webElementUtils.isConditionMet(ExpectedConditions.titleIs((String)this.getPageTitle()), this.pageTitleTimeout);
    }

    public void open() {
        this.webDriver.get(this.getFullUrl());
    }
}

