/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.jcr;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JcrHelper.class);
    private final Session session;

    public JcrHelper(Session session) {
        this.session = session;
    }

    public Node getNode(String nodePath) throws RepositoryException {
        this.session.refresh(true);
        return this.session.getNode(nodePath);
    }

    public void createNode(String parentNodePath, String nodeName, String nodeType, Map<String, Pair<String, Integer>> properties) throws RepositoryException {
        LOG.debug("Creating node '{}' of type '{}' under '{}'", new Object[]{nodeName, nodeType, parentNodePath});
        this.session.refresh(true);
        Node parentNode = this.session.getNode(parentNodePath);
        Node createdNode = parentNode.addNode(nodeName, nodeType);
        if (properties != null) {
            for (Map.Entry<String, Pair<String, Integer>> mapEntry : properties.entrySet()) {
                createdNode.setProperty(mapEntry.getKey(), (String)mapEntry.getValue().getKey(), ((Integer)mapEntry.getValue().getValue()).intValue());
            }
        }
        this.session.save();
    }

    public void createNode(String parentNodePath, String nodeName, String nodeType) throws RepositoryException {
        this.createNode(parentNodePath, nodeName, nodeType, null);
    }

    public void copyNode(String nodePath, String destinationPath) throws RepositoryException {
        this.copyNode(this.getNode(nodePath), this.getNode(destinationPath));
        this.session.save();
    }

    public void copyNode(Node node, Node destinationParent) throws RepositoryException {
        LOG.debug("Copying node '{}' into '{}'", (Object)node.getPath(), (Object)destinationParent.getPath());
        Node newNode = destinationParent.addNode(node.getName(), node.getPrimaryNodeType().getName());
        PropertyIterator it = node.getProperties();
        while (it.hasNext()) {
            Property property = it.nextProperty();
            if (property.getDefinition().isProtected()) continue;
            newNode.setProperty(property.getName(), property.getValue().getString(), property.getType());
        }
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            this.copyNode(nodeIterator.nextNode(), newNode);
        }
    }

    public void deleteNode(String nodePath, Session session) throws RepositoryException {
        LOG.debug("Deleting node '{}'", (Object)nodePath);
        if (session.nodeExists(nodePath)) {
            session.removeItem(nodePath);
            session.save();
        }
    }

    public Property addNodeProperty(String nodePath, String propertyName, String propertyValue, int propertyType) throws RepositoryException {
        LOG.debug("Adding property '{}'='{}' to node '{}'", new Object[]{propertyName, propertyValue, nodePath});
        this.session.refresh(true);
        Node node = this.session.getNode(nodePath);
        Property property = node.setProperty(propertyName, propertyValue, propertyType);
        this.session.save();
        return property;
    }

    public void removeNodeProperty(String nodePath, String propertyName) throws RepositoryException {
        LOG.debug("Removing property '{}' from node '{}'", (Object)propertyName, (Object)nodePath);
        this.session.refresh(true);
        this.session.getNode(nodePath).getProperty(propertyName).setValue((String)null);
        this.session.save();
    }

    public Property getNodeProperty(String nodePath, String propertyName) throws RepositoryException {
        this.session.refresh(true);
        return this.session.getNode(nodePath).getProperty(propertyName);
    }

    public Boolean hasNodeProperty(String nodePath, String propertyName) throws RepositoryException {
        LOG.debug("Checking if node '{}' has property '{}'", (Object)nodePath, (Object)propertyName);
        this.session.refresh(true);
        return this.session.getNode(nodePath).hasProperty(propertyName);
    }

    public Boolean hasNodePropertyValue(String nodePath, String propertyName, String propertyValue) throws RepositoryException {
        LOG.debug("Checking if node '{}' has property '{}' with value '{}'", new Object[]{nodePath, propertyName, propertyValue});
        return this.getNodeProperty(nodePath, propertyName).getValue().getString().equals(propertyValue);
    }
}

