/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.qa.bb.provider.jcr.session;

import com.cognifide.qa.bb.guice.ThreadScoped;
import com.cognifide.qa.bb.provider.jcr.properties.InstanceProperties;
import com.google.inject.Provider;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.commons.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadScoped
public class JcrSessionProvider
implements Provider<Session> {
    private static final Logger LOG = LoggerFactory.getLogger(JcrSessionProvider.class);
    private final InstanceProperties properties;
    private Session session;

    public JcrSessionProvider(InstanceProperties instanceProperties) {
        this.properties = instanceProperties;
    }

    public Session get() {
        if (this.session == null || !this.session.isLive()) {
            try {
                Repository repository = JcrUtils.getRepository((String)(this.properties.getIp() + "/crx/server"));
                SimpleCredentials credentials = new SimpleCredentials(this.properties.getLogin(), this.properties.getPassword().toCharArray());
                this.session = repository.login((Credentials)credentials);
            }
            catch (RepositoryException e) {
                LOG.error("Can't connect with jcr repository", (Throwable)e);
            }
        }
        return this.session;
    }
}

