;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.ce.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.ce/GenericDouble
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.ce/CreateAnomalyMonitorResponse
  (s/keys :req-un [:cognitect.aws.ce.CreateAnomalyMonitorResponse/MonitorArn]))

(s/def
  :cognitect.aws.ce/GetSavingsPlansUtilizationDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/DataType
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/Filter
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/SortBy
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/NextToken
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/MaxResults]))

(s/def :cognitect.aws.ce/TotalPotentialRISavings string?)

(s/def
  :cognitect.aws.ce/SearchString
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilizationAggregates
  (s/keys
    :req-un
    [:cognitect.aws.ce.SavingsPlansUtilizationAggregates/Utilization]
    :opt-un
    [:cognitect.aws.ce.SavingsPlansUtilizationAggregates/AmortizedCommitment
     :cognitect.aws.ce.SavingsPlansUtilizationAggregates/Savings]))

(s/def :cognitect.aws.ce/UtilizationsByTime (s/coll-of :cognitect.aws.ce/UtilizationByTime))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilizationDetails
  (s/coll-of :cognitect.aws.ce/SavingsPlansUtilizationDetail))

(s/def
  :cognitect.aws.ce/UpdateCostAllocationTagsStatusErrors
  (s/coll-of :cognitect.aws.ce/UpdateCostAllocationTagsStatusError :min-count 0 :max-count 20))

(s/def
  :cognitect.aws.ce/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.TagResourceRequest/ResourceArn
     :cognitect.aws.ce.TagResourceRequest/ResourceTags]))

(s/def
  :cognitect.aws.ce/GetUsageForecastRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetUsageForecastRequest/TimePeriod
     :cognitect.aws.ce.GetUsageForecastRequest/Metric
     :cognitect.aws.ce.GetUsageForecastRequest/Granularity]
    :opt-un
    [:cognitect.aws.ce.GetUsageForecastRequest/Filter
     :cognitect.aws.ce.GetUsageForecastRequest/PredictionIntervalLevel]))

(s/def :cognitect.aws.ce/OnDemandCost string?)

(s/def :cognitect.aws.ce/Expressions (s/coll-of :cognitect.aws.ce/Expression))

(s/def :cognitect.aws.ce/RootCauses (s/coll-of :cognitect.aws.ce/RootCause))

(s/def
  :cognitect.aws.ce/GetReservationPurchaseRecommendationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/Recommendations
     :cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/Metadata
     :cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/GetAnomaliesRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetAnomaliesRequest/DateInterval]
    :opt-un
    [:cognitect.aws.ce.GetAnomaliesRequest/MonitorArn
     :cognitect.aws.ce.GetAnomaliesRequest/TotalImpact
     :cognitect.aws.ce.GetAnomaliesRequest/MaxResults
     :cognitect.aws.ce.GetAnomaliesRequest/Feedback
     :cognitect.aws.ce.GetAnomaliesRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendations
  (s/coll-of :cognitect.aws.ce/ReservationPurchaseRecommendation))

(s/def
  :cognitect.aws.ce/Group
  (s/keys :opt-un [:cognitect.aws.ce.Group/Keys :cognitect.aws.ce.Group/Metrics]))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRuleParameterValuesList
  (s/coll-of :cognitect.aws.ce/GenericString :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.ce/CostCategoryValue
  (s/spec #(re-matches (re-pattern "^(?! )[\\p{L}\\p{N}\\p{Z}-_]*(?<! )$") %) :gen #(gen/string)))

(s/def :cognitect.aws.ce/ReservationGroupValue string?)

(s/def
  :cognitect.aws.ce/UpdateAnomalyMonitorResponse
  (s/keys :req-un [:cognitect.aws.ce.UpdateAnomalyMonitorResponse/MonitorArn]))

(s/def :cognitect.aws.ce/AttributeType string?)

(s/def
  :cognitect.aws.ce/GetReservationCoverageRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetReservationCoverageRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetReservationCoverageRequest/Filter
     :cognitect.aws.ce.GetReservationCoverageRequest/SortBy
     :cognitect.aws.ce.GetReservationCoverageRequest/GroupBy
     :cognitect.aws.ce.GetReservationCoverageRequest/Granularity
     :cognitect.aws.ce.GetReservationCoverageRequest/MaxResults
     :cognitect.aws.ce.GetReservationCoverageRequest/NextPageToken
     :cognitect.aws.ce.GetReservationCoverageRequest/Metrics]))

(s/def :cognitect.aws.ce/CostCategoryValuesList (s/coll-of :cognitect.aws.ce/CostCategoryValue))

(s/def
  :cognitect.aws.ce/SortDefinitionKey
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/MemoryDBInstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.MemoryDBInstanceDetails/Family
     :cognitect.aws.ce.MemoryDBInstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.MemoryDBInstanceDetails/CurrentGeneration
     :cognitect.aws.ce.MemoryDBInstanceDetails/NodeType
     :cognitect.aws.ce.MemoryDBInstanceDetails/Region]))

(s/def
  :cognitect.aws.ce/UpdateAnomalyMonitorRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.UpdateAnomalyMonitorRequest/MonitorArn]
    :opt-un
    [:cognitect.aws.ce.UpdateAnomalyMonitorRequest/MonitorName]))

(s/def
  :cognitect.aws.ce/DeleteAnomalySubscriptionRequest
  (s/keys :req-un [:cognitect.aws.ce.DeleteAnomalySubscriptionRequest/SubscriptionArn]))

(s/def :cognitect.aws.ce/Groups (s/coll-of :cognitect.aws.ce/Group))

(s/def
  :cognitect.aws.ce/CostCategoryRuleVersion
  (s/spec string? :gen #(s/gen #{"CostCategoryExpression.v1"})))

(s/def
  :cognitect.aws.ce/EC2ResourceUtilization
  (s/keys
    :opt-un
    [:cognitect.aws.ce.EC2ResourceUtilization/MaxCpuUtilizationPercentage
     :cognitect.aws.ce.EC2ResourceUtilization/NetworkResourceUtilization
     :cognitect.aws.ce.EC2ResourceUtilization/DiskResourceUtilization
     :cognitect.aws.ce.EC2ResourceUtilization/MaxMemoryUtilizationPercentage
     :cognitect.aws.ce.EC2ResourceUtilization/MaxStorageUtilizationPercentage
     :cognitect.aws.ce.EC2ResourceUtilization/EBSResourceUtilization]))

(s/def :cognitect.aws.ce/OnDemandCostOfRIHoursUsed string?)

(s/def
  :cognitect.aws.ce/Dimension
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ANOMALY_TOTAL_IMPACT_PERCENTAGE"
        "SUBSCRIPTION_ID"
        "SERVICE_CODE"
        "LINKED_ACCOUNT"
        "LEGAL_ENTITY_NAME"
        "TENANCY"
        "PURCHASE_TYPE"
        "PAYMENT_OPTION"
        "SERVICE"
        "SAVINGS_PLANS_TYPE"
        "INSTANCE_TYPE_FAMILY"
        "RECORD_TYPE"
        "SAVINGS_PLAN_ARN"
        "INSTANCE_TYPE"
        "DEPLOYMENT_OPTION"
        "LINKED_ACCOUNT_NAME"
        "PLATFORM"
        "OPERATING_SYSTEM"
        "RESOURCE_ID"
        "SCOPE"
        "AGREEMENT_END_DATE_TIME_BEFORE"
        "AGREEMENT_END_DATE_TIME_AFTER"
        "ANOMALY_TOTAL_IMPACT_ABSOLUTE"
        "CACHE_ENGINE"
        "USAGE_TYPE_GROUP"
        "DATABASE_ENGINE"
        "REGION"
        "RIGHTSIZING_TYPE"
        "AZ"
        "RESERVATION_ID"
        "INVOICING_ENTITY"
        "BILLING_ENTITY"
        "OPERATION"
        "USAGE_TYPE"})))

(s/def :cognitect.aws.ce/CoveragesByTime (s/coll-of :cognitect.aws.ce/CoverageByTime))

(s/def
  :cognitect.aws.ce/Impact
  (s/keys
    :req-un
    [:cognitect.aws.ce.Impact/MaxImpact]
    :opt-un
    [:cognitect.aws.ce.Impact/TotalActualSpend
     :cognitect.aws.ce.Impact/TotalImpactPercentage
     :cognitect.aws.ce.Impact/TotalImpact
     :cognitect.aws.ce.Impact/TotalExpectedSpend]))

(s/def
  :cognitect.aws.ce/DiskResourceUtilization
  (s/keys
    :opt-un
    [:cognitect.aws.ce.DiskResourceUtilization/DiskReadBytesPerSecond
     :cognitect.aws.ce.DiskResourceUtilization/DiskWriteOpsPerSecond
     :cognitect.aws.ce.DiskResourceUtilization/DiskReadOpsPerSecond
     :cognitect.aws.ce.DiskResourceUtilization/DiskWriteBytesPerSecond]))

(s/def
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/AdditionalMetadata
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/RecommendationId
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/GenerationTimestamp]))

(s/def :cognitect.aws.ce/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ce/FindingReasonCode
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DISK_THROUGHPUT_OVER_PROVISIONED"
        "CPU_OVER_PROVISIONED"
        "DISK_IOPS_UNDER_PROVISIONED"
        "NETWORK_BANDWIDTH_OVER_PROVISIONED"
        "NETWORK_PPS_UNDER_PROVISIONED"
        "DISK_IOPS_OVER_PROVISIONED"
        "MEMORY_OVER_PROVISIONED"
        "CPU_UNDER_PROVISIONED"
        "NETWORK_PPS_OVER_PROVISIONED"
        "EBS_THROUGHPUT_UNDER_PROVISIONED"
        "DISK_THROUGHPUT_UNDER_PROVISIONED"
        "EBS_IOPS_OVER_PROVISIONED"
        "EBS_THROUGHPUT_OVER_PROVISIONED"
        "MEMORY_UNDER_PROVISIONED"
        "EBS_IOPS_UNDER_PROVISIONED"
        "NETWORK_BANDWIDTH_UNDER_PROVISIONED"})))

(s/def
  :cognitect.aws.ce/UpdateAnomalySubscriptionResponse
  (s/keys :req-un [:cognitect.aws.ce.UpdateAnomalySubscriptionResponse/SubscriptionArn]))

(s/def
  :cognitect.aws.ce/CostAllocationTag
  (s/keys
    :req-un
    [:cognitect.aws.ce.CostAllocationTag/TagKey
     :cognitect.aws.ce.CostAllocationTag/Type
     :cognitect.aws.ce.CostAllocationTag/Status]
    :opt-un
    [:cognitect.aws.ce.CostAllocationTag/LastUpdatedDate
     :cognitect.aws.ce.CostAllocationTag/LastUsedDate]))

(s/def
  :cognitect.aws.ce/CostCategoryName
  (s/spec #(re-matches (re-pattern "^(?! )[\\p{L}\\p{N}\\p{Z}-_]*(?<! )$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/DateInterval
  (s/keys :req-un [:cognitect.aws.ce.DateInterval/Start :cognitect.aws.ce.DateInterval/End]))

(s/def :cognitect.aws.ce/PurchasedUnits string?)

(s/def
  :cognitect.aws.ce/DeleteAnomalyMonitorRequest
  (s/keys :req-un [:cognitect.aws.ce.DeleteAnomalyMonitorRequest/MonitorArn]))

(s/def
  :cognitect.aws.ce/CostCategoryProcessingStatus
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CostCategoryProcessingStatus/Status
     :cognitect.aws.ce.CostCategoryProcessingStatus/Component]))

(s/def
  :cognitect.aws.ce/GetCostAndUsageWithResourcesRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/TimePeriod
     :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Granularity
     :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Filter]
    :opt-un
    [:cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/GroupBy
     :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/NextPageToken
     :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Metrics]))

(s/def
  :cognitect.aws.ce/UtilizationByTime
  (s/keys
    :opt-un
    [:cognitect.aws.ce.UtilizationByTime/TimePeriod
     :cognitect.aws.ce.UtilizationByTime/Total
     :cognitect.aws.ce.UtilizationByTime/Groups]))

(s/def
  :cognitect.aws.ce/GetCostAndUsageResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetCostAndUsageResponse/GroupDefinitions
     :cognitect.aws.ce.GetCostAndUsageResponse/DimensionValueAttributes
     :cognitect.aws.ce.GetCostAndUsageResponse/ResultsByTime
     :cognitect.aws.ce.GetCostAndUsageResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/YearMonthDay
  (s/spec
    #(re-matches (re-pattern "(\\d{4}-\\d{2}-\\d{2})(T\\d{2}:\\d{2}:\\d{2}Z)?") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ce/GetAnomalyMonitorsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetAnomalyMonitorsRequest/MonitorArnList
     :cognitect.aws.ce.GetAnomalyMonitorsRequest/MaxResults
     :cognitect.aws.ce.GetAnomalyMonitorsRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/NullableNonNegativeDouble
  (s/spec (s/and double? #(<= 0 %)) :gen #(gen/double* {:infinite? false, :NaN? false, :min 0})))

(s/def
  :cognitect.aws.ce/UpdateCostCategoryDefinitionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.UpdateCostCategoryDefinitionResponse/CostCategoryArn
     :cognitect.aws.ce.UpdateCostCategoryDefinitionResponse/EffectiveStart]))

(s/def
  :cognitect.aws.ce/CostCategoryStatus
  (s/spec string? :gen #(s/gen #{"APPLIED" "PROCESSING"})))

(s/def :cognitect.aws.ce/UtilizationPercentage string?)

(s/def
  :cognitect.aws.ce/UpdateAnomalySubscriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.UpdateAnomalySubscriptionRequest/SubscriptionArn]
    :opt-un
    [:cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Threshold
     :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/ThresholdExpression
     :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/SubscriptionName
     :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/MonitorArnList
     :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Subscribers
     :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Frequency]))

(s/def
  :cognitect.aws.ce/ResourceTagList
  (s/coll-of :cognitect.aws.ce/ResourceTag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.ce/GetSavingsPlansUtilizationDetailsResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/SavingsPlansUtilizationDetails
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/NextToken
     :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/Total]))

(s/def
  :cognitect.aws.ce/RedshiftInstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RedshiftInstanceDetails/Family
     :cognitect.aws.ce.RedshiftInstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.RedshiftInstanceDetails/CurrentGeneration
     :cognitect.aws.ce.RedshiftInstanceDetails/NodeType
     :cognitect.aws.ce.RedshiftInstanceDetails/Region]))

(s/def
  :cognitect.aws.ce/SubscriberAddress
  (s/spec
    #(re-matches
      (re-pattern
        "(^[a-zA-Z0-9.!#$%&'*+=?^_‘{|}~-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$)|(^arn:(aws[a-zA-Z-]*):sns:[a-zA-Z0-9-]+:[0-9]{12}:[a-zA-Z0-9_-]+(\\.fifo)?$)")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ce/ReservationAggregates
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationAggregates/TotalActualUnits
     :cognitect.aws.ce.ReservationAggregates/TotalAmortizedFee
     :cognitect.aws.ce.ReservationAggregates/TotalPotentialRISavings
     :cognitect.aws.ce.ReservationAggregates/UnusedHours
     :cognitect.aws.ce.ReservationAggregates/PurchasedUnits
     :cognitect.aws.ce.ReservationAggregates/AmortizedUpfrontFee
     :cognitect.aws.ce.ReservationAggregates/UtilizationPercentage
     :cognitect.aws.ce.ReservationAggregates/OnDemandCostOfRIHoursUsed
     :cognitect.aws.ce.ReservationAggregates/RICostForUnusedHours
     :cognitect.aws.ce.ReservationAggregates/NetRISavings
     :cognitect.aws.ce.ReservationAggregates/TotalActualHours
     :cognitect.aws.ce.ReservationAggregates/UnrealizedSavings
     :cognitect.aws.ce.ReservationAggregates/UtilizationPercentageInUnits
     :cognitect.aws.ce.ReservationAggregates/AmortizedRecurringFee
     :cognitect.aws.ce.ReservationAggregates/UnusedUnits
     :cognitect.aws.ce.ReservationAggregates/PurchasedHours
     :cognitect.aws.ce.ReservationAggregates/RealizedSavings]))

(s/def
  :cognitect.aws.ce/GetReservationPurchaseRecommendationRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/Service]
    :opt-un
    [:cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/Filter
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/PageSize
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/TermInYears
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/PaymentOption
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/AccountScope
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/LookbackPeriodInDays
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/ServiceSpecification
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/AccountId
     :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/NextPageToken]))

(s/def :cognitect.aws.ce/ErrorMessage string?)

(s/def
  :cognitect.aws.ce/CostCategory
  (s/keys
    :req-un
    [:cognitect.aws.ce.CostCategory/CostCategoryArn
     :cognitect.aws.ce.CostCategory/EffectiveStart
     :cognitect.aws.ce.CostCategory/Name
     :cognitect.aws.ce.CostCategory/RuleVersion
     :cognitect.aws.ce.CostCategory/Rules]
    :opt-un
    [:cognitect.aws.ce.CostCategory/ProcessingStatus
     :cognitect.aws.ce.CostCategory/EffectiveEnd
     :cognitect.aws.ce.CostCategory/DefaultValue
     :cognitect.aws.ce.CostCategory/SplitChargeRules]))

(s/def :cognitect.aws.ce/TagList (s/coll-of :cognitect.aws.ce/Entity))

(s/def
  :cognitect.aws.ce/CostCategoryRulesList
  (s/coll-of :cognitect.aws.ce/CostCategoryRule :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.ce/GetUsageForecastResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetUsageForecastResponse/Total
     :cognitect.aws.ce.GetUsageForecastResponse/ForecastResultsByTime]))

(s/def
  :cognitect.aws.ce/GetReservationUtilizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetReservationUtilizationRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetReservationUtilizationRequest/Filter
     :cognitect.aws.ce.GetReservationUtilizationRequest/SortBy
     :cognitect.aws.ce.GetReservationUtilizationRequest/GroupBy
     :cognitect.aws.ce.GetReservationUtilizationRequest/Granularity
     :cognitect.aws.ce.GetReservationUtilizationRequest/MaxResults
     :cognitect.aws.ce.GetReservationUtilizationRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/ResourceTag
  (s/keys :req-un [:cognitect.aws.ce.ResourceTag/Key :cognitect.aws.ce.ResourceTag/Value]))

(s/def
  :cognitect.aws.ce/PredictionIntervalLevel
  (s/spec (s/and int? #(<= 51 % 99)) :gen #(gen/choose 51 99)))

(s/def :cognitect.aws.ce/TotalActualUnits string?)

(s/def
  :cognitect.aws.ce/TagValues
  (s/keys
    :opt-un
    [:cognitect.aws.ce.TagValues/Key
     :cognitect.aws.ce.TagValues/Values
     :cognitect.aws.ce.TagValues/MatchOptions]))

(s/def
  :cognitect.aws.ce/GetCostAndUsageRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetCostAndUsageRequest/TimePeriod
     :cognitect.aws.ce.GetCostAndUsageRequest/Granularity
     :cognitect.aws.ce.GetCostAndUsageRequest/Metrics]
    :opt-un
    [:cognitect.aws.ce.GetCostAndUsageRequest/Filter
     :cognitect.aws.ce.GetCostAndUsageRequest/GroupBy
     :cognitect.aws.ce.GetCostAndUsageRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/GetCostAndUsageWithResourcesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/GroupDefinitions
     :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/DimensionValueAttributes
     :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/ResultsByTime
     :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/Coverage
  (s/keys
    :opt-un
    [:cognitect.aws.ce.Coverage/CoverageHours
     :cognitect.aws.ce.Coverage/CoverageNormalizedUnits
     :cognitect.aws.ce.Coverage/CoverageCost]))

(s/def
  :cognitect.aws.ce/DescribeCostCategoryDefinitionResponse
  (s/keys :opt-un [:cognitect.aws.ce.DescribeCostCategoryDefinitionResponse/CostCategory]))

(s/def :cognitect.aws.ce/Key string?)

(s/def
  :cognitect.aws.ce/ListCostCategoryDefinitionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListCostCategoryDefinitionsResponse/CostCategoryReferences
     :cognitect.aws.ce.ListCostCategoryDefinitionsResponse/NextToken]))

(s/def
  :cognitect.aws.ce/ResultByTime
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ResultByTime/Estimated
     :cognitect.aws.ce.ResultByTime/TimePeriod
     :cognitect.aws.ce.ResultByTime/Total
     :cognitect.aws.ce.ResultByTime/Groups]))

(s/def
  :cognitect.aws.ce/CostCategoryInheritedValueDimension
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CostCategoryInheritedValueDimension/DimensionName
     :cognitect.aws.ce.CostCategoryInheritedValueDimension/DimensionKey]))

(s/def
  :cognitect.aws.ce/GetSavingsPlansPurchaseRecommendationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/Metadata
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/SavingsPlansPurchaseRecommendation
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/MetricsOverLookbackPeriod
  (s/coll-of :cognitect.aws.ce/RecommendationDetailHourlyMetrics))

(s/def
  :cognitect.aws.ce/CostCategoryValues
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CostCategoryValues/Key
     :cognitect.aws.ce.CostCategoryValues/Values
     :cognitect.aws.ce.CostCategoryValues/MatchOptions]))

(s/def
  :cognitect.aws.ce/GetDimensionValuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetDimensionValuesRequest/TimePeriod
     :cognitect.aws.ce.GetDimensionValuesRequest/Dimension]
    :opt-un
    [:cognitect.aws.ce.GetDimensionValuesRequest/SearchString
     :cognitect.aws.ce.GetDimensionValuesRequest/Filter
     :cognitect.aws.ce.GetDimensionValuesRequest/SortBy
     :cognitect.aws.ce.GetDimensionValuesRequest/Context
     :cognitect.aws.ce.GetDimensionValuesRequest/MaxResults
     :cognitect.aws.ce.GetDimensionValuesRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/ListCostAllocationTagsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListCostAllocationTagsResponse/CostAllocationTags
     :cognitect.aws.ce.ListCostAllocationTagsResponse/NextToken]))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRuleParameterType
  (s/spec string? :gen #(s/gen #{"ALLOCATION_PERCENTAGES"})))

(s/def
  :cognitect.aws.ce/ResourceTagKey
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/GetTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetTagsResponse/Tags
     :cognitect.aws.ce.GetTagsResponse/ReturnSize
     :cognitect.aws.ce.GetTagsResponse/TotalSize]
    :opt-un
    [:cognitect.aws.ce.GetTagsResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/NonNegativeInteger
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.ce/RecommendationDetailData
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RecommendationDetailData/HourlyCommitmentToPurchase
     :cognitect.aws.ce.RecommendationDetailData/CurrencyCode
     :cognitect.aws.ce.RecommendationDetailData/TermInYears
     :cognitect.aws.ce.RecommendationDetailData/EstimatedAverageCoverage
     :cognitect.aws.ce.RecommendationDetailData/CurrentMaximumHourlyOnDemandSpend
     :cognitect.aws.ce.RecommendationDetailData/CurrentAverageCoverage
     :cognitect.aws.ce.RecommendationDetailData/EstimatedSavingsAmount
     :cognitect.aws.ce.RecommendationDetailData/EstimatedAverageUtilization
     :cognitect.aws.ce.RecommendationDetailData/EstimatedMonthlySavingsAmount
     :cognitect.aws.ce.RecommendationDetailData/PaymentOption
     :cognitect.aws.ce.RecommendationDetailData/UpfrontCost
     :cognitect.aws.ce.RecommendationDetailData/AccountScope
     :cognitect.aws.ce.RecommendationDetailData/LookbackPeriodInDays
     :cognitect.aws.ce.RecommendationDetailData/CurrentAverageHourlyOnDemandSpend
     :cognitect.aws.ce.RecommendationDetailData/EstimatedROI
     :cognitect.aws.ce.RecommendationDetailData/EstimatedSavingsPercentage
     :cognitect.aws.ce.RecommendationDetailData/EstimatedOnDemandCost
     :cognitect.aws.ce.RecommendationDetailData/LatestUsageTimestamp
     :cognitect.aws.ce.RecommendationDetailData/OfferingId
     :cognitect.aws.ce.RecommendationDetailData/InstanceFamily
     :cognitect.aws.ce.RecommendationDetailData/AccountId
     :cognitect.aws.ce.RecommendationDetailData/EstimatedSPCost
     :cognitect.aws.ce.RecommendationDetailData/SavingsPlansType
     :cognitect.aws.ce.RecommendationDetailData/CurrentMinimumHourlyOnDemandSpend
     :cognitect.aws.ce.RecommendationDetailData/ExistingHourlyCommitment
     :cognitect.aws.ce.RecommendationDetailData/MetricsOverLookbackPeriod
     :cognitect.aws.ce.RecommendationDetailData/Region
     :cognitect.aws.ce.RecommendationDetailData/GenerationTimestamp
     :cognitect.aws.ce.RecommendationDetailData/EstimatedOnDemandCostWithCurrentCommitment]))

(s/def :cognitect.aws.ce/MonitorDimension (s/spec string? :gen #(s/gen #{"SERVICE"})))

(s/def :cognitect.aws.ce/ReservedHours string?)

(s/def
  :cognitect.aws.ce/Anomaly
  (s/keys
    :req-un
    [:cognitect.aws.ce.Anomaly/AnomalyId
     :cognitect.aws.ce.Anomaly/AnomalyScore
     :cognitect.aws.ce.Anomaly/Impact
     :cognitect.aws.ce.Anomaly/MonitorArn]
    :opt-un
    [:cognitect.aws.ce.Anomaly/AnomalyEndDate
     :cognitect.aws.ce.Anomaly/DimensionValue
     :cognitect.aws.ce.Anomaly/AnomalyStartDate
     :cognitect.aws.ce.Anomaly/RootCauses
     :cognitect.aws.ce.Anomaly/Feedback]))

(s/def :cognitect.aws.ce/Anomalies (s/coll-of :cognitect.aws.ce/Anomaly))

(s/def :cognitect.aws.ce/SavingsPlanArn string?)

(s/def :cognitect.aws.ce/DeleteAnomalySubscriptionResponse (s/keys))

(s/def
  :cognitect.aws.ce/GetCostCategoriesResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetCostCategoriesResponse/ReturnSize
     :cognitect.aws.ce.GetCostCategoriesResponse/TotalSize]
    :opt-un
    [:cognitect.aws.ce.GetCostCategoriesResponse/CostCategoryNames
     :cognitect.aws.ce.GetCostCategoriesResponse/CostCategoryValues
     :cognitect.aws.ce.GetCostCategoriesResponse/NextPageToken]))

(s/def :cognitect.aws.ce/TargetInstancesList (s/coll-of :cognitect.aws.ce/TargetInstance))

(s/def
  :cognitect.aws.ce/SavingsPlansSavings
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansSavings/NetSavings
     :cognitect.aws.ce.SavingsPlansSavings/OnDemandCostEquivalent]))

(s/def
  :cognitect.aws.ce/CostCategoryProcessingStatusList
  (s/coll-of :cognitect.aws.ce/CostCategoryProcessingStatus))

(s/def
  :cognitect.aws.ce/EC2InstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.EC2InstanceDetails/Platform
     :cognitect.aws.ce.EC2InstanceDetails/Tenancy
     :cognitect.aws.ce.EC2InstanceDetails/InstanceType
     :cognitect.aws.ce.EC2InstanceDetails/AvailabilityZone
     :cognitect.aws.ce.EC2InstanceDetails/Family
     :cognitect.aws.ce.EC2InstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.EC2InstanceDetails/CurrentGeneration
     :cognitect.aws.ce.EC2InstanceDetails/Region]))

(s/def
  :cognitect.aws.ce/CreateCostCategoryDefinitionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CreateCostCategoryDefinitionResponse/CostCategoryArn
     :cognitect.aws.ce.CreateCostCategoryDefinitionResponse/EffectiveStart]))

(s/def
  :cognitect.aws.ce/ListSavingsPlansPurchaseRecommendationGenerationRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/PageSize
     :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/GenerationStatus
     :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/RecommendationIds
     :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/GetReservationUtilizationResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetReservationUtilizationResponse/UtilizationsByTime]
    :opt-un
    [:cognitect.aws.ce.GetReservationUtilizationResponse/Total
     :cognitect.aws.ce.GetReservationUtilizationResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/ESInstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ESInstanceDetails/InstanceSize
     :cognitect.aws.ce.ESInstanceDetails/InstanceClass
     :cognitect.aws.ce.ESInstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.ESInstanceDetails/CurrentGeneration
     :cognitect.aws.ce.ESInstanceDetails/Region]))

(s/def
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/HourlyCommitmentToPurchase
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/CurrencyCode
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedTotalCost
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/TotalRecommendationCount
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedSavingsAmount
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/DailyCommitmentToPurchase
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/CurrentOnDemandSpend
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedMonthlySavingsAmount
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedROI
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedSavingsPercentage
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedOnDemandCostWithCurrentCommitment]))

(s/def
  :cognitect.aws.ce/TotalImpactFilter
  (s/keys
    :req-un
    [:cognitect.aws.ce.TotalImpactFilter/NumericOperator
     :cognitect.aws.ce.TotalImpactFilter/StartValue]
    :opt-un
    [:cognitect.aws.ce.TotalImpactFilter/EndValue]))

(s/def
  :cognitect.aws.ce/DimensionValues
  (s/keys
    :opt-un
    [:cognitect.aws.ce.DimensionValues/Key
     :cognitect.aws.ce.DimensionValues/Values
     :cognitect.aws.ce.DimensionValues/MatchOptions]))

(s/def
  :cognitect.aws.ce/SavingsPlansCoverage
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansCoverage/Coverage
     :cognitect.aws.ce.SavingsPlansCoverage/Attributes
     :cognitect.aws.ce.SavingsPlansCoverage/TimePeriod]))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilizationDetail
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansUtilizationDetail/SavingsPlanArn
     :cognitect.aws.ce.SavingsPlansUtilizationDetail/Attributes
     :cognitect.aws.ce.SavingsPlansUtilizationDetail/AmortizedCommitment
     :cognitect.aws.ce.SavingsPlansUtilizationDetail/Savings
     :cognitect.aws.ce.SavingsPlansUtilizationDetail/Utilization]))

(s/def
  :cognitect.aws.ce/MetricValue
  (s/keys :opt-un [:cognitect.aws.ce.MetricValue/Unit :cognitect.aws.ce.MetricValue/Amount]))

(s/def
  :cognitect.aws.ce/ResourceTagValue
  (s/spec #(re-matches (re-pattern "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/RDSInstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RDSInstanceDetails/DatabaseEngine
     :cognitect.aws.ce.RDSInstanceDetails/DatabaseEdition
     :cognitect.aws.ce.RDSInstanceDetails/InstanceType
     :cognitect.aws.ce.RDSInstanceDetails/LicenseModel
     :cognitect.aws.ce.RDSInstanceDetails/Family
     :cognitect.aws.ce.RDSInstanceDetails/DeploymentOption
     :cognitect.aws.ce.RDSInstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.RDSInstanceDetails/CurrentGeneration
     :cognitect.aws.ce.RDSInstanceDetails/Region]))

(s/def
  :cognitect.aws.ce/RecommendationTarget
  (s/spec string? :gen #(s/gen #{"CROSS_INSTANCE_FAMILY" "SAME_INSTANCE_FAMILY"})))

(s/def :cognitect.aws.ce/TagValuesList (s/coll-of :cognitect.aws.ce/TagValues))

(s/def
  :cognitect.aws.ce/CostAllocationTagType
  (s/spec string? :gen #(s/gen #{"UserDefined" "AWSGenerated"})))

(s/def
  :cognitect.aws.ce/ReservationCoverageGroups
  (s/coll-of :cognitect.aws.ce/ReservationCoverageGroup))

(s/def
  :cognitect.aws.ce/SavingsPlansDataType
  (s/spec string? :gen #(s/gen #{"AMORTIZED_COMMITMENT" "UTILIZATION" "SAVINGS" "ATTRIBUTES"})))

(s/def
  :cognitect.aws.ce/GetAnomalySubscriptionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetAnomalySubscriptionsRequest/SubscriptionArnList
     :cognitect.aws.ce.GetAnomalySubscriptionsRequest/MonitorArn
     :cognitect.aws.ce.GetAnomalySubscriptionsRequest/MaxResults
     :cognitect.aws.ce.GetAnomalySubscriptionsRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/CostAllocationTagsMaxResults
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def
  :cognitect.aws.ce/RightsizingRecommendationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RightsizingRecommendationSummary/TotalRecommendationCount
     :cognitect.aws.ce.RightsizingRecommendationSummary/SavingsCurrencyCode
     :cognitect.aws.ce.RightsizingRecommendationSummary/SavingsPercentage
     :cognitect.aws.ce.RightsizingRecommendationSummary/EstimatedTotalMonthlySavingsAmount]))

(s/def
  :cognitect.aws.ce/GroupDefinitionKey
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendationDetail
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationPurchaseRecommendationDetail/CurrencyCode
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageUtilization
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedBreakEvenInMonths
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MaximumNumberOfInstancesUsedPerHour
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedReservationCostForLookbackPeriod
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/InstanceDetails
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecurringStandardMonthlyCost
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MinimumNormalizedUnitsUsedPerHour
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlySavingsAmount
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/UpfrontCost
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageNumberOfInstancesUsedPerHour
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageNormalizedUnitsUsedPerHour
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecommendedNumberOfInstancesToPurchase
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlySavingsPercentage
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AccountId
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecommendedNormalizedUnitsToPurchase
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlyOnDemandCost
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MinimumNumberOfInstancesUsedPerHour
     :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MaximumNormalizedUnitsUsedPerHour]))

(s/def
  :cognitect.aws.ce/CostCategoryRuleType
  (s/spec string? :gen #(s/gen #{"REGULAR" "INHERITED_VALUE"})))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendation
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationPurchaseRecommendation/TermInYears
     :cognitect.aws.ce.ReservationPurchaseRecommendation/PaymentOption
     :cognitect.aws.ce.ReservationPurchaseRecommendation/AccountScope
     :cognitect.aws.ce.ReservationPurchaseRecommendation/LookbackPeriodInDays
     :cognitect.aws.ce.ReservationPurchaseRecommendation/RecommendationDetails
     :cognitect.aws.ce.ReservationPurchaseRecommendation/ServiceSpecification
     :cognitect.aws.ce.ReservationPurchaseRecommendation/RecommendationSummary]))

(s/def :cognitect.aws.ce/MetricAmount string?)

(s/def
  :cognitect.aws.ce/CostAllocationTagStatusList
  (s/coll-of :cognitect.aws.ce/CostAllocationTagStatusEntry :min-count 1 :max-count 20))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilizationsByTime
  (s/coll-of :cognitect.aws.ce/SavingsPlansUtilizationByTime))

(s/def
  :cognitect.aws.ce/Metrics
  (s/map-of :cognitect.aws.ce/MetricName :cognitect.aws.ce/MetricValue))

(s/def :cognitect.aws.ce/StartSavingsPlansPurchaseRecommendationGenerationRequest (s/keys))

(s/def
  :cognitect.aws.ce/RecommendationDetailId
  (s/spec
    #(re-matches (re-pattern "^[\\S\\s]{8}-[\\S\\s]{4}-[\\S\\s]{4}-[\\S\\s]{4}-[\\S\\s]{12}$") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.ce/PurchasedHours string?)

(s/def
  :cognitect.aws.ce/ResourceDetails
  (s/keys :opt-un [:cognitect.aws.ce.ResourceDetails/EC2ResourceDetails]))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRuleTargetsList
  (s/coll-of :cognitect.aws.ce/GenericString :min-count 1 :max-count 500))

(s/def
  :cognitect.aws.ce/GroupDefinitionType
  (s/spec string? :gen #(s/gen #{"COST_CATEGORY" "TAG" "DIMENSION"})))

(s/def
  :cognitect.aws.ce/CostCategoryStatusComponent
  (s/spec string? :gen #(s/gen #{"COST_EXPLORER"})))

(s/def
  :cognitect.aws.ce/CreateAnomalySubscriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.CreateAnomalySubscriptionRequest/AnomalySubscription]
    :opt-un
    [:cognitect.aws.ce.CreateAnomalySubscriptionRequest/ResourceTags]))

(s/def
  :cognitect.aws.ce/RootCause
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RootCause/UsageType
     :cognitect.aws.ce.RootCause/LinkedAccount
     :cognitect.aws.ce.RootCause/LinkedAccountName
     :cognitect.aws.ce.RootCause/Service
     :cognitect.aws.ce.RootCause/Region]))

(s/def
  :cognitect.aws.ce/RecommendationId
  (s/spec
    #(re-matches (re-pattern "^[\\S\\s]{8}-[\\S\\s]{4}-[\\S\\s]{4}-[\\S\\s]{4}-[\\S\\s]{12}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ce/CostAllocationTagStatus
  (s/spec string? :gen #(s/gen #{"Active" "Inactive"})))

(s/def
  :cognitect.aws.ce/Context
  (s/spec string? :gen #(s/gen #{"SAVINGS_PLANS" "COST_AND_USAGE" "RESERVATIONS"})))

(s/def
  :cognitect.aws.ce/EC2ResourceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.EC2ResourceDetails/NetworkPerformance
     :cognitect.aws.ce.EC2ResourceDetails/Storage
     :cognitect.aws.ce.EC2ResourceDetails/HourlyOnDemandRate
     :cognitect.aws.ce.EC2ResourceDetails/Platform
     :cognitect.aws.ce.EC2ResourceDetails/InstanceType
     :cognitect.aws.ce.EC2ResourceDetails/Vcpu
     :cognitect.aws.ce.EC2ResourceDetails/Memory
     :cognitect.aws.ce.EC2ResourceDetails/Sku
     :cognitect.aws.ce.EC2ResourceDetails/Region]))

(s/def :cognitect.aws.ce/UnusedHours string?)

(s/def
  :cognitect.aws.ce/Expression
  (s/keys
    :opt-un
    [:cognitect.aws.ce.Expression/And
     :cognitect.aws.ce.Expression/CostCategories
     :cognitect.aws.ce.Expression/Tags
     :cognitect.aws.ce.Expression/Not
     :cognitect.aws.ce.Expression/Dimensions
     :cognitect.aws.ce.Expression/Or]))

(s/def
  :cognitect.aws.ce/ReservationCoverageGroup
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationCoverageGroup/Coverage
     :cognitect.aws.ce.ReservationCoverageGroup/Attributes]))

(s/def
  :cognitect.aws.ce/AnomalyDateInterval
  (s/keys
    :req-un
    [:cognitect.aws.ce.AnomalyDateInterval/StartDate]
    :opt-un
    [:cognitect.aws.ce.AnomalyDateInterval/EndDate]))

(s/def
  :cognitect.aws.ce/CostCategoryRule
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CostCategoryRule/Type
     :cognitect.aws.ce.CostCategoryRule/Value
     :cognitect.aws.ce.CostCategoryRule/Rule
     :cognitect.aws.ce.CostCategoryRule/InheritedValue]))

(s/def :cognitect.aws.ce/AmortizedUpfrontFee string?)

(s/def
  :cognitect.aws.ce/MatchOption
  (s/spec
    string?
    :gen
    #(s/gen
      #{"GREATER_THAN_OR_EQUAL"
        "ABSENT"
        "CONTAINS"
        "CASE_SENSITIVE"
        "CASE_INSENSITIVE"
        "ENDS_WITH"
        "EQUALS"
        "STARTS_WITH"})))

(s/def
  :cognitect.aws.ce/ResourceTagKeyList
  (s/coll-of :cognitect.aws.ce/ResourceTagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.ce/InstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.InstanceDetails/EC2InstanceDetails
     :cognitect.aws.ce.InstanceDetails/RedshiftInstanceDetails
     :cognitect.aws.ce.InstanceDetails/ESInstanceDetails
     :cognitect.aws.ce.InstanceDetails/ElastiCacheInstanceDetails
     :cognitect.aws.ce.InstanceDetails/MemoryDBInstanceDetails
     :cognitect.aws.ce.InstanceDetails/RDSInstanceDetails]))

(s/def
  :cognitect.aws.ce/CreateAnomalySubscriptionResponse
  (s/keys :req-un [:cognitect.aws.ce.CreateAnomalySubscriptionResponse/SubscriptionArn]))

(s/def
  :cognitect.aws.ce/ReservationUtilizationGroups
  (s/coll-of :cognitect.aws.ce/ReservationUtilizationGroup))

(s/def
  :cognitect.aws.ce/PlatformDifference
  (s/spec
    string?
    :gen
    #(s/gen
      #{"STORAGE_INTERFACE"
        "VIRTUALIZATION_TYPE"
        "NETWORK_INTERFACE"
        "INSTANCE_STORE_AVAILABILITY"
        "HYPERVISOR"})))

(s/def
  :cognitect.aws.ce/UpdateCostAllocationTagsStatusResponse
  (s/keys :opt-un [:cognitect.aws.ce.UpdateCostAllocationTagsStatusResponse/Errors]))

(s/def :cognitect.aws.ce/SavingsPlansCoverages (s/coll-of :cognitect.aws.ce/SavingsPlansCoverage))

(s/def
  :cognitect.aws.ce/GetRightsizingRecommendationRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetRightsizingRecommendationRequest/Service]
    :opt-un
    [:cognitect.aws.ce.GetRightsizingRecommendationRequest/Filter
     :cognitect.aws.ce.GetRightsizingRecommendationRequest/PageSize
     :cognitect.aws.ce.GetRightsizingRecommendationRequest/Configuration
     :cognitect.aws.ce.GetRightsizingRecommendationRequest/NextPageToken]))

(s/def :cognitect.aws.ce/UnrealizedSavings string?)

(s/def
  :cognitect.aws.ce/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.ce.ListTagsForResourceRequest/ResourceArn]))

(s/def :cognitect.aws.ce/MetricUnit string?)

(s/def
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationDetailList
  (s/coll-of :cognitect.aws.ce/SavingsPlansPurchaseRecommendationDetail))

(s/def :cognitect.aws.ce/Values (s/coll-of :cognitect.aws.ce/Value))

(s/def
  :cognitect.aws.ce/ResourceUtilization
  (s/keys :opt-un [:cognitect.aws.ce.ResourceUtilization/EC2ResourceUtilization]))

(s/def :cognitect.aws.ce/CoverageHoursPercentage string?)

(s/def :cognitect.aws.ce/GroupDefinitions (s/coll-of :cognitect.aws.ce/GroupDefinition))

(s/def :cognitect.aws.ce/OfferingClass (s/spec string? :gen #(s/gen #{"STANDARD" "CONVERTIBLE"})))

(s/def
  :cognitect.aws.ce/NextPageToken
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/SortDefinition
  (s/keys
    :req-un
    [:cognitect.aws.ce.SortDefinition/Key]
    :opt-un
    [:cognitect.aws.ce.SortDefinition/SortOrder]))

(s/def
  :cognitect.aws.ce/DescribeCostCategoryDefinitionRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.DescribeCostCategoryDefinitionRequest/CostCategoryArn]
    :opt-un
    [:cognitect.aws.ce.DescribeCostCategoryDefinitionRequest/EffectiveOn]))

(s/def :cognitect.aws.ce/TotalRunningHours string?)

(s/def :cognitect.aws.ce/PlatformDifferences (s/coll-of :cognitect.aws.ce/PlatformDifference))

(s/def
  :cognitect.aws.ce/TerminateRecommendationDetail
  (s/keys
    :opt-un
    [:cognitect.aws.ce.TerminateRecommendationDetail/CurrencyCode
     :cognitect.aws.ce.TerminateRecommendationDetail/EstimatedMonthlySavings]))

(s/def :cognitect.aws.ce/AnomalySubscriptions (s/coll-of :cognitect.aws.ce/AnomalySubscription))

(s/def :cognitect.aws.ce/DeleteAnomalyMonitorResponse (s/keys))

(s/def
  :cognitect.aws.ce/CostCategoryInheritedValueDimensionName
  (s/spec string? :gen #(s/gen #{"TAG" "LINKED_ACCOUNT_NAME"})))

(s/def :cognitect.aws.ce/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ce/SavingsPlansDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansDetails/OfferingId
     :cognitect.aws.ce.SavingsPlansDetails/InstanceFamily
     :cognitect.aws.ce.SavingsPlansDetails/Region]))

(s/def :cognitect.aws.ce/ReservationGroupKey string?)

(s/def
  :cognitect.aws.ce/PaymentOption
  (s/spec
    string?
    :gen
    #(s/gen
      #{"LIGHT_UTILIZATION"
        "NO_UPFRONT"
        "HEAVY_UTILIZATION"
        "PARTIAL_UPFRONT"
        "ALL_UPFRONT"
        "MEDIUM_UTILIZATION"})))

(s/def
  :cognitect.aws.ce/ReservationUtilizationGroup
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationUtilizationGroup/Key
     :cognitect.aws.ce.ReservationUtilizationGroup/Attributes
     :cognitect.aws.ce.ReservationUtilizationGroup/Value
     :cognitect.aws.ce.ReservationUtilizationGroup/Utilization]))

(s/def :cognitect.aws.ce/FindingReasonCodes (s/coll-of :cognitect.aws.ce/FindingReasonCode))

(s/def :cognitect.aws.ce/GenerationSummaryList (s/coll-of :cognitect.aws.ce/GenerationSummary))

(s/def
  :cognitect.aws.ce/CurrentInstance
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CurrentInstance/CurrencyCode
     :cognitect.aws.ce.CurrentInstance/ResourceDetails
     :cognitect.aws.ce.CurrentInstance/TotalRunningHoursInLookbackPeriod
     :cognitect.aws.ce.CurrentInstance/MonthlyCost
     :cognitect.aws.ce.CurrentInstance/Tags
     :cognitect.aws.ce.CurrentInstance/ResourceId
     :cognitect.aws.ce.CurrentInstance/ReservationCoveredHoursInLookbackPeriod
     :cognitect.aws.ce.CurrentInstance/InstanceName
     :cognitect.aws.ce.CurrentInstance/SavingsPlansCoveredHoursInLookbackPeriod
     :cognitect.aws.ce.CurrentInstance/ResourceUtilization
     :cognitect.aws.ce.CurrentInstance/OnDemandHoursInLookbackPeriod]))

(s/def
  :cognitect.aws.ce/CostAllocationTagList
  (s/coll-of :cognitect.aws.ce/CostAllocationTag :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.ce/EC2Specification
  (s/keys :opt-un [:cognitect.aws.ce.EC2Specification/OfferingClass]))

(s/def :cognitect.aws.ce/MonitorArnList (s/coll-of :cognitect.aws.ce/Arn))

(s/def
  :cognitect.aws.ce/ListSavingsPlansPurchaseRecommendationGenerationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationResponse/GenerationSummaryList
     :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/GetTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetTagsRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetTagsRequest/SearchString
     :cognitect.aws.ce.GetTagsRequest/Filter
     :cognitect.aws.ce.GetTagsRequest/SortBy
     :cognitect.aws.ce.GetTagsRequest/TagKey
     :cognitect.aws.ce.GetTagsRequest/MaxResults
     :cognitect.aws.ce.GetTagsRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/AnomalySubscription
  (s/keys
    :req-un
    [:cognitect.aws.ce.AnomalySubscription/MonitorArnList
     :cognitect.aws.ce.AnomalySubscription/Subscribers
     :cognitect.aws.ce.AnomalySubscription/Frequency
     :cognitect.aws.ce.AnomalySubscription/SubscriptionName]
    :opt-un
    [:cognitect.aws.ce.AnomalySubscription/Threshold
     :cognitect.aws.ce.AnomalySubscription/SubscriptionArn
     :cognitect.aws.ce.AnomalySubscription/ThresholdExpression
     :cognitect.aws.ce.AnomalySubscription/AccountId]))

(s/def :cognitect.aws.ce/MonitorType (s/spec string? :gen #(s/gen #{"CUSTOM" "DIMENSIONAL"})))

(s/def :cognitect.aws.ce/TotalRunningNormalizedUnits string?)

(s/def
  :cognitect.aws.ce/DimensionValuesWithAttributesList
  (s/coll-of :cognitect.aws.ce/DimensionValuesWithAttributes))

(s/def :cognitect.aws.ce/Keys (s/coll-of :cognitect.aws.ce/Key))

(s/def
  :cognitect.aws.ce/LookbackPeriodInDays
  (s/spec string? :gen #(s/gen #{"SIXTY_DAYS" "SEVEN_DAYS" "THIRTY_DAYS"})))

(s/def
  :cognitect.aws.ce/CostCategoryReference
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CostCategoryReference/ProcessingStatus
     :cognitect.aws.ce.CostCategoryReference/CostCategoryArn
     :cognitect.aws.ce.CostCategoryReference/EffectiveStart
     :cognitect.aws.ce.CostCategoryReference/EffectiveEnd
     :cognitect.aws.ce.CostCategoryReference/Values
     :cognitect.aws.ce.CostCategoryReference/DefaultValue
     :cognitect.aws.ce.CostCategoryReference/Name
     :cognitect.aws.ce.CostCategoryReference/NumberOfRules]))

(s/def :cognitect.aws.ce/MatchOptions (s/coll-of :cognitect.aws.ce/MatchOption))

(s/def
  :cognitect.aws.ce/EBSResourceUtilization
  (s/keys
    :opt-un
    [:cognitect.aws.ce.EBSResourceUtilization/EbsWriteOpsPerSecond
     :cognitect.aws.ce.EBSResourceUtilization/EbsReadOpsPerSecond
     :cognitect.aws.ce.EBSResourceUtilization/EbsReadBytesPerSecond
     :cognitect.aws.ce.EBSResourceUtilization/EbsWriteBytesPerSecond]))

(s/def
  :cognitect.aws.ce/AnomalyScore
  (s/keys
    :req-un
    [:cognitect.aws.ce.AnomalyScore/MaxScore :cognitect.aws.ce.AnomalyScore/CurrentScore]))

(s/def
  :cognitect.aws.ce/ForecastResult
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ForecastResult/MeanValue
     :cognitect.aws.ce.ForecastResult/PredictionIntervalUpperBound
     :cognitect.aws.ce.ForecastResult/PredictionIntervalLowerBound
     :cognitect.aws.ce.ForecastResult/TimePeriod]))

(s/def
  :cognitect.aws.ce/RightsizingRecommendationList
  (s/coll-of :cognitect.aws.ce/RightsizingRecommendation))

(s/def
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationDetail
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/HourlyCommitmentToPurchase
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrencyCode
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/RecommendationDetailId
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentMaximumHourlyOnDemandSpend
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSavingsAmount
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedAverageUtilization
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedMonthlySavingsAmount
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/UpfrontCost
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentAverageHourlyOnDemandSpend
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedROI
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSavingsPercentage
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedOnDemandCost
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/AccountId
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSPCost
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentMinimumHourlyOnDemandSpend
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/SavingsPlansDetails
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedOnDemandCostWithCurrentCommitment]))

(s/def
  :cognitect.aws.ce/ElastiCacheInstanceDetails
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ElastiCacheInstanceDetails/Family
     :cognitect.aws.ce.ElastiCacheInstanceDetails/SizeFlexEligible
     :cognitect.aws.ce.ElastiCacheInstanceDetails/ProductDescription
     :cognitect.aws.ce.ElastiCacheInstanceDetails/CurrentGeneration
     :cognitect.aws.ce.ElastiCacheInstanceDetails/NodeType
     :cognitect.aws.ce.ElastiCacheInstanceDetails/Region]))

(s/def :cognitect.aws.ce/ForecastResultsByTime (s/coll-of :cognitect.aws.ce/ForecastResult))

(s/def
  :cognitect.aws.ce/RightsizingRecommendationConfiguration
  (s/keys
    :req-un
    [:cognitect.aws.ce.RightsizingRecommendationConfiguration/RecommendationTarget
     :cognitect.aws.ce.RightsizingRecommendationConfiguration/BenefitsConsidered]))

(s/def
  :cognitect.aws.ce/StartSavingsPlansPurchaseRecommendationGenerationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/EstimatedCompletionTime
     :cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/RecommendationId
     :cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/GenerationStartedTime]))

(s/def
  :cognitect.aws.ce/CoverageByTime
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CoverageByTime/TimePeriod
     :cognitect.aws.ce.CoverageByTime/Total
     :cognitect.aws.ce.CoverageByTime/Groups]))

(s/def :cognitect.aws.ce/SortOrder (s/spec string? :gen #(s/gen #{"ASCENDING" "DESCENDING"})))

(s/def :cognitect.aws.ce/UnusedUnits string?)

(s/def :cognitect.aws.ce/CoverageNormalizedUnitsPercentage string?)

(s/def :cognitect.aws.ce/TermInYears (s/spec string? :gen #(s/gen #{"ONE_YEAR" "THREE_YEARS"})))

(s/def
  :cognitect.aws.ce/UpdateCostAllocationTagsStatusError
  (s/keys
    :opt-un
    [:cognitect.aws.ce.UpdateCostAllocationTagsStatusError/TagKey
     :cognitect.aws.ce.UpdateCostAllocationTagsStatusError/Message
     :cognitect.aws.ce.UpdateCostAllocationTagsStatusError/Code]))

(s/def
  :cognitect.aws.ce/CoverageCost
  (s/keys :opt-un [:cognitect.aws.ce.CoverageCost/OnDemandCost]))

(s/def
  :cognitect.aws.ce/GetSavingsPlanPurchaseRecommendationDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsRequest/RecommendationDetailId]))

(s/def :cognitect.aws.ce/UtilizationPercentageInUnits string?)

(s/def
  :cognitect.aws.ce/UpdateCostAllocationTagsStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.UpdateCostAllocationTagsStatusRequest/CostAllocationTagsStatus]))

(s/def
  :cognitect.aws.ce/GenerationStatus
  (s/spec string? :gen #(s/gen #{"SUCCEEDED" "FAILED" "PROCESSING"})))

(s/def
  :cognitect.aws.ce/ModifyRecommendationDetail
  (s/keys :opt-un [:cognitect.aws.ce.ModifyRecommendationDetail/TargetInstances]))

(s/def
  :cognitect.aws.ce/Arn
  (s/spec
    #(re-matches
      (re-pattern "arn:aws[-a-z0-9]*:[a-z0-9]+:[-a-z0-9]*:[0-9]{12}:[-a-zA-Z0-9/:_]+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendation
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansPurchaseRecommendation/TermInYears
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/PaymentOption
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/AccountScope
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/LookbackPeriodInDays
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansPurchaseRecommendationSummary
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansPurchaseRecommendationDetails
     :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansType]))

(s/def
  :cognitect.aws.ce/GetAnomalySubscriptionsResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetAnomalySubscriptionsResponse/AnomalySubscriptions]
    :opt-un
    [:cognitect.aws.ce.GetAnomalySubscriptionsResponse/NextPageToken]))

(s/def :cognitect.aws.ce/SubscriberType (s/spec string? :gen #(s/gen #{"SNS" "EMAIL"})))

(s/def
  :cognitect.aws.ce/GenericString
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRuleParameter
  (s/keys
    :req-un
    [:cognitect.aws.ce.CostCategorySplitChargeRuleParameter/Type
     :cognitect.aws.ce.CostCategorySplitChargeRuleParameter/Values]))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRulesList
  (s/coll-of :cognitect.aws.ce/CostCategorySplitChargeRule :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendationDetails
  (s/coll-of :cognitect.aws.ce/ReservationPurchaseRecommendationDetail))

(s/def :cognitect.aws.ce/Value (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/Subscriber
  (s/keys
    :opt-un
    [:cognitect.aws.ce.Subscriber/Address
     :cognitect.aws.ce.Subscriber/Type
     :cognitect.aws.ce.Subscriber/Status]))

(s/def :cognitect.aws.ce/ResultsByTime (s/coll-of :cognitect.aws.ce/ResultByTime))

(s/def
  :cognitect.aws.ce/NetworkResourceUtilization
  (s/keys
    :opt-un
    [:cognitect.aws.ce.NetworkResourceUtilization/NetworkPacketsInPerSecond
     :cognitect.aws.ce.NetworkResourceUtilization/NetworkOutBytesPerSecond
     :cognitect.aws.ce.NetworkResourceUtilization/NetworkPacketsOutPerSecond
     :cognitect.aws.ce.NetworkResourceUtilization/NetworkInBytesPerSecond]))

(s/def
  :cognitect.aws.ce/GetSavingsPlansPurchaseRecommendationRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/SavingsPlansType
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/TermInYears
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/PaymentOption
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/LookbackPeriodInDays]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/Filter
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/PageSize
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/AccountScope
     :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/NextPageToken]))

(s/def
  :cognitect.aws.ce/DeleteCostCategoryDefinitionRequest
  (s/keys :req-un [:cognitect.aws.ce.DeleteCostCategoryDefinitionRequest/CostCategoryArn]))

(s/def
  :cognitect.aws.ce/RecommendationDetailHourlyMetrics
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedCoverage
     :cognitect.aws.ce.RecommendationDetailHourlyMetrics/StartTime
     :cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedOnDemandCost
     :cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedNewCommitmentUtilization
     :cognitect.aws.ce.RecommendationDetailHourlyMetrics/CurrentCoverage]))

(s/def :cognitect.aws.ce/Estimated boolean?)

(s/def
  :cognitect.aws.ce/GetAnomalyMonitorsResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetAnomalyMonitorsResponse/AnomalyMonitors]
    :opt-un
    [:cognitect.aws.ce.GetAnomalyMonitorsResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/GenerationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GenerationSummary/GenerationCompletionTime
     :cognitect.aws.ce.GenerationSummary/GenerationStatus
     :cognitect.aws.ce.GenerationSummary/EstimatedCompletionTime
     :cognitect.aws.ce.GenerationSummary/RecommendationId
     :cognitect.aws.ce.GenerationSummary/GenerationStartedTime]))

(s/def :cognitect.aws.ce/PageSize (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.ce/MaxResults
  (s/spec (s/and int? #(<= 1 %)) :gen #(gen/choose 1 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.ce/ListCostCategoryDefinitionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListCostCategoryDefinitionsRequest/EffectiveOn
     :cognitect.aws.ce.ListCostCategoryDefinitionsRequest/NextToken
     :cognitect.aws.ce.ListCostCategoryDefinitionsRequest/MaxResults]))

(s/def
  :cognitect.aws.ce/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.UntagResourceRequest/ResourceArn
     :cognitect.aws.ce.UntagResourceRequest/ResourceTagKeys]))

(s/def
  :cognitect.aws.ce/TagKey
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/ProvideAnomalyFeedbackResponse
  (s/keys :req-un [:cognitect.aws.ce.ProvideAnomalyFeedbackResponse/AnomalyId]))

(s/def :cognitect.aws.ce/AnomalyMonitors (s/coll-of :cognitect.aws.ce/AnomalyMonitor))

(s/def
  :cognitect.aws.ce/GetAnomaliesResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetAnomaliesResponse/Anomalies]
    :opt-un
    [:cognitect.aws.ce.GetAnomaliesResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/GetSavingsPlansUtilizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationRequest/Filter
     :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/SortBy
     :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/Granularity]))

(s/def
  :cognitect.aws.ce/SavingsPlansCoverageData
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansCoverageData/CoveragePercentage
     :cognitect.aws.ce.SavingsPlansCoverageData/OnDemandCost
     :cognitect.aws.ce.SavingsPlansCoverageData/SpendCoveredBySavingsPlans
     :cognitect.aws.ce.SavingsPlansCoverageData/TotalCost]))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendationSummary
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationPurchaseRecommendationSummary/CurrencyCode
     :cognitect.aws.ce.ReservationPurchaseRecommendationSummary/TotalEstimatedMonthlySavingsPercentage
     :cognitect.aws.ce.ReservationPurchaseRecommendationSummary/TotalEstimatedMonthlySavingsAmount]))

(s/def :cognitect.aws.ce/RICostForUnusedHours string?)

(s/def
  :cognitect.aws.ce/ServiceSpecification
  (s/keys :opt-un [:cognitect.aws.ce.ServiceSpecification/EC2Specification]))

(s/def
  :cognitect.aws.ce/GetSavingsPlansCoverageRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansCoverageRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansCoverageRequest/Filter
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/SortBy
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/NextToken
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/GroupBy
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/Granularity
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/MaxResults
     :cognitect.aws.ce.GetSavingsPlansCoverageRequest/Metrics]))

(s/def :cognitect.aws.ce/AmortizedRecurringFee string?)

(s/def
  :cognitect.aws.ce/AnomalyMonitor
  (s/keys
    :req-un
    [:cognitect.aws.ce.AnomalyMonitor/MonitorName :cognitect.aws.ce.AnomalyMonitor/MonitorType]
    :opt-un
    [:cognitect.aws.ce.AnomalyMonitor/LastUpdatedDate
     :cognitect.aws.ce.AnomalyMonitor/MonitorSpecification
     :cognitect.aws.ce.AnomalyMonitor/MonitorArn
     :cognitect.aws.ce.AnomalyMonitor/DimensionalValueCount
     :cognitect.aws.ce.AnomalyMonitor/MonitorDimension
     :cognitect.aws.ce.AnomalyMonitor/LastEvaluatedDate
     :cognitect.aws.ce.AnomalyMonitor/CreationDate]))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilizationByTime
  (s/keys
    :req-un
    [:cognitect.aws.ce.SavingsPlansUtilizationByTime/TimePeriod
     :cognitect.aws.ce.SavingsPlansUtilizationByTime/Utilization]
    :opt-un
    [:cognitect.aws.ce.SavingsPlansUtilizationByTime/AmortizedCommitment
     :cognitect.aws.ce.SavingsPlansUtilizationByTime/Savings]))

(s/def
  :cognitect.aws.ce/CostAllocationTagStatusEntry
  (s/keys
    :req-un
    [:cognitect.aws.ce.CostAllocationTagStatusEntry/TagKey
     :cognitect.aws.ce.CostAllocationTagStatusEntry/Status]))

(s/def
  :cognitect.aws.ce/CostCategoryMaxResults
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.ce/GetSavingsPlansCoverageResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansCoverageResponse/SavingsPlansCoverages]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansCoverageResponse/NextToken]))

(s/def
  :cognitect.aws.ce/ZonedDateTime
  (s/spec
    #(re-matches
      (re-pattern "^\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(([+-]\\d\\d:\\d\\d)|Z)$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ce/Attributes
  (s/map-of :cognitect.aws.ce/AttributeType :cognitect.aws.ce/AttributeValue))

(s/def
  :cognitect.aws.ce/SavingsPlansUtilization
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansUtilization/TotalCommitment
     :cognitect.aws.ce.SavingsPlansUtilization/UtilizationPercentage
     :cognitect.aws.ce.SavingsPlansUtilization/UnusedCommitment
     :cognitect.aws.ce.SavingsPlansUtilization/UsedCommitment]))

(s/def
  :cognitect.aws.ce/GetRightsizingRecommendationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetRightsizingRecommendationResponse/RightsizingRecommendations
     :cognitect.aws.ce.GetRightsizingRecommendationResponse/Summary
     :cognitect.aws.ce.GetRightsizingRecommendationResponse/Metadata
     :cognitect.aws.ce.GetRightsizingRecommendationResponse/Configuration
     :cognitect.aws.ce.GetRightsizingRecommendationResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/ReservationPurchaseRecommendationMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ReservationPurchaseRecommendationMetadata/RecommendationId
     :cognitect.aws.ce.ReservationPurchaseRecommendationMetadata/GenerationTimestamp]))

(s/def :cognitect.aws.ce/CostCategoryNamesList (s/coll-of :cognitect.aws.ce/CostCategoryName))

(s/def :cognitect.aws.ce/RecommendationIdList (s/coll-of :cognitect.aws.ce/RecommendationId))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRuleParametersList
  (s/coll-of :cognitect.aws.ce/CostCategorySplitChargeRuleParameter :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.ce/CreateAnomalyMonitorRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.CreateAnomalyMonitorRequest/AnomalyMonitor]
    :opt-un
    [:cognitect.aws.ce.CreateAnomalyMonitorRequest/ResourceTags]))

(s/def
  :cognitect.aws.ce/ProvideAnomalyFeedbackRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.ProvideAnomalyFeedbackRequest/AnomalyId
     :cognitect.aws.ce.ProvideAnomalyFeedbackRequest/Feedback]))

(s/def
  :cognitect.aws.ce/RightsizingRecommendationMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RightsizingRecommendationMetadata/LookbackPeriodInDays
     :cognitect.aws.ce.RightsizingRecommendationMetadata/AdditionalMetadata
     :cognitect.aws.ce.RightsizingRecommendationMetadata/RecommendationId
     :cognitect.aws.ce.RightsizingRecommendationMetadata/GenerationTimestamp]))

(s/def
  :cognitect.aws.ce/GetCostForecastResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetCostForecastResponse/Total
     :cognitect.aws.ce.GetCostForecastResponse/ForecastResultsByTime]))

(s/def
  :cognitect.aws.ce/CreateCostCategoryDefinitionRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.CreateCostCategoryDefinitionRequest/Name
     :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/RuleVersion
     :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/Rules]
    :opt-un
    [:cognitect.aws.ce.CreateCostCategoryDefinitionRequest/EffectiveStart
     :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/ResourceTags
     :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/DefaultValue
     :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/SplitChargeRules]))

(s/def
  :cognitect.aws.ce/SavingsPlansAmortizedCommitment
  (s/keys
    :opt-un
    [:cognitect.aws.ce.SavingsPlansAmortizedCommitment/AmortizedUpfrontCommitment
     :cognitect.aws.ce.SavingsPlansAmortizedCommitment/AmortizedRecurringCommitment
     :cognitect.aws.ce.SavingsPlansAmortizedCommitment/TotalAmortizedCommitment]))

(s/def
  :cognitect.aws.ce/GetReservationCoverageResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetReservationCoverageResponse/CoveragesByTime]
    :opt-un
    [:cognitect.aws.ce.GetReservationCoverageResponse/Total
     :cognitect.aws.ce.GetReservationCoverageResponse/NextPageToken]))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeMethod
  (s/spec string? :gen #(s/gen #{"FIXED" "PROPORTIONAL" "EVEN"})))

(s/def
  :cognitect.aws.ce/UpdateCostCategoryDefinitionRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/CostCategoryArn
     :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/RuleVersion
     :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/Rules]
    :opt-un
    [:cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/EffectiveStart
     :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/DefaultValue
     :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/SplitChargeRules]))

(s/def
  :cognitect.aws.ce/GetSavingsPlanPurchaseRecommendationDetailsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsResponse/RecommendationDetailId
     :cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsResponse/RecommendationDetailData]))

(s/def
  :cognitect.aws.ce/CoverageNormalizedUnits
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CoverageNormalizedUnits/TotalRunningNormalizedUnits
     :cognitect.aws.ce.CoverageNormalizedUnits/CoverageNormalizedUnitsPercentage
     :cognitect.aws.ce.CoverageNormalizedUnits/ReservedNormalizedUnits
     :cognitect.aws.ce.CoverageNormalizedUnits/OnDemandNormalizedUnits]))

(s/def :cognitect.aws.ce/ReservedNormalizedUnits string?)

(s/def :cognitect.aws.ce/Granularity (s/spec string? :gen #(s/gen #{"MONTHLY" "DAILY" "HOURLY"})))

(s/def :cognitect.aws.ce/RightsizingType (s/spec string? :gen #(s/gen #{"MODIFY" "TERMINATE"})))

(s/def
  :cognitect.aws.ce/MetricName
  (s/spec #(re-matches (re-pattern "[\\S\\s]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ce/DimensionValuesWithAttributes
  (s/keys
    :opt-un
    [:cognitect.aws.ce.DimensionValuesWithAttributes/Attributes
     :cognitect.aws.ce.DimensionValuesWithAttributes/Value]))

(s/def
  :cognitect.aws.ce/CostCategoryReferencesList
  (s/coll-of :cognitect.aws.ce/CostCategoryReference))

(s/def
  :cognitect.aws.ce/Metric
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AMORTIZED_COST"
        "BLENDED_COST"
        "USAGE_QUANTITY"
        "NET_UNBLENDED_COST"
        "UNBLENDED_COST"
        "NET_AMORTIZED_COST"
        "NORMALIZED_USAGE_AMOUNT"})))

(s/def
  :cognitect.aws.ce/CoverageHours
  (s/keys
    :opt-un
    [:cognitect.aws.ce.CoverageHours/ReservedHours
     :cognitect.aws.ce.CoverageHours/CoverageHoursPercentage
     :cognitect.aws.ce.CoverageHours/TotalRunningHours
     :cognitect.aws.ce.CoverageHours/OnDemandHours]))

(s/def :cognitect.aws.ce/Subscribers (s/coll-of :cognitect.aws.ce/Subscriber))

(s/def :cognitect.aws.ce/GenericBoolean boolean?)

(s/def :cognitect.aws.ce/RealizedSavings string?)

(s/def :cognitect.aws.ce/TotalAmortizedFee string?)

(s/def
  :cognitect.aws.ce/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.ce.ListTagsForResourceResponse/ResourceTags]))

(s/def :cognitect.aws.ce/OnDemandNormalizedUnits string?)

(s/def :cognitect.aws.ce/AccountScope (s/spec string? :gen #(s/gen #{"PAYER" "LINKED"})))

(s/def :cognitect.aws.ce/MetricNames (s/coll-of :cognitect.aws.ce/MetricName))

(s/def
  :cognitect.aws.ce/CostCategorySplitChargeRule
  (s/keys
    :req-un
    [:cognitect.aws.ce.CostCategorySplitChargeRule/Source
     :cognitect.aws.ce.CostCategorySplitChargeRule/Targets
     :cognitect.aws.ce.CostCategorySplitChargeRule/Method]
    :opt-un
    [:cognitect.aws.ce.CostCategorySplitChargeRule/Parameters]))

(s/def
  :cognitect.aws.ce/CostAllocationTagKeyList
  (s/coll-of :cognitect.aws.ce/TagKey :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.ce/RightsizingRecommendation
  (s/keys
    :opt-un
    [:cognitect.aws.ce.RightsizingRecommendation/CurrentInstance
     :cognitect.aws.ce.RightsizingRecommendation/TerminateRecommendationDetail
     :cognitect.aws.ce.RightsizingRecommendation/RightsizingType
     :cognitect.aws.ce.RightsizingRecommendation/ModifyRecommendationDetail
     :cognitect.aws.ce.RightsizingRecommendation/AccountId
     :cognitect.aws.ce.RightsizingRecommendation/FindingReasonCodes]))

(s/def
  :cognitect.aws.ce/GroupDefinition
  (s/keys :opt-un [:cognitect.aws.ce.GroupDefinition/Type :cognitect.aws.ce.GroupDefinition/Key]))

(s/def :cognitect.aws.ce/AttributeValue string?)

(s/def :cognitect.aws.ce/OnDemandHours string?)

(s/def :cognitect.aws.ce/SavingsPlansDataTypes (s/coll-of :cognitect.aws.ce/SavingsPlansDataType))

(s/def
  :cognitect.aws.ce/ListCostAllocationTagsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ce.ListCostAllocationTagsRequest/TagKeys
     :cognitect.aws.ce.ListCostAllocationTagsRequest/Type
     :cognitect.aws.ce.ListCostAllocationTagsRequest/Status
     :cognitect.aws.ce.ListCostAllocationTagsRequest/NextToken
     :cognitect.aws.ce.ListCostAllocationTagsRequest/MaxResults]))

(s/def
  :cognitect.aws.ce/TargetInstance
  (s/keys
    :opt-un
    [:cognitect.aws.ce.TargetInstance/CurrencyCode
     :cognitect.aws.ce.TargetInstance/PlatformDifferences
     :cognitect.aws.ce.TargetInstance/ResourceDetails
     :cognitect.aws.ce.TargetInstance/EstimatedMonthlySavings
     :cognitect.aws.ce.TargetInstance/ExpectedResourceUtilization
     :cognitect.aws.ce.TargetInstance/EstimatedMonthlyCost
     :cognitect.aws.ce.TargetInstance/DefaultTargetInstance]))

(s/def
  :cognitect.aws.ce/SupportedSavingsPlansType
  (s/spec string? :gen #(s/gen #{"SAGEMAKER_SP" "COMPUTE_SP" "EC2_INSTANCE_SP"})))

(s/def
  :cognitect.aws.ce/AnomalySubscriptionFrequency
  (s/spec string? :gen #(s/gen #{"IMMEDIATE" "WEEKLY" "DAILY"})))

(s/def
  :cognitect.aws.ce/GetCostForecastRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetCostForecastRequest/TimePeriod
     :cognitect.aws.ce.GetCostForecastRequest/Metric
     :cognitect.aws.ce.GetCostForecastRequest/Granularity]
    :opt-un
    [:cognitect.aws.ce.GetCostForecastRequest/Filter
     :cognitect.aws.ce.GetCostForecastRequest/PredictionIntervalLevel]))

(s/def
  :cognitect.aws.ce/GetDimensionValuesResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetDimensionValuesResponse/DimensionValues
     :cognitect.aws.ce.GetDimensionValuesResponse/ReturnSize
     :cognitect.aws.ce.GetDimensionValuesResponse/TotalSize]
    :opt-un
    [:cognitect.aws.ce.GetDimensionValuesResponse/NextPageToken]))

(s/def :cognitect.aws.ce/TotalActualHours string?)

(s/def
  :cognitect.aws.ce/GetCostCategoriesRequest
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetCostCategoriesRequest/TimePeriod]
    :opt-un
    [:cognitect.aws.ce.GetCostCategoriesRequest/SearchString
     :cognitect.aws.ce.GetCostCategoriesRequest/Filter
     :cognitect.aws.ce.GetCostCategoriesRequest/CostCategoryName
     :cognitect.aws.ce.GetCostCategoriesRequest/SortBy
     :cognitect.aws.ce.GetCostCategoriesRequest/MaxResults
     :cognitect.aws.ce.GetCostCategoriesRequest/NextPageToken]))

(s/def :cognitect.aws.ce/SortDefinitions (s/coll-of :cognitect.aws.ce/SortDefinition))

(s/def :cognitect.aws.ce/Entity string?)

(s/def
  :cognitect.aws.ce/DeleteCostCategoryDefinitionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ce.DeleteCostCategoryDefinitionResponse/CostCategoryArn
     :cognitect.aws.ce.DeleteCostCategoryDefinitionResponse/EffectiveEnd]))

(s/def
  :cognitect.aws.ce/AnomalyFeedbackType
  (s/spec string? :gen #(s/gen #{"PLANNED_ACTIVITY" "NO" "YES"})))

(s/def :cognitect.aws.ce/NetRISavings string?)

(s/def
  :cognitect.aws.ce/GetSavingsPlansUtilizationResponse
  (s/keys
    :req-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationResponse/Total]
    :opt-un
    [:cognitect.aws.ce.GetSavingsPlansUtilizationResponse/SavingsPlansUtilizationsByTime]))

(s/def :cognitect.aws.ce/SubscriberStatus (s/spec string? :gen #(s/gen #{"DECLINED" "CONFIRMED"})))

(s/def
  :cognitect.aws.ce/NumericOperator
  (s/spec
    string?
    :gen
    #(s/gen
      #{"GREATER_THAN_OR_EQUAL"
        "GREATER_THAN"
        "LESS_THAN_OR_EQUAL"
        "LESS_THAN"
        "EQUAL"
        "BETWEEN"})))

(s/def :cognitect.aws.ce.CreateAnomalyMonitorResponse/MonitorArn :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/TimePeriod
  :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/Filter
  :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/DataType
  :cognitect.aws.ce/SavingsPlansDataTypes)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/NextToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/MaxResults
  :cognitect.aws.ce/MaxResults)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsRequest/SortBy
  :cognitect.aws.ce/SortDefinition)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationAggregates/Utilization
  :cognitect.aws.ce/SavingsPlansUtilization)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationAggregates/Savings
  :cognitect.aws.ce/SavingsPlansSavings)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationAggregates/AmortizedCommitment
  :cognitect.aws.ce/SavingsPlansAmortizedCommitment)

(s/def :cognitect.aws.ce.TagResourceRequest/ResourceArn :cognitect.aws.ce/Arn)

(s/def :cognitect.aws.ce.TagResourceRequest/ResourceTags :cognitect.aws.ce/ResourceTagList)

(s/def :cognitect.aws.ce.GetUsageForecastRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetUsageForecastRequest/Metric :cognitect.aws.ce/Metric)

(s/def :cognitect.aws.ce.GetUsageForecastRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetUsageForecastRequest/Filter :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetUsageForecastRequest/PredictionIntervalLevel
  :cognitect.aws.ce/PredictionIntervalLevel)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/Metadata
  :cognitect.aws.ce/ReservationPurchaseRecommendationMetadata)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/Recommendations
  :cognitect.aws.ce/ReservationPurchaseRecommendations)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/MonitorArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/DateInterval :cognitect.aws.ce/AnomalyDateInterval)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/Feedback :cognitect.aws.ce/AnomalyFeedbackType)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/TotalImpact :cognitect.aws.ce/TotalImpactFilter)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetAnomaliesRequest/MaxResults :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.Group/Keys :cognitect.aws.ce/Keys)

(s/def :cognitect.aws.ce.Group/Metrics :cognitect.aws.ce/Metrics)

(s/def :cognitect.aws.ce.UpdateAnomalyMonitorResponse/MonitorArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/GroupBy :cognitect.aws.ce/GroupDefinitions)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/Metrics :cognitect.aws.ce/MetricNames)

(s/def
  :cognitect.aws.ce.GetReservationCoverageRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/SortBy :cognitect.aws.ce/SortDefinition)

(s/def :cognitect.aws.ce.GetReservationCoverageRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.MemoryDBInstanceDetails/Family :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.MemoryDBInstanceDetails/NodeType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.MemoryDBInstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.MemoryDBInstanceDetails/CurrentGeneration :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.MemoryDBInstanceDetails/SizeFlexEligible :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.UpdateAnomalyMonitorRequest/MonitorArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.UpdateAnomalyMonitorRequest/MonitorName :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.DeleteAnomalySubscriptionRequest/SubscriptionArn
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/MaxCpuUtilizationPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/MaxMemoryUtilizationPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/MaxStorageUtilizationPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/EBSResourceUtilization
  :cognitect.aws.ce/EBSResourceUtilization)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/DiskResourceUtilization
  :cognitect.aws.ce/DiskResourceUtilization)

(s/def
  :cognitect.aws.ce.EC2ResourceUtilization/NetworkResourceUtilization
  :cognitect.aws.ce/NetworkResourceUtilization)

(s/def :cognitect.aws.ce.Impact/MaxImpact :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.Impact/TotalImpact :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.Impact/TotalActualSpend :cognitect.aws.ce/NullableNonNegativeDouble)

(s/def :cognitect.aws.ce.Impact/TotalExpectedSpend :cognitect.aws.ce/NullableNonNegativeDouble)

(s/def :cognitect.aws.ce.Impact/TotalImpactPercentage :cognitect.aws.ce/NullableNonNegativeDouble)

(s/def
  :cognitect.aws.ce.DiskResourceUtilization/DiskReadOpsPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.DiskResourceUtilization/DiskWriteOpsPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.DiskResourceUtilization/DiskReadBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.DiskResourceUtilization/DiskWriteBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/RecommendationId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/GenerationTimestamp
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationMetadata/AdditionalMetadata
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionResponse/SubscriptionArn
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CostAllocationTag/TagKey :cognitect.aws.ce/TagKey)

(s/def :cognitect.aws.ce.CostAllocationTag/Type :cognitect.aws.ce/CostAllocationTagType)

(s/def :cognitect.aws.ce.CostAllocationTag/Status :cognitect.aws.ce/CostAllocationTagStatus)

(s/def :cognitect.aws.ce.CostAllocationTag/LastUpdatedDate :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CostAllocationTag/LastUsedDate :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.DateInterval/Start :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.DateInterval/End :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.DeleteAnomalyMonitorRequest/MonitorArn :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.CostCategoryProcessingStatus/Component
  :cognitect.aws.ce/CostCategoryStatusComponent)

(s/def :cognitect.aws.ce.CostCategoryProcessingStatus/Status :cognitect.aws.ce/CostCategoryStatus)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/TimePeriod
  :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Granularity
  :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/Metrics :cognitect.aws.ce/MetricNames)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/GroupBy
  :cognitect.aws.ce/GroupDefinitions)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.UtilizationByTime/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.UtilizationByTime/Groups :cognitect.aws.ce/ReservationUtilizationGroups)

(s/def :cognitect.aws.ce.UtilizationByTime/Total :cognitect.aws.ce/ReservationAggregates)

(s/def :cognitect.aws.ce.GetCostAndUsageResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetCostAndUsageResponse/GroupDefinitions
  :cognitect.aws.ce/GroupDefinitions)

(s/def :cognitect.aws.ce.GetCostAndUsageResponse/ResultsByTime :cognitect.aws.ce/ResultsByTime)

(s/def
  :cognitect.aws.ce.GetCostAndUsageResponse/DimensionValueAttributes
  :cognitect.aws.ce/DimensionValuesWithAttributesList)

(s/def :cognitect.aws.ce.GetAnomalyMonitorsRequest/MonitorArnList :cognitect.aws.ce/Values)

(s/def :cognitect.aws.ce.GetAnomalyMonitorsRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetAnomalyMonitorsRequest/MaxResults :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.UpdateCostCategoryDefinitionResponse/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionResponse/EffectiveStart
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/SubscriptionArn
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Threshold
  :cognitect.aws.ce/NullableNonNegativeDouble)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Frequency
  :cognitect.aws.ce/AnomalySubscriptionFrequency)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/MonitorArnList
  :cognitect.aws.ce/MonitorArnList)

(s/def :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/Subscribers :cognitect.aws.ce/Subscribers)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/SubscriptionName
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.UpdateAnomalySubscriptionRequest/ThresholdExpression
  :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/SavingsPlansUtilizationDetails
  :cognitect.aws.ce/SavingsPlansUtilizationDetails)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/Total
  :cognitect.aws.ce/SavingsPlansUtilizationAggregates)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/TimePeriod
  :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationDetailsResponse/NextToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.RedshiftInstanceDetails/Family :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RedshiftInstanceDetails/NodeType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RedshiftInstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RedshiftInstanceDetails/CurrentGeneration :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.RedshiftInstanceDetails/SizeFlexEligible :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.ReservationAggregates/TotalPotentialRISavings
  :cognitect.aws.ce/TotalPotentialRISavings)

(s/def
  :cognitect.aws.ce.ReservationAggregates/OnDemandCostOfRIHoursUsed
  :cognitect.aws.ce/OnDemandCostOfRIHoursUsed)

(s/def :cognitect.aws.ce.ReservationAggregates/PurchasedUnits :cognitect.aws.ce/PurchasedUnits)

(s/def
  :cognitect.aws.ce.ReservationAggregates/UtilizationPercentage
  :cognitect.aws.ce/UtilizationPercentage)

(s/def :cognitect.aws.ce.ReservationAggregates/TotalActualUnits :cognitect.aws.ce/TotalActualUnits)

(s/def :cognitect.aws.ce.ReservationAggregates/PurchasedHours :cognitect.aws.ce/PurchasedHours)

(s/def :cognitect.aws.ce.ReservationAggregates/UnusedHours :cognitect.aws.ce/UnusedHours)

(s/def
  :cognitect.aws.ce.ReservationAggregates/AmortizedUpfrontFee
  :cognitect.aws.ce/AmortizedUpfrontFee)

(s/def
  :cognitect.aws.ce.ReservationAggregates/UnrealizedSavings
  :cognitect.aws.ce/UnrealizedSavings)

(s/def :cognitect.aws.ce.ReservationAggregates/UnusedUnits :cognitect.aws.ce/UnusedUnits)

(s/def
  :cognitect.aws.ce.ReservationAggregates/UtilizationPercentageInUnits
  :cognitect.aws.ce/UtilizationPercentageInUnits)

(s/def
  :cognitect.aws.ce.ReservationAggregates/RICostForUnusedHours
  :cognitect.aws.ce/RICostForUnusedHours)

(s/def
  :cognitect.aws.ce.ReservationAggregates/AmortizedRecurringFee
  :cognitect.aws.ce/AmortizedRecurringFee)

(s/def :cognitect.aws.ce.ReservationAggregates/RealizedSavings :cognitect.aws.ce/RealizedSavings)

(s/def
  :cognitect.aws.ce.ReservationAggregates/TotalAmortizedFee
  :cognitect.aws.ce/TotalAmortizedFee)

(s/def :cognitect.aws.ce.ReservationAggregates/TotalActualHours :cognitect.aws.ce/TotalActualHours)

(s/def :cognitect.aws.ce.ReservationAggregates/NetRISavings :cognitect.aws.ce/NetRISavings)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/Service
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/Filter
  :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/AccountId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/PaymentOption
  :cognitect.aws.ce/PaymentOption)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/TermInYears
  :cognitect.aws.ce/TermInYears)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/PageSize
  :cognitect.aws.ce/NonNegativeInteger)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/ServiceSpecification
  :cognitect.aws.ce/ServiceSpecification)

(s/def
  :cognitect.aws.ce.GetReservationPurchaseRecommendationRequest/AccountScope
  :cognitect.aws.ce/AccountScope)

(s/def :cognitect.aws.ce.CostCategory/Rules :cognitect.aws.ce/CostCategoryRulesList)

(s/def
  :cognitect.aws.ce.CostCategory/SplitChargeRules
  :cognitect.aws.ce/CostCategorySplitChargeRulesList)

(s/def :cognitect.aws.ce.CostCategory/RuleVersion :cognitect.aws.ce/CostCategoryRuleVersion)

(s/def
  :cognitect.aws.ce.CostCategory/ProcessingStatus
  :cognitect.aws.ce/CostCategoryProcessingStatusList)

(s/def :cognitect.aws.ce.CostCategory/EffectiveEnd :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CostCategory/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def :cognitect.aws.ce.CostCategory/Name :cognitect.aws.ce/CostCategoryName)

(s/def :cognitect.aws.ce.CostCategory/EffectiveStart :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CostCategory/DefaultValue :cognitect.aws.ce/CostCategoryValue)

(s/def :cognitect.aws.ce.GetUsageForecastResponse/Total :cognitect.aws.ce/MetricValue)

(s/def
  :cognitect.aws.ce.GetUsageForecastResponse/ForecastResultsByTime
  :cognitect.aws.ce/ForecastResultsByTime)

(s/def :cognitect.aws.ce.GetReservationUtilizationRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetReservationUtilizationRequest/GroupBy
  :cognitect.aws.ce/GroupDefinitions)

(s/def :cognitect.aws.ce.GetReservationUtilizationRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetReservationUtilizationRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetReservationUtilizationRequest/SortBy :cognitect.aws.ce/SortDefinition)

(s/def
  :cognitect.aws.ce.GetReservationUtilizationRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetReservationUtilizationRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.ResourceTag/Key :cognitect.aws.ce/ResourceTagKey)

(s/def :cognitect.aws.ce.ResourceTag/Value :cognitect.aws.ce/ResourceTagValue)

(s/def :cognitect.aws.ce.TagValues/Key :cognitect.aws.ce/TagKey)

(s/def :cognitect.aws.ce.TagValues/Values :cognitect.aws.ce/Values)

(s/def :cognitect.aws.ce.TagValues/MatchOptions :cognitect.aws.ce/MatchOptions)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/Metrics :cognitect.aws.ce/MetricNames)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/GroupBy :cognitect.aws.ce/GroupDefinitions)

(s/def :cognitect.aws.ce.GetCostAndUsageRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/GroupDefinitions
  :cognitect.aws.ce/GroupDefinitions)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/ResultsByTime
  :cognitect.aws.ce/ResultsByTime)

(s/def
  :cognitect.aws.ce.GetCostAndUsageWithResourcesResponse/DimensionValueAttributes
  :cognitect.aws.ce/DimensionValuesWithAttributesList)

(s/def :cognitect.aws.ce.Coverage/CoverageHours :cognitect.aws.ce/CoverageHours)

(s/def :cognitect.aws.ce.Coverage/CoverageNormalizedUnits :cognitect.aws.ce/CoverageNormalizedUnits)

(s/def :cognitect.aws.ce.Coverage/CoverageCost :cognitect.aws.ce/CoverageCost)

(s/def
  :cognitect.aws.ce.DescribeCostCategoryDefinitionResponse/CostCategory
  :cognitect.aws.ce/CostCategory)

(s/def
  :cognitect.aws.ce.ListCostCategoryDefinitionsResponse/CostCategoryReferences
  :cognitect.aws.ce/CostCategoryReferencesList)

(s/def
  :cognitect.aws.ce.ListCostCategoryDefinitionsResponse/NextToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.ResultByTime/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.ResultByTime/Total :cognitect.aws.ce/Metrics)

(s/def :cognitect.aws.ce.ResultByTime/Groups :cognitect.aws.ce/Groups)

(s/def :cognitect.aws.ce.ResultByTime/Estimated :cognitect.aws.ce/Estimated)

(s/def
  :cognitect.aws.ce.CostCategoryInheritedValueDimension/DimensionName
  :cognitect.aws.ce/CostCategoryInheritedValueDimensionName)

(s/def
  :cognitect.aws.ce.CostCategoryInheritedValueDimension/DimensionKey
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/Metadata
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationMetadata)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/SavingsPlansPurchaseRecommendation
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendation)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.CostCategoryValues/Key :cognitect.aws.ce/CostCategoryName)

(s/def :cognitect.aws.ce.CostCategoryValues/Values :cognitect.aws.ce/Values)

(s/def :cognitect.aws.ce.CostCategoryValues/MatchOptions :cognitect.aws.ce/MatchOptions)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/SearchString :cognitect.aws.ce/SearchString)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/Dimension :cognitect.aws.ce/Dimension)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/Context :cognitect.aws.ce/Context)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/SortBy :cognitect.aws.ce/SortDefinitions)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.GetDimensionValuesRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.ListCostAllocationTagsResponse/CostAllocationTags
  :cognitect.aws.ce/CostAllocationTagList)

(s/def :cognitect.aws.ce.ListCostAllocationTagsResponse/NextToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetTagsResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetTagsResponse/Tags :cognitect.aws.ce/TagList)

(s/def :cognitect.aws.ce.GetTagsResponse/ReturnSize :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.GetTagsResponse/TotalSize :cognitect.aws.ce/PageSize)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/ExistingHourlyCommitment
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/EstimatedSPCost :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/UpfrontCost :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedAverageCoverage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedOnDemandCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/SavingsPlansType
  :cognitect.aws.ce/SupportedSavingsPlansType)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/HourlyCommitmentToPurchase
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/AccountId :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/CurrentMinimumHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/CurrentAverageCoverage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/MetricsOverLookbackPeriod
  :cognitect.aws.ce/MetricsOverLookbackPeriod)

(s/def :cognitect.aws.ce.RecommendationDetailData/CurrencyCode :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/LatestUsageTimestamp
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/CurrentMaximumHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedSavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/PaymentOption :cognitect.aws.ce/PaymentOption)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedSavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/Region :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedOnDemandCostWithCurrentCommitment
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/TermInYears :cognitect.aws.ce/TermInYears)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/CurrentAverageHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedAverageUtilization
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/InstanceFamily :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/GenerationTimestamp
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.RecommendationDetailData/EstimatedMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/OfferingId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/EstimatedROI :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RecommendationDetailData/AccountScope :cognitect.aws.ce/AccountScope)

(s/def :cognitect.aws.ce.Anomaly/RootCauses :cognitect.aws.ce/RootCauses)

(s/def :cognitect.aws.ce.Anomaly/Impact :cognitect.aws.ce/Impact)

(s/def :cognitect.aws.ce.Anomaly/AnomalyStartDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.Anomaly/Feedback :cognitect.aws.ce/AnomalyFeedbackType)

(s/def :cognitect.aws.ce.Anomaly/AnomalyScore :cognitect.aws.ce/AnomalyScore)

(s/def :cognitect.aws.ce.Anomaly/MonitorArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.Anomaly/AnomalyId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.Anomaly/DimensionValue :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.Anomaly/AnomalyEndDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.GetCostCategoriesResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetCostCategoriesResponse/CostCategoryNames
  :cognitect.aws.ce/CostCategoryNamesList)

(s/def
  :cognitect.aws.ce.GetCostCategoriesResponse/CostCategoryValues
  :cognitect.aws.ce/CostCategoryValuesList)

(s/def :cognitect.aws.ce.GetCostCategoriesResponse/ReturnSize :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.GetCostCategoriesResponse/TotalSize :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.SavingsPlansSavings/NetSavings :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansSavings/OnDemandCostEquivalent :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/Family :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/InstanceType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/AvailabilityZone :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/Platform :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/Tenancy :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2InstanceDetails/CurrentGeneration :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.EC2InstanceDetails/SizeFlexEligible :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.CreateCostCategoryDefinitionResponse/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionResponse/EffectiveStart
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/GenerationStatus
  :cognitect.aws.ce/GenerationStatus)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/RecommendationIds
  :cognitect.aws.ce/RecommendationIdList)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/PageSize
  :cognitect.aws.ce/NonNegativeInteger)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetReservationUtilizationResponse/UtilizationsByTime
  :cognitect.aws.ce/UtilizationsByTime)

(s/def
  :cognitect.aws.ce.GetReservationUtilizationResponse/Total
  :cognitect.aws.ce/ReservationAggregates)

(s/def
  :cognitect.aws.ce.GetReservationUtilizationResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.ESInstanceDetails/InstanceClass :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ESInstanceDetails/InstanceSize :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ESInstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ESInstanceDetails/CurrentGeneration :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.ESInstanceDetails/SizeFlexEligible :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/HourlyCommitmentToPurchase
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/CurrentOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/CurrencyCode
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedSavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedSavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedOnDemandCostWithCurrentCommitment
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/DailyCommitmentToPurchase
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedROI
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/EstimatedTotalCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationSummary/TotalRecommendationCount
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.TotalImpactFilter/NumericOperator :cognitect.aws.ce/NumericOperator)

(s/def :cognitect.aws.ce.TotalImpactFilter/StartValue :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.TotalImpactFilter/EndValue :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.DimensionValues/Key :cognitect.aws.ce/Dimension)

(s/def :cognitect.aws.ce.DimensionValues/Values :cognitect.aws.ce/Values)

(s/def :cognitect.aws.ce.DimensionValues/MatchOptions :cognitect.aws.ce/MatchOptions)

(s/def :cognitect.aws.ce.SavingsPlansCoverage/Attributes :cognitect.aws.ce/Attributes)

(s/def :cognitect.aws.ce.SavingsPlansCoverage/Coverage :cognitect.aws.ce/SavingsPlansCoverageData)

(s/def :cognitect.aws.ce.SavingsPlansCoverage/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationDetail/SavingsPlanArn
  :cognitect.aws.ce/SavingsPlanArn)

(s/def :cognitect.aws.ce.SavingsPlansUtilizationDetail/Attributes :cognitect.aws.ce/Attributes)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationDetail/Utilization
  :cognitect.aws.ce/SavingsPlansUtilization)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationDetail/Savings
  :cognitect.aws.ce/SavingsPlansSavings)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationDetail/AmortizedCommitment
  :cognitect.aws.ce/SavingsPlansAmortizedCommitment)

(s/def :cognitect.aws.ce.MetricValue/Amount :cognitect.aws.ce/MetricAmount)

(s/def :cognitect.aws.ce.MetricValue/Unit :cognitect.aws.ce/MetricUnit)

(s/def :cognitect.aws.ce.RDSInstanceDetails/InstanceType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/CurrentGeneration :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.RDSInstanceDetails/DeploymentOption :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/Family :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/DatabaseEdition :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/LicenseModel :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/DatabaseEngine :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RDSInstanceDetails/SizeFlexEligible :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.GetAnomalySubscriptionsRequest/SubscriptionArnList
  :cognitect.aws.ce/Values)

(s/def :cognitect.aws.ce.GetAnomalySubscriptionsRequest/MonitorArn :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetAnomalySubscriptionsRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetAnomalySubscriptionsRequest/MaxResults :cognitect.aws.ce/PageSize)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationSummary/TotalRecommendationCount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationSummary/EstimatedTotalMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationSummary/SavingsCurrencyCode
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationSummary/SavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageUtilization
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlySavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecurringStandardMonthlyCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlyOnDemandCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MaximumNormalizedUnitsUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/UpfrontCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AccountId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/CurrencyCode
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MinimumNumberOfInstancesUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MaximumNumberOfInstancesUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/InstanceDetails
  :cognitect.aws.ce/InstanceDetails)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecommendedNumberOfInstancesToPurchase
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageNumberOfInstancesUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedBreakEvenInMonths
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/RecommendedNormalizedUnitsToPurchase
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/MinimumNormalizedUnitsUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/EstimatedReservationCostForLookbackPeriod
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationDetail/AverageNormalizedUnitsUsedPerHour
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/AccountScope
  :cognitect.aws.ce/AccountScope)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/TermInYears
  :cognitect.aws.ce/TermInYears)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/PaymentOption
  :cognitect.aws.ce/PaymentOption)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/ServiceSpecification
  :cognitect.aws.ce/ServiceSpecification)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/RecommendationDetails
  :cognitect.aws.ce/ReservationPurchaseRecommendationDetails)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendation/RecommendationSummary
  :cognitect.aws.ce/ReservationPurchaseRecommendationSummary)

(s/def :cognitect.aws.ce.ResourceDetails/EC2ResourceDetails :cognitect.aws.ce/EC2ResourceDetails)

(s/def
  :cognitect.aws.ce.CreateAnomalySubscriptionRequest/AnomalySubscription
  :cognitect.aws.ce/AnomalySubscription)

(s/def
  :cognitect.aws.ce.CreateAnomalySubscriptionRequest/ResourceTags
  :cognitect.aws.ce/ResourceTagList)

(s/def :cognitect.aws.ce.RootCause/Service :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RootCause/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RootCause/LinkedAccount :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RootCause/UsageType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.RootCause/LinkedAccountName :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Memory :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/HourlyOnDemandRate :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/InstanceType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Vcpu :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Storage :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Platform :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/Sku :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2ResourceDetails/NetworkPerformance :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.Expression/Or :cognitect.aws.ce/Expressions)

(s/def :cognitect.aws.ce.Expression/And :cognitect.aws.ce/Expressions)

(s/def :cognitect.aws.ce.Expression/Not :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.Expression/Dimensions :cognitect.aws.ce/DimensionValues)

(s/def :cognitect.aws.ce.Expression/Tags :cognitect.aws.ce/TagValues)

(s/def :cognitect.aws.ce.Expression/CostCategories :cognitect.aws.ce/CostCategoryValues)

(s/def :cognitect.aws.ce.ReservationCoverageGroup/Attributes :cognitect.aws.ce/Attributes)

(s/def :cognitect.aws.ce.ReservationCoverageGroup/Coverage :cognitect.aws.ce/Coverage)

(s/def :cognitect.aws.ce.AnomalyDateInterval/StartDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.AnomalyDateInterval/EndDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.CostCategoryRule/Value :cognitect.aws.ce/CostCategoryValue)

(s/def :cognitect.aws.ce.CostCategoryRule/Rule :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.CostCategoryRule/InheritedValue
  :cognitect.aws.ce/CostCategoryInheritedValueDimension)

(s/def :cognitect.aws.ce.CostCategoryRule/Type :cognitect.aws.ce/CostCategoryRuleType)

(s/def :cognitect.aws.ce.InstanceDetails/EC2InstanceDetails :cognitect.aws.ce/EC2InstanceDetails)

(s/def :cognitect.aws.ce.InstanceDetails/RDSInstanceDetails :cognitect.aws.ce/RDSInstanceDetails)

(s/def
  :cognitect.aws.ce.InstanceDetails/RedshiftInstanceDetails
  :cognitect.aws.ce/RedshiftInstanceDetails)

(s/def
  :cognitect.aws.ce.InstanceDetails/ElastiCacheInstanceDetails
  :cognitect.aws.ce/ElastiCacheInstanceDetails)

(s/def :cognitect.aws.ce.InstanceDetails/ESInstanceDetails :cognitect.aws.ce/ESInstanceDetails)

(s/def
  :cognitect.aws.ce.InstanceDetails/MemoryDBInstanceDetails
  :cognitect.aws.ce/MemoryDBInstanceDetails)

(s/def
  :cognitect.aws.ce.CreateAnomalySubscriptionResponse/SubscriptionArn
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.UpdateCostAllocationTagsStatusResponse/Errors
  :cognitect.aws.ce/UpdateCostAllocationTagsStatusErrors)

(s/def :cognitect.aws.ce.GetRightsizingRecommendationRequest/Filter :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationRequest/Configuration
  :cognitect.aws.ce/RightsizingRecommendationConfiguration)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationRequest/Service
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationRequest/PageSize
  :cognitect.aws.ce/NonNegativeInteger)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.ListTagsForResourceRequest/ResourceArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.ResourceUtilization/EC2ResourceUtilization
  :cognitect.aws.ce/EC2ResourceUtilization)

(s/def :cognitect.aws.ce.SortDefinition/Key :cognitect.aws.ce/SortDefinitionKey)

(s/def :cognitect.aws.ce.SortDefinition/SortOrder :cognitect.aws.ce/SortOrder)

(s/def
  :cognitect.aws.ce.DescribeCostCategoryDefinitionRequest/CostCategoryArn
  :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.DescribeCostCategoryDefinitionRequest/EffectiveOn
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.TerminateRecommendationDetail/EstimatedMonthlySavings
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.TerminateRecommendationDetail/CurrencyCode :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansDetails/Region :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansDetails/InstanceFamily :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansDetails/OfferingId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ReservationUtilizationGroup/Key :cognitect.aws.ce/ReservationGroupKey)

(s/def :cognitect.aws.ce.ReservationUtilizationGroup/Value :cognitect.aws.ce/ReservationGroupValue)

(s/def :cognitect.aws.ce.ReservationUtilizationGroup/Attributes :cognitect.aws.ce/Attributes)

(s/def
  :cognitect.aws.ce.ReservationUtilizationGroup/Utilization
  :cognitect.aws.ce/ReservationAggregates)

(s/def
  :cognitect.aws.ce.CurrentInstance/OnDemandHoursInLookbackPeriod
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.CurrentInstance/SavingsPlansCoveredHoursInLookbackPeriod
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CurrentInstance/MonthlyCost :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CurrentInstance/Tags :cognitect.aws.ce/TagValuesList)

(s/def :cognitect.aws.ce.CurrentInstance/CurrencyCode :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CurrentInstance/ResourceId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CurrentInstance/InstanceName :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.CurrentInstance/ResourceDetails :cognitect.aws.ce/ResourceDetails)

(s/def :cognitect.aws.ce.CurrentInstance/ResourceUtilization :cognitect.aws.ce/ResourceUtilization)

(s/def
  :cognitect.aws.ce.CurrentInstance/ReservationCoveredHoursInLookbackPeriod
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.CurrentInstance/TotalRunningHoursInLookbackPeriod
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.EC2Specification/OfferingClass :cognitect.aws.ce/OfferingClass)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationResponse/GenerationSummaryList
  :cognitect.aws.ce/GenerationSummaryList)

(s/def
  :cognitect.aws.ce.ListSavingsPlansPurchaseRecommendationGenerationResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetTagsRequest/SearchString :cognitect.aws.ce/SearchString)

(s/def :cognitect.aws.ce.GetTagsRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetTagsRequest/TagKey :cognitect.aws.ce/TagKey)

(s/def :cognitect.aws.ce.GetTagsRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetTagsRequest/SortBy :cognitect.aws.ce/SortDefinitions)

(s/def :cognitect.aws.ce.GetTagsRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.GetTagsRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.AnomalySubscription/SubscriptionArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalySubscription/AccountId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalySubscription/MonitorArnList :cognitect.aws.ce/MonitorArnList)

(s/def :cognitect.aws.ce.AnomalySubscription/Subscribers :cognitect.aws.ce/Subscribers)

(s/def :cognitect.aws.ce.AnomalySubscription/Threshold :cognitect.aws.ce/NullableNonNegativeDouble)

(s/def
  :cognitect.aws.ce.AnomalySubscription/Frequency
  :cognitect.aws.ce/AnomalySubscriptionFrequency)

(s/def :cognitect.aws.ce.AnomalySubscription/SubscriptionName :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalySubscription/ThresholdExpression :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.CostCategoryReference/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def :cognitect.aws.ce.CostCategoryReference/Name :cognitect.aws.ce/CostCategoryName)

(s/def :cognitect.aws.ce.CostCategoryReference/EffectiveStart :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CostCategoryReference/EffectiveEnd :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CostCategoryReference/NumberOfRules :cognitect.aws.ce/NonNegativeInteger)

(s/def
  :cognitect.aws.ce.CostCategoryReference/ProcessingStatus
  :cognitect.aws.ce/CostCategoryProcessingStatusList)

(s/def :cognitect.aws.ce.CostCategoryReference/Values :cognitect.aws.ce/CostCategoryValuesList)

(s/def :cognitect.aws.ce.CostCategoryReference/DefaultValue :cognitect.aws.ce/CostCategoryValue)

(s/def :cognitect.aws.ce.EBSResourceUtilization/EbsReadOpsPerSecond :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EBSResourceUtilization/EbsWriteOpsPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EBSResourceUtilization/EbsReadBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.EBSResourceUtilization/EbsWriteBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalyScore/MaxScore :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.AnomalyScore/CurrentScore :cognitect.aws.ce/GenericDouble)

(s/def :cognitect.aws.ce.ForecastResult/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.ForecastResult/MeanValue :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ForecastResult/PredictionIntervalLowerBound
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ForecastResult/PredictionIntervalUpperBound
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSPCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/UpfrontCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedOnDemandCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/HourlyCommitmentToPurchase
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/AccountId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentMinimumHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrencyCode
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentMaximumHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/RecommendationDetailId
  :cognitect.aws.ce/RecommendationDetailId)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/SavingsPlansDetails
  :cognitect.aws.ce/SavingsPlansDetails)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedSavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedOnDemandCostWithCurrentCommitment
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/CurrentAverageHourlyOnDemandSpend
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedAverageUtilization
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendationDetail/EstimatedROI
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ElastiCacheInstanceDetails/Family :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ElastiCacheInstanceDetails/NodeType :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ElastiCacheInstanceDetails/Region :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ElastiCacheInstanceDetails/ProductDescription
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ElastiCacheInstanceDetails/CurrentGeneration
  :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.ElastiCacheInstanceDetails/SizeFlexEligible
  :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationConfiguration/RecommendationTarget
  :cognitect.aws.ce/RecommendationTarget)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationConfiguration/BenefitsConsidered
  :cognitect.aws.ce/GenericBoolean)

(s/def
  :cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/RecommendationId
  :cognitect.aws.ce/RecommendationId)

(s/def
  :cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/GenerationStartedTime
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.StartSavingsPlansPurchaseRecommendationGenerationResponse/EstimatedCompletionTime
  :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.CoverageByTime/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.CoverageByTime/Groups :cognitect.aws.ce/ReservationCoverageGroups)

(s/def :cognitect.aws.ce.CoverageByTime/Total :cognitect.aws.ce/Coverage)

(s/def :cognitect.aws.ce.UpdateCostAllocationTagsStatusError/TagKey :cognitect.aws.ce/TagKey)

(s/def :cognitect.aws.ce.UpdateCostAllocationTagsStatusError/Code :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.UpdateCostAllocationTagsStatusError/Message :cognitect.aws.ce/ErrorMessage)

(s/def :cognitect.aws.ce.CoverageCost/OnDemandCost :cognitect.aws.ce/OnDemandCost)

(s/def
  :cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsRequest/RecommendationDetailId
  :cognitect.aws.ce/RecommendationDetailId)

(s/def
  :cognitect.aws.ce.UpdateCostAllocationTagsStatusRequest/CostAllocationTagsStatus
  :cognitect.aws.ce/CostAllocationTagStatusList)

(s/def
  :cognitect.aws.ce.ModifyRecommendationDetail/TargetInstances
  :cognitect.aws.ce/TargetInstancesList)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/AccountScope
  :cognitect.aws.ce/AccountScope)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansType
  :cognitect.aws.ce/SupportedSavingsPlansType)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/TermInYears
  :cognitect.aws.ce/TermInYears)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/PaymentOption
  :cognitect.aws.ce/PaymentOption)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansPurchaseRecommendationDetails
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationDetailList)

(s/def
  :cognitect.aws.ce.SavingsPlansPurchaseRecommendation/SavingsPlansPurchaseRecommendationSummary
  :cognitect.aws.ce/SavingsPlansPurchaseRecommendationSummary)

(s/def
  :cognitect.aws.ce.GetAnomalySubscriptionsResponse/AnomalySubscriptions
  :cognitect.aws.ce/AnomalySubscriptions)

(s/def
  :cognitect.aws.ce.GetAnomalySubscriptionsResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.CostCategorySplitChargeRuleParameter/Type
  :cognitect.aws.ce/CostCategorySplitChargeRuleParameterType)

(s/def
  :cognitect.aws.ce.CostCategorySplitChargeRuleParameter/Values
  :cognitect.aws.ce/CostCategorySplitChargeRuleParameterValuesList)

(s/def :cognitect.aws.ce.Subscriber/Address :cognitect.aws.ce/SubscriberAddress)

(s/def :cognitect.aws.ce.Subscriber/Type :cognitect.aws.ce/SubscriberType)

(s/def :cognitect.aws.ce.Subscriber/Status :cognitect.aws.ce/SubscriberStatus)

(s/def
  :cognitect.aws.ce.NetworkResourceUtilization/NetworkInBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.NetworkResourceUtilization/NetworkOutBytesPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.NetworkResourceUtilization/NetworkPacketsInPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.NetworkResourceUtilization/NetworkPacketsOutPerSecond
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/SavingsPlansType
  :cognitect.aws.ce/SupportedSavingsPlansType)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/TermInYears
  :cognitect.aws.ce/TermInYears)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/PaymentOption
  :cognitect.aws.ce/PaymentOption)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/AccountScope
  :cognitect.aws.ce/AccountScope)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/PageSize
  :cognitect.aws.ce/NonNegativeInteger)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.GetSavingsPlansPurchaseRecommendationRequest/Filter
  :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.DeleteCostCategoryDefinitionRequest/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.RecommendationDetailHourlyMetrics/StartTime
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedOnDemandCost
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailHourlyMetrics/CurrentCoverage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedCoverage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RecommendationDetailHourlyMetrics/EstimatedNewCommitmentUtilization
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetAnomalyMonitorsResponse/AnomalyMonitors
  :cognitect.aws.ce/AnomalyMonitors)

(s/def :cognitect.aws.ce.GetAnomalyMonitorsResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GenerationSummary/RecommendationId :cognitect.aws.ce/RecommendationId)

(s/def :cognitect.aws.ce.GenerationSummary/GenerationStatus :cognitect.aws.ce/GenerationStatus)

(s/def :cognitect.aws.ce.GenerationSummary/GenerationStartedTime :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.GenerationSummary/GenerationCompletionTime :cognitect.aws.ce/ZonedDateTime)

(s/def :cognitect.aws.ce.GenerationSummary/EstimatedCompletionTime :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.ListCostCategoryDefinitionsRequest/EffectiveOn
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.ListCostCategoryDefinitionsRequest/NextToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.ListCostCategoryDefinitionsRequest/MaxResults
  :cognitect.aws.ce/CostCategoryMaxResults)

(s/def :cognitect.aws.ce.UntagResourceRequest/ResourceArn :cognitect.aws.ce/Arn)

(s/def :cognitect.aws.ce.UntagResourceRequest/ResourceTagKeys :cognitect.aws.ce/ResourceTagKeyList)

(s/def :cognitect.aws.ce.ProvideAnomalyFeedbackResponse/AnomalyId :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.GetAnomaliesResponse/Anomalies :cognitect.aws.ce/Anomalies)

(s/def :cognitect.aws.ce.GetAnomaliesResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/TimePeriod
  :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/Granularity
  :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetSavingsPlansUtilizationRequest/SortBy :cognitect.aws.ce/SortDefinition)

(s/def
  :cognitect.aws.ce.SavingsPlansCoverageData/SpendCoveredBySavingsPlans
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansCoverageData/OnDemandCost :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansCoverageData/TotalCost :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansCoverageData/CoveragePercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationSummary/TotalEstimatedMonthlySavingsAmount
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationSummary/TotalEstimatedMonthlySavingsPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationSummary/CurrencyCode
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.ServiceSpecification/EC2Specification :cognitect.aws.ce/EC2Specification)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/GroupBy :cognitect.aws.ce/GroupDefinitions)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/Metrics :cognitect.aws.ce/MetricNames)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/NextToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageRequest/SortBy :cognitect.aws.ce/SortDefinition)

(s/def :cognitect.aws.ce.AnomalyMonitor/DimensionalValueCount :cognitect.aws.ce/NonNegativeInteger)

(s/def :cognitect.aws.ce.AnomalyMonitor/MonitorDimension :cognitect.aws.ce/MonitorDimension)

(s/def :cognitect.aws.ce.AnomalyMonitor/MonitorSpecification :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.AnomalyMonitor/LastEvaluatedDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.AnomalyMonitor/LastUpdatedDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.AnomalyMonitor/MonitorType :cognitect.aws.ce/MonitorType)

(s/def :cognitect.aws.ce.AnomalyMonitor/MonitorName :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalyMonitor/MonitorArn :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.AnomalyMonitor/CreationDate :cognitect.aws.ce/YearMonthDay)

(s/def :cognitect.aws.ce.SavingsPlansUtilizationByTime/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationByTime/Utilization
  :cognitect.aws.ce/SavingsPlansUtilization)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationByTime/Savings
  :cognitect.aws.ce/SavingsPlansSavings)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilizationByTime/AmortizedCommitment
  :cognitect.aws.ce/SavingsPlansAmortizedCommitment)

(s/def :cognitect.aws.ce.CostAllocationTagStatusEntry/TagKey :cognitect.aws.ce/TagKey)

(s/def
  :cognitect.aws.ce.CostAllocationTagStatusEntry/Status
  :cognitect.aws.ce/CostAllocationTagStatus)

(s/def
  :cognitect.aws.ce.GetSavingsPlansCoverageResponse/SavingsPlansCoverages
  :cognitect.aws.ce/SavingsPlansCoverages)

(s/def :cognitect.aws.ce.GetSavingsPlansCoverageResponse/NextToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.SavingsPlansUtilization/TotalCommitment :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansUtilization/UsedCommitment :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.SavingsPlansUtilization/UnusedCommitment :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansUtilization/UtilizationPercentage
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationResponse/Metadata
  :cognitect.aws.ce/RightsizingRecommendationMetadata)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationResponse/Summary
  :cognitect.aws.ce/RightsizingRecommendationSummary)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationResponse/RightsizingRecommendations
  :cognitect.aws.ce/RightsizingRecommendationList)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.GetRightsizingRecommendationResponse/Configuration
  :cognitect.aws.ce/RightsizingRecommendationConfiguration)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationMetadata/RecommendationId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ReservationPurchaseRecommendationMetadata/GenerationTimestamp
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.CreateAnomalyMonitorRequest/AnomalyMonitor
  :cognitect.aws.ce/AnomalyMonitor)

(s/def :cognitect.aws.ce.CreateAnomalyMonitorRequest/ResourceTags :cognitect.aws.ce/ResourceTagList)

(s/def :cognitect.aws.ce.ProvideAnomalyFeedbackRequest/AnomalyId :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.ProvideAnomalyFeedbackRequest/Feedback
  :cognitect.aws.ce/AnomalyFeedbackType)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationMetadata/RecommendationId
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationMetadata/GenerationTimestamp
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationMetadata/LookbackPeriodInDays
  :cognitect.aws.ce/LookbackPeriodInDays)

(s/def
  :cognitect.aws.ce.RightsizingRecommendationMetadata/AdditionalMetadata
  :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.GetCostForecastResponse/Total :cognitect.aws.ce/MetricValue)

(s/def
  :cognitect.aws.ce.GetCostForecastResponse/ForecastResultsByTime
  :cognitect.aws.ce/ForecastResultsByTime)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/Name
  :cognitect.aws.ce/CostCategoryName)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/EffectiveStart
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/RuleVersion
  :cognitect.aws.ce/CostCategoryRuleVersion)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/Rules
  :cognitect.aws.ce/CostCategoryRulesList)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/DefaultValue
  :cognitect.aws.ce/CostCategoryValue)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/SplitChargeRules
  :cognitect.aws.ce/CostCategorySplitChargeRulesList)

(s/def
  :cognitect.aws.ce.CreateCostCategoryDefinitionRequest/ResourceTags
  :cognitect.aws.ce/ResourceTagList)

(s/def
  :cognitect.aws.ce.SavingsPlansAmortizedCommitment/AmortizedRecurringCommitment
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansAmortizedCommitment/AmortizedUpfrontCommitment
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.SavingsPlansAmortizedCommitment/TotalAmortizedCommitment
  :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.GetReservationCoverageResponse/CoveragesByTime
  :cognitect.aws.ce/CoveragesByTime)

(s/def :cognitect.aws.ce.GetReservationCoverageResponse/Total :cognitect.aws.ce/Coverage)

(s/def
  :cognitect.aws.ce.GetReservationCoverageResponse/NextPageToken
  :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/EffectiveStart
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/RuleVersion
  :cognitect.aws.ce/CostCategoryRuleVersion)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/Rules
  :cognitect.aws.ce/CostCategoryRulesList)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/DefaultValue
  :cognitect.aws.ce/CostCategoryValue)

(s/def
  :cognitect.aws.ce.UpdateCostCategoryDefinitionRequest/SplitChargeRules
  :cognitect.aws.ce/CostCategorySplitChargeRulesList)

(s/def
  :cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsResponse/RecommendationDetailId
  :cognitect.aws.ce/RecommendationDetailId)

(s/def
  :cognitect.aws.ce.GetSavingsPlanPurchaseRecommendationDetailsResponse/RecommendationDetailData
  :cognitect.aws.ce/RecommendationDetailData)

(s/def
  :cognitect.aws.ce.CoverageNormalizedUnits/OnDemandNormalizedUnits
  :cognitect.aws.ce/OnDemandNormalizedUnits)

(s/def
  :cognitect.aws.ce.CoverageNormalizedUnits/ReservedNormalizedUnits
  :cognitect.aws.ce/ReservedNormalizedUnits)

(s/def
  :cognitect.aws.ce.CoverageNormalizedUnits/TotalRunningNormalizedUnits
  :cognitect.aws.ce/TotalRunningNormalizedUnits)

(s/def
  :cognitect.aws.ce.CoverageNormalizedUnits/CoverageNormalizedUnitsPercentage
  :cognitect.aws.ce/CoverageNormalizedUnitsPercentage)

(s/def :cognitect.aws.ce.DimensionValuesWithAttributes/Value :cognitect.aws.ce/Value)

(s/def :cognitect.aws.ce.DimensionValuesWithAttributes/Attributes :cognitect.aws.ce/Attributes)

(s/def :cognitect.aws.ce.CoverageHours/OnDemandHours :cognitect.aws.ce/OnDemandHours)

(s/def :cognitect.aws.ce.CoverageHours/ReservedHours :cognitect.aws.ce/ReservedHours)

(s/def :cognitect.aws.ce.CoverageHours/TotalRunningHours :cognitect.aws.ce/TotalRunningHours)

(s/def
  :cognitect.aws.ce.CoverageHours/CoverageHoursPercentage
  :cognitect.aws.ce/CoverageHoursPercentage)

(s/def :cognitect.aws.ce.ListTagsForResourceResponse/ResourceTags :cognitect.aws.ce/ResourceTagList)

(s/def :cognitect.aws.ce.CostCategorySplitChargeRule/Source :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.CostCategorySplitChargeRule/Targets
  :cognitect.aws.ce/CostCategorySplitChargeRuleTargetsList)

(s/def
  :cognitect.aws.ce.CostCategorySplitChargeRule/Method
  :cognitect.aws.ce/CostCategorySplitChargeMethod)

(s/def
  :cognitect.aws.ce.CostCategorySplitChargeRule/Parameters
  :cognitect.aws.ce/CostCategorySplitChargeRuleParametersList)

(s/def :cognitect.aws.ce.RightsizingRecommendation/AccountId :cognitect.aws.ce/GenericString)

(s/def
  :cognitect.aws.ce.RightsizingRecommendation/CurrentInstance
  :cognitect.aws.ce/CurrentInstance)

(s/def
  :cognitect.aws.ce.RightsizingRecommendation/RightsizingType
  :cognitect.aws.ce/RightsizingType)

(s/def
  :cognitect.aws.ce.RightsizingRecommendation/ModifyRecommendationDetail
  :cognitect.aws.ce/ModifyRecommendationDetail)

(s/def
  :cognitect.aws.ce.RightsizingRecommendation/TerminateRecommendationDetail
  :cognitect.aws.ce/TerminateRecommendationDetail)

(s/def
  :cognitect.aws.ce.RightsizingRecommendation/FindingReasonCodes
  :cognitect.aws.ce/FindingReasonCodes)

(s/def :cognitect.aws.ce.GroupDefinition/Type :cognitect.aws.ce/GroupDefinitionType)

(s/def :cognitect.aws.ce.GroupDefinition/Key :cognitect.aws.ce/GroupDefinitionKey)

(s/def
  :cognitect.aws.ce.ListCostAllocationTagsRequest/Status
  :cognitect.aws.ce/CostAllocationTagStatus)

(s/def
  :cognitect.aws.ce.ListCostAllocationTagsRequest/TagKeys
  :cognitect.aws.ce/CostAllocationTagKeyList)

(s/def :cognitect.aws.ce.ListCostAllocationTagsRequest/Type :cognitect.aws.ce/CostAllocationTagType)

(s/def :cognitect.aws.ce.ListCostAllocationTagsRequest/NextToken :cognitect.aws.ce/NextPageToken)

(s/def
  :cognitect.aws.ce.ListCostAllocationTagsRequest/MaxResults
  :cognitect.aws.ce/CostAllocationTagsMaxResults)

(s/def :cognitect.aws.ce.TargetInstance/EstimatedMonthlyCost :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.TargetInstance/EstimatedMonthlySavings :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.TargetInstance/CurrencyCode :cognitect.aws.ce/GenericString)

(s/def :cognitect.aws.ce.TargetInstance/DefaultTargetInstance :cognitect.aws.ce/GenericBoolean)

(s/def :cognitect.aws.ce.TargetInstance/ResourceDetails :cognitect.aws.ce/ResourceDetails)

(s/def
  :cognitect.aws.ce.TargetInstance/ExpectedResourceUtilization
  :cognitect.aws.ce/ResourceUtilization)

(s/def :cognitect.aws.ce.TargetInstance/PlatformDifferences :cognitect.aws.ce/PlatformDifferences)

(s/def :cognitect.aws.ce.GetCostForecastRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def :cognitect.aws.ce.GetCostForecastRequest/Metric :cognitect.aws.ce/Metric)

(s/def :cognitect.aws.ce.GetCostForecastRequest/Granularity :cognitect.aws.ce/Granularity)

(s/def :cognitect.aws.ce.GetCostForecastRequest/Filter :cognitect.aws.ce/Expression)

(s/def
  :cognitect.aws.ce.GetCostForecastRequest/PredictionIntervalLevel
  :cognitect.aws.ce/PredictionIntervalLevel)

(s/def
  :cognitect.aws.ce.GetDimensionValuesResponse/DimensionValues
  :cognitect.aws.ce/DimensionValuesWithAttributesList)

(s/def :cognitect.aws.ce.GetDimensionValuesResponse/ReturnSize :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.GetDimensionValuesResponse/TotalSize :cognitect.aws.ce/PageSize)

(s/def :cognitect.aws.ce.GetDimensionValuesResponse/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/SearchString :cognitect.aws.ce/SearchString)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/TimePeriod :cognitect.aws.ce/DateInterval)

(s/def
  :cognitect.aws.ce.GetCostCategoriesRequest/CostCategoryName
  :cognitect.aws.ce/CostCategoryName)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/Filter :cognitect.aws.ce/Expression)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/SortBy :cognitect.aws.ce/SortDefinitions)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/MaxResults :cognitect.aws.ce/MaxResults)

(s/def :cognitect.aws.ce.GetCostCategoriesRequest/NextPageToken :cognitect.aws.ce/NextPageToken)

(s/def :cognitect.aws.ce.DeleteCostCategoryDefinitionResponse/CostCategoryArn :cognitect.aws.ce/Arn)

(s/def
  :cognitect.aws.ce.DeleteCostCategoryDefinitionResponse/EffectiveEnd
  :cognitect.aws.ce/ZonedDateTime)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationResponse/SavingsPlansUtilizationsByTime
  :cognitect.aws.ce/SavingsPlansUtilizationsByTime)

(s/def
  :cognitect.aws.ce.GetSavingsPlansUtilizationResponse/Total
  :cognitect.aws.ce/SavingsPlansUtilizationAggregates)

