;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.cognito-idp.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.cognito-idp/AdminListUserAuthEventsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/NextToken
     :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/MaxResults]))

(s/def
  :cognitect.aws.cognito-idp/AttributeListType
  (s/coll-of :cognitect.aws.cognito-idp/AttributeType))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolDomainRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.DescribeUserPoolDomainRequest/Domain]))

(s/def :cognitect.aws.cognito-idp/AdminLinkProviderForUserResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/EventType
  (s/spec string? :gen #(s/gen #{"SignIn" "ForgotPassword" "SignUp"})))

(s/def
  :cognitect.aws.cognito-idp/AdminSetUserSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/Username
     :cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/MFAOptions]))

(s/def
  :cognitect.aws.cognito-idp/ListOfStringTypes
  (s/coll-of :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/DomainStatusType
  (s/spec string? :gen #(s/gen #{"UPDATING" "DELETING" "CREATING" "ACTIVE" "FAILED"})))

(s/def
  :cognitect.aws.cognito-idp/AttributeDataType
  (s/spec string? :gen #(s/gen #{"Number" "String" "DateTime" "Boolean"})))

(s/def
  :cognitect.aws.cognito-idp/ListUserPoolClientsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserPoolClientsResponse/NextToken
     :cognitect.aws.cognito-idp.ListUserPoolClientsResponse/UserPoolClients]))

(s/def
  :cognitect.aws.cognito-idp/UpdateResourceServerRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateResourceServerRequest/UserPoolId
     :cognitect.aws.cognito-idp.UpdateResourceServerRequest/Identifier
     :cognitect.aws.cognito-idp.UpdateResourceServerRequest/Name]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateResourceServerRequest/Scopes]))

(s/def :cognitect.aws.cognito-idp/GenerateSecret boolean?)

(s/def
  :cognitect.aws.cognito-idp/NumberAttributeConstraintsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.NumberAttributeConstraintsType/MinValue
     :cognitect.aws.cognito-idp.NumberAttributeConstraintsType/MaxValue]))

(s/def
  :cognitect.aws.cognito-idp/IdentityProviderType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.IdentityProviderType/AttributeMapping
     :cognitect.aws.cognito-idp.IdentityProviderType/LastModifiedDate
     :cognitect.aws.cognito-idp.IdentityProviderType/UserPoolId
     :cognitect.aws.cognito-idp.IdentityProviderType/IdpIdentifiers
     :cognitect.aws.cognito-idp.IdentityProviderType/ProviderName
     :cognitect.aws.cognito-idp.IdentityProviderType/CreationDate
     :cognitect.aws.cognito-idp.IdentityProviderType/ProviderDetails
     :cognitect.aws.cognito-idp.IdentityProviderType/ProviderType]))

(s/def
  :cognitect.aws.cognito-idp/ChallengeResponsesType
  (s/map-of :cognitect.aws.cognito-idp/StringType :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/SoftwareTokenMfaConfigType
  (s/keys :opt-un [:cognitect.aws.cognito-idp.SoftwareTokenMfaConfigType/Enabled]))

(s/def :cognitect.aws.cognito-idp/VerifyUserAttributeResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.TagResourceRequest/ResourceArn
     :cognitect.aws.cognito-idp.TagResourceRequest/Tags]))

(s/def
  :cognitect.aws.cognito-idp/ClientSecretType
  (s/spec #(re-matches (re-pattern "[\\w+]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/AdminDeleteUserAttributesResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/GetCSVHeaderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.GetCSVHeaderResponse/UserPoolId
     :cognitect.aws.cognito-idp.GetCSVHeaderResponse/CSVHeader]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolTagsListType
  (s/coll-of :cognitect.aws.cognito-idp/TagKeysType))

(s/def
  :cognitect.aws.cognito-idp/UserPoolClientListType
  (s/coll-of :cognitect.aws.cognito-idp/UserPoolClientDescription))

(s/def
  :cognitect.aws.cognito-idp/AdminUpdateUserAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/Username
     :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/UserAttributes]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/ClientMetadata]))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType
  (s/spec #(re-matches (re-pattern "[\\x21\\x23-\\x5B\\x5D-\\x7E]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ClientPermissionListType
  (s/coll-of :cognitect.aws.cognito-idp/ClientPermissionType))

(s/def
  :cognitect.aws.cognito-idp/ForgetDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ForgetDeviceRequest/DeviceKey]
    :opt-un
    [:cognitect.aws.cognito-idp.ForgetDeviceRequest/AccessToken]))

(s/def
  :cognitect.aws.cognito-idp/SupportedIdentityProvidersListType
  (s/coll-of :cognitect.aws.cognito-idp/ProviderNameType))

(s/def
  :cognitect.aws.cognito-idp/AuthEventType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AuthEventType/EventFeedback
     :cognitect.aws.cognito-idp.AuthEventType/EventType
     :cognitect.aws.cognito-idp.AuthEventType/ChallengeResponses
     :cognitect.aws.cognito-idp.AuthEventType/CreationDate
     :cognitect.aws.cognito-idp.AuthEventType/EventId
     :cognitect.aws.cognito-idp.AuthEventType/EventResponse
     :cognitect.aws.cognito-idp.AuthEventType/EventRisk
     :cognitect.aws.cognito-idp.AuthEventType/EventContextData]))

(s/def
  :cognitect.aws.cognito-idp/AssociateSoftwareTokenRequest
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AssociateSoftwareTokenRequest/AccessToken
     :cognitect.aws.cognito-idp.AssociateSoftwareTokenRequest/Session]))

(s/def
  :cognitect.aws.cognito-idp/ProvidersListType
  (s/coll-of :cognitect.aws.cognito-idp/ProviderDescription :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserPoolDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/Domain
     :cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/UserPoolId
     :cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/CustomDomainConfig]))

(s/def :cognitect.aws.cognito-idp/UsersListType (s/coll-of :cognitect.aws.cognito-idp/UserType))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerScopeType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ResourceServerScopeType/ScopeName
     :cognitect.aws.cognito-idp.ResourceServerScopeType/ScopeDescription]))

(s/def
  :cognitect.aws.cognito-idp/UserImportJobNameType
  (s/spec #(re-matches (re-pattern "[\\w\\s+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ListUserPoolsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserPoolsResponse/UserPools
     :cognitect.aws.cognito-idp.ListUserPoolsResponse/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/AttributeNameType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/UserFilterType
  (s/spec
    (s/and string? #(>= 256 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/PreventUserExistenceErrorTypes
  (s/spec string? :gen #(s/gen #{"LEGACY" "ENABLED"})))

(s/def :cognitect.aws.cognito-idp/AdminEnableUserResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/VerifiedAttributeType
  (s/spec string? :gen #(s/gen #{"phone_number" "email"})))

(s/def
  :cognitect.aws.cognito-idp/ListGroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListGroupsResponse/NextToken
     :cognitect.aws.cognito-idp.ListGroupsResponse/Groups]))

(s/def
  :cognitect.aws.cognito-idp/AttributeType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AttributeType/Name]
    :opt-un
    [:cognitect.aws.cognito-idp.AttributeType/Value]))

(s/def
  :cognitect.aws.cognito-idp/DeleteIdentityProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteIdentityProviderRequest/UserPoolId
     :cognitect.aws.cognito-idp.DeleteIdentityProviderRequest/ProviderName]))

(s/def
  :cognitect.aws.cognito-idp/AdminUpdateAuthEventFeedbackRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/Username
     :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/EventId
     :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/FeedbackValue]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolClientType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthFlowsUserPoolClient
     :cognitect.aws.cognito-idp.UserPoolClientType/RefreshTokenValidity
     :cognitect.aws.cognito-idp.UserPoolClientType/LastModifiedDate
     :cognitect.aws.cognito-idp.UserPoolClientType/ReadAttributes
     :cognitect.aws.cognito-idp.UserPoolClientType/UserPoolId
     :cognitect.aws.cognito-idp.UserPoolClientType/DefaultRedirectURI
     :cognitect.aws.cognito-idp.UserPoolClientType/AccessTokenValidity
     :cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthFlows
     :cognitect.aws.cognito-idp.UserPoolClientType/LogoutURLs
     :cognitect.aws.cognito-idp.UserPoolClientType/ClientName
     :cognitect.aws.cognito-idp.UserPoolClientType/PreventUserExistenceErrors
     :cognitect.aws.cognito-idp.UserPoolClientType/SupportedIdentityProviders
     :cognitect.aws.cognito-idp.UserPoolClientType/TokenValidityUnits
     :cognitect.aws.cognito-idp.UserPoolClientType/CallbackURLs
     :cognitect.aws.cognito-idp.UserPoolClientType/ClientId
     :cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthScopes
     :cognitect.aws.cognito-idp.UserPoolClientType/CreationDate
     :cognitect.aws.cognito-idp.UserPoolClientType/IdTokenValidity
     :cognitect.aws.cognito-idp.UserPoolClientType/WriteAttributes
     :cognitect.aws.cognito-idp.UserPoolClientType/ExplicitAuthFlows
     :cognitect.aws.cognito-idp.UserPoolClientType/ClientSecret
     :cognitect.aws.cognito-idp.UserPoolClientType/AnalyticsConfiguration]))

(s/def :cognitect.aws.cognito-idp/AdminSetUserPasswordResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/AccessTokenValidityType
  (s/spec (s/and int? #(<= 1 % 86400)) :gen #(gen/choose 1 86400)))

(s/def
  :cognitect.aws.cognito-idp/SoftwareTokenMfaSettingsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.SoftwareTokenMfaSettingsType/Enabled
     :cognitect.aws.cognito-idp.SoftwareTokenMfaSettingsType/PreferredMfa]))

(s/def
  :cognitect.aws.cognito-idp/CompromisedCredentialsActionsType
  (s/keys :req-un [:cognitect.aws.cognito-idp.CompromisedCredentialsActionsType/EventAction]))

(s/def
  :cognitect.aws.cognito-idp/DescribeIdentityProviderResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.DescribeIdentityProviderResponse/IdentityProvider]))

(s/def :cognitect.aws.cognito-idp/DeleteUserPoolDomainResponse (s/keys))

(s/def :cognitect.aws.cognito-idp/GroupListType (s/coll-of :cognitect.aws.cognito-idp/GroupType))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserPoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsConfiguration
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AccountRecoverySetting
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/MfaConfiguration
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AdminCreateUserConfig
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsVerificationMessage
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailVerificationMessage
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AutoVerifiedAttributes
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/DeviceConfiguration
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/LambdaConfig
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/Policies
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailVerificationSubject
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolTags
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolAddOns
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailConfiguration
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsAuthenticationMessage
     :cognitect.aws.cognito-idp.UpdateUserPoolRequest/VerificationMessageTemplate]))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserAttributesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateUserAttributesResponse/CodeDeliveryDetailsList]))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.DescribeUserPoolResponse/UserPool]))

(s/def
  :cognitect.aws.cognito-idp/PasswordPolicyType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.PasswordPolicyType/RequireLowercase
     :cognitect.aws.cognito-idp.PasswordPolicyType/RequireNumbers
     :cognitect.aws.cognito-idp.PasswordPolicyType/RequireUppercase
     :cognitect.aws.cognito-idp.PasswordPolicyType/MinimumLength
     :cognitect.aws.cognito-idp.PasswordPolicyType/RequireSymbols
     :cognitect.aws.cognito-idp.PasswordPolicyType/TemporaryPasswordValidityDays]))

(s/def
  :cognitect.aws.cognito-idp/PrecedenceType
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def :cognitect.aws.cognito-idp/ChangePasswordResponse (s/keys))

(s/def :cognitect.aws.cognito-idp/HttpHeaderList (s/coll-of :cognitect.aws.cognito-idp/HttpHeader))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserPoolClientResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.UpdateUserPoolClientResponse/UserPoolClient]))

(s/def
  :cognitect.aws.cognito-idp/AdvancedSecurityModeType
  (s/spec string? :gen #(s/gen #{"AUDIT" "ENFORCED" "OFF"})))

(s/def :cognitect.aws.cognito-idp/StringType string?)

(s/def
  :cognitect.aws.cognito-idp/SetUserPoolMfaConfigRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/MfaConfiguration
     :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/SmsMfaConfiguration
     :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/SoftwareTokenMfaConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/UserImportJobType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserImportJobType/CompletionDate
     :cognitect.aws.cognito-idp.UserImportJobType/PreSignedUrl
     :cognitect.aws.cognito-idp.UserImportJobType/ImportedUsers
     :cognitect.aws.cognito-idp.UserImportJobType/JobName
     :cognitect.aws.cognito-idp.UserImportJobType/UserPoolId
     :cognitect.aws.cognito-idp.UserImportJobType/Status
     :cognitect.aws.cognito-idp.UserImportJobType/CloudWatchLogsRoleArn
     :cognitect.aws.cognito-idp.UserImportJobType/FailedUsers
     :cognitect.aws.cognito-idp.UserImportJobType/CompletionMessage
     :cognitect.aws.cognito-idp.UserImportJobType/SkippedUsers
     :cognitect.aws.cognito-idp.UserImportJobType/CreationDate
     :cognitect.aws.cognito-idp.UserImportJobType/StartDate
     :cognitect.aws.cognito-idp.UserImportJobType/JobId]))

(s/def
  :cognitect.aws.cognito-idp/ConfirmSignUpRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ConfirmSignUpRequest/ClientId
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/Username
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ConfirmationCode]
    :opt-un
    [:cognitect.aws.cognito-idp.ConfirmSignUpRequest/UserContextData
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ClientMetadata
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/SecretHash
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ForceAliasCreation
     :cognitect.aws.cognito-idp.ConfirmSignUpRequest/AnalyticsMetadata]))

(s/def
  :cognitect.aws.cognito-idp/RecoveryOptionType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.RecoveryOptionType/Priority
     :cognitect.aws.cognito-idp.RecoveryOptionType/Name]))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.DescribeUserPoolRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/CustomDomainConfigType
  (s/keys :req-un [:cognitect.aws.cognito-idp.CustomDomainConfigType/CertificateArn]))

(s/def
  :cognitect.aws.cognito-idp/DeleteGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteGroupRequest/GroupName
     :cognitect.aws.cognito-idp.DeleteGroupRequest/UserPoolId]))

(s/def :cognitect.aws.cognito-idp/AdminUpdateDeviceStatusResponse (s/keys))

(s/def :cognitect.aws.cognito-idp/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/EventRiskType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.EventRiskType/CompromisedCredentialsDetected
     :cognitect.aws.cognito-idp.EventRiskType/RiskLevel
     :cognitect.aws.cognito-idp.EventRiskType/RiskDecision]))

(s/def
  :cognitect.aws.cognito-idp/StartUserImportJobResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.StartUserImportJobResponse/UserImportJob]))

(s/def
  :cognitect.aws.cognito-idp/ResendConfirmationCodeResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.ResendConfirmationCodeResponse/CodeDeliveryDetails]))

(s/def
  :cognitect.aws.cognito-idp/PasswordPolicyMinLengthType
  (s/spec (s/and int? #(<= 6 % 99)) :gen #(gen/choose 6 99)))

(s/def
  :cognitect.aws.cognito-idp/UsernameAttributeType
  (s/spec string? :gen #(s/gen #{"phone_number" "email"})))

(s/def
  :cognitect.aws.cognito-idp/BlockedIPRangeListType
  (s/coll-of :cognitect.aws.cognito-idp/StringType :max-count 20))

(s/def
  :cognitect.aws.cognito-idp/DescribeRiskConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DescribeRiskConfigurationRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.DescribeRiskConfigurationRequest/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/ForgotPasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ForgotPasswordRequest/ClientId
     :cognitect.aws.cognito-idp.ForgotPasswordRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.ForgotPasswordRequest/UserContextData
     :cognitect.aws.cognito-idp.ForgotPasswordRequest/ClientMetadata
     :cognitect.aws.cognito-idp.ForgotPasswordRequest/SecretHash
     :cognitect.aws.cognito-idp.ForgotPasswordRequest/AnalyticsMetadata]))

(s/def :cognitect.aws.cognito-idp/AdminResetUserPasswordResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/UpdateGroupResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.UpdateGroupResponse/Group]))

(s/def
  :cognitect.aws.cognito-idp/PreSignedUrlType
  (s/spec
    (s/and string? #(<= 0 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/VerifySoftwareTokenRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/UserCode]
    :opt-un
    [:cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/AccessToken
     :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/Session
     :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/FriendlyDeviceName]))

(s/def
  :cognitect.aws.cognito-idp/DeleteUserAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteUserAttributesRequest/UserAttributeNames
     :cognitect.aws.cognito-idp.DeleteUserAttributesRequest/AccessToken]))

(s/def
  :cognitect.aws.cognito-idp/ListProvidersLimitType
  (s/spec (s/and int? #(<= 0 % 60)) :gen #(gen/choose 0 60)))

(s/def
  :cognitect.aws.cognito-idp/OAuthFlowsType
  (s/coll-of :cognitect.aws.cognito-idp/OAuthFlowType :min-count 0 :max-count 3))

(s/def
  :cognitect.aws.cognito-idp/DeviceType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.DeviceType/DeviceCreateDate
     :cognitect.aws.cognito-idp.DeviceType/DeviceLastAuthenticatedDate
     :cognitect.aws.cognito-idp.DeviceType/DeviceKey
     :cognitect.aws.cognito-idp.DeviceType/DeviceLastModifiedDate
     :cognitect.aws.cognito-idp.DeviceType/DeviceAttributes]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserPoolType/SchemaAttributes
     :cognitect.aws.cognito-idp.UserPoolType/SmsConfiguration
     :cognitect.aws.cognito-idp.UserPoolType/AccountRecoverySetting
     :cognitect.aws.cognito-idp.UserPoolType/MfaConfiguration
     :cognitect.aws.cognito-idp.UserPoolType/AdminCreateUserConfig
     :cognitect.aws.cognito-idp.UserPoolType/LastModifiedDate
     :cognitect.aws.cognito-idp.UserPoolType/SmsConfigurationFailure
     :cognitect.aws.cognito-idp.UserPoolType/SmsVerificationMessage
     :cognitect.aws.cognito-idp.UserPoolType/Status
     :cognitect.aws.cognito-idp.UserPoolType/UsernameAttributes
     :cognitect.aws.cognito-idp.UserPoolType/EstimatedNumberOfUsers
     :cognitect.aws.cognito-idp.UserPoolType/EmailConfigurationFailure
     :cognitect.aws.cognito-idp.UserPoolType/Domain
     :cognitect.aws.cognito-idp.UserPoolType/EmailVerificationMessage
     :cognitect.aws.cognito-idp.UserPoolType/UsernameConfiguration
     :cognitect.aws.cognito-idp.UserPoolType/AutoVerifiedAttributes
     :cognitect.aws.cognito-idp.UserPoolType/DeviceConfiguration
     :cognitect.aws.cognito-idp.UserPoolType/LambdaConfig
     :cognitect.aws.cognito-idp.UserPoolType/CustomDomain
     :cognitect.aws.cognito-idp.UserPoolType/Arn
     :cognitect.aws.cognito-idp.UserPoolType/Policies
     :cognitect.aws.cognito-idp.UserPoolType/EmailVerificationSubject
     :cognitect.aws.cognito-idp.UserPoolType/CreationDate
     :cognitect.aws.cognito-idp.UserPoolType/UserPoolTags
     :cognitect.aws.cognito-idp.UserPoolType/UserPoolAddOns
     :cognitect.aws.cognito-idp.UserPoolType/Name
     :cognitect.aws.cognito-idp.UserPoolType/EmailConfiguration
     :cognitect.aws.cognito-idp.UserPoolType/Id
     :cognitect.aws.cognito-idp.UserPoolType/SmsAuthenticationMessage
     :cognitect.aws.cognito-idp.UserPoolType/VerificationMessageTemplate
     :cognitect.aws.cognito-idp.UserPoolType/AliasAttributes]))

(s/def
  :cognitect.aws.cognito-idp/ListUsersInGroupResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListUsersInGroupResponse/NextToken
     :cognitect.aws.cognito-idp.ListUsersInGroupResponse/Users]))

(s/def
  :cognitect.aws.cognito-idp/CreateUserImportJobResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.CreateUserImportJobResponse/UserImportJob]))

(s/def
  :cognitect.aws.cognito-idp/GetUserAttributeVerificationCodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/AccessToken
     :cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/AttributeName]
    :opt-un
    [:cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/ClientMetadata]))

(s/def
  :cognitect.aws.cognito-idp/TokenModelType
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9-_=.]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/GetUserResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetUserResponse/Username
     :cognitect.aws.cognito-idp.GetUserResponse/UserAttributes]
    :opt-un
    [:cognitect.aws.cognito-idp.GetUserResponse/MFAOptions
     :cognitect.aws.cognito-idp.GetUserResponse/PreferredMfaSetting
     :cognitect.aws.cognito-idp.GetUserResponse/UserMFASettingList]))

(s/def
  :cognitect.aws.cognito-idp/ProviderUserIdentifierType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderName
     :cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderAttributeValue
     :cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderAttributeName]))

(s/def
  :cognitect.aws.cognito-idp/EventContextDataType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.EventContextDataType/Country
     :cognitect.aws.cognito-idp.EventContextDataType/Timezone
     :cognitect.aws.cognito-idp.EventContextDataType/IpAddress
     :cognitect.aws.cognito-idp.EventContextDataType/DeviceName
     :cognitect.aws.cognito-idp.EventContextDataType/City]))

(s/def
  :cognitect.aws.cognito-idp/CompromisedCredentialsEventActionType
  (s/spec string? :gen #(s/gen #{"NO_ACTION" "BLOCK"})))

(s/def
  :cognitect.aws.cognito-idp/UpdateIdentityProviderResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.UpdateIdentityProviderResponse/IdentityProvider]))

(s/def
  :cognitect.aws.cognito-idp/CompletionMessageType
  (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AdminAddUserToGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/Username
     :cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/GroupName]))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolDomainResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.CreateUserPoolDomainResponse/CloudFrontDomain]))

(s/def
  :cognitect.aws.cognito-idp/VerifySoftwareTokenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.VerifySoftwareTokenResponse/Status
     :cognitect.aws.cognito-idp.VerifySoftwareTokenResponse/Session]))

(s/def
  :cognitect.aws.cognito-idp/ScopeType
  (s/spec #(re-matches (re-pattern "[\\x21\\x23-\\x5B\\x5D-\\x7E]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/CSSType string?)

(s/def
  :cognitect.aws.cognito-idp/EmailSendingAccountType
  (s/spec string? :gen #(s/gen #{"COGNITO_DEFAULT" "DEVELOPER"})))

(s/def
  :cognitect.aws.cognito-idp/SmsConfigurationType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SmsConfigurationType/SnsCallerArn]
    :opt-un
    [:cognitect.aws.cognito-idp.SmsConfigurationType/ExternalId]))

(s/def
  :cognitect.aws.cognito-idp/SMSMfaSettingsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.SMSMfaSettingsType/Enabled
     :cognitect.aws.cognito-idp.SMSMfaSettingsType/PreferredMfa]))

(s/def
  :cognitect.aws.cognito-idp/DescribeResourceServerResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.DescribeResourceServerResponse/ResourceServer]))

(s/def
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsListType
  (s/coll-of :cognitect.aws.cognito-idp/CodeDeliveryDetailsType))

(s/def
  :cognitect.aws.cognito-idp/AccountTakeoverActionsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AccountTakeoverActionsType/MediumAction
     :cognitect.aws.cognito-idp.AccountTakeoverActionsType/LowAction
     :cognitect.aws.cognito-idp.AccountTakeoverActionsType/HighAction]))

(s/def :cognitect.aws.cognito-idp/CSSVersionType string?)

(s/def
  :cognitect.aws.cognito-idp/TimeUnitsType
  (s/spec string? :gen #(s/gen #{"hours" "minutes" "seconds" "days"})))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolClientRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DescribeUserPoolClientRequest/UserPoolId
     :cognitect.aws.cognito-idp.DescribeUserPoolClientRequest/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/EmailConfigurationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.EmailConfigurationType/ConfigurationSet
     :cognitect.aws.cognito-idp.EmailConfigurationType/EmailSendingAccount
     :cognitect.aws.cognito-idp.EmailConfigurationType/ReplyToEmailAddress
     :cognitect.aws.cognito-idp.EmailConfigurationType/SourceArn
     :cognitect.aws.cognito-idp.EmailConfigurationType/From]))

(s/def
  :cognitect.aws.cognito-idp/IdpIdentifierType
  (s/spec #(re-matches (re-pattern "[\\w\\s+=.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/StartUserImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.StartUserImportJobRequest/UserPoolId
     :cognitect.aws.cognito-idp.StartUserImportJobRequest/JobId]))

(s/def
  :cognitect.aws.cognito-idp/ListResourceServersResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListResourceServersResponse/ResourceServers]
    :opt-un
    [:cognitect.aws.cognito-idp.ListResourceServersResponse/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/CreateGroupResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.CreateGroupResponse/Group]))

(s/def
  :cognitect.aws.cognito-idp/ChallengeNameType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"MFA_SETUP" "SOFTWARE_TOKEN_MFA" "ADMIN_NO_SRP_AUTH" "DEVICE_SRP_AUTH" "SELECT_MFA_TYPE"
        "DEVICE_PASSWORD_VERIFIER" "CUSTOM_CHALLENGE" "PASSWORD_VERIFIER" "NEW_PASSWORD_REQUIRED"
        "SMS_MFA"})))

(s/def
  :cognitect.aws.cognito-idp/ChangePasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ChangePasswordRequest/PreviousPassword
     :cognitect.aws.cognito-idp.ChangePasswordRequest/ProposedPassword
     :cognitect.aws.cognito-idp.ChangePasswordRequest/AccessToken]))

(s/def :cognitect.aws.cognito-idp/UpdateAuthEventFeedbackResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/ListUserImportJobsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserImportJobsResponse/PaginationToken
     :cognitect.aws.cognito-idp.ListUserImportJobsResponse/UserImportJobs]))

(s/def :cognitect.aws.cognito-idp/AdminSetUserSettingsResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/RecoveryMechanismsType
  (s/coll-of :cognitect.aws.cognito-idp/RecoveryOptionType :min-count 1 :max-count 2))

(s/def
  :cognitect.aws.cognito-idp/UserPoolListType
  (s/coll-of :cognitect.aws.cognito-idp/UserPoolDescriptionType))

(s/def
  :cognitect.aws.cognito-idp/AdminListGroupsForUserResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListGroupsForUserResponse/NextToken
     :cognitect.aws.cognito-idp.AdminListGroupsForUserResponse/Groups]))

(s/def
  :cognitect.aws.cognito-idp/LongType
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.cognito-idp/EventIdType
  (s/spec #(re-matches (re-pattern "[\\w+-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/CustomSMSSenderLambdaVersionType
  (s/spec string? :gen #(s/gen #{"V1_0"})))

(s/def
  :cognitect.aws.cognito-idp/AdminDisableProviderForUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminDisableProviderForUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminDisableProviderForUserRequest/User]))

(s/def
  :cognitect.aws.cognito-idp/GroupType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.GroupType/Precedence
     :cognitect.aws.cognito-idp.GroupType/LastModifiedDate
     :cognitect.aws.cognito-idp.GroupType/RoleArn
     :cognitect.aws.cognito-idp.GroupType/GroupName
     :cognitect.aws.cognito-idp.GroupType/UserPoolId
     :cognitect.aws.cognito-idp.GroupType/Description
     :cognitect.aws.cognito-idp.GroupType/CreationDate]))

(s/def
  :cognitect.aws.cognito-idp/SchemaAttributesListType
  (s/coll-of :cognitect.aws.cognito-idp/SchemaAttributeType :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.cognito-idp/AdminForgetDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminForgetDeviceRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminForgetDeviceRequest/Username
     :cognitect.aws.cognito-idp.AdminForgetDeviceRequest/DeviceKey]))

(s/def
  :cognitect.aws.cognito-idp/AdminCreateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminCreateUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminCreateUserRequest/ClientMetadata
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/TemporaryPassword
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/ForceAliasCreation
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/MessageAction
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/UserAttributes
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/ValidationData
     :cognitect.aws.cognito-idp.AdminCreateUserRequest/DesiredDeliveryMediums]))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.CreateUserPoolResponse/UserPool]))

(s/def
  :cognitect.aws.cognito-idp/ListUsersInGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListUsersInGroupRequest/UserPoolId
     :cognitect.aws.cognito-idp.ListUsersInGroupRequest/GroupName]
    :opt-un
    [:cognitect.aws.cognito-idp.ListUsersInGroupRequest/Limit
     :cognitect.aws.cognito-idp.ListUsersInGroupRequest/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/SecretHashType
  (s/spec #(re-matches (re-pattern "[\\w+=/]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/GetUserPoolMfaConfigResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/MfaConfiguration
     :cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/SmsMfaConfiguration
     :cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/SoftwareTokenMfaConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolDomainResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.DescribeUserPoolDomainResponse/DomainDescription]))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolClientRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateUserPoolClientRequest/UserPoolId
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ClientName]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthFlowsUserPoolClient
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/RefreshTokenValidity
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ReadAttributes
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/GenerateSecret
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/DefaultRedirectURI
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AccessTokenValidity
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthFlows
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/LogoutURLs
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/PreventUserExistenceErrors
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/SupportedIdentityProviders
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/TokenValidityUnits
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/CallbackURLs
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthScopes
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/IdTokenValidity
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/WriteAttributes
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ExplicitAuthFlows
     :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AnalyticsConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/SetUICustomizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SetUICustomizationRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.SetUICustomizationRequest/CSS
     :cognitect.aws.cognito-idp.SetUICustomizationRequest/ClientId
     :cognitect.aws.cognito-idp.SetUICustomizationRequest/ImageFile]))

(s/def
  :cognitect.aws.cognito-idp/DeviceSecretVerifierConfigType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.DeviceSecretVerifierConfigType/PasswordVerifier
     :cognitect.aws.cognito-idp.DeviceSecretVerifierConfigType/Salt]))

(s/def
  :cognitect.aws.cognito-idp/NotifyEmailType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.NotifyEmailType/Subject]
    :opt-un
    [:cognitect.aws.cognito-idp.NotifyEmailType/HtmlBody
     :cognitect.aws.cognito-idp.NotifyEmailType/TextBody]))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerScopeNameType
  (s/spec
    #(re-matches (re-pattern "[\\x21\\x23-\\x2E\\x30-\\x5B\\x5D-\\x7E]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ProviderNameType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AdminListDevicesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminListDevicesRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminListDevicesRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListDevicesRequest/PaginationToken
     :cognitect.aws.cognito-idp.AdminListDevicesRequest/Limit]))

(s/def
  :cognitect.aws.cognito-idp/ConfirmDeviceResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.ConfirmDeviceResponse/UserConfirmationNecessary]))

(s/def
  :cognitect.aws.cognito-idp/FeedbackValueType
  (s/spec string? :gen #(s/gen #{"Invalid" "Valid"})))

(s/def
  :cognitect.aws.cognito-idp/GetIdentityProviderByIdentifierRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierRequest/UserPoolId
     :cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierRequest/IdpIdentifier]))

(s/def
  :cognitect.aws.cognito-idp/GetDeviceResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetDeviceResponse/Device]))

(s/def :cognitect.aws.cognito-idp/SetUserMFAPreferenceResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/ProviderNameTypeV1
  (s/spec
    #(re-matches (re-pattern "[^_][\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}][^_]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AttributeValueType
  (s/spec
    (s/and string? #(>= 2048 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/Domain
     :cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/CustomDomainConfig]))

(s/def
  :cognitect.aws.cognito-idp/IntegerType
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.cognito-idp/UserPoolClientDescription
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserPoolClientDescription/UserPoolId
     :cognitect.aws.cognito-idp.UserPoolClientDescription/ClientName
     :cognitect.aws.cognito-idp.UserPoolClientDescription/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/AdminLinkProviderForUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/DestinationUser
     :cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/SourceUser]))

(s/def
  :cognitect.aws.cognito-idp/EmailVerificationSubjectByLinkType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/ConfirmSignUpResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/CreateResourceServerResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.CreateResourceServerResponse/ResourceServer]))

(s/def :cognitect.aws.cognito-idp/AdminDisableProviderForUserResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/InitiateAuthResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.InitiateAuthResponse/AuthenticationResult
     :cognitect.aws.cognito-idp.InitiateAuthResponse/ChallengeName
     :cognitect.aws.cognito-idp.InitiateAuthResponse/Session
     :cognitect.aws.cognito-idp.InitiateAuthResponse/ChallengeParameters]))

(s/def
  :cognitect.aws.cognito-idp/NotifyConfigurationType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.NotifyConfigurationType/SourceArn]
    :opt-un
    [:cognitect.aws.cognito-idp.NotifyConfigurationType/ReplyTo
     :cognitect.aws.cognito-idp.NotifyConfigurationType/NoActionEmail
     :cognitect.aws.cognito-idp.NotifyConfigurationType/BlockEmail
     :cognitect.aws.cognito-idp.NotifyConfigurationType/MfaEmail
     :cognitect.aws.cognito-idp.NotifyConfigurationType/From]))

(s/def
  :cognitect.aws.cognito-idp/DeleteResourceServerRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteResourceServerRequest/UserPoolId
     :cognitect.aws.cognito-idp.DeleteResourceServerRequest/Identifier]))

(s/def
  :cognitect.aws.cognito-idp/UsernameAttributesListType
  (s/coll-of :cognitect.aws.cognito-idp/UsernameAttributeType))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserPoolDomainResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.UpdateUserPoolDomainResponse/CloudFrontDomain]))

(s/def
  :cognitect.aws.cognito-idp/SmsVerificationMessageType
  (s/spec #(re-matches (re-pattern ".*\\{####\\}.*") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/AdminUpdateUserAttributesResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/SignUpRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SignUpRequest/ClientId
     :cognitect.aws.cognito-idp.SignUpRequest/Username
     :cognitect.aws.cognito-idp.SignUpRequest/Password]
    :opt-un
    [:cognitect.aws.cognito-idp.SignUpRequest/UserContextData
     :cognitect.aws.cognito-idp.SignUpRequest/ClientMetadata
     :cognitect.aws.cognito-idp.SignUpRequest/SecretHash
     :cognitect.aws.cognito-idp.SignUpRequest/UserAttributes
     :cognitect.aws.cognito-idp.SignUpRequest/ValidationData
     :cognitect.aws.cognito-idp.SignUpRequest/AnalyticsMetadata]))

(s/def
  :cognitect.aws.cognito-idp/GetUICustomizationRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetUICustomizationRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.GetUICustomizationRequest/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/UserType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserType/Username
     :cognitect.aws.cognito-idp.UserType/MFAOptions
     :cognitect.aws.cognito-idp.UserType/Enabled
     :cognitect.aws.cognito-idp.UserType/Attributes
     :cognitect.aws.cognito-idp.UserType/UserCreateDate
     :cognitect.aws.cognito-idp.UserType/UserLastModifiedDate
     :cognitect.aws.cognito-idp.UserType/UserStatus]))

(s/def
  :cognitect.aws.cognito-idp/AdminResetUserPasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/ClientMetadata]))

(s/def
  :cognitect.aws.cognito-idp/RiskLevelType
  (s/spec string? :gen #(s/gen #{"Medium" "High" "Low"})))

(s/def
  :cognitect.aws.cognito-idp/QueryLimit
  (s/spec (s/and int? #(<= 1 % 60)) :gen #(gen/choose 1 60)))

(s/def :cognitect.aws.cognito-idp/AdminUserGlobalSignOutResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/DescribeRiskConfigurationResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.DescribeRiskConfigurationResponse/RiskConfiguration]))

(s/def :cognitect.aws.cognito-idp/AddCustomAttributesResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/UICustomizationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UICustomizationType/LastModifiedDate
     :cognitect.aws.cognito-idp.UICustomizationType/ImageUrl
     :cognitect.aws.cognito-idp.UICustomizationType/UserPoolId
     :cognitect.aws.cognito-idp.UICustomizationType/CSSVersion
     :cognitect.aws.cognito-idp.UICustomizationType/CSS
     :cognitect.aws.cognito-idp.UICustomizationType/ClientId
     :cognitect.aws.cognito-idp.UICustomizationType/CreationDate]))

(s/def
  :cognitect.aws.cognito-idp/EventFeedbackType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.EventFeedbackType/FeedbackValue
     :cognitect.aws.cognito-idp.EventFeedbackType/Provider]
    :opt-un
    [:cognitect.aws.cognito-idp.EventFeedbackType/FeedbackDate]))

(s/def
  :cognitect.aws.cognito-idp/QueryLimitType
  (s/spec (s/and int? #(<= 0 % 60)) :gen #(gen/choose 0 60)))

(s/def
  :cognitect.aws.cognito-idp/ProviderDescription
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ProviderDescription/LastModifiedDate
     :cognitect.aws.cognito-idp.ProviderDescription/ProviderName
     :cognitect.aws.cognito-idp.ProviderDescription/CreationDate
     :cognitect.aws.cognito-idp.ProviderDescription/ProviderType]))

(s/def
  :cognitect.aws.cognito-idp/ListIdentityProvidersResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListIdentityProvidersResponse/Providers]
    :opt-un
    [:cognitect.aws.cognito-idp.ListIdentityProvidersResponse/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/EventFilterType
  (s/spec string? :gen #(s/gen #{"SIGN_UP" "SIGN_IN" "PASSWORD_CHANGE"})))

(s/def
  :cognitect.aws.cognito-idp/EmailNotificationBodyType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ArnType
  (s/spec
    #(re-matches
      (re-pattern
        "arn:[\\w+=/,.@-]+:[\\w+=/,.@-]+:([\\w+=/,.@-]*)?:[0-9]+:[\\w+=/,.@-]+(:[\\w+=/,.@-]+)?(:[\\w+=/,.@-]+)?")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/DescribeResourceServerRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DescribeResourceServerRequest/UserPoolId
     :cognitect.aws.cognito-idp.DescribeResourceServerRequest/Identifier]))

(s/def :cognitect.aws.cognito-idp/AdminUpdateAuthEventFeedbackResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/SecretCodeType
  (s/spec #(re-matches (re-pattern "[A-Za-z0-9]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/BooleanType boolean?)

(s/def
  :cognitect.aws.cognito-idp/AdminListGroupsForUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/Username
     :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/Limit
     :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerScopeDescriptionType
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/ImageFileType
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateUserPoolRequest/PoolName]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsConfiguration
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/Schema
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/AccountRecoverySetting
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/MfaConfiguration
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/AdminCreateUserConfig
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsVerificationMessage
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/UsernameAttributes
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailVerificationMessage
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/UsernameConfiguration
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/AutoVerifiedAttributes
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/DeviceConfiguration
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/LambdaConfig
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/Policies
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailVerificationSubject
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/UserPoolTags
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/UserPoolAddOns
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailConfiguration
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsAuthenticationMessage
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/VerificationMessageTemplate
     :cognitect.aws.cognito-idp.CreateUserPoolRequest/AliasAttributes]))

(s/def
  :cognitect.aws.cognito-idp/UsernameConfigurationType
  (s/keys :req-un [:cognitect.aws.cognito-idp.UsernameConfigurationType/CaseSensitive]))

(s/def
  :cognitect.aws.cognito-idp/AuthFlowType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"CUSTOM_AUTH" "ADMIN_USER_PASSWORD_AUTH" "ADMIN_NO_SRP_AUTH" "USER_SRP_AUTH"
        "USER_PASSWORD_AUTH" "REFRESH_TOKEN" "REFRESH_TOKEN_AUTH"})))

(s/def
  :cognitect.aws.cognito-idp/AliasAttributeType
  (s/spec string? :gen #(s/gen #{"phone_number" "email" "preferred_username"})))

(s/def
  :cognitect.aws.cognito-idp/TemporaryPasswordValidityDaysType
  (s/spec (s/and int? #(<= 0 % 365)) :gen #(gen/choose 0 365)))

(s/def :cognitect.aws.cognito-idp/UpdateDeviceStatusResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/AccountTakeoverActionType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AccountTakeoverActionType/Notify
     :cognitect.aws.cognito-idp.AccountTakeoverActionType/EventAction]))

(s/def
  :cognitect.aws.cognito-idp/AdminListUserAuthEventsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListUserAuthEventsResponse/AuthEvents
     :cognitect.aws.cognito-idp.AdminListUserAuthEventsResponse/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/GetGroupResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.GetGroupResponse/Group]))

(s/def
  :cognitect.aws.cognito-idp/DomainVersionType
  (s/spec
    (s/and string? #(<= 1 (count %) 20))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 20) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.ListTagsForResourceRequest/ResourceArn]))

(s/def
  :cognitect.aws.cognito-idp/LogoutURLsListType
  (s/coll-of :cognitect.aws.cognito-idp/RedirectUrlType :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.cognito-idp/AnalyticsConfigurationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AnalyticsConfigurationType/ApplicationArn
     :cognitect.aws.cognito-idp.AnalyticsConfigurationType/ExternalId
     :cognitect.aws.cognito-idp.AnalyticsConfigurationType/RoleArn
     :cognitect.aws.cognito-idp.AnalyticsConfigurationType/ApplicationId
     :cognitect.aws.cognito-idp.AnalyticsConfigurationType/UserDataShared]))

(s/def
  :cognitect.aws.cognito-idp/AuthEventsType
  (s/coll-of :cognitect.aws.cognito-idp/AuthEventType))

(s/def
  :cognitect.aws.cognito-idp/IdentityProviderTypeType
  (s/spec
    string?
    :gen
    #(s/gen #{"OIDC" "Google" "SAML" "SignInWithApple" "LoginWithAmazon" "Facebook"})))

(s/def
  :cognitect.aws.cognito-idp/DomainDescriptionType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.DomainDescriptionType/CloudFrontDistribution
     :cognitect.aws.cognito-idp.DomainDescriptionType/UserPoolId
     :cognitect.aws.cognito-idp.DomainDescriptionType/Status
     :cognitect.aws.cognito-idp.DomainDescriptionType/AWSAccountId
     :cognitect.aws.cognito-idp.DomainDescriptionType/Domain
     :cognitect.aws.cognito-idp.DomainDescriptionType/CustomDomainConfig
     :cognitect.aws.cognito-idp.DomainDescriptionType/S3Bucket
     :cognitect.aws.cognito-idp.DomainDescriptionType/Version]))

(s/def
  :cognitect.aws.cognito-idp/SignUpResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SignUpResponse/UserConfirmed
     :cognitect.aws.cognito-idp.SignUpResponse/UserSub]
    :opt-un
    [:cognitect.aws.cognito-idp.SignUpResponse/CodeDeliveryDetails]))

(s/def
  :cognitect.aws.cognito-idp/ListIdentityProvidersRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListIdentityProvidersRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.ListIdentityProvidersRequest/NextToken
     :cognitect.aws.cognito-idp.ListIdentityProvidersRequest/MaxResults]))

(s/def :cognitect.aws.cognito-idp/ConfirmForgotPasswordResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/VerifySoftwareTokenResponseType
  (s/spec string? :gen #(s/gen #{"SUCCESS" "ERROR"})))

(s/def
  :cognitect.aws.cognito-idp/AdminGetUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminGetUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminGetUserRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/AuthParametersType
  (s/map-of :cognitect.aws.cognito-idp/StringType :cognitect.aws.cognito-idp/StringType))

(s/def :cognitect.aws.cognito-idp/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/AdminInitiateAuthRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminInitiateAuthRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ClientId
     :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AuthFlow]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ClientMetadata
     :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ContextData
     :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AnalyticsMetadata
     :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AuthParameters]))

(s/def
  :cognitect.aws.cognito-idp/ListUserPoolsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListUserPoolsRequest/MaxResults]
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserPoolsRequest/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolIdType
  (s/spec #(re-matches (re-pattern "[\\w-]+_[0-9a-zA-Z]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AdminRespondToAuthChallengeRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ClientId
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ChallengeName]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ClientMetadata
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ChallengeResponses
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ContextData
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/AnalyticsMetadata
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/Session]))

(s/def
  :cognitect.aws.cognito-idp/CreateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateGroupRequest/GroupName
     :cognitect.aws.cognito-idp.CreateGroupRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateGroupRequest/Precedence
     :cognitect.aws.cognito-idp.CreateGroupRequest/RoleArn
     :cognitect.aws.cognito-idp.CreateGroupRequest/Description]))

(s/def
  :cognitect.aws.cognito-idp/CreateResourceServerRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateResourceServerRequest/UserPoolId
     :cognitect.aws.cognito-idp.CreateResourceServerRequest/Identifier
     :cognitect.aws.cognito-idp.CreateResourceServerRequest/Name]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateResourceServerRequest/Scopes]))

(s/def
  :cognitect.aws.cognito-idp/UpdateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateGroupRequest/GroupName
     :cognitect.aws.cognito-idp.UpdateGroupRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateGroupRequest/Precedence
     :cognitect.aws.cognito-idp.UpdateGroupRequest/RoleArn
     :cognitect.aws.cognito-idp.UpdateGroupRequest/Description]))

(s/def
  :cognitect.aws.cognito-idp/ClientPermissionType
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/ListGroupsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListGroupsRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.ListGroupsRequest/Limit
     :cognitect.aws.cognito-idp.ListGroupsRequest/NextToken]))

(s/def
  :cognitect.aws.cognito-idp/DeleteUserRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.DeleteUserRequest/AccessToken]))

(s/def
  :cognitect.aws.cognito-idp/EmailAddressType
  (s/spec
    #(re-matches
      (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+@[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/MessageActionType
  (s/spec string? :gen #(s/gen #{"RESEND" "SUPPRESS"})))

(s/def
  :cognitect.aws.cognito-idp/AddCustomAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AddCustomAttributesRequest/UserPoolId
     :cognitect.aws.cognito-idp.AddCustomAttributesRequest/CustomAttributes]))

(s/def
  :cognitect.aws.cognito-idp/ClientIdType
  (s/spec #(re-matches (re-pattern "[\\w+]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/PoolQueryLimitType
  (s/spec (s/and int? #(<= 1 % 60)) :gen #(gen/choose 1 60)))

(s/def
  :cognitect.aws.cognito-idp/UserImportJobIdType
  (s/spec #(re-matches (re-pattern "import-[0-9a-zA-Z-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/IdTokenValidityType
  (s/spec (s/and int? #(<= 1 % 86400)) :gen #(gen/choose 1 86400)))

(s/def
  :cognitect.aws.cognito-idp/GetSigningCertificateResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.GetSigningCertificateResponse/Certificate]))

(s/def
  :cognitect.aws.cognito-idp/ExplicitAuthFlowsType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"ALLOW_CUSTOM_AUTH" "ALLOW_USER_PASSWORD_AUTH" "ADMIN_NO_SRP_AUTH" "CUSTOM_AUTH_FLOW_ONLY"
        "ALLOW_REFRESH_TOKEN_AUTH" "USER_PASSWORD_AUTH" "ALLOW_USER_SRP_AUTH"
        "ALLOW_ADMIN_USER_PASSWORD_AUTH"})))

(s/def
  :cognitect.aws.cognito-idp/UserPoolNameType
  (s/spec #(re-matches (re-pattern "[\\w\\s+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerNameType
  (s/spec #(re-matches (re-pattern "[\\w\\s+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/CreateUserPoolClientResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.CreateUserPoolClientResponse/UserPoolClient]))

(s/def
  :cognitect.aws.cognito-idp/AccountTakeoverRiskConfigurationType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AccountTakeoverRiskConfigurationType/Actions]
    :opt-un
    [:cognitect.aws.cognito-idp.AccountTakeoverRiskConfigurationType/NotifyConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/RecoveryOptionNameType
  (s/spec string? :gen #(s/gen #{"verified_email" "verified_phone_number" "admin_only"})))

(s/def
  :cognitect.aws.cognito-idp/RiskExceptionConfigurationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.RiskExceptionConfigurationType/SkippedIPRangeList
     :cognitect.aws.cognito-idp.RiskExceptionConfigurationType/BlockedIPRangeList]))

(s/def
  :cognitect.aws.cognito-idp/SessionType
  (s/spec
    (s/and string? #(<= 20 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/DomainType
  (s/spec
    #(re-matches (re-pattern "^[a-z0-9](?:[a-z0-9\\-]{0,61}[a-z0-9])?$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/GetSigningCertificateRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetSigningCertificateRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/RiskDecisionType
  (s/spec string? :gen #(s/gen #{"NoRisk" "Block" "AccountTakeover"})))

(s/def
  :cognitect.aws.cognito-idp/DeliveryMediumType
  (s/spec string? :gen #(s/gen #{"SMS" "EMAIL"})))

(s/def
  :cognitect.aws.cognito-idp/MFAOptionListType
  (s/coll-of :cognitect.aws.cognito-idp/MFAOptionType))

(s/def
  :cognitect.aws.cognito-idp/AdminRespondToAuthChallengeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/AuthenticationResult
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/ChallengeName
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/Session
     :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/ChallengeParameters]))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DescribeUserImportJobRequest/UserPoolId
     :cognitect.aws.cognito-idp.DescribeUserImportJobRequest/JobId]))

(s/def
  :cognitect.aws.cognito-idp/UsernameType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/UserPoolDescriptionType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.UserPoolDescriptionType/LastModifiedDate
     :cognitect.aws.cognito-idp.UserPoolDescriptionType/Status
     :cognitect.aws.cognito-idp.UserPoolDescriptionType/LambdaConfig
     :cognitect.aws.cognito-idp.UserPoolDescriptionType/CreationDate
     :cognitect.aws.cognito-idp.UserPoolDescriptionType/Name
     :cognitect.aws.cognito-idp.UserPoolDescriptionType/Id]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolTagsType
  (s/map-of :cognitect.aws.cognito-idp/TagKeysType :cognitect.aws.cognito-idp/TagValueType))

(s/def :cognitect.aws.cognito-idp/AdminConfirmSignUpResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/CustomEmailLambdaVersionConfigType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CustomEmailLambdaVersionConfigType/LambdaVersion
     :cognitect.aws.cognito-idp.CustomEmailLambdaVersionConfigType/LambdaArn]))

(s/def
  :cognitect.aws.cognito-idp/UserMFASettingListType
  (s/coll-of :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/GroupNameType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/UpdateAuthEventFeedbackRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/UserPoolId
     :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/Username
     :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/EventId
     :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/FeedbackToken
     :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/FeedbackValue]))

(s/def
  :cognitect.aws.cognito-idp/ConfirmForgotPasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ClientId
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/Username
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ConfirmationCode
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/Password]
    :opt-un
    [:cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/UserContextData
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ClientMetadata
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/SecretHash
     :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/AnalyticsMetadata]))

(s/def
  :cognitect.aws.cognito-idp/IdpIdentifiersListType
  (s/coll-of :cognitect.aws.cognito-idp/IdpIdentifierType :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.cognito-idp/DescribeIdentityProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DescribeIdentityProviderRequest/UserPoolId
     :cognitect.aws.cognito-idp.DescribeIdentityProviderRequest/ProviderName]))

(s/def
  :cognitect.aws.cognito-idp/ResendConfirmationCodeRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/ClientId
     :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/UserContextData
     :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/ClientMetadata
     :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/SecretHash
     :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/AnalyticsMetadata]))

(s/def
  :cognitect.aws.cognito-idp/ChallengeResponseType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ChallengeResponseType/ChallengeResponse
     :cognitect.aws.cognito-idp.ChallengeResponseType/ChallengeName]))

(s/def
  :cognitect.aws.cognito-idp/SESConfigurationSet
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ClientMetadataType
  (s/map-of :cognitect.aws.cognito-idp/StringType :cognitect.aws.cognito-idp/StringType))

(s/def :cognitect.aws.cognito-idp/GlobalSignOutResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/ConfirmDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ConfirmDeviceRequest/AccessToken
     :cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceKey]
    :opt-un
    [:cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceSecretVerifierConfig
     :cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceName]))

(s/def
  :cognitect.aws.cognito-idp/ForgotPasswordResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.ForgotPasswordResponse/CodeDeliveryDetails]))

(s/def :cognitect.aws.cognito-idp/AdminSetUserMFAPreferenceResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/MessageTemplateType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.MessageTemplateType/EmailSubject
     :cognitect.aws.cognito-idp.MessageTemplateType/SMSMessage
     :cognitect.aws.cognito-idp.MessageTemplateType/EmailMessage]))

(s/def :cognitect.aws.cognito-idp/ForceAliasCreation boolean?)

(s/def
  :cognitect.aws.cognito-idp/GetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetGroupRequest/GroupName
     :cognitect.aws.cognito-idp.GetGroupRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/StopUserImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.StopUserImportJobRequest/UserPoolId
     :cognitect.aws.cognito-idp.StopUserImportJobRequest/JobId]))

(s/def
  :cognitect.aws.cognito-idp/AdminGetUserResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminGetUserResponse/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminGetUserResponse/MFAOptions
     :cognitect.aws.cognito-idp.AdminGetUserResponse/Enabled
     :cognitect.aws.cognito-idp.AdminGetUserResponse/UserCreateDate
     :cognitect.aws.cognito-idp.AdminGetUserResponse/PreferredMfaSetting
     :cognitect.aws.cognito-idp.AdminGetUserResponse/UserMFASettingList
     :cognitect.aws.cognito-idp.AdminGetUserResponse/UserAttributes
     :cognitect.aws.cognito-idp.AdminGetUserResponse/UserLastModifiedDate
     :cognitect.aws.cognito-idp.AdminGetUserResponse/UserStatus]))

(s/def :cognitect.aws.cognito-idp/DateType inst?)

(s/def
  :cognitect.aws.cognito-idp/GetDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetDeviceRequest/DeviceKey]
    :opt-un
    [:cognitect.aws.cognito-idp.GetDeviceRequest/AccessToken]))

(s/def :cognitect.aws.cognito-idp/ImageUrlType string?)

(s/def
  :cognitect.aws.cognito-idp/AdminDisableUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminDisableUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminDisableUserRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/S3BucketType
  (s/spec #(re-matches (re-pattern "^[0-9A-Za-z\\.\\-_]*(?<!\\.)$") %) :gen #(gen/string)))

(s/def :cognitect.aws.cognito-idp/AccountTakeoverActionNotifyType boolean?)

(s/def
  :cognitect.aws.cognito-idp/PasswordType
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AdminListDevicesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminListDevicesResponse/PaginationToken
     :cognitect.aws.cognito-idp.AdminListDevicesResponse/Devices]))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ResourceServerType/UserPoolId
     :cognitect.aws.cognito-idp.ResourceServerType/Scopes
     :cognitect.aws.cognito-idp.ResourceServerType/Name
     :cognitect.aws.cognito-idp.ResourceServerType/Identifier]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolAddOnsType
  (s/keys :req-un [:cognitect.aws.cognito-idp.UserPoolAddOnsType/AdvancedSecurityMode]))

(s/def
  :cognitect.aws.cognito-idp/DeleteUserPoolDomainRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteUserPoolDomainRequest/Domain
     :cognitect.aws.cognito-idp.DeleteUserPoolDomainRequest/UserPoolId]))

(s/def :cognitect.aws.cognito-idp/DeviceListType (s/coll-of :cognitect.aws.cognito-idp/DeviceType))

(s/def
  :cognitect.aws.cognito-idp/ListDevicesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListDevicesResponse/PaginationToken
     :cognitect.aws.cognito-idp.ListDevicesResponse/Devices]))

(s/def
  :cognitect.aws.cognito-idp/RiskConfigurationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.RiskConfigurationType/AccountTakeoverRiskConfiguration
     :cognitect.aws.cognito-idp.RiskConfigurationType/LastModifiedDate
     :cognitect.aws.cognito-idp.RiskConfigurationType/UserPoolId
     :cognitect.aws.cognito-idp.RiskConfigurationType/CompromisedCredentialsRiskConfiguration
     :cognitect.aws.cognito-idp.RiskConfigurationType/RiskExceptionConfiguration
     :cognitect.aws.cognito-idp.RiskConfigurationType/ClientId]))

(s/def :cognitect.aws.cognito-idp/DeleteUserAttributesResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/SchemaAttributeType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.SchemaAttributeType/AttributeDataType
     :cognitect.aws.cognito-idp.SchemaAttributeType/StringAttributeConstraints
     :cognitect.aws.cognito-idp.SchemaAttributeType/Mutable
     :cognitect.aws.cognito-idp.SchemaAttributeType/NumberAttributeConstraints
     :cognitect.aws.cognito-idp.SchemaAttributeType/DeveloperOnlyAttribute
     :cognitect.aws.cognito-idp.SchemaAttributeType/Required
     :cognitect.aws.cognito-idp.SchemaAttributeType/Name]))

(s/def
  :cognitect.aws.cognito-idp/AdminEnableUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminEnableUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminEnableUserRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/AdminCreateUserResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.AdminCreateUserResponse/User]))

(s/def
  :cognitect.aws.cognito-idp/UserImportJobStatusType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"Created" "Failed" "Succeeded" "Expired" "InProgress" "Stopping" "Stopped" "Pending"})))

(s/def
  :cognitect.aws.cognito-idp/ListResourceServersRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListResourceServersRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.ListResourceServersRequest/NextToken
     :cognitect.aws.cognito-idp.ListResourceServersRequest/MaxResults]))

(s/def
  :cognitect.aws.cognito-idp/SetUserMFAPreferenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/AccessToken]
    :opt-un
    [:cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/SoftwareTokenMfaSettings
     :cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/SMSMfaSettings]))

(s/def
  :cognitect.aws.cognito-idp/DeleteUserPoolRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.DeleteUserPoolRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserPoolClientRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/UserPoolId
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ClientId]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthFlowsUserPoolClient
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/RefreshTokenValidity
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ReadAttributes
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/DefaultRedirectURI
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AccessTokenValidity
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthFlows
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/LogoutURLs
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ClientName
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/PreventUserExistenceErrors
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/SupportedIdentityProviders
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/TokenValidityUnits
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/CallbackURLs
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthScopes
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/IdTokenValidity
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/WriteAttributes
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ExplicitAuthFlows
     :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AnalyticsConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/DeleteUserPoolClientRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.DeleteUserPoolClientRequest/UserPoolId
     :cognitect.aws.cognito-idp.DeleteUserPoolClientRequest/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/DeviceKeyType
  (s/spec #(re-matches (re-pattern "[\\w-]+_[0-9a-f-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ListResourceServersLimitType
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def :cognitect.aws.cognito-idp/UpdateUserPoolResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/NewDeviceMetadataType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.NewDeviceMetadataType/DeviceKey
     :cognitect.aws.cognito-idp.NewDeviceMetadataType/DeviceGroupKey]))

(s/def
  :cognitect.aws.cognito-idp/AdminInitiateAuthResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminInitiateAuthResponse/AuthenticationResult
     :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/ChallengeName
     :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/Session
     :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/ChallengeParameters]))

(s/def
  :cognitect.aws.cognito-idp/AdminGetDeviceResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.AdminGetDeviceResponse/Device]))

(s/def
  :cognitect.aws.cognito-idp/AttributeNameListType
  (s/coll-of :cognitect.aws.cognito-idp/AttributeNameType))

(s/def
  :cognitect.aws.cognito-idp/GetUserAttributeVerificationCodeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeResponse/CodeDeliveryDetails]))

(s/def
  :cognitect.aws.cognito-idp/SearchPaginationTokenType
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AccountTakeoverEventActionType
  (s/spec string? :gen #(s/gen #{"NO_ACTION" "BLOCK" "MFA_REQUIRED" "MFA_IF_CONFIGURED"})))

(s/def
  :cognitect.aws.cognito-idp/RespondToAuthChallengeRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ClientId
     :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ChallengeName]
    :opt-un
    [:cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/UserContextData
     :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ClientMetadata
     :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ChallengeResponses
     :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/AnalyticsMetadata
     :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/Session]))

(s/def
  :cognitect.aws.cognito-idp/AttributeMappingType
  (s/map-of
    :cognitect.aws.cognito-idp/AttributeMappingKeyType
    :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/GetUserRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetUserRequest/AccessToken]))

(s/def
  :cognitect.aws.cognito-idp/RedirectUrlType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/EmailVerificationMessageByLinkType
  (s/spec
    #(re-matches
      (re-pattern
        "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]*\\{##[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]*##\\}[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UntagResourceRequest/ResourceArn
     :cognitect.aws.cognito-idp.UntagResourceRequest/TagKeys]))

(s/def
  :cognitect.aws.cognito-idp/UpdateUserAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateUserAttributesRequest/UserAttributes
     :cognitect.aws.cognito-idp.UpdateUserAttributesRequest/AccessToken]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateUserAttributesRequest/ClientMetadata]))

(s/def
  :cognitect.aws.cognito-idp/SearchedAttributeNamesListType
  (s/coll-of :cognitect.aws.cognito-idp/AttributeNameType))

(s/def
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.CodeDeliveryDetailsType/AttributeName
     :cognitect.aws.cognito-idp.CodeDeliveryDetailsType/Destination
     :cognitect.aws.cognito-idp.CodeDeliveryDetailsType/DeliveryMedium]))

(s/def
  :cognitect.aws.cognito-idp/CustomSMSLambdaVersionConfigType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CustomSMSLambdaVersionConfigType/LambdaVersion
     :cognitect.aws.cognito-idp.CustomSMSLambdaVersionConfigType/LambdaArn]))

(s/def
  :cognitect.aws.cognito-idp/TagValueType
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/UserPoolMfaType
  (s/spec string? :gen #(s/gen #{"OPTIONAL" "ON" "OFF"})))

(s/def
  :cognitect.aws.cognito-idp/ChallengeResponseListType
  (s/coll-of :cognitect.aws.cognito-idp/ChallengeResponseType))

(s/def
  :cognitect.aws.cognito-idp/AssociateSoftwareTokenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AssociateSoftwareTokenResponse/SecretCode
     :cognitect.aws.cognito-idp.AssociateSoftwareTokenResponse/Session]))

(s/def
  :cognitect.aws.cognito-idp/AnalyticsMetadataType
  (s/keys :opt-un [:cognitect.aws.cognito-idp.AnalyticsMetadataType/AnalyticsEndpointId]))

(s/def :cognitect.aws.cognito-idp/ChallengeName (s/spec string? :gen #(s/gen #{"Mfa" "Password"})))

(s/def
  :cognitect.aws.cognito-idp/ClientNameType
  (s/spec #(re-matches (re-pattern "[\\w\\s+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ListDevicesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListDevicesRequest/AccessToken]
    :opt-un
    [:cognitect.aws.cognito-idp.ListDevicesRequest/PaginationToken
     :cognitect.aws.cognito-idp.ListDevicesRequest/Limit]))

(s/def
  :cognitect.aws.cognito-idp/CallbackURLsListType
  (s/coll-of :cognitect.aws.cognito-idp/RedirectUrlType :min-count 0 :max-count 100))

(s/def
  :cognitect.aws.cognito-idp/AdminUserGlobalSignOutRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminUserGlobalSignOutRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminUserGlobalSignOutRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/SetUserPoolMfaConfigResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/MfaConfiguration
     :cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/SmsMfaConfiguration
     :cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/SoftwareTokenMfaConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserPoolClientResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.DescribeUserPoolClientResponse/UserPoolClient]))

(s/def
  :cognitect.aws.cognito-idp/TagKeysType
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/HttpHeader
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.HttpHeader/headerValue
     :cognitect.aws.cognito-idp.HttpHeader/headerName]))

(s/def
  :cognitect.aws.cognito-idp/UpdateIdentityProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/UserPoolId
     :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/ProviderName]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/AttributeMapping
     :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/IdpIdentifiers
     :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/ProviderDetails]))

(s/def
  :cognitect.aws.cognito-idp/AdminGetDeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminGetDeviceRequest/DeviceKey
     :cognitect.aws.cognito-idp.AdminGetDeviceRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminGetDeviceRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/SetUserSettingsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SetUserSettingsRequest/AccessToken
     :cognitect.aws.cognito-idp.SetUserSettingsRequest/MFAOptions]))

(s/def
  :cognitect.aws.cognito-idp/UpdateResourceServerResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.UpdateResourceServerResponse/ResourceServer]))

(s/def
  :cognitect.aws.cognito-idp/RefreshTokenValidityType
  (s/spec (s/and int? #(<= 0 % 315360000)) :gen #(gen/choose 0 315360000)))

(s/def
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/EmailNotificationSubjectType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/VerifyUserAttributeRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.VerifyUserAttributeRequest/AccessToken
     :cognitect.aws.cognito-idp.VerifyUserAttributeRequest/AttributeName
     :cognitect.aws.cognito-idp.VerifyUserAttributeRequest/Code]))

(s/def
  :cognitect.aws.cognito-idp/AttributeMappingKeyType
  (s/spec
    (s/and string? #(<= 1 (count %) 32))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 32) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/ChallengeParametersType
  (s/map-of :cognitect.aws.cognito-idp/StringType :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/ListUserPoolClientsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListUserPoolClientsRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserPoolClientsRequest/NextToken
     :cognitect.aws.cognito-idp.ListUserPoolClientsRequest/MaxResults]))

(s/def
  :cognitect.aws.cognito-idp/PaginationKey
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/GetUserPoolMfaConfigRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetUserPoolMfaConfigRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/AdminDeleteUserAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/Username
     :cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/UserAttributeNames]))

(s/def
  :cognitect.aws.cognito-idp/TokenValidityUnitsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.TokenValidityUnitsType/AccessToken
     :cognitect.aws.cognito-idp.TokenValidityUnitsType/RefreshToken
     :cognitect.aws.cognito-idp.TokenValidityUnitsType/IdToken]))

(s/def
  :cognitect.aws.cognito-idp/ChallengeResponse
  (s/spec string? :gen #(s/gen #{"Success" "Failure"})))

(s/def
  :cognitect.aws.cognito-idp/CreateIdentityProviderResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.CreateIdentityProviderResponse/IdentityProvider]))

(s/def
  :cognitect.aws.cognito-idp/AdminUpdateDeviceStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/Username
     :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/DeviceKey]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/DeviceRememberedStatus]))

(s/def
  :cognitect.aws.cognito-idp/CompromisedCredentialsRiskConfigurationType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CompromisedCredentialsRiskConfigurationType/Actions]
    :opt-un
    [:cognitect.aws.cognito-idp.CompromisedCredentialsRiskConfigurationType/EventFilter]))

(s/def
  :cognitect.aws.cognito-idp/VerificationMessageTemplateType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailSubjectByLink
     :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailMessageByLink
     :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailSubject
     :cognitect.aws.cognito-idp.VerificationMessageTemplateType/DefaultEmailOption
     :cognitect.aws.cognito-idp.VerificationMessageTemplateType/SmsMessage
     :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailMessage]))

(s/def
  :cognitect.aws.cognito-idp/DeviceNameType
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/AliasAttributesListType
  (s/coll-of :cognitect.aws.cognito-idp/AliasAttributeType))

(s/def
  :cognitect.aws.cognito-idp/UserContextDataType
  (s/keys :opt-un [:cognitect.aws.cognito-idp.UserContextDataType/EncodedData]))

(s/def
  :cognitect.aws.cognito-idp/ListUsersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.ListUsersResponse/PaginationToken
     :cognitect.aws.cognito-idp.ListUsersResponse/Users]))

(s/def
  :cognitect.aws.cognito-idp/AdminDeleteUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminDeleteUserRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminDeleteUserRequest/Username]))

(s/def
  :cognitect.aws.cognito-idp/AdminCreateUserUnusedAccountValidityDaysType
  (s/spec (s/and int? #(<= 0 % 365)) :gen #(gen/choose 0 365)))

(s/def
  :cognitect.aws.cognito-idp/GetUICustomizationResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetUICustomizationResponse/UICustomization]))

(s/def
  :cognitect.aws.cognito-idp/HexStringType
  (s/spec #(re-matches (re-pattern "^[0-9a-fA-F]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/DeviceRememberedStatusType
  (s/spec string? :gen #(s/gen #{"not_remembered" "remembered"})))

(s/def :cognitect.aws.cognito-idp/SetUserSettingsResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/DescribeUserImportJobResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.DescribeUserImportJobResponse/UserImportJob]))

(s/def
  :cognitect.aws.cognito-idp/ListUsersRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListUsersRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.ListUsersRequest/Filter
     :cognitect.aws.cognito-idp.ListUsersRequest/PaginationToken
     :cognitect.aws.cognito-idp.ListUsersRequest/AttributesToGet
     :cognitect.aws.cognito-idp.ListUsersRequest/Limit]))

(s/def
  :cognitect.aws.cognito-idp/AdminRemoveUserFromGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/Username
     :cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/GroupName]))

(s/def
  :cognitect.aws.cognito-idp/EmailVerificationMessageType
  (s/spec
    #(re-matches
      (re-pattern
        "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]*\\{####\\}[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\s*]*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/AdminSetUserPasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Username
     :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Password]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Permanent]))

(s/def
  :cognitect.aws.cognito-idp/SetRiskConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.SetRiskConfigurationRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.SetRiskConfigurationRequest/AccountTakeoverRiskConfiguration
     :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/CompromisedCredentialsRiskConfiguration
     :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/RiskExceptionConfiguration
     :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/ClientId]))

(s/def
  :cognitect.aws.cognito-idp/ResourceServerScopeListType
  (s/coll-of :cognitect.aws.cognito-idp/ResourceServerScopeType :max-count 100))

(s/def
  :cognitect.aws.cognito-idp/CreateIdentityProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateIdentityProviderRequest/UserPoolId
     :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderName
     :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderType
     :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderDetails]
    :opt-un
    [:cognitect.aws.cognito-idp.CreateIdentityProviderRequest/AttributeMapping
     :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/IdpIdentifiers]))

(s/def
  :cognitect.aws.cognito-idp/AdminSetUserMFAPreferenceRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/Username
     :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/UserPoolId]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/SoftwareTokenMfaSettings
     :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/SMSMfaSettings]))

(s/def
  :cognitect.aws.cognito-idp/StringAttributeConstraintsType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.StringAttributeConstraintsType/MinLength
     :cognitect.aws.cognito-idp.StringAttributeConstraintsType/MaxLength]))

(s/def
  :cognitect.aws.cognito-idp/OAuthFlowType
  (s/spec string? :gen #(s/gen #{"implicit" "client_credentials" "code"})))

(s/def
  :cognitect.aws.cognito-idp/CustomEmailSenderLambdaVersionType
  (s/spec string? :gen #(s/gen #{"V1_0"})))

(s/def
  :cognitect.aws.cognito-idp/CustomAttributeNameType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/PriorityType
  (s/spec (s/and int? #(<= 1 % 2)) :gen #(gen/choose 1 2)))

(s/def
  :cognitect.aws.cognito-idp/UserStatusType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"UNKNOWN" "ARCHIVED" "FORCE_CHANGE_PASSWORD" "COMPROMISED" "RESET_REQUIRED" "UNCONFIRMED"
        "CONFIRMED"})))

(s/def
  :cognitect.aws.cognito-idp/AdminCreateUserConfigType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AdminCreateUserConfigType/UnusedAccountValidityDays
     :cognitect.aws.cognito-idp.AdminCreateUserConfigType/InviteMessageTemplate
     :cognitect.aws.cognito-idp.AdminCreateUserConfigType/AllowAdminCreateUserOnly]))

(s/def
  :cognitect.aws.cognito-idp/AuthenticationResultType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.AuthenticationResultType/AccessToken
     :cognitect.aws.cognito-idp.AuthenticationResultType/TokenType
     :cognitect.aws.cognito-idp.AuthenticationResultType/RefreshToken
     :cognitect.aws.cognito-idp.AuthenticationResultType/NewDeviceMetadata
     :cognitect.aws.cognito-idp.AuthenticationResultType/IdToken
     :cognitect.aws.cognito-idp.AuthenticationResultType/ExpiresIn]))

(s/def :cognitect.aws.cognito-idp/AWSAccountIdType string?)

(s/def
  :cognitect.aws.cognito-idp/UpdateDeviceStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/AccessToken
     :cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/DeviceKey]
    :opt-un
    [:cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/DeviceRememberedStatus]))

(s/def :cognitect.aws.cognito-idp/AdminDisableUserResponse (s/keys))

(s/def
  :cognitect.aws.cognito-idp/InitiateAuthRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.InitiateAuthRequest/AuthFlow
     :cognitect.aws.cognito-idp.InitiateAuthRequest/ClientId]
    :opt-un
    [:cognitect.aws.cognito-idp.InitiateAuthRequest/UserContextData
     :cognitect.aws.cognito-idp.InitiateAuthRequest/ClientMetadata
     :cognitect.aws.cognito-idp.InitiateAuthRequest/AnalyticsMetadata
     :cognitect.aws.cognito-idp.InitiateAuthRequest/AuthParameters]))

(s/def
  :cognitect.aws.cognito-idp/DeviceConfigurationType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.DeviceConfigurationType/DeviceOnlyRememberedOnUserPrompt
     :cognitect.aws.cognito-idp.DeviceConfigurationType/ChallengeRequiredOnNewDevice]))

(s/def
  :cognitect.aws.cognito-idp/ContextDataType
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ContextDataType/IpAddress
     :cognitect.aws.cognito-idp.ContextDataType/ServerName
     :cognitect.aws.cognito-idp.ContextDataType/ServerPath
     :cognitect.aws.cognito-idp.ContextDataType/HttpHeaders]
    :opt-un
    [:cognitect.aws.cognito-idp.ContextDataType/EncodedData]))

(s/def
  :cognitect.aws.cognito-idp/UserPoolPolicyType
  (s/keys :opt-un [:cognitect.aws.cognito-idp.UserPoolPolicyType/PasswordPolicy]))

(s/def
  :cognitect.aws.cognito-idp/SoftwareTokenMFAUserCodeType
  (s/spec #(re-matches (re-pattern "[0-9]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/SetRiskConfigurationResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.SetRiskConfigurationResponse/RiskConfiguration]))

(s/def
  :cognitect.aws.cognito-idp/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.ListTagsForResourceResponse/Tags]))

(s/def
  :cognitect.aws.cognito-idp/AdminConfirmSignUpRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/UserPoolId
     :cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/Username]
    :opt-un
    [:cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/ClientMetadata]))

(s/def
  :cognitect.aws.cognito-idp/UserImportJobsListType
  (s/coll-of :cognitect.aws.cognito-idp/UserImportJobType :min-count 1 :max-count 50))

(s/def
  :cognitect.aws.cognito-idp/AccountRecoverySettingType
  (s/keys :opt-un [:cognitect.aws.cognito-idp.AccountRecoverySettingType/RecoveryMechanisms]))

(s/def
  :cognitect.aws.cognito-idp/SetUICustomizationResponse
  (s/keys :req-un [:cognitect.aws.cognito-idp.SetUICustomizationResponse/UICustomization]))

(s/def :cognitect.aws.cognito-idp/StatusType (s/spec string? :gen #(s/gen #{"Disabled" "Enabled"})))

(s/def
  :cognitect.aws.cognito-idp/CustomAttributesListType
  (s/coll-of :cognitect.aws.cognito-idp/SchemaAttributeType :min-count 1 :max-count 25))

(s/def
  :cognitect.aws.cognito-idp/DeliveryMediumListType
  (s/coll-of :cognitect.aws.cognito-idp/DeliveryMediumType))

(s/def
  :cognitect.aws.cognito-idp/MFAOptionType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.MFAOptionType/AttributeName
     :cognitect.aws.cognito-idp.MFAOptionType/DeliveryMedium]))

(s/def
  :cognitect.aws.cognito-idp/StopUserImportJobResponse
  (s/keys :opt-un [:cognitect.aws.cognito-idp.StopUserImportJobResponse/UserImportJob]))

(s/def
  :cognitect.aws.cognito-idp/VerifiedAttributesListType
  (s/coll-of :cognitect.aws.cognito-idp/VerifiedAttributeType))

(s/def
  :cognitect.aws.cognito-idp/CreateUserImportJobRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.CreateUserImportJobRequest/JobName
     :cognitect.aws.cognito-idp.CreateUserImportJobRequest/UserPoolId
     :cognitect.aws.cognito-idp.CreateUserImportJobRequest/CloudWatchLogsRoleArn]))

(s/def :cognitect.aws.cognito-idp/WrappedBooleanType boolean?)

(s/def
  :cognitect.aws.cognito-idp/ExplicitAuthFlowsListType
  (s/coll-of :cognitect.aws.cognito-idp/ExplicitAuthFlowsType))

(s/def
  :cognitect.aws.cognito-idp/GlobalSignOutRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.GlobalSignOutRequest/AccessToken]))

(s/def
  :cognitect.aws.cognito-idp/SmsMfaConfigType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.SmsMfaConfigType/SmsConfiguration
     :cognitect.aws.cognito-idp.SmsMfaConfigType/SmsAuthenticationMessage]))

(s/def
  :cognitect.aws.cognito-idp/ProviderDetailsType
  (s/map-of :cognitect.aws.cognito-idp/StringType :cognitect.aws.cognito-idp/StringType))

(s/def
  :cognitect.aws.cognito-idp/EventFiltersType
  (s/coll-of :cognitect.aws.cognito-idp/EventFilterType))

(s/def
  :cognitect.aws.cognito-idp/LambdaConfigType
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.LambdaConfigType/PreSignUp
     :cognitect.aws.cognito-idp.LambdaConfigType/PreTokenGeneration
     :cognitect.aws.cognito-idp.LambdaConfigType/PreAuthentication
     :cognitect.aws.cognito-idp.LambdaConfigType/CustomSMSSender
     :cognitect.aws.cognito-idp.LambdaConfigType/CreateAuthChallenge
     :cognitect.aws.cognito-idp.LambdaConfigType/VerifyAuthChallengeResponse
     :cognitect.aws.cognito-idp.LambdaConfigType/PostAuthentication
     :cognitect.aws.cognito-idp.LambdaConfigType/KMSKeyID
     :cognitect.aws.cognito-idp.LambdaConfigType/CustomMessage
     :cognitect.aws.cognito-idp.LambdaConfigType/PostConfirmation
     :cognitect.aws.cognito-idp.LambdaConfigType/DefineAuthChallenge
     :cognitect.aws.cognito-idp.LambdaConfigType/CustomEmailSender
     :cognitect.aws.cognito-idp.LambdaConfigType/UserMigration]))

(s/def
  :cognitect.aws.cognito-idp/RespondToAuthChallengeResponse
  (s/keys
    :opt-un
    [:cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/AuthenticationResult
     :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/ChallengeName
     :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/Session
     :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/ChallengeParameters]))

(s/def
  :cognitect.aws.cognito-idp/DescriptionType
  (s/spec
    (s/and string? #(>= 2048 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.cognito-idp/ScopeListType
  (s/coll-of :cognitect.aws.cognito-idp/ScopeType :max-count 50))

(s/def
  :cognitect.aws.cognito-idp/ListUserImportJobsRequest
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.ListUserImportJobsRequest/UserPoolId
     :cognitect.aws.cognito-idp.ListUserImportJobsRequest/MaxResults]
    :opt-un
    [:cognitect.aws.cognito-idp.ListUserImportJobsRequest/PaginationToken]))

(s/def
  :cognitect.aws.cognito-idp/GetIdentityProviderByIdentifierResponse
  (s/keys
    :req-un
    [:cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierResponse/IdentityProvider]))

(s/def
  :cognitect.aws.cognito-idp/GetCSVHeaderRequest
  (s/keys :req-un [:cognitect.aws.cognito-idp.GetCSVHeaderRequest/UserPoolId]))

(s/def
  :cognitect.aws.cognito-idp/SkippedIPRangeListType
  (s/coll-of :cognitect.aws.cognito-idp/StringType :max-count 20))

(s/def
  :cognitect.aws.cognito-idp/EventResponseType
  (s/spec string? :gen #(s/gen #{"Success" "Failure"})))

(s/def
  :cognitect.aws.cognito-idp/PaginationKeyType
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/DefaultEmailOptionType
  (s/spec string? :gen #(s/gen #{"CONFIRM_WITH_CODE" "CONFIRM_WITH_LINK"})))

(s/def
  :cognitect.aws.cognito-idp/ConfirmationCodeType
  (s/spec #(re-matches (re-pattern "[\\S]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.cognito-idp/ResourceServersListType
  (s/coll-of :cognitect.aws.cognito-idp/ResourceServerType))

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/MaxResults
  :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolDomainRequest/Domain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserSettingsRequest/MFAOptions
  :cognitect.aws.cognito-idp/MFAOptionListType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolClientsResponse/UserPoolClients
  :cognitect.aws.cognito-idp/UserPoolClientListType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolClientsResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.UpdateResourceServerRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateResourceServerRequest/Identifier
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.UpdateResourceServerRequest/Name
  :cognitect.aws.cognito-idp/ResourceServerNameType)

(s/def
  :cognitect.aws.cognito-idp.UpdateResourceServerRequest/Scopes
  :cognitect.aws.cognito-idp/ResourceServerScopeListType)

(s/def
  :cognitect.aws.cognito-idp.NumberAttributeConstraintsType/MinValue
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.NumberAttributeConstraintsType/MaxValue
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/ProviderType
  :cognitect.aws.cognito-idp/IdentityProviderTypeType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/ProviderDetails
  :cognitect.aws.cognito-idp/ProviderDetailsType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/AttributeMapping
  :cognitect.aws.cognito-idp/AttributeMappingType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/IdpIdentifiers
  :cognitect.aws.cognito-idp/IdpIdentifiersListType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.IdentityProviderType/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.SoftwareTokenMfaConfigType/Enabled
  :cognitect.aws.cognito-idp/BooleanType)

(s/def :cognitect.aws.cognito-idp.TagResourceRequest/ResourceArn :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.TagResourceRequest/Tags
  :cognitect.aws.cognito-idp/UserPoolTagsType)

(s/def
  :cognitect.aws.cognito-idp.GetCSVHeaderResponse/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.GetCSVHeaderResponse/CSVHeader
  :cognitect.aws.cognito-idp/ListOfStringTypes)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateUserAttributesRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ForgetDeviceRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.ForgetDeviceRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def :cognitect.aws.cognito-idp.AuthEventType/EventId :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.AuthEventType/EventType :cognitect.aws.cognito-idp/EventType)

(s/def :cognitect.aws.cognito-idp.AuthEventType/CreationDate :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.AuthEventType/EventResponse
  :cognitect.aws.cognito-idp/EventResponseType)

(s/def :cognitect.aws.cognito-idp.AuthEventType/EventRisk :cognitect.aws.cognito-idp/EventRiskType)

(s/def
  :cognitect.aws.cognito-idp.AuthEventType/ChallengeResponses
  :cognitect.aws.cognito-idp/ChallengeResponseListType)

(s/def
  :cognitect.aws.cognito-idp.AuthEventType/EventContextData
  :cognitect.aws.cognito-idp/EventContextDataType)

(s/def
  :cognitect.aws.cognito-idp.AuthEventType/EventFeedback
  :cognitect.aws.cognito-idp/EventFeedbackType)

(s/def
  :cognitect.aws.cognito-idp.AssociateSoftwareTokenRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AssociateSoftwareTokenRequest/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/Domain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolDomainRequest/CustomDomainConfig
  :cognitect.aws.cognito-idp/CustomDomainConfigType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerScopeType/ScopeName
  :cognitect.aws.cognito-idp/ResourceServerScopeNameType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerScopeType/ScopeDescription
  :cognitect.aws.cognito-idp/ResourceServerScopeDescriptionType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolsResponse/UserPools
  :cognitect.aws.cognito-idp/UserPoolListType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolsResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.ListGroupsResponse/Groups
  :cognitect.aws.cognito-idp/GroupListType)

(s/def
  :cognitect.aws.cognito-idp.ListGroupsResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def :cognitect.aws.cognito-idp.AttributeType/Name :cognitect.aws.cognito-idp/AttributeNameType)

(s/def :cognitect.aws.cognito-idp.AttributeType/Value :cognitect.aws.cognito-idp/AttributeValueType)

(s/def
  :cognitect.aws.cognito-idp.DeleteIdentityProviderRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DeleteIdentityProviderRequest/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/EventId
  :cognitect.aws.cognito-idp/EventIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateAuthEventFeedbackRequest/FeedbackValue
  :cognitect.aws.cognito-idp/FeedbackValueType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/LogoutURLs
  :cognitect.aws.cognito-idp/LogoutURLsListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/ClientName
  :cognitect.aws.cognito-idp/ClientNameType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/DefaultRedirectURI
  :cognitect.aws.cognito-idp/RedirectUrlType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/TokenValidityUnits
  :cognitect.aws.cognito-idp/TokenValidityUnitsType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthScopes
  :cognitect.aws.cognito-idp/ScopeListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthFlows
  :cognitect.aws.cognito-idp/OAuthFlowsType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/AllowedOAuthFlowsUserPoolClient
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/AccessTokenValidity
  :cognitect.aws.cognito-idp/AccessTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/SupportedIdentityProviders
  :cognitect.aws.cognito-idp/SupportedIdentityProvidersListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/ReadAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/RefreshTokenValidity
  :cognitect.aws.cognito-idp/RefreshTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/PreventUserExistenceErrors
  :cognitect.aws.cognito-idp/PreventUserExistenceErrorTypes)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/CallbackURLs
  :cognitect.aws.cognito-idp/CallbackURLsListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/ClientSecret
  :cognitect.aws.cognito-idp/ClientSecretType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/WriteAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/ExplicitAuthFlows
  :cognitect.aws.cognito-idp/ExplicitAuthFlowsListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/IdTokenValidity
  :cognitect.aws.cognito-idp/IdTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/AnalyticsConfiguration
  :cognitect.aws.cognito-idp/AnalyticsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientType/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.SoftwareTokenMfaSettingsType/Enabled
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SoftwareTokenMfaSettingsType/PreferredMfa
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.CompromisedCredentialsActionsType/EventAction
  :cognitect.aws.cognito-idp/CompromisedCredentialsEventActionType)

(s/def
  :cognitect.aws.cognito-idp.DescribeIdentityProviderResponse/IdentityProvider
  :cognitect.aws.cognito-idp/IdentityProviderType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsConfiguration
  :cognitect.aws.cognito-idp/SmsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/Policies
  :cognitect.aws.cognito-idp/UserPoolPolicyType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolTags
  :cognitect.aws.cognito-idp/UserPoolTagsType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AccountRecoverySetting
  :cognitect.aws.cognito-idp/AccountRecoverySettingType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailVerificationSubject
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailConfiguration
  :cognitect.aws.cognito-idp/EmailConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsVerificationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AutoVerifiedAttributes
  :cognitect.aws.cognito-idp/VerifiedAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/DeviceConfiguration
  :cognitect.aws.cognito-idp/DeviceConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/EmailVerificationMessage
  :cognitect.aws.cognito-idp/EmailVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/SmsAuthenticationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/LambdaConfig
  :cognitect.aws.cognito-idp/LambdaConfigType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/VerificationMessageTemplate
  :cognitect.aws.cognito-idp/VerificationMessageTemplateType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/AdminCreateUserConfig
  :cognitect.aws.cognito-idp/AdminCreateUserConfigType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolRequest/UserPoolAddOns
  :cognitect.aws.cognito-idp/UserPoolAddOnsType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserAttributesResponse/CodeDeliveryDetailsList
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsListType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolResponse/UserPool
  :cognitect.aws.cognito-idp/UserPoolType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/MinimumLength
  :cognitect.aws.cognito-idp/PasswordPolicyMinLengthType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/RequireUppercase
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/RequireLowercase
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/RequireNumbers
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/RequireSymbols
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.PasswordPolicyType/TemporaryPasswordValidityDays
  :cognitect.aws.cognito-idp/TemporaryPasswordValidityDaysType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientResponse/UserPoolClient
  :cognitect.aws.cognito-idp/UserPoolClientType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/SmsMfaConfiguration
  :cognitect.aws.cognito-idp/SmsMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/SoftwareTokenMfaConfiguration
  :cognitect.aws.cognito-idp/SoftwareTokenMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigRequest/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/JobName
  :cognitect.aws.cognito-idp/UserImportJobNameType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/SkippedUsers
  :cognitect.aws.cognito-idp/LongType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/CompletionDate
  :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserImportJobType/StartDate :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/JobId
  :cognitect.aws.cognito-idp/UserImportJobIdType)

(s/def :cognitect.aws.cognito-idp.UserImportJobType/FailedUsers :cognitect.aws.cognito-idp/LongType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/ImportedUsers
  :cognitect.aws.cognito-idp/LongType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/CloudWatchLogsRoleArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/CompletionMessage
  :cognitect.aws.cognito-idp/CompletionMessageType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/Status
  :cognitect.aws.cognito-idp/UserImportJobStatusType)

(s/def
  :cognitect.aws.cognito-idp.UserImportJobType/PreSignedUrl
  :cognitect.aws.cognito-idp/PreSignedUrlType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/SecretHash
  :cognitect.aws.cognito-idp/SecretHashType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ConfirmationCode
  :cognitect.aws.cognito-idp/ConfirmationCodeType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ForceAliasCreation
  :cognitect.aws.cognito-idp/ForceAliasCreation)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmSignUpRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.RecoveryOptionType/Priority
  :cognitect.aws.cognito-idp/PriorityType)

(s/def
  :cognitect.aws.cognito-idp.RecoveryOptionType/Name
  :cognitect.aws.cognito-idp/RecoveryOptionNameType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CustomDomainConfigType/CertificateArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.DeleteGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.DeleteGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.EventRiskType/RiskDecision
  :cognitect.aws.cognito-idp/RiskDecisionType)

(s/def :cognitect.aws.cognito-idp.EventRiskType/RiskLevel :cognitect.aws.cognito-idp/RiskLevelType)

(s/def
  :cognitect.aws.cognito-idp.EventRiskType/CompromisedCredentialsDetected
  :cognitect.aws.cognito-idp/WrappedBooleanType)

(s/def
  :cognitect.aws.cognito-idp.StartUserImportJobResponse/UserImportJob
  :cognitect.aws.cognito-idp/UserImportJobType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeResponse/CodeDeliveryDetails
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsType)

(s/def
  :cognitect.aws.cognito-idp.DescribeRiskConfigurationRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DescribeRiskConfigurationRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/SecretHash
  :cognitect.aws.cognito-idp/SecretHashType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def :cognitect.aws.cognito-idp.UpdateGroupResponse/Group :cognitect.aws.cognito-idp/GroupType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/UserCode
  :cognitect.aws.cognito-idp/SoftwareTokenMFAUserCodeType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenRequest/FriendlyDeviceName
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserAttributesRequest/UserAttributeNames
  :cognitect.aws.cognito-idp/AttributeNameListType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserAttributesRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def :cognitect.aws.cognito-idp.DeviceType/DeviceKey :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.DeviceType/DeviceAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def :cognitect.aws.cognito-idp.DeviceType/DeviceCreateDate :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.DeviceType/DeviceLastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.DeviceType/DeviceLastAuthenticatedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/LastModifiedDate :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/Domain :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/SmsConfiguration
  :cognitect.aws.cognito-idp/SmsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/EmailConfigurationFailure
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/CustomDomain :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/SmsConfigurationFailure
  :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/Id :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/Policies
  :cognitect.aws.cognito-idp/UserPoolPolicyType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/UserPoolTags
  :cognitect.aws.cognito-idp/UserPoolTagsType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/AccountRecoverySetting
  :cognitect.aws.cognito-idp/AccountRecoverySettingType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/EmailVerificationSubject
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/UsernameConfiguration
  :cognitect.aws.cognito-idp/UsernameConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/EmailConfiguration
  :cognitect.aws.cognito-idp/EmailConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/UsernameAttributes
  :cognitect.aws.cognito-idp/UsernameAttributesListType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/Arn :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/SmsVerificationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/AutoVerifiedAttributes
  :cognitect.aws.cognito-idp/VerifiedAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/DeviceConfiguration
  :cognitect.aws.cognito-idp/DeviceConfigurationType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/Name :cognitect.aws.cognito-idp/UserPoolNameType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/EmailVerificationMessage
  :cognitect.aws.cognito-idp/EmailVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/AliasAttributes
  :cognitect.aws.cognito-idp/AliasAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/SmsAuthenticationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/LambdaConfig
  :cognitect.aws.cognito-idp/LambdaConfigType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/VerificationMessageTemplate
  :cognitect.aws.cognito-idp/VerificationMessageTemplateType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/SchemaAttributes
  :cognitect.aws.cognito-idp/SchemaAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/AdminCreateUserConfig
  :cognitect.aws.cognito-idp/AdminCreateUserConfigType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/EstimatedNumberOfUsers
  :cognitect.aws.cognito-idp/IntegerType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolType/UserPoolAddOns
  :cognitect.aws.cognito-idp/UserPoolAddOnsType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/CreationDate :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserPoolType/Status :cognitect.aws.cognito-idp/StatusType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupResponse/Users
  :cognitect.aws.cognito-idp/UsersListType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.CreateUserImportJobResponse/UserImportJob
  :cognitect.aws.cognito-idp/UserImportJobType)

(s/def
  :cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/AttributeName
  :cognitect.aws.cognito-idp/AttributeNameType)

(s/def
  :cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def :cognitect.aws.cognito-idp.GetUserResponse/Username :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.GetUserResponse/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.GetUserResponse/MFAOptions
  :cognitect.aws.cognito-idp/MFAOptionListType)

(s/def
  :cognitect.aws.cognito-idp.GetUserResponse/PreferredMfaSetting
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.GetUserResponse/UserMFASettingList
  :cognitect.aws.cognito-idp/UserMFASettingListType)

(s/def
  :cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderAttributeName
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.ProviderUserIdentifierType/ProviderAttributeValue
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EventContextDataType/IpAddress
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EventContextDataType/DeviceName
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EventContextDataType/Timezone
  :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.EventContextDataType/City :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EventContextDataType/Country
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderResponse/IdentityProvider
  :cognitect.aws.cognito-idp/IdentityProviderType)

(s/def
  :cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminAddUserToGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolDomainResponse/CloudFrontDomain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenResponse/Status
  :cognitect.aws.cognito-idp/VerifySoftwareTokenResponseType)

(s/def
  :cognitect.aws.cognito-idp.VerifySoftwareTokenResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.SmsConfigurationType/SnsCallerArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.SmsConfigurationType/ExternalId
  :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.SMSMfaSettingsType/Enabled :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SMSMfaSettingsType/PreferredMfa
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.DescribeResourceServerResponse/ResourceServer
  :cognitect.aws.cognito-idp/ResourceServerType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverActionsType/LowAction
  :cognitect.aws.cognito-idp/AccountTakeoverActionType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverActionsType/MediumAction
  :cognitect.aws.cognito-idp/AccountTakeoverActionType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverActionsType/HighAction
  :cognitect.aws.cognito-idp/AccountTakeoverActionType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolClientRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolClientRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.EmailConfigurationType/SourceArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.EmailConfigurationType/ReplyToEmailAddress
  :cognitect.aws.cognito-idp/EmailAddressType)

(s/def
  :cognitect.aws.cognito-idp.EmailConfigurationType/EmailSendingAccount
  :cognitect.aws.cognito-idp/EmailSendingAccountType)

(s/def :cognitect.aws.cognito-idp.EmailConfigurationType/From :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EmailConfigurationType/ConfigurationSet
  :cognitect.aws.cognito-idp/SESConfigurationSet)

(s/def
  :cognitect.aws.cognito-idp.StartUserImportJobRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.StartUserImportJobRequest/JobId
  :cognitect.aws.cognito-idp/UserImportJobIdType)

(s/def
  :cognitect.aws.cognito-idp.ListResourceServersResponse/ResourceServers
  :cognitect.aws.cognito-idp/ResourceServersListType)

(s/def
  :cognitect.aws.cognito-idp.ListResourceServersResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def :cognitect.aws.cognito-idp.CreateGroupResponse/Group :cognitect.aws.cognito-idp/GroupType)

(s/def
  :cognitect.aws.cognito-idp.ChangePasswordRequest/PreviousPassword
  :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.ChangePasswordRequest/ProposedPassword
  :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.ChangePasswordRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.ListUserImportJobsResponse/UserImportJobs
  :cognitect.aws.cognito-idp/UserImportJobsListType)

(s/def
  :cognitect.aws.cognito-idp.ListUserImportJobsResponse/PaginationToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserResponse/Groups
  :cognitect.aws.cognito-idp/GroupListType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.AdminDisableProviderForUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AdminDisableProviderForUserRequest/User
  :cognitect.aws.cognito-idp/ProviderUserIdentifierType)

(s/def :cognitect.aws.cognito-idp.GroupType/GroupName :cognitect.aws.cognito-idp/GroupNameType)

(s/def :cognitect.aws.cognito-idp.GroupType/UserPoolId :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def :cognitect.aws.cognito-idp.GroupType/Description :cognitect.aws.cognito-idp/DescriptionType)

(s/def :cognitect.aws.cognito-idp.GroupType/RoleArn :cognitect.aws.cognito-idp/ArnType)

(s/def :cognitect.aws.cognito-idp.GroupType/Precedence :cognitect.aws.cognito-idp/PrecedenceType)

(s/def :cognitect.aws.cognito-idp.GroupType/LastModifiedDate :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.GroupType/CreationDate :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.AdminForgetDeviceRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminForgetDeviceRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminForgetDeviceRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/TemporaryPassword
  :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/ValidationData
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/MessageAction
  :cognitect.aws.cognito-idp/MessageActionType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/DesiredDeliveryMediums
  :cognitect.aws.cognito-idp/DeliveryMediumListType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/ForceAliasCreation
  :cognitect.aws.cognito-idp/ForceAliasCreation)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolResponse/UserPool
  :cognitect.aws.cognito-idp/UserPoolType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupRequest/Limit
  :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersInGroupRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/SmsMfaConfiguration
  :cognitect.aws.cognito-idp/SmsMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/SoftwareTokenMfaConfiguration
  :cognitect.aws.cognito-idp/SoftwareTokenMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.GetUserPoolMfaConfigResponse/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolDomainResponse/DomainDescription
  :cognitect.aws.cognito-idp/DomainDescriptionType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/GenerateSecret
  :cognitect.aws.cognito-idp/GenerateSecret)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/LogoutURLs
  :cognitect.aws.cognito-idp/LogoutURLsListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ClientName
  :cognitect.aws.cognito-idp/ClientNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/DefaultRedirectURI
  :cognitect.aws.cognito-idp/RedirectUrlType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/TokenValidityUnits
  :cognitect.aws.cognito-idp/TokenValidityUnitsType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthScopes
  :cognitect.aws.cognito-idp/ScopeListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthFlows
  :cognitect.aws.cognito-idp/OAuthFlowsType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AllowedOAuthFlowsUserPoolClient
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AccessTokenValidity
  :cognitect.aws.cognito-idp/AccessTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/SupportedIdentityProviders
  :cognitect.aws.cognito-idp/SupportedIdentityProvidersListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ReadAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/RefreshTokenValidity
  :cognitect.aws.cognito-idp/RefreshTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/PreventUserExistenceErrors
  :cognitect.aws.cognito-idp/PreventUserExistenceErrorTypes)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/CallbackURLs
  :cognitect.aws.cognito-idp/CallbackURLsListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/WriteAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/ExplicitAuthFlows
  :cognitect.aws.cognito-idp/ExplicitAuthFlowsListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/IdTokenValidity
  :cognitect.aws.cognito-idp/IdTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientRequest/AnalyticsConfiguration
  :cognitect.aws.cognito-idp/AnalyticsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.SetUICustomizationRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.SetUICustomizationRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def :cognitect.aws.cognito-idp.SetUICustomizationRequest/CSS :cognitect.aws.cognito-idp/CSSType)

(s/def
  :cognitect.aws.cognito-idp.SetUICustomizationRequest/ImageFile
  :cognitect.aws.cognito-idp/ImageFileType)

(s/def
  :cognitect.aws.cognito-idp.DeviceSecretVerifierConfigType/PasswordVerifier
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.DeviceSecretVerifierConfigType/Salt
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.NotifyEmailType/Subject
  :cognitect.aws.cognito-idp/EmailNotificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.NotifyEmailType/HtmlBody
  :cognitect.aws.cognito-idp/EmailNotificationBodyType)

(s/def
  :cognitect.aws.cognito-idp.NotifyEmailType/TextBody
  :cognitect.aws.cognito-idp/EmailNotificationBodyType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesRequest/Limit
  :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesRequest/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmDeviceResponse/UserConfirmationNecessary
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierRequest/IdpIdentifier
  :cognitect.aws.cognito-idp/IdpIdentifierType)

(s/def :cognitect.aws.cognito-idp.GetDeviceResponse/Device :cognitect.aws.cognito-idp/DeviceType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/Domain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolDomainRequest/CustomDomainConfig
  :cognitect.aws.cognito-idp/CustomDomainConfigType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientDescription/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientDescription/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolClientDescription/ClientName
  :cognitect.aws.cognito-idp/ClientNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/DestinationUser
  :cognitect.aws.cognito-idp/ProviderUserIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.AdminLinkProviderForUserRequest/SourceUser
  :cognitect.aws.cognito-idp/ProviderUserIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.CreateResourceServerResponse/ResourceServer
  :cognitect.aws.cognito-idp/ResourceServerType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthResponse/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthResponse/ChallengeParameters
  :cognitect.aws.cognito-idp/ChallengeParametersType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthResponse/AuthenticationResult
  :cognitect.aws.cognito-idp/AuthenticationResultType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/From
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/ReplyTo
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/SourceArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/BlockEmail
  :cognitect.aws.cognito-idp/NotifyEmailType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/NoActionEmail
  :cognitect.aws.cognito-idp/NotifyEmailType)

(s/def
  :cognitect.aws.cognito-idp.NotifyConfigurationType/MfaEmail
  :cognitect.aws.cognito-idp/NotifyEmailType)

(s/def
  :cognitect.aws.cognito-idp.DeleteResourceServerRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DeleteResourceServerRequest/Identifier
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolDomainResponse/CloudFrontDomain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/SecretHash
  :cognitect.aws.cognito-idp/SecretHashType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/ValidationData
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def :cognitect.aws.cognito-idp.SignUpRequest/ClientId :cognitect.aws.cognito-idp/ClientIdType)

(s/def :cognitect.aws.cognito-idp.SignUpRequest/Password :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.SignUpRequest/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def :cognitect.aws.cognito-idp.SignUpRequest/Username :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.GetUICustomizationRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.GetUICustomizationRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def :cognitect.aws.cognito-idp.UserType/Username :cognitect.aws.cognito-idp/UsernameType)

(s/def :cognitect.aws.cognito-idp.UserType/Attributes :cognitect.aws.cognito-idp/AttributeListType)

(s/def :cognitect.aws.cognito-idp.UserType/UserCreateDate :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserType/UserLastModifiedDate :cognitect.aws.cognito-idp/DateType)

(s/def :cognitect.aws.cognito-idp.UserType/Enabled :cognitect.aws.cognito-idp/BooleanType)

(s/def :cognitect.aws.cognito-idp.UserType/UserStatus :cognitect.aws.cognito-idp/UserStatusType)

(s/def :cognitect.aws.cognito-idp.UserType/MFAOptions :cognitect.aws.cognito-idp/MFAOptionListType)

(s/def
  :cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminResetUserPasswordRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.DescribeRiskConfigurationResponse/RiskConfiguration
  :cognitect.aws.cognito-idp/RiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/ImageUrl
  :cognitect.aws.cognito-idp/ImageUrlType)

(s/def :cognitect.aws.cognito-idp.UICustomizationType/CSS :cognitect.aws.cognito-idp/CSSType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/CSSVersion
  :cognitect.aws.cognito-idp/CSSVersionType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.UICustomizationType/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.EventFeedbackType/FeedbackValue
  :cognitect.aws.cognito-idp/FeedbackValueType)

(s/def :cognitect.aws.cognito-idp.EventFeedbackType/Provider :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.EventFeedbackType/FeedbackDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.ProviderDescription/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.ProviderDescription/ProviderType
  :cognitect.aws.cognito-idp/IdentityProviderTypeType)

(s/def
  :cognitect.aws.cognito-idp.ProviderDescription/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.ProviderDescription/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.ListIdentityProvidersResponse/Providers
  :cognitect.aws.cognito-idp/ProvidersListType)

(s/def
  :cognitect.aws.cognito-idp.ListIdentityProvidersResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.DescribeResourceServerRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DescribeResourceServerRequest/Identifier
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/Limit
  :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.AdminListGroupsForUserRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsConfiguration
  :cognitect.aws.cognito-idp/SmsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/PoolName
  :cognitect.aws.cognito-idp/UserPoolNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/Policies
  :cognitect.aws.cognito-idp/UserPoolPolicyType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/UserPoolTags
  :cognitect.aws.cognito-idp/UserPoolTagsType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/AccountRecoverySetting
  :cognitect.aws.cognito-idp/AccountRecoverySettingType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailVerificationSubject
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/UsernameConfiguration
  :cognitect.aws.cognito-idp/UsernameConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailConfiguration
  :cognitect.aws.cognito-idp/EmailConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/UsernameAttributes
  :cognitect.aws.cognito-idp/UsernameAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsVerificationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/AutoVerifiedAttributes
  :cognitect.aws.cognito-idp/VerifiedAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/DeviceConfiguration
  :cognitect.aws.cognito-idp/DeviceConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/Schema
  :cognitect.aws.cognito-idp/SchemaAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/EmailVerificationMessage
  :cognitect.aws.cognito-idp/EmailVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/AliasAttributes
  :cognitect.aws.cognito-idp/AliasAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/SmsAuthenticationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/LambdaConfig
  :cognitect.aws.cognito-idp/LambdaConfigType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/VerificationMessageTemplate
  :cognitect.aws.cognito-idp/VerificationMessageTemplateType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/AdminCreateUserConfig
  :cognitect.aws.cognito-idp/AdminCreateUserConfigType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolRequest/UserPoolAddOns
  :cognitect.aws.cognito-idp/UserPoolAddOnsType)

(s/def
  :cognitect.aws.cognito-idp.UsernameConfigurationType/CaseSensitive
  :cognitect.aws.cognito-idp/WrappedBooleanType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverActionType/Notify
  :cognitect.aws.cognito-idp/AccountTakeoverActionNotifyType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverActionType/EventAction
  :cognitect.aws.cognito-idp/AccountTakeoverEventActionType)

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsResponse/AuthEvents
  :cognitect.aws.cognito-idp/AuthEventsType)

(s/def
  :cognitect.aws.cognito-idp.AdminListUserAuthEventsResponse/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def :cognitect.aws.cognito-idp.GetGroupResponse/Group :cognitect.aws.cognito-idp/GroupType)

(s/def
  :cognitect.aws.cognito-idp.ListTagsForResourceRequest/ResourceArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsConfigurationType/ApplicationId
  :cognitect.aws.cognito-idp/HexStringType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsConfigurationType/ApplicationArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsConfigurationType/RoleArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsConfigurationType/ExternalId
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsConfigurationType/UserDataShared
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/AWSAccountId
  :cognitect.aws.cognito-idp/AWSAccountIdType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/Domain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/S3Bucket
  :cognitect.aws.cognito-idp/S3BucketType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/CloudFrontDistribution
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/Version
  :cognitect.aws.cognito-idp/DomainVersionType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/Status
  :cognitect.aws.cognito-idp/DomainStatusType)

(s/def
  :cognitect.aws.cognito-idp.DomainDescriptionType/CustomDomainConfig
  :cognitect.aws.cognito-idp/CustomDomainConfigType)

(s/def
  :cognitect.aws.cognito-idp.SignUpResponse/UserConfirmed
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SignUpResponse/CodeDeliveryDetails
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsType)

(s/def :cognitect.aws.cognito-idp.SignUpResponse/UserSub :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.ListIdentityProvidersRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListIdentityProvidersRequest/MaxResults
  :cognitect.aws.cognito-idp/ListProvidersLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListIdentityProvidersRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AuthFlow
  :cognitect.aws.cognito-idp/AuthFlowType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AuthParameters
  :cognitect.aws.cognito-idp/AuthParametersType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthRequest/ContextData
  :cognitect.aws.cognito-idp/ContextDataType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolsRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolsRequest/MaxResults
  :cognitect.aws.cognito-idp/PoolQueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ChallengeResponses
  :cognitect.aws.cognito-idp/ChallengeResponsesType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ContextData
  :cognitect.aws.cognito-idp/ContextDataType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.CreateGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateGroupRequest/Description
  :cognitect.aws.cognito-idp/DescriptionType)

(s/def :cognitect.aws.cognito-idp.CreateGroupRequest/RoleArn :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.CreateGroupRequest/Precedence
  :cognitect.aws.cognito-idp/PrecedenceType)

(s/def
  :cognitect.aws.cognito-idp.CreateResourceServerRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateResourceServerRequest/Identifier
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.CreateResourceServerRequest/Name
  :cognitect.aws.cognito-idp/ResourceServerNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateResourceServerRequest/Scopes
  :cognitect.aws.cognito-idp/ResourceServerScopeListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.UpdateGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateGroupRequest/Description
  :cognitect.aws.cognito-idp/DescriptionType)

(s/def :cognitect.aws.cognito-idp.UpdateGroupRequest/RoleArn :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.UpdateGroupRequest/Precedence
  :cognitect.aws.cognito-idp/PrecedenceType)

(s/def
  :cognitect.aws.cognito-idp.ListGroupsRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def :cognitect.aws.cognito-idp.ListGroupsRequest/Limit :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListGroupsRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AddCustomAttributesRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AddCustomAttributesRequest/CustomAttributes
  :cognitect.aws.cognito-idp/CustomAttributesListType)

(s/def
  :cognitect.aws.cognito-idp.GetSigningCertificateResponse/Certificate
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserPoolClientResponse/UserPoolClient
  :cognitect.aws.cognito-idp/UserPoolClientType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverRiskConfigurationType/NotifyConfiguration
  :cognitect.aws.cognito-idp/NotifyConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.AccountTakeoverRiskConfigurationType/Actions
  :cognitect.aws.cognito-idp/AccountTakeoverActionsType)

(s/def
  :cognitect.aws.cognito-idp.RiskExceptionConfigurationType/BlockedIPRangeList
  :cognitect.aws.cognito-idp/BlockedIPRangeListType)

(s/def
  :cognitect.aws.cognito-idp.RiskExceptionConfigurationType/SkippedIPRangeList
  :cognitect.aws.cognito-idp/SkippedIPRangeListType)

(s/def
  :cognitect.aws.cognito-idp.GetSigningCertificateRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/ChallengeParameters
  :cognitect.aws.cognito-idp/ChallengeParametersType)

(s/def
  :cognitect.aws.cognito-idp.AdminRespondToAuthChallengeResponse/AuthenticationResult
  :cognitect.aws.cognito-idp/AuthenticationResultType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserImportJobRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserImportJobRequest/JobId
  :cognitect.aws.cognito-idp/UserImportJobIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/Id
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/Name
  :cognitect.aws.cognito-idp/UserPoolNameType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/LambdaConfig
  :cognitect.aws.cognito-idp/LambdaConfigType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/Status
  :cognitect.aws.cognito-idp/StatusType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolDescriptionType/CreationDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.CustomEmailLambdaVersionConfigType/LambdaVersion
  :cognitect.aws.cognito-idp/CustomEmailSenderLambdaVersionType)

(s/def
  :cognitect.aws.cognito-idp.CustomEmailLambdaVersionConfigType/LambdaArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/EventId
  :cognitect.aws.cognito-idp/EventIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/FeedbackToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.UpdateAuthEventFeedbackRequest/FeedbackValue
  :cognitect.aws.cognito-idp/FeedbackValueType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/SecretHash
  :cognitect.aws.cognito-idp/SecretHashType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ConfirmationCode
  :cognitect.aws.cognito-idp/ConfirmationCodeType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/Password
  :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmForgotPasswordRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.DescribeIdentityProviderRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DescribeIdentityProviderRequest/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/SecretHash
  :cognitect.aws.cognito-idp/SecretHashType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ResendConfirmationCodeRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.ChallengeResponseType/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeName)

(s/def
  :cognitect.aws.cognito-idp.ChallengeResponseType/ChallengeResponse
  :cognitect.aws.cognito-idp/ChallengeResponse)

(s/def
  :cognitect.aws.cognito-idp.ConfirmDeviceRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceSecretVerifierConfig
  :cognitect.aws.cognito-idp/DeviceSecretVerifierConfigType)

(s/def
  :cognitect.aws.cognito-idp.ConfirmDeviceRequest/DeviceName
  :cognitect.aws.cognito-idp/DeviceNameType)

(s/def
  :cognitect.aws.cognito-idp.ForgotPasswordResponse/CodeDeliveryDetails
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsType)

(s/def
  :cognitect.aws.cognito-idp.MessageTemplateType/SMSMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.MessageTemplateType/EmailMessage
  :cognitect.aws.cognito-idp/EmailVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.MessageTemplateType/EmailSubject
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.GetGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.GetGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.StopUserImportJobRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.StopUserImportJobRequest/JobId
  :cognitect.aws.cognito-idp/UserImportJobIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/UserStatus
  :cognitect.aws.cognito-idp/UserStatusType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/UserCreateDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/UserMFASettingList
  :cognitect.aws.cognito-idp/UserMFASettingListType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/PreferredMfaSetting
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/Enabled
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/MFAOptions
  :cognitect.aws.cognito-idp/MFAOptionListType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/UserLastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetUserResponse/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.GetDeviceRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.GetDeviceRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AdminDisableUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminDisableUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesResponse/Devices
  :cognitect.aws.cognito-idp/DeviceListType)

(s/def
  :cognitect.aws.cognito-idp.AdminListDevicesResponse/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerType/Identifier
  :cognitect.aws.cognito-idp/ResourceServerIdentifierType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerType/Name
  :cognitect.aws.cognito-idp/ResourceServerNameType)

(s/def
  :cognitect.aws.cognito-idp.ResourceServerType/Scopes
  :cognitect.aws.cognito-idp/ResourceServerScopeListType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolAddOnsType/AdvancedSecurityMode
  :cognitect.aws.cognito-idp/AdvancedSecurityModeType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserPoolDomainRequest/Domain
  :cognitect.aws.cognito-idp/DomainType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserPoolDomainRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListDevicesResponse/Devices
  :cognitect.aws.cognito-idp/DeviceListType)

(s/def
  :cognitect.aws.cognito-idp.ListDevicesResponse/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/CompromisedCredentialsRiskConfiguration
  :cognitect.aws.cognito-idp/CompromisedCredentialsRiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/AccountTakeoverRiskConfiguration
  :cognitect.aws.cognito-idp/AccountTakeoverRiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/RiskExceptionConfiguration
  :cognitect.aws.cognito-idp/RiskExceptionConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.RiskConfigurationType/LastModifiedDate
  :cognitect.aws.cognito-idp/DateType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/Name
  :cognitect.aws.cognito-idp/CustomAttributeNameType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/AttributeDataType
  :cognitect.aws.cognito-idp/AttributeDataType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/DeveloperOnlyAttribute
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/Mutable
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/Required
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/NumberAttributeConstraints
  :cognitect.aws.cognito-idp/NumberAttributeConstraintsType)

(s/def
  :cognitect.aws.cognito-idp.SchemaAttributeType/StringAttributeConstraints
  :cognitect.aws.cognito-idp/StringAttributeConstraintsType)

(s/def
  :cognitect.aws.cognito-idp.AdminEnableUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminEnableUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def :cognitect.aws.cognito-idp.AdminCreateUserResponse/User :cognitect.aws.cognito-idp/UserType)

(s/def
  :cognitect.aws.cognito-idp.ListResourceServersRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListResourceServersRequest/MaxResults
  :cognitect.aws.cognito-idp/ListResourceServersLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListResourceServersRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/SMSMfaSettings
  :cognitect.aws.cognito-idp/SMSMfaSettingsType)

(s/def
  :cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/SoftwareTokenMfaSettings
  :cognitect.aws.cognito-idp/SoftwareTokenMfaSettingsType)

(s/def
  :cognitect.aws.cognito-idp.SetUserMFAPreferenceRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserPoolRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/LogoutURLs
  :cognitect.aws.cognito-idp/LogoutURLsListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ClientName
  :cognitect.aws.cognito-idp/ClientNameType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/DefaultRedirectURI
  :cognitect.aws.cognito-idp/RedirectUrlType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/TokenValidityUnits
  :cognitect.aws.cognito-idp/TokenValidityUnitsType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthScopes
  :cognitect.aws.cognito-idp/ScopeListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthFlows
  :cognitect.aws.cognito-idp/OAuthFlowsType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AllowedOAuthFlowsUserPoolClient
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AccessTokenValidity
  :cognitect.aws.cognito-idp/AccessTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/SupportedIdentityProviders
  :cognitect.aws.cognito-idp/SupportedIdentityProvidersListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ReadAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/RefreshTokenValidity
  :cognitect.aws.cognito-idp/RefreshTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/PreventUserExistenceErrors
  :cognitect.aws.cognito-idp/PreventUserExistenceErrorTypes)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/CallbackURLs
  :cognitect.aws.cognito-idp/CallbackURLsListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/WriteAttributes
  :cognitect.aws.cognito-idp/ClientPermissionListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/ExplicitAuthFlows
  :cognitect.aws.cognito-idp/ExplicitAuthFlowsListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/IdTokenValidity
  :cognitect.aws.cognito-idp/IdTokenValidityType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserPoolClientRequest/AnalyticsConfiguration
  :cognitect.aws.cognito-idp/AnalyticsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserPoolClientRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.DeleteUserPoolClientRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.NewDeviceMetadataType/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.NewDeviceMetadataType/DeviceGroupKey
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/ChallengeParameters
  :cognitect.aws.cognito-idp/ChallengeParametersType)

(s/def
  :cognitect.aws.cognito-idp.AdminInitiateAuthResponse/AuthenticationResult
  :cognitect.aws.cognito-idp/AuthenticationResultType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetDeviceResponse/Device
  :cognitect.aws.cognito-idp/DeviceType)

(s/def
  :cognitect.aws.cognito-idp.GetUserAttributeVerificationCodeResponse/CodeDeliveryDetails
  :cognitect.aws.cognito-idp/CodeDeliveryDetailsType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ChallengeResponses
  :cognitect.aws.cognito-idp/ChallengeResponsesType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.GetUserRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.UntagResourceRequest/ResourceArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.UntagResourceRequest/TagKeys
  :cognitect.aws.cognito-idp/UserPoolTagsListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserAttributesRequest/UserAttributes
  :cognitect.aws.cognito-idp/AttributeListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserAttributesRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.UpdateUserAttributesRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.CodeDeliveryDetailsType/Destination
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.CodeDeliveryDetailsType/DeliveryMedium
  :cognitect.aws.cognito-idp/DeliveryMediumType)

(s/def
  :cognitect.aws.cognito-idp.CodeDeliveryDetailsType/AttributeName
  :cognitect.aws.cognito-idp/AttributeNameType)

(s/def
  :cognitect.aws.cognito-idp.CustomSMSLambdaVersionConfigType/LambdaVersion
  :cognitect.aws.cognito-idp/CustomSMSSenderLambdaVersionType)

(s/def
  :cognitect.aws.cognito-idp.CustomSMSLambdaVersionConfigType/LambdaArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.AssociateSoftwareTokenResponse/SecretCode
  :cognitect.aws.cognito-idp/SecretCodeType)

(s/def
  :cognitect.aws.cognito-idp.AssociateSoftwareTokenResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.AnalyticsMetadataType/AnalyticsEndpointId
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.ListDevicesRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.ListDevicesRequest/Limit
  :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListDevicesRequest/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def
  :cognitect.aws.cognito-idp.AdminUserGlobalSignOutRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminUserGlobalSignOutRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/SmsMfaConfiguration
  :cognitect.aws.cognito-idp/SmsMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/SoftwareTokenMfaConfiguration
  :cognitect.aws.cognito-idp/SoftwareTokenMfaConfigType)

(s/def
  :cognitect.aws.cognito-idp.SetUserPoolMfaConfigResponse/MfaConfiguration
  :cognitect.aws.cognito-idp/UserPoolMfaType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserPoolClientResponse/UserPoolClient
  :cognitect.aws.cognito-idp/UserPoolClientType)

(s/def :cognitect.aws.cognito-idp.HttpHeader/headerName :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.HttpHeader/headerValue :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/ProviderDetails
  :cognitect.aws.cognito-idp/ProviderDetailsType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/AttributeMapping
  :cognitect.aws.cognito-idp/AttributeMappingType)

(s/def
  :cognitect.aws.cognito-idp.UpdateIdentityProviderRequest/IdpIdentifiers
  :cognitect.aws.cognito-idp/IdpIdentifiersListType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetDeviceRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetDeviceRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminGetDeviceRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.SetUserSettingsRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.SetUserSettingsRequest/MFAOptions
  :cognitect.aws.cognito-idp/MFAOptionListType)

(s/def
  :cognitect.aws.cognito-idp.UpdateResourceServerResponse/ResourceServer
  :cognitect.aws.cognito-idp/ResourceServerType)

(s/def
  :cognitect.aws.cognito-idp.VerifyUserAttributeRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.VerifyUserAttributeRequest/AttributeName
  :cognitect.aws.cognito-idp/AttributeNameType)

(s/def
  :cognitect.aws.cognito-idp.VerifyUserAttributeRequest/Code
  :cognitect.aws.cognito-idp/ConfirmationCodeType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolClientsRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolClientsRequest/MaxResults
  :cognitect.aws.cognito-idp/QueryLimit)

(s/def
  :cognitect.aws.cognito-idp.ListUserPoolClientsRequest/NextToken
  :cognitect.aws.cognito-idp/PaginationKey)

(s/def
  :cognitect.aws.cognito-idp.GetUserPoolMfaConfigRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminDeleteUserAttributesRequest/UserAttributeNames
  :cognitect.aws.cognito-idp/AttributeNameListType)

(s/def
  :cognitect.aws.cognito-idp.TokenValidityUnitsType/AccessToken
  :cognitect.aws.cognito-idp/TimeUnitsType)

(s/def
  :cognitect.aws.cognito-idp.TokenValidityUnitsType/IdToken
  :cognitect.aws.cognito-idp/TimeUnitsType)

(s/def
  :cognitect.aws.cognito-idp.TokenValidityUnitsType/RefreshToken
  :cognitect.aws.cognito-idp/TimeUnitsType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderResponse/IdentityProvider
  :cognitect.aws.cognito-idp/IdentityProviderType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.AdminUpdateDeviceStatusRequest/DeviceRememberedStatus
  :cognitect.aws.cognito-idp/DeviceRememberedStatusType)

(s/def
  :cognitect.aws.cognito-idp.CompromisedCredentialsRiskConfigurationType/EventFilter
  :cognitect.aws.cognito-idp/EventFiltersType)

(s/def
  :cognitect.aws.cognito-idp.CompromisedCredentialsRiskConfigurationType/Actions
  :cognitect.aws.cognito-idp/CompromisedCredentialsActionsType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/SmsMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailMessage
  :cognitect.aws.cognito-idp/EmailVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailSubject
  :cognitect.aws.cognito-idp/EmailVerificationSubjectType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailMessageByLink
  :cognitect.aws.cognito-idp/EmailVerificationMessageByLinkType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/EmailSubjectByLink
  :cognitect.aws.cognito-idp/EmailVerificationSubjectByLinkType)

(s/def
  :cognitect.aws.cognito-idp.VerificationMessageTemplateType/DefaultEmailOption
  :cognitect.aws.cognito-idp/DefaultEmailOptionType)

(s/def
  :cognitect.aws.cognito-idp.UserContextDataType/EncodedData
  :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.ListUsersResponse/Users :cognitect.aws.cognito-idp/UsersListType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersResponse/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def
  :cognitect.aws.cognito-idp.AdminDeleteUserRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminDeleteUserRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.GetUICustomizationResponse/UICustomization
  :cognitect.aws.cognito-idp/UICustomizationType)

(s/def
  :cognitect.aws.cognito-idp.DescribeUserImportJobResponse/UserImportJob
  :cognitect.aws.cognito-idp/UserImportJobType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersRequest/AttributesToGet
  :cognitect.aws.cognito-idp/SearchedAttributeNamesListType)

(s/def :cognitect.aws.cognito-idp.ListUsersRequest/Limit :cognitect.aws.cognito-idp/QueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListUsersRequest/PaginationToken
  :cognitect.aws.cognito-idp/SearchPaginationTokenType)

(s/def :cognitect.aws.cognito-idp.ListUsersRequest/Filter :cognitect.aws.cognito-idp/UserFilterType)

(s/def
  :cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminRemoveUserFromGroupRequest/GroupName
  :cognitect.aws.cognito-idp/GroupNameType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Password
  :cognitect.aws.cognito-idp/PasswordType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserPasswordRequest/Permanent
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/CompromisedCredentialsRiskConfiguration
  :cognitect.aws.cognito-idp/CompromisedCredentialsRiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/AccountTakeoverRiskConfiguration
  :cognitect.aws.cognito-idp/AccountTakeoverRiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationRequest/RiskExceptionConfiguration
  :cognitect.aws.cognito-idp/RiskExceptionConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderName
  :cognitect.aws.cognito-idp/ProviderNameTypeV1)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderType
  :cognitect.aws.cognito-idp/IdentityProviderTypeType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/ProviderDetails
  :cognitect.aws.cognito-idp/ProviderDetailsType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/AttributeMapping
  :cognitect.aws.cognito-idp/AttributeMappingType)

(s/def
  :cognitect.aws.cognito-idp.CreateIdentityProviderRequest/IdpIdentifiers
  :cognitect.aws.cognito-idp/IdpIdentifiersListType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/SMSMfaSettings
  :cognitect.aws.cognito-idp/SMSMfaSettingsType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/SoftwareTokenMfaSettings
  :cognitect.aws.cognito-idp/SoftwareTokenMfaSettingsType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminSetUserMFAPreferenceRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.StringAttributeConstraintsType/MinLength
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.StringAttributeConstraintsType/MaxLength
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserConfigType/AllowAdminCreateUserOnly
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserConfigType/UnusedAccountValidityDays
  :cognitect.aws.cognito-idp/AdminCreateUserUnusedAccountValidityDaysType)

(s/def
  :cognitect.aws.cognito-idp.AdminCreateUserConfigType/InviteMessageTemplate
  :cognitect.aws.cognito-idp/MessageTemplateType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/ExpiresIn
  :cognitect.aws.cognito-idp/IntegerType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/TokenType
  :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/RefreshToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/IdToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.AuthenticationResultType/NewDeviceMetadata
  :cognitect.aws.cognito-idp/NewDeviceMetadataType)

(s/def
  :cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/DeviceKey
  :cognitect.aws.cognito-idp/DeviceKeyType)

(s/def
  :cognitect.aws.cognito-idp.UpdateDeviceStatusRequest/DeviceRememberedStatus
  :cognitect.aws.cognito-idp/DeviceRememberedStatusType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/AuthFlow
  :cognitect.aws.cognito-idp/AuthFlowType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/AuthParameters
  :cognitect.aws.cognito-idp/AuthParametersType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/ClientId
  :cognitect.aws.cognito-idp/ClientIdType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/AnalyticsMetadata
  :cognitect.aws.cognito-idp/AnalyticsMetadataType)

(s/def
  :cognitect.aws.cognito-idp.InitiateAuthRequest/UserContextData
  :cognitect.aws.cognito-idp/UserContextDataType)

(s/def
  :cognitect.aws.cognito-idp.DeviceConfigurationType/ChallengeRequiredOnNewDevice
  :cognitect.aws.cognito-idp/BooleanType)

(s/def
  :cognitect.aws.cognito-idp.DeviceConfigurationType/DeviceOnlyRememberedOnUserPrompt
  :cognitect.aws.cognito-idp/BooleanType)

(s/def :cognitect.aws.cognito-idp.ContextDataType/IpAddress :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.ContextDataType/ServerName :cognitect.aws.cognito-idp/StringType)

(s/def :cognitect.aws.cognito-idp.ContextDataType/ServerPath :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.ContextDataType/HttpHeaders
  :cognitect.aws.cognito-idp/HttpHeaderList)

(s/def :cognitect.aws.cognito-idp.ContextDataType/EncodedData :cognitect.aws.cognito-idp/StringType)

(s/def
  :cognitect.aws.cognito-idp.UserPoolPolicyType/PasswordPolicy
  :cognitect.aws.cognito-idp/PasswordPolicyType)

(s/def
  :cognitect.aws.cognito-idp.SetRiskConfigurationResponse/RiskConfiguration
  :cognitect.aws.cognito-idp/RiskConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.ListTagsForResourceResponse/Tags
  :cognitect.aws.cognito-idp/UserPoolTagsType)

(s/def
  :cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/Username
  :cognitect.aws.cognito-idp/UsernameType)

(s/def
  :cognitect.aws.cognito-idp.AdminConfirmSignUpRequest/ClientMetadata
  :cognitect.aws.cognito-idp/ClientMetadataType)

(s/def
  :cognitect.aws.cognito-idp.AccountRecoverySettingType/RecoveryMechanisms
  :cognitect.aws.cognito-idp/RecoveryMechanismsType)

(s/def
  :cognitect.aws.cognito-idp.SetUICustomizationResponse/UICustomization
  :cognitect.aws.cognito-idp/UICustomizationType)

(s/def
  :cognitect.aws.cognito-idp.MFAOptionType/DeliveryMedium
  :cognitect.aws.cognito-idp/DeliveryMediumType)

(s/def
  :cognitect.aws.cognito-idp.MFAOptionType/AttributeName
  :cognitect.aws.cognito-idp/AttributeNameType)

(s/def
  :cognitect.aws.cognito-idp.StopUserImportJobResponse/UserImportJob
  :cognitect.aws.cognito-idp/UserImportJobType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserImportJobRequest/JobName
  :cognitect.aws.cognito-idp/UserImportJobNameType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserImportJobRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.CreateUserImportJobRequest/CloudWatchLogsRoleArn
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.GlobalSignOutRequest/AccessToken
  :cognitect.aws.cognito-idp/TokenModelType)

(s/def
  :cognitect.aws.cognito-idp.SmsMfaConfigType/SmsAuthenticationMessage
  :cognitect.aws.cognito-idp/SmsVerificationMessageType)

(s/def
  :cognitect.aws.cognito-idp.SmsMfaConfigType/SmsConfiguration
  :cognitect.aws.cognito-idp/SmsConfigurationType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/DefineAuthChallenge
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/VerifyAuthChallengeResponse
  :cognitect.aws.cognito-idp/ArnType)

(s/def :cognitect.aws.cognito-idp.LambdaConfigType/UserMigration :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/PostConfirmation
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/PreTokenGeneration
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/CustomEmailSender
  :cognitect.aws.cognito-idp/CustomEmailLambdaVersionConfigType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/CustomSMSSender
  :cognitect.aws.cognito-idp/CustomSMSLambdaVersionConfigType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/PostAuthentication
  :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/PreAuthentication
  :cognitect.aws.cognito-idp/ArnType)

(s/def :cognitect.aws.cognito-idp.LambdaConfigType/KMSKeyID :cognitect.aws.cognito-idp/ArnType)

(s/def :cognitect.aws.cognito-idp.LambdaConfigType/PreSignUp :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.LambdaConfigType/CreateAuthChallenge
  :cognitect.aws.cognito-idp/ArnType)

(s/def :cognitect.aws.cognito-idp.LambdaConfigType/CustomMessage :cognitect.aws.cognito-idp/ArnType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/ChallengeName
  :cognitect.aws.cognito-idp/ChallengeNameType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/Session
  :cognitect.aws.cognito-idp/SessionType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/ChallengeParameters
  :cognitect.aws.cognito-idp/ChallengeParametersType)

(s/def
  :cognitect.aws.cognito-idp.RespondToAuthChallengeResponse/AuthenticationResult
  :cognitect.aws.cognito-idp/AuthenticationResultType)

(s/def
  :cognitect.aws.cognito-idp.ListUserImportJobsRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

(s/def
  :cognitect.aws.cognito-idp.ListUserImportJobsRequest/MaxResults
  :cognitect.aws.cognito-idp/PoolQueryLimitType)

(s/def
  :cognitect.aws.cognito-idp.ListUserImportJobsRequest/PaginationToken
  :cognitect.aws.cognito-idp/PaginationKeyType)

(s/def
  :cognitect.aws.cognito-idp.GetIdentityProviderByIdentifierResponse/IdentityProvider
  :cognitect.aws.cognito-idp/IdentityProviderType)

(s/def
  :cognitect.aws.cognito-idp.GetCSVHeaderRequest/UserPoolId
  :cognitect.aws.cognito-idp/UserPoolIdType)

