;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.iam.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.iam/UpdateAccountPasswordPolicyRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/MinimumPasswordLength
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireNumbers
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireUppercaseCharacters
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/HardExpiry
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireLowercaseCharacters
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireSymbols
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/AllowUsersToChangePassword
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/MaxPasswordAge
     :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/PasswordReusePrevention]))

(s/def
  :cognitect.aws.iam/DeleteAccountAliasRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteAccountAliasRequest/AccountAlias]))

(s/def :cognitect.aws.iam/PolicyIdentifierType string?)

(s/def
  :cognitect.aws.iam/ListServerCertificatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListServerCertificatesRequest/PathPrefix
     :cognitect.aws.iam.ListServerCertificatesRequest/Marker
     :cognitect.aws.iam.ListServerCertificatesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/AccessAdvisorUsageGranularityType
  (s/spec string? :gen #(s/gen #{"SERVICE_LEVEL" "ACTION_LEVEL"})))

(s/def
  :cognitect.aws.iam/GetGroupPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetGroupPolicyRequest/GroupName
     :cognitect.aws.iam.GetGroupPolicyRequest/PolicyName]))

(s/def :cognitect.aws.iam/EvaluationResultsListType (s/coll-of :cognitect.aws.iam/EvaluationResult))

(s/def
  :cognitect.aws.iam/publicKeyIdType
  (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListSAMLProviderTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListSAMLProviderTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListSAMLProviderTagsResponse/Marker
     :cognitect.aws.iam.ListSAMLProviderTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/UntagInstanceProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagInstanceProfileRequest/InstanceProfileName
     :cognitect.aws.iam.UntagInstanceProfileRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/DeleteRolePermissionsBoundaryRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteRolePermissionsBoundaryRequest/RoleName]))

(s/def :cognitect.aws.iam/serviceNameType string?)

(s/def
  :cognitect.aws.iam/ResourceNameType
  (s/spec
    (s/and string? #(<= 1 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.iam/AccountNotManagementOrDelegatedAdministratorException (s/keys))

(s/def
  :cognitect.aws.iam/RemoveRoleFromInstanceProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.RemoveRoleFromInstanceProfileRequest/InstanceProfileName
     :cognitect.aws.iam.RemoveRoleFromInstanceProfileRequest/RoleName]))

(s/def
  :cognitect.aws.iam/TagMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagMFADeviceRequest/SerialNumber
     :cognitect.aws.iam.TagMFADeviceRequest/Tags]))

(s/def
  :cognitect.aws.iam/GetInstanceProfileRequest
  (s/keys :req-un [:cognitect.aws.iam.GetInstanceProfileRequest/InstanceProfileName]))

(s/def
  :cognitect.aws.iam/CreateServiceSpecificCredentialResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.CreateServiceSpecificCredentialResponse/ServiceSpecificCredential]))

(s/def :cognitect.aws.iam/groupNameListType (s/coll-of :cognitect.aws.iam/groupNameType))

(s/def :cognitect.aws.iam/policyNotAttachableMessage string?)

(s/def :cognitect.aws.iam/invalidInputMessage string?)

(s/def
  :cognitect.aws.iam/ListEntitiesForPolicyResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListEntitiesForPolicyResponse/Marker
     :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyUsers
     :cognitect.aws.iam.ListEntitiesForPolicyResponse/IsTruncated
     :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyGroups
     :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyRoles]))

(s/def
  :cognitect.aws.iam/publicKeyFingerprintType
  (s/spec #(re-matches (re-pattern "[:\\w]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.iam/ServiceAccessNotEnabledException (s/keys))

(s/def
  :cognitect.aws.iam/Group
  (s/keys
    :req-un
    [:cognitect.aws.iam.Group/Path
     :cognitect.aws.iam.Group/GroupName
     :cognitect.aws.iam.Group/GroupId
     :cognitect.aws.iam.Group/Arn
     :cognitect.aws.iam.Group/CreateDate]))

(s/def
  :cognitect.aws.iam/GetSSHPublicKeyResponse
  (s/keys :opt-un [:cognitect.aws.iam.GetSSHPublicKeyResponse/SSHPublicKey]))

(s/def
  :cognitect.aws.iam/ListServiceSpecificCredentialsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListServiceSpecificCredentialsResponse/ServiceSpecificCredentials]))

(s/def
  :cognitect.aws.iam/DetachUserPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DetachUserPolicyRequest/UserName
     :cognitect.aws.iam.DetachUserPolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/DeleteSigningCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteSigningCertificateRequest/CertificateId]
    :opt-un
    [:cognitect.aws.iam.DeleteSigningCertificateRequest/UserName]))

(s/def :cognitect.aws.iam/keyPairMismatchMessage string?)

(s/def
  :cognitect.aws.iam/ReasonType
  (s/spec
    (s/and string? #(>= 1000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/PolicyEvaluationException
  (s/keys :opt-un [:cognitect.aws.iam.PolicyEvaluationException/message]))

(s/def
  :cognitect.aws.iam/AddUserToGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AddUserToGroupRequest/GroupName
     :cognitect.aws.iam.AddUserToGroupRequest/UserName]))

(s/def
  :cognitect.aws.iam/CreateUserResponse
  (s/keys :opt-un [:cognitect.aws.iam.CreateUserResponse/User]))

(s/def
  :cognitect.aws.iam/ListGroupsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListGroupsResponse/Groups]
    :opt-un
    [:cognitect.aws.iam.ListGroupsResponse/Marker
     :cognitect.aws.iam.ListGroupsResponse/IsTruncated]))

(s/def :cognitect.aws.iam/ReportStateDescriptionType string?)

(s/def :cognitect.aws.iam/dateType inst?)

(s/def
  :cognitect.aws.iam/ListOrganizationsFeaturesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListOrganizationsFeaturesResponse/EnabledFeatures
     :cognitect.aws.iam.ListOrganizationsFeaturesResponse/OrganizationId]))

(s/def
  :cognitect.aws.iam/tagKeyType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListInstanceProfilesForRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListInstanceProfilesForRoleRequest/RoleName]
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfilesForRoleRequest/Marker
     :cognitect.aws.iam.ListInstanceProfilesForRoleRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/PutUserPermissionsBoundaryRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.PutUserPermissionsBoundaryRequest/UserName
     :cognitect.aws.iam.PutUserPermissionsBoundaryRequest/PermissionsBoundary]))

(s/def
  :cognitect.aws.iam/serviceUserName
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/GetUserPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetUserPolicyRequest/UserName
     :cognitect.aws.iam.GetUserPolicyRequest/PolicyName]))

(s/def
  :cognitect.aws.iam/UpdateLoginProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateLoginProfileRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.UpdateLoginProfileRequest/Password
     :cognitect.aws.iam.UpdateLoginProfileRequest/PasswordResetRequired]))

(s/def
  :cognitect.aws.iam/virtualMFADeviceName
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/Tag
  (s/keys :req-un [:cognitect.aws.iam.Tag/Key :cognitect.aws.iam.Tag/Value]))

(s/def
  :cognitect.aws.iam/DeleteServiceLinkedRoleResponse
  (s/keys :req-un [:cognitect.aws.iam.DeleteServiceLinkedRoleResponse/DeletionTaskId]))

(s/def :cognitect.aws.iam/ServicesLastAccessed (s/coll-of :cognitect.aws.iam/ServiceLastAccessed))

(s/def :cognitect.aws.iam/ReportFormatType (s/spec string? :gen #(s/gen #{"text/csv"})))

(s/def
  :cognitect.aws.iam/ContextEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ContextEntry/ContextKeyName
     :cognitect.aws.iam.ContextEntry/ContextKeyValues
     :cognitect.aws.iam.ContextEntry/ContextKeyType]))

(s/def :cognitect.aws.iam/roleListType (s/coll-of :cognitect.aws.iam/Role))

(s/def :cognitect.aws.iam/thumbprintListType (s/coll-of :cognitect.aws.iam/thumbprintType))

(s/def
  :cognitect.aws.iam/CreateInstanceProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateInstanceProfileRequest/InstanceProfileName]
    :opt-un
    [:cognitect.aws.iam.CreateInstanceProfileRequest/Path
     :cognitect.aws.iam.CreateInstanceProfileRequest/Tags]))

(s/def
  :cognitect.aws.iam/GenerateOrganizationsAccessReportResponse
  (s/keys :opt-un [:cognitect.aws.iam.GenerateOrganizationsAccessReportResponse/JobId]))

(s/def
  :cognitect.aws.iam/ListAttachedRolePoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListAttachedRolePoliciesRequest/RoleName]
    :opt-un
    [:cognitect.aws.iam.ListAttachedRolePoliciesRequest/PathPrefix
     :cognitect.aws.iam.ListAttachedRolePoliciesRequest/Marker
     :cognitect.aws.iam.ListAttachedRolePoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/ListRoleTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListRoleTagsRequest/RoleName]
    :opt-un
    [:cognitect.aws.iam.ListRoleTagsRequest/Marker
     :cognitect.aws.iam.ListRoleTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/PolicyRole
  (s/keys :opt-un [:cognitect.aws.iam.PolicyRole/RoleId :cognitect.aws.iam.PolicyRole/RoleName]))

(s/def
  :cognitect.aws.iam/serverCertificateNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/DeleteServiceLinkedRoleRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteServiceLinkedRoleRequest/RoleName]))

(s/def
  :cognitect.aws.iam/certificateChainType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/CreatePolicyVersionResponse
  (s/keys :opt-un [:cognitect.aws.iam.CreatePolicyVersionResponse/PolicyVersion]))

(s/def
  :cognitect.aws.iam/DeleteRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteRolePolicyRequest/RoleName
     :cognitect.aws.iam.DeleteRolePolicyRequest/PolicyName]))

(s/def
  :cognitect.aws.iam/GenerateCredentialReportResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GenerateCredentialReportResponse/Description
     :cognitect.aws.iam.GenerateCredentialReportResponse/State]))

(s/def
  :cognitect.aws.iam/OrganizationsDecisionDetail
  (s/keys :opt-un [:cognitect.aws.iam.OrganizationsDecisionDetail/AllowedByOrganizations]))

(s/def
  :cognitect.aws.iam/ConcurrentModificationException
  (s/keys :opt-un [:cognitect.aws.iam.ConcurrentModificationException/message]))

(s/def
  :cognitect.aws.iam/GetRoleResponse
  (s/keys :req-un [:cognitect.aws.iam.GetRoleResponse/Role]))

(s/def
  :cognitect.aws.iam/DeactivateMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeactivateMFADeviceRequest/SerialNumber]
    :opt-un
    [:cognitect.aws.iam.DeactivateMFADeviceRequest/UserName]))

(s/def
  :cognitect.aws.iam/ListSAMLProviderTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListSAMLProviderTagsRequest/SAMLProviderArn]
    :opt-un
    [:cognitect.aws.iam.ListSAMLProviderTagsRequest/Marker
     :cognitect.aws.iam.ListSAMLProviderTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/pathType
  (s/spec
    #(re-matches (re-pattern "(\\u002F)|(\\u002F[\\u0021-\\u007E]+\\u002F)") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/DeleteGroupRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteGroupRequest/GroupName]))

(s/def
  :cognitect.aws.iam/SAMLPrivateKey
  (s/keys
    :opt-un
    [:cognitect.aws.iam.SAMLPrivateKey/KeyId :cognitect.aws.iam.SAMLPrivateKey/Timestamp]))

(s/def
  :cognitect.aws.iam/MalformedPolicyDocumentException
  (s/keys :opt-un [:cognitect.aws.iam.MalformedPolicyDocumentException/message]))

(s/def
  :cognitect.aws.iam/DeleteRoleRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteRoleRequest/RoleName]))

(s/def
  :cognitect.aws.iam/AddClientIDToOpenIDConnectProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AddClientIDToOpenIDConnectProviderRequest/OpenIDConnectProviderArn
     :cognitect.aws.iam.AddClientIDToOpenIDConnectProviderRequest/ClientID]))

(s/def
  :cognitect.aws.iam/ListPoliciesGrantingServiceAccessRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/Arn
     :cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/ServiceNamespaces]
    :opt-un
    [:cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/Marker]))

(s/def
  :cognitect.aws.iam/ServerCertificateMetadata
  (s/keys
    :req-un
    [:cognitect.aws.iam.ServerCertificateMetadata/Path
     :cognitect.aws.iam.ServerCertificateMetadata/ServerCertificateName
     :cognitect.aws.iam.ServerCertificateMetadata/ServerCertificateId
     :cognitect.aws.iam.ServerCertificateMetadata/Arn]
    :opt-un
    [:cognitect.aws.iam.ServerCertificateMetadata/UploadDate
     :cognitect.aws.iam.ServerCertificateMetadata/Expiration]))

(s/def
  :cognitect.aws.iam/CreateLoginProfileResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateLoginProfileResponse/LoginProfile]))

(s/def
  :cognitect.aws.iam/privateKeyType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/PolicyDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.PolicyDetail/PolicyName :cognitect.aws.iam.PolicyDetail/PolicyDocument]))

(s/def
  :cognitect.aws.iam/policyDescriptionType
  (s/spec
    (s/and string? #(>= 1000 (count %)))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/TagRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagRoleRequest/RoleName :cognitect.aws.iam.TagRoleRequest/Tags]))

(s/def :cognitect.aws.iam/limitExceededMessage string?)

(s/def :cognitect.aws.iam/ListSAMLProvidersRequest (s/keys))

(s/def
  :cognitect.aws.iam/FeatureType
  (s/spec string? :gen #(s/gen #{"RootCredentialsManagement" "RootSessions"})))

(s/def
  :cognitect.aws.iam/listPolicyGrantingServiceAccessResponseListType
  (s/coll-of :cognitect.aws.iam/ListPoliciesGrantingServiceAccessEntry))

(s/def
  :cognitect.aws.iam/GetOpenIDConnectProviderRequest
  (s/keys :req-un [:cognitect.aws.iam.GetOpenIDConnectProviderRequest/OpenIDConnectProviderArn]))

(s/def :cognitect.aws.iam/policyEvaluationErrorMessage string?)

(s/def
  :cognitect.aws.iam/ListAttachedUserPoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListAttachedUserPoliciesRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.ListAttachedUserPoliciesRequest/PathPrefix
     :cognitect.aws.iam.ListAttachedUserPoliciesRequest/Marker
     :cognitect.aws.iam.ListAttachedUserPoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/PermissionsBoundaryAttachmentType
  (s/spec string? :gen #(s/gen #{"PermissionsBoundaryPolicy"})))

(s/def
  :cognitect.aws.iam/certificateBodyType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/GetServiceLinkedRoleDeletionStatusResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusResponse/Status]
    :opt-un
    [:cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusResponse/Reason]))

(s/def
  :cognitect.aws.iam/RoleUsageType
  (s/keys
    :opt-un
    [:cognitect.aws.iam.RoleUsageType/Resources :cognitect.aws.iam.RoleUsageType/Region]))

(s/def :cognitect.aws.iam/ListOpenIDConnectProvidersRequest (s/keys))

(s/def
  :cognitect.aws.iam/TagServerCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagServerCertificateRequest/ServerCertificateName
     :cognitect.aws.iam.TagServerCertificateRequest/Tags]))

(s/def
  :cognitect.aws.iam/UploadServerCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UploadServerCertificateRequest/ServerCertificateName
     :cognitect.aws.iam.UploadServerCertificateRequest/CertificateBody
     :cognitect.aws.iam.UploadServerCertificateRequest/PrivateKey]
    :opt-un
    [:cognitect.aws.iam.UploadServerCertificateRequest/Path
     :cognitect.aws.iam.UploadServerCertificateRequest/Tags
     :cognitect.aws.iam.UploadServerCertificateRequest/CertificateChain]))

(s/def
  :cognitect.aws.iam/GetGroupPolicyResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetGroupPolicyResponse/GroupName
     :cognitect.aws.iam.GetGroupPolicyResponse/PolicyName
     :cognitect.aws.iam.GetGroupPolicyResponse/PolicyDocument]))

(s/def
  :cognitect.aws.iam/summaryKeyType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AccountMFAEnabled"
        "VersionsPerPolicyQuota"
        "PolicySizeQuota"
        "AccountPasswordPresent"
        "ServerCertificates"
        "AccessKeysPerUserQuota"
        "GroupsQuota"
        "AttachedPoliciesPerRoleQuota"
        "SigningCertificatesPerUserQuota"
        "GroupPolicySizeQuota"
        "PolicyVersionsInUse"
        "UserPolicySizeQuota"
        "MFADevicesInUse"
        "Users"
        "Groups"
        "AccountSigningCertificatesPresent"
        "Policies"
        "AttachedPoliciesPerGroupQuota"
        "UsersQuota"
        "PoliciesQuota"
        "ServerCertificatesQuota"
        "AccountAccessKeysPresent"
        "GlobalEndpointTokenVersion"
        "GroupsPerUserQuota"
        "MFADevices"
        "AttachedPoliciesPerUserQuota"
        "PolicyVersionsInUseQuota"})))

(s/def :cognitect.aws.iam/ArnListType (s/coll-of :cognitect.aws.iam/arnType))

(s/def
  :cognitect.aws.iam/EntityDetails
  (s/keys
    :req-un
    [:cognitect.aws.iam.EntityDetails/EntityInfo]
    :opt-un
    [:cognitect.aws.iam.EntityDetails/LastAuthenticated]))

(s/def
  :cognitect.aws.iam/ColumnNumber
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iam/CertificationKeyType
  (s/spec #(re-matches (re-pattern "[\\u0020-\\u00FF]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/PolicyEvaluationDecisionType
  (s/spec string? :gen #(s/gen #{"implicitDeny" "allowed" "explicitDeny"})))

(s/def :cognitect.aws.iam/entityTemporarilyUnmodifiableMessage string?)

(s/def
  :cognitect.aws.iam/GetUserPolicyResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetUserPolicyResponse/UserName
     :cognitect.aws.iam.GetUserPolicyResponse/PolicyName
     :cognitect.aws.iam.GetUserPolicyResponse/PolicyDocument]))

(s/def
  :cognitect.aws.iam/DeleteOpenIDConnectProviderRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteOpenIDConnectProviderRequest/OpenIDConnectProviderArn]))

(s/def
  :cognitect.aws.iam/GetUserResponse
  (s/keys :req-un [:cognitect.aws.iam.GetUserResponse/User]))

(s/def
  :cognitect.aws.iam/ListAttachedGroupPoliciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListAttachedGroupPoliciesResponse/AttachedPolicies
     :cognitect.aws.iam.ListAttachedGroupPoliciesResponse/Marker
     :cognitect.aws.iam.ListAttachedGroupPoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ServiceFailureException
  (s/keys :opt-un [:cognitect.aws.iam.ServiceFailureException/message]))

(s/def
  :cognitect.aws.iam/UpdateSAMLProviderResponse
  (s/keys :opt-un [:cognitect.aws.iam.UpdateSAMLProviderResponse/SAMLProviderArn]))

(s/def
  :cognitect.aws.iam/DisableOrganizationsRootSessionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.DisableOrganizationsRootSessionsResponse/EnabledFeatures
     :cognitect.aws.iam.DisableOrganizationsRootSessionsResponse/OrganizationId]))

(s/def
  :cognitect.aws.iam/DeletionTaskStatusType
  (s/spec string? :gen #(s/gen #{"IN_PROGRESS" "NOT_STARTED" "SUCCEEDED" "FAILED"})))

(s/def
  :cognitect.aws.iam/SigningCertificate
  (s/keys
    :req-un
    [:cognitect.aws.iam.SigningCertificate/UserName
     :cognitect.aws.iam.SigningCertificate/CertificateId
     :cognitect.aws.iam.SigningCertificate/CertificateBody
     :cognitect.aws.iam.SigningCertificate/Status]
    :opt-un
    [:cognitect.aws.iam.SigningCertificate/UploadDate]))

(s/def
  :cognitect.aws.iam/MalformedCertificateException
  (s/keys :opt-un [:cognitect.aws.iam.MalformedCertificateException/message]))

(s/def
  :cognitect.aws.iam/ResourceSpecificResultListType
  (s/coll-of :cognitect.aws.iam/ResourceSpecificResult))

(s/def
  :cognitect.aws.iam/SimulationPolicyListType
  (s/coll-of :cognitect.aws.iam/policyDocumentType))

(s/def
  :cognitect.aws.iam/ServiceNotSupportedException
  (s/keys :opt-un [:cognitect.aws.iam.ServiceNotSupportedException/message]))

(s/def :cognitect.aws.iam/groupDetailListType (s/coll-of :cognitect.aws.iam/GroupDetail))

(s/def :cognitect.aws.iam/StatementListType (s/coll-of :cognitect.aws.iam/Statement))

(s/def
  :cognitect.aws.iam/AttachRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AttachRolePolicyRequest/RoleName
     :cognitect.aws.iam.AttachRolePolicyRequest/PolicyArn]))

(s/def :cognitect.aws.iam/serviceFailureExceptionMessage string?)

(s/def
  :cognitect.aws.iam/EnableOrganizationsRootCredentialsManagementResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.EnableOrganizationsRootCredentialsManagementResponse/EnabledFeatures
     :cognitect.aws.iam.EnableOrganizationsRootCredentialsManagementResponse/OrganizationId]))

(s/def
  :cognitect.aws.iam/GetPolicyVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetPolicyVersionRequest/PolicyArn
     :cognitect.aws.iam.GetPolicyVersionRequest/VersionId]))

(s/def
  :cognitect.aws.iam/PutUserPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.PutUserPolicyRequest/UserName
     :cognitect.aws.iam.PutUserPolicyRequest/PolicyName
     :cognitect.aws.iam.PutUserPolicyRequest/PolicyDocument]))

(s/def
  :cognitect.aws.iam/ActionNameType
  (s/spec
    (s/and string? #(<= 3 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/GetSSHPublicKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetSSHPublicKeyRequest/UserName
     :cognitect.aws.iam.GetSSHPublicKeyRequest/SSHPublicKeyId
     :cognitect.aws.iam.GetSSHPublicKeyRequest/Encoding]))

(s/def
  :cognitect.aws.iam/ContextKeyTypeEnum
  (s/spec
    string?
    :gen
    #(s/gen
      #{"boolean"
        "numeric"
        "booleanList"
        "string"
        "binaryList"
        "ipList"
        "binary"
        "numericList"
        "ip"
        "dateList"
        "date"
        "stringList"})))

(s/def
  :cognitect.aws.iam/ListOpenIDConnectProviderTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/OpenIDConnectProviderArn]
    :opt-un
    [:cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/Marker
     :cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/ListPolicyVersionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListPolicyVersionsResponse/Versions
     :cognitect.aws.iam.ListPolicyVersionsResponse/Marker
     :cognitect.aws.iam.ListPolicyVersionsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/DeleteInstanceProfileRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteInstanceProfileRequest/InstanceProfileName]))

(s/def
  :cognitect.aws.iam/ListAttachedGroupPoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListAttachedGroupPoliciesRequest/GroupName]
    :opt-un
    [:cognitect.aws.iam.ListAttachedGroupPoliciesRequest/PathPrefix
     :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/Marker
     :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/globalEndpointTokenVersion
  (s/spec string? :gen #(s/gen #{"v2Token" "v1Token"})))

(s/def
  :cognitect.aws.iam/CreateSAMLProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.CreateSAMLProviderResponse/Tags
     :cognitect.aws.iam.CreateSAMLProviderResponse/SAMLProviderArn]))

(s/def
  :cognitect.aws.iam/CreatePolicyResponse
  (s/keys :opt-un [:cognitect.aws.iam.CreatePolicyResponse/Policy]))

(s/def
  :cognitect.aws.iam/CreateVirtualMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateVirtualMFADeviceRequest/VirtualMFADeviceName]
    :opt-un
    [:cognitect.aws.iam.CreateVirtualMFADeviceRequest/Path
     :cognitect.aws.iam.CreateVirtualMFADeviceRequest/Tags]))

(s/def
  :cognitect.aws.iam/policyNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/CreateServiceLinkedRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateServiceLinkedRoleRequest/AWSServiceName]
    :opt-un
    [:cognitect.aws.iam.CreateServiceLinkedRoleRequest/CustomSuffix
     :cognitect.aws.iam.CreateServiceLinkedRoleRequest/Description]))

(s/def
  :cognitect.aws.iam/UpdateServiceSpecificCredentialRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/ServiceSpecificCredentialId
     :cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/Status]
    :opt-un
    [:cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/UserName]))

(s/def :cognitect.aws.iam/groupListType (s/coll-of :cognitect.aws.iam/Group))

(s/def
  :cognitect.aws.iam/DuplicateCertificateException
  (s/keys :opt-un [:cognitect.aws.iam.DuplicateCertificateException/message]))

(s/def :cognitect.aws.iam/invalidPublicKeyMessage string?)

(s/def
  :cognitect.aws.iam/ListInstanceProfilesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfilesRequest/PathPrefix
     :cognitect.aws.iam.ListInstanceProfilesRequest/Marker
     :cognitect.aws.iam.ListInstanceProfilesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/UpdateAccessKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateAccessKeyRequest/AccessKeyId
     :cognitect.aws.iam.UpdateAccessKeyRequest/Status]
    :opt-un
    [:cognitect.aws.iam.UpdateAccessKeyRequest/UserName]))

(s/def
  :cognitect.aws.iam/GetServiceLastAccessedDetailsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobStatus
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobCreationDate
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/ServicesLastAccessed
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobCompletionDate]
    :opt-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobType
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/Marker
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/IsTruncated
     :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/Error]))

(s/def
  :cognitect.aws.iam/ContextKeyNameType
  (s/spec
    (s/and string? #(<= 5 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 5 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/CreateGroupResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateGroupResponse/Group]))

(s/def
  :cognitect.aws.iam/ChangePasswordRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ChangePasswordRequest/OldPassword
     :cognitect.aws.iam.ChangePasswordRequest/NewPassword]))

(s/def
  :cognitect.aws.iam/roleMaxSessionDurationType
  (s/spec (s/and int? #(<= 3600 % 43200)) :gen #(gen/choose 3600 43200)))

(s/def
  :cognitect.aws.iam/GenerateServiceLastAccessedDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GenerateServiceLastAccessedDetailsRequest/Arn]
    :opt-un
    [:cognitect.aws.iam.GenerateServiceLastAccessedDetailsRequest/Granularity]))

(s/def
  :cognitect.aws.iam/ListGroupsForUserResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListGroupsForUserResponse/Groups]
    :opt-un
    [:cognitect.aws.iam.ListGroupsForUserResponse/Marker
     :cognitect.aws.iam.ListGroupsForUserResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/GetRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetRolePolicyRequest/RoleName
     :cognitect.aws.iam.GetRolePolicyRequest/PolicyName]))

(s/def :cognitect.aws.iam/DisableOrganizationsRootSessionsRequest (s/keys))

(s/def
  :cognitect.aws.iam/BootstrapDatum
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.iam/UpdateAssumeRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateAssumeRolePolicyRequest/RoleName
     :cognitect.aws.iam.UpdateAssumeRolePolicyRequest/PolicyDocument]))

(s/def
  :cognitect.aws.iam/SetDefaultPolicyVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.SetDefaultPolicyVersionRequest/PolicyArn
     :cognitect.aws.iam.SetDefaultPolicyVersionRequest/VersionId]))

(s/def
  :cognitect.aws.iam/ListUserTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListUserTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListUserTagsResponse/Marker
     :cognitect.aws.iam.ListUserTagsResponse/IsTruncated]))

(s/def :cognitect.aws.iam/tagListType (s/coll-of :cognitect.aws.iam/Tag :max-count 50))

(s/def :cognitect.aws.iam/certificateListType (s/coll-of :cognitect.aws.iam/SigningCertificate))

(s/def
  :cognitect.aws.iam/ListServerCertificateTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListServerCertificateTagsRequest/ServerCertificateName]
    :opt-un
    [:cognitect.aws.iam.ListServerCertificateTagsRequest/Marker
     :cognitect.aws.iam.ListServerCertificateTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/GetMFADeviceResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetMFADeviceResponse/SerialNumber]
    :opt-un
    [:cognitect.aws.iam.GetMFADeviceResponse/Certifications
     :cognitect.aws.iam.GetMFADeviceResponse/UserName
     :cognitect.aws.iam.GetMFADeviceResponse/EnableDate]))

(s/def
  :cognitect.aws.iam/DeletionTaskFailureReasonType
  (s/keys
    :opt-un
    [:cognitect.aws.iam.DeletionTaskFailureReasonType/RoleUsageList
     :cognitect.aws.iam.DeletionTaskFailureReasonType/Reason]))

(s/def :cognitect.aws.iam/userListType (s/coll-of :cognitect.aws.iam/User))

(s/def
  :cognitect.aws.iam/InvalidUserTypeException
  (s/keys :opt-un [:cognitect.aws.iam.InvalidUserTypeException/message]))

(s/def
  :cognitect.aws.iam/GetOrganizationsAccessReportResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobStatus
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobCreationDate]
    :opt-un
    [:cognitect.aws.iam.GetOrganizationsAccessReportResponse/Marker
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/AccessDetails
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/IsTruncated
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobCompletionDate
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/NumberOfServicesNotAccessed
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/ErrorDetails
     :cognitect.aws.iam.GetOrganizationsAccessReportResponse/NumberOfServicesAccessible]))

(s/def :cognitect.aws.iam/virtualMFADeviceListType (s/coll-of :cognitect.aws.iam/VirtualMFADevice))

(s/def
  :cognitect.aws.iam/summaryMapType
  (s/map-of :cognitect.aws.iam/summaryKeyType :cognitect.aws.iam/summaryValueType))

(s/def :cognitect.aws.iam/userDetailListType (s/coll-of :cognitect.aws.iam/UserDetail))

(s/def
  :cognitect.aws.iam/ReportGenerationLimitExceededException
  (s/keys :opt-un [:cognitect.aws.iam.ReportGenerationLimitExceededException/message]))

(s/def
  :cognitect.aws.iam/VirtualMFADevice
  (s/keys
    :req-un
    [:cognitect.aws.iam.VirtualMFADevice/SerialNumber]
    :opt-un
    [:cognitect.aws.iam.VirtualMFADevice/Tags
     :cognitect.aws.iam.VirtualMFADevice/User
     :cognitect.aws.iam.VirtualMFADevice/QRCodePNG
     :cognitect.aws.iam.VirtualMFADevice/Base32StringSeed
     :cognitect.aws.iam.VirtualMFADevice/EnableDate]))

(s/def
  :cognitect.aws.iam/accessKeyIdType
  (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/PolicyNotAttachableException
  (s/keys :opt-un [:cognitect.aws.iam.PolicyNotAttachableException/message]))

(s/def
  :cognitect.aws.iam/EntityType
  (s/spec string? :gen #(s/gen #{"LocalManagedPolicy" "User" "Role" "AWSManagedPolicy" "Group"})))

(s/def :cognitect.aws.iam/invalidCertificateMessage string?)

(s/def
  :cognitect.aws.iam/ErrorDetails
  (s/keys :req-un [:cognitect.aws.iam.ErrorDetails/Message :cognitect.aws.iam.ErrorDetails/Code]))

(s/def
  :cognitect.aws.iam/GetServerCertificateRequest
  (s/keys :req-un [:cognitect.aws.iam.GetServerCertificateRequest/ServerCertificateName]))

(s/def
  :cognitect.aws.iam/ReportContentType
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def
  :cognitect.aws.iam/GetSAMLProviderRequest
  (s/keys :req-un [:cognitect.aws.iam.GetSAMLProviderRequest/SAMLProviderArn]))

(s/def
  :cognitect.aws.iam/OpenIdIdpCommunicationErrorException
  (s/keys :opt-un [:cognitect.aws.iam.OpenIdIdpCommunicationErrorException/message]))

(s/def
  :cognitect.aws.iam/UpdateOpenIDConnectProviderThumbprintRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateOpenIDConnectProviderThumbprintRequest/OpenIDConnectProviderArn
     :cognitect.aws.iam.UpdateOpenIDConnectProviderThumbprintRequest/ThumbprintList]))

(s/def
  :cognitect.aws.iam/UntagSAMLProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagSAMLProviderRequest/SAMLProviderArn
     :cognitect.aws.iam.UntagSAMLProviderRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/ListAccountAliasesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListAccountAliasesRequest/Marker
     :cognitect.aws.iam.ListAccountAliasesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/EntityAlreadyExistsException
  (s/keys :opt-un [:cognitect.aws.iam.EntityAlreadyExistsException/message]))

(s/def
  :cognitect.aws.iam/AttachUserPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AttachUserPolicyRequest/UserName
     :cognitect.aws.iam.AttachUserPolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/SimulatePolicyResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.SimulatePolicyResponse/Marker
     :cognitect.aws.iam.SimulatePolicyResponse/EvaluationResults
     :cognitect.aws.iam.SimulatePolicyResponse/IsTruncated]))

(s/def :cognitect.aws.iam/credentialReportExpiredExceptionMessage string?)

(s/def
  :cognitect.aws.iam/ListRolesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListRolesResponse/Roles]
    :opt-un
    [:cognitect.aws.iam.ListRolesResponse/Marker :cognitect.aws.iam.ListRolesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/UploadSSHPublicKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UploadSSHPublicKeyRequest/UserName
     :cognitect.aws.iam.UploadSSHPublicKeyRequest/SSHPublicKeyBody]))

(s/def
  :cognitect.aws.iam/AccessKeyLastUsed
  (s/keys
    :req-un
    [:cognitect.aws.iam.AccessKeyLastUsed/ServiceName :cognitect.aws.iam.AccessKeyLastUsed/Region]
    :opt-un
    [:cognitect.aws.iam.AccessKeyLastUsed/LastUsedDate]))

(s/def
  :cognitect.aws.iam/summaryValueType
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iam/DeleteSAMLProviderRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteSAMLProviderRequest/SAMLProviderArn]))

(s/def :cognitect.aws.iam/PolicyGroupListType (s/coll-of :cognitect.aws.iam/PolicyGroup))

(s/def :cognitect.aws.iam/accountAliasListType (s/coll-of :cognitect.aws.iam/accountAliasType))

(s/def :cognitect.aws.iam/entityAlreadyExistsMessage string?)

(s/def
  :cognitect.aws.iam/GenerateOrganizationsAccessReportRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GenerateOrganizationsAccessReportRequest/EntityPath]
    :opt-un
    [:cognitect.aws.iam.GenerateOrganizationsAccessReportRequest/OrganizationsPolicyId]))

(s/def
  :cognitect.aws.iam/ListSSHPublicKeysRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListSSHPublicKeysRequest/Marker
     :cognitect.aws.iam.ListSSHPublicKeysRequest/UserName
     :cognitect.aws.iam.ListSSHPublicKeysRequest/MaxItems]))

(s/def :cognitect.aws.iam/booleanObjectType boolean?)

(s/def :cognitect.aws.iam/duplicateSSHPublicKeyMessage string?)

(s/def
  :cognitect.aws.iam/InstanceProfile
  (s/keys
    :req-un
    [:cognitect.aws.iam.InstanceProfile/Path
     :cognitect.aws.iam.InstanceProfile/InstanceProfileName
     :cognitect.aws.iam.InstanceProfile/InstanceProfileId
     :cognitect.aws.iam.InstanceProfile/Arn
     :cognitect.aws.iam.InstanceProfile/CreateDate
     :cognitect.aws.iam.InstanceProfile/Roles]
    :opt-un
    [:cognitect.aws.iam.InstanceProfile/Tags]))

(s/def
  :cognitect.aws.iam/DisableOrganizationsRootCredentialsManagementResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.DisableOrganizationsRootCredentialsManagementResponse/EnabledFeatures
     :cognitect.aws.iam.DisableOrganizationsRootCredentialsManagementResponse/OrganizationId]))

(s/def
  :cognitect.aws.iam/GetServerCertificateResponse
  (s/keys :req-un [:cognitect.aws.iam.GetServerCertificateResponse/ServerCertificate]))

(s/def
  :cognitect.aws.iam/DeleteVirtualMFADeviceRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteVirtualMFADeviceRequest/SerialNumber]))

(s/def :cognitect.aws.iam/attachedPoliciesListType (s/coll-of :cognitect.aws.iam/AttachedPolicy))

(s/def
  :cognitect.aws.iam/ListUserPoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListUserPoliciesRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.ListUserPoliciesRequest/Marker
     :cognitect.aws.iam.ListUserPoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/integerType
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iam/PutRolePermissionsBoundaryRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.PutRolePermissionsBoundaryRequest/RoleName
     :cognitect.aws.iam.PutRolePermissionsBoundaryRequest/PermissionsBoundary]))

(s/def
  :cognitect.aws.iam/TagUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagUserRequest/UserName :cognitect.aws.iam.TagUserRequest/Tags]))

(s/def
  :cognitect.aws.iam/organizationsPolicyIdType
  (s/spec #(re-matches (re-pattern "^p-[0-9a-zA-Z_]{8,128}$") %) :gen #(gen/string)))

(s/def :cognitect.aws.iam/unrecognizedPublicKeyEncodingMessage string?)

(s/def :cognitect.aws.iam/reportGenerationLimitExceededMessage string?)

(s/def
  :cognitect.aws.iam/UpdateSigningCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateSigningCertificateRequest/CertificateId
     :cognitect.aws.iam.UpdateSigningCertificateRequest/Status]
    :opt-un
    [:cognitect.aws.iam.UpdateSigningCertificateRequest/UserName]))

(s/def
  :cognitect.aws.iam/maxPasswordAgeType
  (s/spec (s/and int? #(<= 1 % 1095)) :gen #(gen/choose 1 1095)))

(s/def :cognitect.aws.iam/passwordPolicyViolationMessage string?)

(s/def
  :cognitect.aws.iam/SSHPublicKeyMetadata
  (s/keys
    :req-un
    [:cognitect.aws.iam.SSHPublicKeyMetadata/UserName
     :cognitect.aws.iam.SSHPublicKeyMetadata/SSHPublicKeyId
     :cognitect.aws.iam.SSHPublicKeyMetadata/Status
     :cognitect.aws.iam.SSHPublicKeyMetadata/UploadDate]))

(s/def
  :cognitect.aws.iam/GetSAMLProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetSAMLProviderResponse/PrivateKeyList
     :cognitect.aws.iam.GetSAMLProviderResponse/AssertionEncryptionMode
     :cognitect.aws.iam.GetSAMLProviderResponse/CreateDate
     :cognitect.aws.iam.GetSAMLProviderResponse/Tags
     :cognitect.aws.iam.GetSAMLProviderResponse/SAMLMetadataDocument
     :cognitect.aws.iam.GetSAMLProviderResponse/SAMLProviderUUID
     :cognitect.aws.iam.GetSAMLProviderResponse/ValidUntil]))

(s/def :cognitect.aws.iam/UpdateRoleResponse (s/keys))

(s/def
  :cognitect.aws.iam/passwordType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/LoginProfile
  (s/keys
    :req-un
    [:cognitect.aws.iam.LoginProfile/UserName :cognitect.aws.iam.LoginProfile/CreateDate]
    :opt-un
    [:cognitect.aws.iam.LoginProfile/PasswordResetRequired]))

(s/def :cognitect.aws.iam/instanceProfileListType (s/coll-of :cognitect.aws.iam/InstanceProfile))

(s/def
  :cognitect.aws.iam/serviceSpecificCredentialId
  (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/PolicySourceType
  (s/spec
    string?
    :gen
    #(s/gen #{"user-managed" "role" "resource" "none" "group" "user" "aws-managed"})))

(s/def
  :cognitect.aws.iam/UntagServerCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagServerCertificateRequest/ServerCertificateName
     :cognitect.aws.iam.UntagServerCertificateRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/DeleteAccessKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteAccessKeyRequest/AccessKeyId]
    :opt-un
    [:cognitect.aws.iam.DeleteAccessKeyRequest/UserName]))

(s/def
  :cognitect.aws.iam/ResourceHandlingOptionType
  (s/spec
    (s/and string? #(<= 1 (count %) 64))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 64) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/SAMLProviderListEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iam.SAMLProviderListEntry/CreateDate
     :cognitect.aws.iam.SAMLProviderListEntry/Arn
     :cognitect.aws.iam.SAMLProviderListEntry/ValidUntil]))

(s/def :cognitect.aws.iam/entityListType (s/coll-of :cognitect.aws.iam/EntityType))

(s/def
  :cognitect.aws.iam/RemoveUserFromGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.RemoveUserFromGroupRequest/GroupName
     :cognitect.aws.iam.RemoveUserFromGroupRequest/UserName]))

(s/def
  :cognitect.aws.iam/existingUserNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/PutGroupPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.PutGroupPolicyRequest/GroupName
     :cognitect.aws.iam.PutGroupPolicyRequest/PolicyName
     :cognitect.aws.iam.PutGroupPolicyRequest/PolicyDocument]))

(s/def
  :cognitect.aws.iam/ListMFADeviceTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListMFADeviceTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListMFADeviceTagsResponse/Marker
     :cognitect.aws.iam.ListMFADeviceTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/CreateRoleResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateRoleResponse/Role]))

(s/def
  :cognitect.aws.iam/CreateOpenIDConnectProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.CreateOpenIDConnectProviderResponse/Tags
     :cognitect.aws.iam.CreateOpenIDConnectProviderResponse/OpenIDConnectProviderArn]))

(s/def
  :cognitect.aws.iam/ListServiceSpecificCredentialsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListServiceSpecificCredentialsRequest/UserName
     :cognitect.aws.iam.ListServiceSpecificCredentialsRequest/ServiceName]))

(s/def
  :cognitect.aws.iam/DeleteServiceSpecificCredentialRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteServiceSpecificCredentialRequest/ServiceSpecificCredentialId]
    :opt-un
    [:cognitect.aws.iam.DeleteServiceSpecificCredentialRequest/UserName]))

(s/def :cognitect.aws.iam/encodingType (s/spec string? :gen #(s/gen #{"PEM" "SSH"})))

(s/def
  :cognitect.aws.iam/thumbprintType
  (s/spec
    (s/and string? #(<= 40 (count %) 40))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 40 40) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/policyDocumentType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/PermissionsBoundaryDecisionDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.PermissionsBoundaryDecisionDetail/AllowedByPermissionsBoundary]))

(s/def :cognitect.aws.iam/OrganizationNotFoundException (s/keys))

(s/def
  :cognitect.aws.iam/MFADevice
  (s/keys
    :req-un
    [:cognitect.aws.iam.MFADevice/UserName
     :cognitect.aws.iam.MFADevice/SerialNumber
     :cognitect.aws.iam.MFADevice/EnableDate]))

(s/def
  :cognitect.aws.iam/GetAccountSummaryResponse
  (s/keys :opt-un [:cognitect.aws.iam.GetAccountSummaryResponse/SummaryMap]))

(s/def
  :cognitect.aws.iam/UpdateRoleDescriptionResponse
  (s/keys :opt-un [:cognitect.aws.iam.UpdateRoleDescriptionResponse/Role]))

(s/def
  :cognitect.aws.iam/groupNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListServerCertificateTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListServerCertificateTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListServerCertificateTagsResponse/Marker
     :cognitect.aws.iam.ListServerCertificateTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListUserTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListUserTagsRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.ListUserTagsRequest/Marker
     :cognitect.aws.iam.ListUserTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/TrackedActionsLastAccessed
  (s/coll-of :cognitect.aws.iam/TrackedActionLastAccessed))

(s/def :cognitect.aws.iam/ActionNameListType (s/coll-of :cognitect.aws.iam/ActionNameType))

(s/def
  :cognitect.aws.iam/entityNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/CredentialReportNotReadyException
  (s/keys :opt-un [:cognitect.aws.iam.CredentialReportNotReadyException/message]))

(s/def
  :cognitect.aws.iam/SAMLMetadataDocumentType
  (s/spec
    (s/and string? #(<= 1000 (count %) 10000000))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 1000 10000000) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.iam/EnableOrganizationsRootCredentialsManagementRequest (s/keys))

(s/def
  :cognitect.aws.iam/publicKeyMaterialType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u00FF]+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/SetSecurityTokenServicePreferencesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.SetSecurityTokenServicePreferencesRequest/GlobalEndpointTokenVersion]))

(s/def :cognitect.aws.iam/AccessDetails (s/coll-of :cognitect.aws.iam/AccessDetail))

(s/def
  :cognitect.aws.iam/ListPoliciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListPoliciesResponse/Marker
     :cognitect.aws.iam.ListPoliciesResponse/IsTruncated
     :cognitect.aws.iam.ListPoliciesResponse/Policies]))

(s/def
  :cognitect.aws.iam/EvaluationResult
  (s/keys
    :req-un
    [:cognitect.aws.iam.EvaluationResult/EvalActionName
     :cognitect.aws.iam.EvaluationResult/EvalDecision]
    :opt-un
    [:cognitect.aws.iam.EvaluationResult/MissingContextValues
     :cognitect.aws.iam.EvaluationResult/PermissionsBoundaryDecisionDetail
     :cognitect.aws.iam.EvaluationResult/MatchedStatements
     :cognitect.aws.iam.EvaluationResult/EvalDecisionDetails
     :cognitect.aws.iam.EvaluationResult/OrganizationsDecisionDetail
     :cognitect.aws.iam.EvaluationResult/EvalResourceName
     :cognitect.aws.iam.EvaluationResult/ResourceSpecificResults]))

(s/def
  :cognitect.aws.iam/DetachGroupPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DetachGroupPolicyRequest/GroupName
     :cognitect.aws.iam.DetachGroupPolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/ServiceSpecificCredential
  (s/keys
    :req-un
    [:cognitect.aws.iam.ServiceSpecificCredential/CreateDate
     :cognitect.aws.iam.ServiceSpecificCredential/ServiceName
     :cognitect.aws.iam.ServiceSpecificCredential/ServiceUserName
     :cognitect.aws.iam.ServiceSpecificCredential/ServicePassword
     :cognitect.aws.iam.ServiceSpecificCredential/ServiceSpecificCredentialId
     :cognitect.aws.iam.ServiceSpecificCredential/UserName
     :cognitect.aws.iam.ServiceSpecificCredential/Status]))

(s/def
  :cognitect.aws.iam/policyPathType
  (s/spec #(re-matches (re-pattern "((/[A-Za-z0-9\\.,\\+@=_-]+)*)/") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/EvalDecisionDetailsType
  (s/map-of
    :cognitect.aws.iam/EvalDecisionSourceType
    :cognitect.aws.iam/PolicyEvaluationDecisionType))

(s/def
  :cognitect.aws.iam/organizationsEntityPathType
  (s/spec
    #(re-matches (re-pattern "^o-[0-9a-z]{10,32}\\/r-[0-9a-z]{4,32}[0-9a-z-\\/]*") %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.iam/noSuchEntityMessage string?)

(s/def
  :cognitect.aws.iam/GenerateServiceLastAccessedDetailsResponse
  (s/keys :opt-un [:cognitect.aws.iam.GenerateServiceLastAccessedDetailsResponse/JobId]))

(s/def
  :cognitect.aws.iam/ServerCertificate
  (s/keys
    :req-un
    [:cognitect.aws.iam.ServerCertificate/ServerCertificateMetadata
     :cognitect.aws.iam.ServerCertificate/CertificateBody]
    :opt-un
    [:cognitect.aws.iam.ServerCertificate/Tags
     :cognitect.aws.iam.ServerCertificate/CertificateChain]))

(s/def
  :cognitect.aws.iam/GetGroupResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetGroupResponse/Group :cognitect.aws.iam.GetGroupResponse/Users]
    :opt-un
    [:cognitect.aws.iam.GetGroupResponse/Marker :cognitect.aws.iam.GetGroupResponse/IsTruncated]))

(s/def :cognitect.aws.iam/booleanType boolean?)

(s/def :cognitect.aws.iam/tagKeyListType (s/coll-of :cognitect.aws.iam/tagKeyType :max-count 50))

(s/def :cognitect.aws.iam/ContextEntryListType (s/coll-of :cognitect.aws.iam/ContextEntry))

(s/def :cognitect.aws.iam/PolicyRoleListType (s/coll-of :cognitect.aws.iam/PolicyRole))

(s/def
  :cognitect.aws.iam/serviceNamespaceListType
  (s/coll-of :cognitect.aws.iam/serviceNamespaceType :min-count 1 :max-count 200))

(s/def
  :cognitect.aws.iam/OpenIDConnectProviderListEntry
  (s/keys :opt-un [:cognitect.aws.iam.OpenIDConnectProviderListEntry/Arn]))

(s/def :cognitect.aws.iam/credentialReportNotPresentExceptionMessage string?)

(s/def
  :cognitect.aws.iam/ListAttachedRolePoliciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListAttachedRolePoliciesResponse/AttachedPolicies
     :cognitect.aws.iam.ListAttachedRolePoliciesResponse/Marker
     :cognitect.aws.iam.ListAttachedRolePoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/TagOpenIDConnectProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagOpenIDConnectProviderRequest/OpenIDConnectProviderArn
     :cognitect.aws.iam.TagOpenIDConnectProviderRequest/Tags]))

(s/def :cognitect.aws.iam/idType (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/arnType
  (s/spec
    (s/and string? #(<= 20 (count %) 2048))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 20 2048) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/ListPoliciesGrantingServiceAccessEntry
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListPoliciesGrantingServiceAccessEntry/Policies
     :cognitect.aws.iam.ListPoliciesGrantingServiceAccessEntry/ServiceNamespace]))

(s/def
  :cognitect.aws.iam/ManagedPolicyDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ManagedPolicyDetail/PermissionsBoundaryUsageCount
     :cognitect.aws.iam.ManagedPolicyDetail/PolicyName
     :cognitect.aws.iam.ManagedPolicyDetail/Path
     :cognitect.aws.iam.ManagedPolicyDetail/CreateDate
     :cognitect.aws.iam.ManagedPolicyDetail/AttachmentCount
     :cognitect.aws.iam.ManagedPolicyDetail/IsAttachable
     :cognitect.aws.iam.ManagedPolicyDetail/DefaultVersionId
     :cognitect.aws.iam.ManagedPolicyDetail/PolicyId
     :cognitect.aws.iam.ManagedPolicyDetail/Description
     :cognitect.aws.iam.ManagedPolicyDetail/UpdateDate
     :cognitect.aws.iam.ManagedPolicyDetail/Arn
     :cognitect.aws.iam.ManagedPolicyDetail/PolicyVersionList]))

(s/def :cognitect.aws.iam/policyDetailListType (s/coll-of :cognitect.aws.iam/PolicyDetail))

(s/def
  :cognitect.aws.iam/OpenIDConnectProviderListType
  (s/coll-of :cognitect.aws.iam/OpenIDConnectProviderListEntry))

(s/def
  :cognitect.aws.iam/CreateServiceLinkedRoleResponse
  (s/keys :opt-un [:cognitect.aws.iam.CreateServiceLinkedRoleResponse/Role]))

(s/def
  :cognitect.aws.iam/UpdateSAMLProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateSAMLProviderRequest/SAMLProviderArn]
    :opt-un
    [:cognitect.aws.iam.UpdateSAMLProviderRequest/AssertionEncryptionMode
     :cognitect.aws.iam.UpdateSAMLProviderRequest/SAMLMetadataDocument
     :cognitect.aws.iam.UpdateSAMLProviderRequest/AddPrivateKey
     :cognitect.aws.iam.UpdateSAMLProviderRequest/RemovePrivateKey]))

(s/def
  :cognitect.aws.iam/DeleteGroupPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteGroupPolicyRequest/GroupName
     :cognitect.aws.iam.DeleteGroupPolicyRequest/PolicyName]))

(s/def
  :cognitect.aws.iam/ServiceSpecificCredentialMetadata
  (s/keys
    :req-un
    [:cognitect.aws.iam.ServiceSpecificCredentialMetadata/UserName
     :cognitect.aws.iam.ServiceSpecificCredentialMetadata/Status
     :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceUserName
     :cognitect.aws.iam.ServiceSpecificCredentialMetadata/CreateDate
     :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceSpecificCredentialId
     :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceName]))

(s/def
  :cognitect.aws.iam/CreateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateGroupRequest/GroupName]
    :opt-un
    [:cognitect.aws.iam.CreateGroupRequest/Path]))

(s/def
  :cognitect.aws.iam/UpdateGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateGroupRequest/GroupName]
    :opt-un
    [:cognitect.aws.iam.UpdateGroupRequest/NewPath
     :cognitect.aws.iam.UpdateGroupRequest/NewGroupName]))

(s/def
  :cognitect.aws.iam/ListGroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListGroupsRequest/PathPrefix
     :cognitect.aws.iam.ListGroupsRequest/Marker
     :cognitect.aws.iam.ListGroupsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/DeleteUserRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteUserRequest/UserName]))

(s/def
  :cognitect.aws.iam/serviceNamespaceType
  (s/spec #(re-matches (re-pattern "[\\w-]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListInstanceProfileTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListInstanceProfileTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfileTagsResponse/Marker
     :cognitect.aws.iam.ListInstanceProfileTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/User
  (s/keys
    :req-un
    [:cognitect.aws.iam.User/Path
     :cognitect.aws.iam.User/UserName
     :cognitect.aws.iam.User/UserId
     :cognitect.aws.iam.User/Arn
     :cognitect.aws.iam.User/CreateDate]
    :opt-un
    [:cognitect.aws.iam.User/Tags
     :cognitect.aws.iam.User/PermissionsBoundary
     :cognitect.aws.iam.User/PasswordLastUsed]))

(s/def
  :cognitect.aws.iam/ContextKeyNamesResultListType
  (s/coll-of :cognitect.aws.iam/ContextKeyNameType))

(s/def
  :cognitect.aws.iam/UploadSSHPublicKeyResponse
  (s/keys :opt-un [:cognitect.aws.iam.UploadSSHPublicKeyResponse/SSHPublicKey]))

(s/def
  :cognitect.aws.iam/ListOpenIDConnectProviderTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/Marker
     :cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/GetAccountPasswordPolicyResponse
  (s/keys :req-un [:cognitect.aws.iam.GetAccountPasswordPolicyResponse/PasswordPolicy]))

(s/def :cognitect.aws.iam/entityDetailsListType (s/coll-of :cognitect.aws.iam/EntityDetails))

(s/def :cognitect.aws.iam/DisableOrganizationsRootCredentialsManagementRequest (s/keys))

(s/def
  :cognitect.aws.iam/clientIDType
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/markerType
  (s/spec #(re-matches (re-pattern "[\\u0020-\\u00FF]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/AccessKeyMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.iam.AccessKeyMetadata/CreateDate
     :cognitect.aws.iam.AccessKeyMetadata/Status
     :cognitect.aws.iam.AccessKeyMetadata/UserName
     :cognitect.aws.iam.AccessKeyMetadata/AccessKeyId]))

(s/def
  :cognitect.aws.iam/tagValueType
  (s/spec #(re-matches (re-pattern "[\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/accessKeyMetadataListType
  (s/coll-of :cognitect.aws.iam/AccessKeyMetadata))

(s/def
  :cognitect.aws.iam/UserDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.UserDetail/Path
     :cognitect.aws.iam.UserDetail/CreateDate
     :cognitect.aws.iam.UserDetail/GroupList
     :cognitect.aws.iam.UserDetail/UserId
     :cognitect.aws.iam.UserDetail/Tags
     :cognitect.aws.iam.UserDetail/PermissionsBoundary
     :cognitect.aws.iam.UserDetail/UserName
     :cognitect.aws.iam.UserDetail/Arn
     :cognitect.aws.iam.UserDetail/UserPolicyList
     :cognitect.aws.iam.UserDetail/AttachedManagedPolicies]))

(s/def
  :cognitect.aws.iam/CreateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateUserRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.CreateUserRequest/Path
     :cognitect.aws.iam.CreateUserRequest/Tags
     :cognitect.aws.iam.CreateUserRequest/PermissionsBoundary]))

(s/def
  :cognitect.aws.iam/UploadServerCertificateResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.UploadServerCertificateResponse/ServerCertificateMetadata
     :cognitect.aws.iam.UploadServerCertificateResponse/Tags]))

(s/def
  :cognitect.aws.iam/serverCertificateMetadataListType
  (s/coll-of :cognitect.aws.iam/ServerCertificateMetadata))

(s/def :cognitect.aws.iam/SAMLProviderListType (s/coll-of :cognitect.aws.iam/SAMLProviderListEntry))

(s/def
  :cognitect.aws.iam/EvalDecisionSourceType
  (s/spec
    (s/and string? #(<= 3 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 3 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/GetServiceLastAccessedDetailsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/JobId]
    :opt-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/Marker
     :cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/CreateVirtualMFADeviceResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateVirtualMFADeviceResponse/VirtualMFADevice]))

(s/def :cognitect.aws.iam/SSHPublicKeyListType (s/coll-of :cognitect.aws.iam/SSHPublicKeyMetadata))

(s/def
  :cognitect.aws.iam/ListSAMLProvidersResponse
  (s/keys :opt-un [:cognitect.aws.iam.ListSAMLProvidersResponse/SAMLProviderList]))

(s/def
  :cognitect.aws.iam/policyDocumentVersionListType
  (s/coll-of :cognitect.aws.iam/PolicyVersion))

(s/def
  :cognitect.aws.iam/ListUserPoliciesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListUserPoliciesResponse/PolicyNames]
    :opt-un
    [:cognitect.aws.iam.ListUserPoliciesResponse/Marker
     :cognitect.aws.iam.ListUserPoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/CreateInstanceProfileResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateInstanceProfileResponse/InstanceProfile]))

(s/def
  :cognitect.aws.iam/CredentialReportExpiredException
  (s/keys :opt-un [:cognitect.aws.iam.CredentialReportExpiredException/message]))

(s/def :cognitect.aws.iam/ContextKeyValueType string?)

(s/def
  :cognitect.aws.iam/GetRoleRequest
  (s/keys :req-un [:cognitect.aws.iam.GetRoleRequest/RoleName]))

(s/def
  :cognitect.aws.iam/UntagMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagMFADeviceRequest/SerialNumber
     :cognitect.aws.iam.UntagMFADeviceRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/policyGrantingServiceAccessListType
  (s/coll-of :cognitect.aws.iam/PolicyGrantingServiceAccess))

(s/def
  :cognitect.aws.iam/ListServerCertificatesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListServerCertificatesResponse/ServerCertificateMetadataList]
    :opt-un
    [:cognitect.aws.iam.ListServerCertificatesResponse/Marker
     :cognitect.aws.iam.ListServerCertificatesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/UntagRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagRoleRequest/RoleName :cognitect.aws.iam.UntagRoleRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/GetOrganizationsAccessReportRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetOrganizationsAccessReportRequest/JobId]
    :opt-un
    [:cognitect.aws.iam.GetOrganizationsAccessReportRequest/SortKey
     :cognitect.aws.iam.GetOrganizationsAccessReportRequest/Marker
     :cognitect.aws.iam.GetOrganizationsAccessReportRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/roleDescriptionType
  (s/spec
    #(re-matches (re-pattern "[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u00A1-\\u00FF]*") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/ResyncMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ResyncMFADeviceRequest/UserName
     :cognitect.aws.iam.ResyncMFADeviceRequest/SerialNumber
     :cognitect.aws.iam.ResyncMFADeviceRequest/AuthenticationCode1
     :cognitect.aws.iam.ResyncMFADeviceRequest/AuthenticationCode2]))

(s/def
  :cognitect.aws.iam/ListInstanceProfilesForRoleResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListInstanceProfilesForRoleResponse/InstanceProfiles]
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfilesForRoleResponse/Marker
     :cognitect.aws.iam.ListInstanceProfilesForRoleResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/GetGroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetGroupRequest/GroupName]
    :opt-un
    [:cognitect.aws.iam.GetGroupRequest/Marker :cognitect.aws.iam.GetGroupRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/AttachedPolicy
  (s/keys
    :opt-un
    [:cognitect.aws.iam.AttachedPolicy/PolicyName :cognitect.aws.iam.AttachedPolicy/PolicyArn]))

(s/def
  :cognitect.aws.iam/privateKeyIdType
  (s/spec #(re-matches (re-pattern "[A-Z0-9]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListPoliciesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListPoliciesRequest/PathPrefix
     :cognitect.aws.iam.ListPoliciesRequest/Marker
     :cognitect.aws.iam.ListPoliciesRequest/PolicyUsageFilter
     :cognitect.aws.iam.ListPoliciesRequest/MaxItems
     :cognitect.aws.iam.ListPoliciesRequest/OnlyAttached
     :cognitect.aws.iam.ListPoliciesRequest/Scope]))

(s/def
  :cognitect.aws.iam/GetContextKeysForCustomPolicyRequest
  (s/keys :req-un [:cognitect.aws.iam.GetContextKeysForCustomPolicyRequest/PolicyInputList]))

(s/def
  :cognitect.aws.iam/CreateRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateRoleRequest/RoleName
     :cognitect.aws.iam.CreateRoleRequest/AssumeRolePolicyDocument]
    :opt-un
    [:cognitect.aws.iam.CreateRoleRequest/Path
     :cognitect.aws.iam.CreateRoleRequest/Tags
     :cognitect.aws.iam.CreateRoleRequest/PermissionsBoundary
     :cognitect.aws.iam.CreateRoleRequest/Description
     :cognitect.aws.iam.CreateRoleRequest/MaxSessionDuration]))

(s/def
  :cognitect.aws.iam/GetLoginProfileRequest
  (s/keys :opt-un [:cognitect.aws.iam.GetLoginProfileRequest/UserName]))

(s/def
  :cognitect.aws.iam/DuplicateSSHPublicKeyException
  (s/keys :opt-un [:cognitect.aws.iam.DuplicateSSHPublicKeyException/message]))

(s/def :cognitect.aws.iam/policyType (s/spec string? :gen #(s/gen #{"MANAGED" "INLINE"})))

(s/def :cognitect.aws.iam/deleteConflictMessage string?)

(s/def
  :cognitect.aws.iam/GetMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetMFADeviceRequest/SerialNumber]
    :opt-un
    [:cognitect.aws.iam.GetMFADeviceRequest/UserName]))

(s/def
  :cognitect.aws.iam/CreateAccessKeyResponse
  (s/keys :req-un [:cognitect.aws.iam.CreateAccessKeyResponse/AccessKey]))

(s/def
  :cognitect.aws.iam/jobStatusType
  (s/spec string? :gen #(s/gen #{"COMPLETED" "IN_PROGRESS" "FAILED"})))

(s/def
  :cognitect.aws.iam/ReportStateType
  (s/spec string? :gen #(s/gen #{"COMPLETE" "INPROGRESS" "STARTED"})))

(s/def :cognitect.aws.iam/FeaturesListType (s/coll-of :cognitect.aws.iam/FeatureType))

(s/def
  :cognitect.aws.iam/GetServiceLastAccessedDetailsWithEntitiesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobStatus
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobCreationDate
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobCompletionDate
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/EntityDetailsList]
    :opt-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/Marker
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/IsTruncated
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/Error]))

(s/def
  :cognitect.aws.iam/SimulatePrincipalPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.SimulatePrincipalPolicyRequest/PolicySourceArn
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ActionNames]
    :opt-un
    [:cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceHandlingOption
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourcePolicy
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/Marker
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceArns
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ContextEntries
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/PolicyInputList
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/PermissionsBoundaryPolicyInputList
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceOwner
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/MaxItems
     :cognitect.aws.iam.SimulatePrincipalPolicyRequest/CallerArn]))

(s/def
  :cognitect.aws.iam/UpdateUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateUserRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.UpdateUserRequest/NewPath
     :cognitect.aws.iam.UpdateUserRequest/NewUserName]))

(s/def :cognitect.aws.iam/ConcurrentModificationMessage string?)

(s/def
  :cognitect.aws.iam/ResetServiceSpecificCredentialResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ResetServiceSpecificCredentialResponse/ServiceSpecificCredential]))

(s/def
  :cognitect.aws.iam/GetContextKeysForPrincipalPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetContextKeysForPrincipalPolicyRequest/PolicySourceArn]
    :opt-un
    [:cognitect.aws.iam.GetContextKeysForPrincipalPolicyRequest/PolicyInputList]))

(s/def
  :cognitect.aws.iam/EnableMFADeviceRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.EnableMFADeviceRequest/UserName
     :cognitect.aws.iam.EnableMFADeviceRequest/SerialNumber
     :cognitect.aws.iam.EnableMFADeviceRequest/AuthenticationCode1
     :cognitect.aws.iam.EnableMFADeviceRequest/AuthenticationCode2]))

(s/def
  :cognitect.aws.iam/UntagOpenIDConnectProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagOpenIDConnectProviderRequest/OpenIDConnectProviderArn
     :cognitect.aws.iam.UntagOpenIDConnectProviderRequest/TagKeys]))

(s/def :cognitect.aws.iam/policyScopeType (s/spec string? :gen #(s/gen #{"AWS" "Local" "All"})))

(s/def
  :cognitect.aws.iam/SimulateCustomPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.SimulateCustomPolicyRequest/PolicyInputList
     :cognitect.aws.iam.SimulateCustomPolicyRequest/ActionNames]
    :opt-un
    [:cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceHandlingOption
     :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourcePolicy
     :cognitect.aws.iam.SimulateCustomPolicyRequest/Marker
     :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceArns
     :cognitect.aws.iam.SimulateCustomPolicyRequest/ContextEntries
     :cognitect.aws.iam.SimulateCustomPolicyRequest/PermissionsBoundaryPolicyInputList
     :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceOwner
     :cognitect.aws.iam.SimulateCustomPolicyRequest/MaxItems
     :cognitect.aws.iam.SimulateCustomPolicyRequest/CallerArn]))

(s/def
  :cognitect.aws.iam/assertionEncryptionModeType
  (s/spec string? :gen #(s/gen #{"Required" "Allowed"})))

(s/def
  :cognitect.aws.iam/ListGroupPoliciesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListGroupPoliciesResponse/PolicyNames]
    :opt-un
    [:cognitect.aws.iam.ListGroupPoliciesResponse/Marker
     :cognitect.aws.iam.ListGroupPoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/AddRoleToInstanceProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AddRoleToInstanceProfileRequest/InstanceProfileName
     :cognitect.aws.iam.AddRoleToInstanceProfileRequest/RoleName]))

(s/def :cognitect.aws.iam/EnableOrganizationsRootSessionsRequest (s/keys))

(s/def :cognitect.aws.iam/clientIDListType (s/coll-of :cognitect.aws.iam/clientIDType))

(s/def
  :cognitect.aws.iam/UpdateSSHPublicKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateSSHPublicKeyRequest/UserName
     :cognitect.aws.iam.UpdateSSHPublicKeyRequest/SSHPublicKeyId
     :cognitect.aws.iam.UpdateSSHPublicKeyRequest/Status]))

(s/def
  :cognitect.aws.iam/ResourceSpecificResult
  (s/keys
    :req-un
    [:cognitect.aws.iam.ResourceSpecificResult/EvalResourceName
     :cognitect.aws.iam.ResourceSpecificResult/EvalResourceDecision]
    :opt-un
    [:cognitect.aws.iam.ResourceSpecificResult/MissingContextValues
     :cognitect.aws.iam.ResourceSpecificResult/PermissionsBoundaryDecisionDetail
     :cognitect.aws.iam.ResourceSpecificResult/MatchedStatements
     :cognitect.aws.iam.ResourceSpecificResult/EvalDecisionDetails]))

(s/def
  :cognitect.aws.iam/GetLoginProfileResponse
  (s/keys :req-un [:cognitect.aws.iam.GetLoginProfileResponse/LoginProfile]))

(s/def
  :cognitect.aws.iam/GetPolicyResponse
  (s/keys :opt-un [:cognitect.aws.iam.GetPolicyResponse/Policy]))

(s/def
  :cognitect.aws.iam/GetAccessKeyLastUsedRequest
  (s/keys :req-un [:cognitect.aws.iam.GetAccessKeyLastUsedRequest/AccessKeyId]))

(s/def
  :cognitect.aws.iam/attachmentCountType
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iam/GetServiceLastAccessedDetailsWithEntitiesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/JobId
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/ServiceNamespace]
    :opt-un
    [:cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/Marker
     :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/CreateLoginProfileRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.CreateLoginProfileRequest/Password
     :cognitect.aws.iam.CreateLoginProfileRequest/UserName
     :cognitect.aws.iam.CreateLoginProfileRequest/PasswordResetRequired]))

(s/def
  :cognitect.aws.iam/passwordReusePreventionType
  (s/spec (s/and int? #(<= 1 % 24)) :gen #(gen/choose 1 24)))

(s/def
  :cognitect.aws.iam/CreatePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreatePolicyRequest/PolicyName
     :cognitect.aws.iam.CreatePolicyRequest/PolicyDocument]
    :opt-un
    [:cognitect.aws.iam.CreatePolicyRequest/Path
     :cognitect.aws.iam.CreatePolicyRequest/Tags
     :cognitect.aws.iam.CreatePolicyRequest/Description]))

(s/def :cognitect.aws.iam/policyNameListType (s/coll-of :cognitect.aws.iam/policyNameType))

(s/def
  :cognitect.aws.iam/AccessDetail
  (s/keys
    :req-un
    [:cognitect.aws.iam.AccessDetail/ServiceName :cognitect.aws.iam.AccessDetail/ServiceNamespace]
    :opt-un
    [:cognitect.aws.iam.AccessDetail/EntityPath
     :cognitect.aws.iam.AccessDetail/LastAuthenticatedTime
     :cognitect.aws.iam.AccessDetail/TotalAuthenticatedEntities
     :cognitect.aws.iam.AccessDetail/Region]))

(s/def
  :cognitect.aws.iam/ListPolicyVersionsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListPolicyVersionsRequest/PolicyArn]
    :opt-un
    [:cognitect.aws.iam.ListPolicyVersionsRequest/Marker
     :cognitect.aws.iam.ListPolicyVersionsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/GetUserRequest
  (s/keys :opt-un [:cognitect.aws.iam.GetUserRequest/UserName]))

(s/def
  :cognitect.aws.iam/ListVirtualMFADevicesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListVirtualMFADevicesResponse/VirtualMFADevices]
    :opt-un
    [:cognitect.aws.iam.ListVirtualMFADevicesResponse/Marker
     :cognitect.aws.iam.ListVirtualMFADevicesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListSigningCertificatesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListSigningCertificatesResponse/Certificates]
    :opt-un
    [:cognitect.aws.iam.ListSigningCertificatesResponse/Marker
     :cognitect.aws.iam.ListSigningCertificatesResponse/IsTruncated]))

(s/def :cognitect.aws.iam/ResourceNameListType (s/coll-of :cognitect.aws.iam/ResourceNameType))

(s/def
  :cognitect.aws.iam/RoleDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.RoleDetail/RoleId
     :cognitect.aws.iam.RoleDetail/InstanceProfileList
     :cognitect.aws.iam.RoleDetail/AssumeRolePolicyDocument
     :cognitect.aws.iam.RoleDetail/Path
     :cognitect.aws.iam.RoleDetail/RoleName
     :cognitect.aws.iam.RoleDetail/CreateDate
     :cognitect.aws.iam.RoleDetail/RolePolicyList
     :cognitect.aws.iam.RoleDetail/Tags
     :cognitect.aws.iam.RoleDetail/PermissionsBoundary
     :cognitect.aws.iam.RoleDetail/RoleLastUsed
     :cognitect.aws.iam.RoleDetail/Arn
     :cognitect.aws.iam.RoleDetail/AttachedManagedPolicies]))

(s/def
  :cognitect.aws.iam/pathPrefixType
  (s/spec #(re-matches (re-pattern "\\u002F[\\u0021-\\u007F]*") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ServiceLastAccessed
  (s/keys
    :req-un
    [:cognitect.aws.iam.ServiceLastAccessed/ServiceName
     :cognitect.aws.iam.ServiceLastAccessed/ServiceNamespace]
    :opt-un
    [:cognitect.aws.iam.ServiceLastAccessed/TrackedActionsLastAccessed
     :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticatedEntity
     :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticatedRegion
     :cognitect.aws.iam.ServiceLastAccessed/TotalAuthenticatedEntities
     :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticated]))

(s/def
  :cognitect.aws.iam/PasswordPolicyViolationException
  (s/keys :opt-un [:cognitect.aws.iam.PasswordPolicyViolationException/message]))

(s/def
  :cognitect.aws.iam/EntityInfo
  (s/keys
    :req-un
    [:cognitect.aws.iam.EntityInfo/Arn
     :cognitect.aws.iam.EntityInfo/Name
     :cognitect.aws.iam.EntityInfo/Type
     :cognitect.aws.iam.EntityInfo/Id]
    :opt-un
    [:cognitect.aws.iam.EntityInfo/Path]))

(s/def :cognitect.aws.iam/serviceNotSupportedMessage string?)

(s/def
  :cognitect.aws.iam/RoleLastUsed
  (s/keys
    :opt-un
    [:cognitect.aws.iam.RoleLastUsed/LastUsedDate :cognitect.aws.iam.RoleLastUsed/Region]))

(s/def
  :cognitect.aws.iam/GetPolicyVersionResponse
  (s/keys :opt-un [:cognitect.aws.iam.GetPolicyVersionResponse/PolicyVersion]))

(s/def
  :cognitect.aws.iam/UntagPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagPolicyRequest/PolicyArn
     :cognitect.aws.iam.UntagPolicyRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/InvalidCertificateException
  (s/keys :opt-un [:cognitect.aws.iam.InvalidCertificateException/message]))

(s/def :cognitect.aws.iam/OrganizationNotInAllFeaturesModeException (s/keys))

(s/def :cognitect.aws.iam/statusType (s/spec string? :gen #(s/gen #{"Active" "Inactive"})))

(s/def
  :cognitect.aws.iam/AttachGroupPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.AttachGroupPolicyRequest/GroupName
     :cognitect.aws.iam.AttachGroupPolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/UploadSigningCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UploadSigningCertificateRequest/CertificateBody]
    :opt-un
    [:cognitect.aws.iam.UploadSigningCertificateRequest/UserName]))

(s/def
  :cognitect.aws.iam/RemoveClientIDFromOpenIDConnectProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.RemoveClientIDFromOpenIDConnectProviderRequest/OpenIDConnectProviderArn
     :cognitect.aws.iam.RemoveClientIDFromOpenIDConnectProviderRequest/ClientID]))

(s/def
  :cognitect.aws.iam/accountAliasType
  (s/spec
    #(re-matches (re-pattern "^[a-z0-9]([a-z0-9]|-(?!-)){1,61}[a-z0-9]$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.iam/DeleteConflictException
  (s/keys :opt-un [:cognitect.aws.iam.DeleteConflictException/message]))

(s/def
  :cognitect.aws.iam/ContextKeyValueListType
  (s/coll-of :cognitect.aws.iam/ContextKeyValueType))

(s/def
  :cognitect.aws.iam/AccessKey
  (s/keys
    :req-un
    [:cognitect.aws.iam.AccessKey/UserName
     :cognitect.aws.iam.AccessKey/AccessKeyId
     :cognitect.aws.iam.AccessKey/Status
     :cognitect.aws.iam.AccessKey/SecretAccessKey]
    :opt-un
    [:cognitect.aws.iam.AccessKey/CreateDate]))

(s/def
  :cognitect.aws.iam/policyVersionIdType
  (s/spec #(re-matches (re-pattern "v[1-9][0-9]*(\\.[A-Za-z0-9-]*)?") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ResetServiceSpecificCredentialRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ResetServiceSpecificCredentialRequest/ServiceSpecificCredentialId]
    :opt-un
    [:cognitect.aws.iam.ResetServiceSpecificCredentialRequest/UserName]))

(s/def
  :cognitect.aws.iam/RegionNameType
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.iam/roleDetailListType (s/coll-of :cognitect.aws.iam/RoleDetail))

(s/def
  :cognitect.aws.iam/NoSuchEntityException
  (s/keys :opt-un [:cognitect.aws.iam.NoSuchEntityException/message]))

(s/def
  :cognitect.aws.iam/DeleteLoginProfileRequest
  (s/keys :opt-un [:cognitect.aws.iam.DeleteLoginProfileRequest/UserName]))

(s/def
  :cognitect.aws.iam/ManagedPolicyDetailListType
  (s/coll-of :cognitect.aws.iam/ManagedPolicyDetail))

(s/def
  :cognitect.aws.iam/UploadSigningCertificateResponse
  (s/keys :req-un [:cognitect.aws.iam.UploadSigningCertificateResponse/Certificate]))

(s/def
  :cognitect.aws.iam/ListMFADevicesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListMFADevicesResponse/MFADevices]
    :opt-un
    [:cognitect.aws.iam.ListMFADevicesResponse/Marker
     :cognitect.aws.iam.ListMFADevicesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListOpenIDConnectProvidersResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListOpenIDConnectProvidersResponse/OpenIDConnectProviderList]))

(s/def
  :cognitect.aws.iam/PolicyVersion
  (s/keys
    :opt-un
    [:cognitect.aws.iam.PolicyVersion/VersionId
     :cognitect.aws.iam.PolicyVersion/CreateDate
     :cognitect.aws.iam.PolicyVersion/IsDefaultVersion
     :cognitect.aws.iam.PolicyVersion/Document]))

(s/def
  :cognitect.aws.iam/CreatePolicyVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreatePolicyVersionRequest/PolicyArn
     :cognitect.aws.iam.CreatePolicyVersionRequest/PolicyDocument]
    :opt-un
    [:cognitect.aws.iam.CreatePolicyVersionRequest/SetAsDefault]))

(s/def
  :cognitect.aws.iam/ListEntitiesForPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListEntitiesForPolicyRequest/PolicyArn]
    :opt-un
    [:cognitect.aws.iam.ListEntitiesForPolicyRequest/PathPrefix
     :cognitect.aws.iam.ListEntitiesForPolicyRequest/Marker
     :cognitect.aws.iam.ListEntitiesForPolicyRequest/PolicyUsageFilter
     :cognitect.aws.iam.ListEntitiesForPolicyRequest/MaxItems
     :cognitect.aws.iam.ListEntitiesForPolicyRequest/EntityFilter]))

(s/def :cognitect.aws.iam/openIdIdpCommunicationErrorExceptionMessage string?)

(s/def :cognitect.aws.iam/serviceName string?)

(s/def
  :cognitect.aws.iam/ListRolePoliciesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListRolePoliciesResponse/PolicyNames]
    :opt-un
    [:cognitect.aws.iam.ListRolePoliciesResponse/Marker
     :cognitect.aws.iam.ListRolePoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/PasswordPolicy
  (s/keys
    :opt-un
    [:cognitect.aws.iam.PasswordPolicy/MinimumPasswordLength
     :cognitect.aws.iam.PasswordPolicy/RequireNumbers
     :cognitect.aws.iam.PasswordPolicy/RequireUppercaseCharacters
     :cognitect.aws.iam.PasswordPolicy/HardExpiry
     :cognitect.aws.iam.PasswordPolicy/ExpirePasswords
     :cognitect.aws.iam.PasswordPolicy/RequireLowercaseCharacters
     :cognitect.aws.iam.PasswordPolicy/RequireSymbols
     :cognitect.aws.iam.PasswordPolicy/AllowUsersToChangePassword
     :cognitect.aws.iam.PasswordPolicy/MaxPasswordAge
     :cognitect.aws.iam.PasswordPolicy/PasswordReusePrevention]))

(s/def
  :cognitect.aws.iam/ListRolesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListRolesRequest/PathPrefix
     :cognitect.aws.iam.ListRolesRequest/Marker
     :cognitect.aws.iam.ListRolesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/PolicyGrantingServiceAccess
  (s/keys
    :req-un
    [:cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyName
     :cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyType]
    :opt-un
    [:cognitect.aws.iam.PolicyGrantingServiceAccess/EntityName
     :cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyArn
     :cognitect.aws.iam.PolicyGrantingServiceAccess/EntityType]))

(s/def
  :cognitect.aws.iam/ListRolePoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListRolePoliciesRequest/RoleName]
    :opt-un
    [:cognitect.aws.iam.ListRolePoliciesRequest/Marker
     :cognitect.aws.iam.ListRolePoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/policyOwnerEntityType
  (s/spec string? :gen #(s/gen #{"USER" "ROLE" "GROUP"})))

(s/def
  :cognitect.aws.iam/DeletePolicyRequest
  (s/keys :req-un [:cognitect.aws.iam.DeletePolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/ListUsersResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListUsersResponse/Users]
    :opt-un
    [:cognitect.aws.iam.ListUsersResponse/Marker :cognitect.aws.iam.ListUsersResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListGroupPoliciesRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListGroupPoliciesRequest/GroupName]
    :opt-un
    [:cognitect.aws.iam.ListGroupPoliciesRequest/Marker
     :cognitect.aws.iam.ListGroupPoliciesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/minimumPasswordLengthType
  (s/spec (s/and int? #(<= 6 % 128)) :gen #(gen/choose 6 128)))

(s/def
  :cognitect.aws.iam/UpdateServerCertificateRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateServerCertificateRequest/ServerCertificateName]
    :opt-un
    [:cognitect.aws.iam.UpdateServerCertificateRequest/NewPath
     :cognitect.aws.iam.UpdateServerCertificateRequest/NewServerCertificateName]))

(s/def
  :cognitect.aws.iam/userNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/UnrecognizedPublicKeyEncodingException
  (s/keys :opt-un [:cognitect.aws.iam.UnrecognizedPublicKeyEncodingException/message]))

(s/def
  :cognitect.aws.iam/CertificationMapType
  (s/map-of :cognitect.aws.iam/CertificationKeyType :cognitect.aws.iam/CertificationValueType))

(s/def
  :cognitect.aws.iam/UnmodifiableEntityException
  (s/keys :opt-un [:cognitect.aws.iam.UnmodifiableEntityException/message]))

(s/def
  :cognitect.aws.iam/CredentialReportNotPresentException
  (s/keys :opt-un [:cognitect.aws.iam.CredentialReportNotPresentException/message]))

(s/def
  :cognitect.aws.iam/ListUsersRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListUsersRequest/PathPrefix
     :cognitect.aws.iam.ListUsersRequest/Marker
     :cognitect.aws.iam.ListUsersRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/Role
  (s/keys
    :req-un
    [:cognitect.aws.iam.Role/Path
     :cognitect.aws.iam.Role/RoleName
     :cognitect.aws.iam.Role/RoleId
     :cognitect.aws.iam.Role/Arn
     :cognitect.aws.iam.Role/CreateDate]
    :opt-un
    [:cognitect.aws.iam.Role/AssumeRolePolicyDocument
     :cognitect.aws.iam.Role/Tags
     :cognitect.aws.iam.Role/PermissionsBoundary
     :cognitect.aws.iam.Role/RoleLastUsed
     :cognitect.aws.iam.Role/Description
     :cognitect.aws.iam.Role/MaxSessionDuration]))

(s/def
  :cognitect.aws.iam/instanceProfileNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/CreateSAMLProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateSAMLProviderRequest/SAMLMetadataDocument
     :cognitect.aws.iam.CreateSAMLProviderRequest/Name]
    :opt-un
    [:cognitect.aws.iam.CreateSAMLProviderRequest/AssertionEncryptionMode
     :cognitect.aws.iam.CreateSAMLProviderRequest/Tags
     :cognitect.aws.iam.CreateSAMLProviderRequest/AddPrivateKey]))

(s/def
  :cognitect.aws.iam/InvalidInputException
  (s/keys :opt-un [:cognitect.aws.iam.InvalidInputException/message]))

(s/def
  :cognitect.aws.iam/UpdateRoleRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateRoleRequest/RoleName]
    :opt-un
    [:cognitect.aws.iam.UpdateRoleRequest/Description
     :cognitect.aws.iam.UpdateRoleRequest/MaxSessionDuration]))

(s/def
  :cognitect.aws.iam/maxItemsType
  (s/spec (s/and int? #(<= 1 % 1000)) :gen #(gen/choose 1 1000)))

(s/def :cognitect.aws.iam/malformedPolicyDocumentMessage string?)

(s/def
  :cognitect.aws.iam/ListPoliciesGrantingServiceAccessResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/PoliciesGrantingServiceAccess]
    :opt-un
    [:cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/Marker
     :cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListVirtualMFADevicesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListVirtualMFADevicesRequest/AssignmentStatus
     :cognitect.aws.iam.ListVirtualMFADevicesRequest/Marker
     :cognitect.aws.iam.ListVirtualMFADevicesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/ListPolicyTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListPolicyTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListPolicyTagsResponse/Marker
     :cognitect.aws.iam.ListPolicyTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/ListInstanceProfilesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListInstanceProfilesResponse/InstanceProfiles]
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfilesResponse/Marker
     :cognitect.aws.iam.ListInstanceProfilesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/assignmentStatusType
  (s/spec string? :gen #(s/gen #{"Any" "Unassigned" "Assigned"})))

(s/def :cognitect.aws.iam/malformedCertificateMessage string?)

(s/def :cognitect.aws.iam/mfaDeviceListType (s/coll-of :cognitect.aws.iam/MFADevice))

(s/def
  :cognitect.aws.iam/DeleteServerCertificateRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteServerCertificateRequest/ServerCertificateName]))

(s/def :cognitect.aws.iam/duplicateCertificateMessage string?)

(s/def :cognitect.aws.iam/LineNumber (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.iam/InvalidPublicKeyException
  (s/keys :opt-un [:cognitect.aws.iam.InvalidPublicKeyException/message]))

(s/def
  :cognitect.aws.iam/DeleteUserPermissionsBoundaryRequest
  (s/keys :req-un [:cognitect.aws.iam.DeleteUserPermissionsBoundaryRequest/UserName]))

(s/def
  :cognitect.aws.iam/PolicyUser
  (s/keys :opt-un [:cognitect.aws.iam.PolicyUser/UserId :cognitect.aws.iam.PolicyUser/UserName]))

(s/def
  :cognitect.aws.iam/EnableOrganizationsRootSessionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.EnableOrganizationsRootSessionsResponse/EnabledFeatures
     :cognitect.aws.iam.EnableOrganizationsRootSessionsResponse/OrganizationId]))

(s/def
  :cognitect.aws.iam/roleNameType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.iam/policyListType (s/coll-of :cognitect.aws.iam/Policy))

(s/def
  :cognitect.aws.iam/OrganizationIdType
  (s/spec #(re-matches (re-pattern "^o-[a-z0-9]{10,32}$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListAttachedUserPoliciesResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListAttachedUserPoliciesResponse/AttachedPolicies
     :cognitect.aws.iam.ListAttachedUserPoliciesResponse/Marker
     :cognitect.aws.iam.ListAttachedUserPoliciesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/GetAccountAuthorizationDetailsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/Filter
     :cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/Marker
     :cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/Statement
  (s/keys
    :opt-un
    [:cognitect.aws.iam.Statement/SourcePolicyId
     :cognitect.aws.iam.Statement/EndPosition
     :cognitect.aws.iam.Statement/StartPosition
     :cognitect.aws.iam.Statement/SourcePolicyType]))

(s/def
  :cognitect.aws.iam/GetInstanceProfileResponse
  (s/keys :req-un [:cognitect.aws.iam.GetInstanceProfileResponse/InstanceProfile]))

(s/def
  :cognitect.aws.iam/TrackedActionLastAccessed
  (s/keys
    :opt-un
    [:cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedTime
     :cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedEntity
     :cognitect.aws.iam.TrackedActionLastAccessed/ActionName
     :cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedRegion]))

(s/def
  :cognitect.aws.iam/Position
  (s/keys :opt-un [:cognitect.aws.iam.Position/Line :cognitect.aws.iam.Position/Column]))

(s/def
  :cognitect.aws.iam/GroupDetail
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GroupDetail/Path
     :cognitect.aws.iam.GroupDetail/GroupPolicyList
     :cognitect.aws.iam.GroupDetail/CreateDate
     :cognitect.aws.iam.GroupDetail/GroupName
     :cognitect.aws.iam.GroupDetail/GroupId
     :cognitect.aws.iam.GroupDetail/Arn
     :cognitect.aws.iam.GroupDetail/AttachedManagedPolicies]))

(s/def :cognitect.aws.iam/unmodifiableEntityMessage string?)

(s/def
  :cognitect.aws.iam/CreateServiceSpecificCredentialRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateServiceSpecificCredentialRequest/UserName
     :cognitect.aws.iam.CreateServiceSpecificCredentialRequest/ServiceName]))

(s/def
  :cognitect.aws.iam/authenticationCodeType
  (s/spec #(re-matches (re-pattern "[\\d]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/ListGroupsForUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListGroupsForUserRequest/UserName]
    :opt-un
    [:cognitect.aws.iam.ListGroupsForUserRequest/Marker
     :cognitect.aws.iam.ListGroupsForUserRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/CreateAccountAliasRequest
  (s/keys :req-un [:cognitect.aws.iam.CreateAccountAliasRequest/AccountAlias]))

(s/def :cognitect.aws.iam/privateKeyList (s/coll-of :cognitect.aws.iam/SAMLPrivateKey :max-count 2))

(s/def :cognitect.aws.iam/accessKeySecretType string?)

(s/def
  :cognitect.aws.iam/GetCredentialReportResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetCredentialReportResponse/GeneratedTime
     :cognitect.aws.iam.GetCredentialReportResponse/ReportFormat
     :cognitect.aws.iam.GetCredentialReportResponse/Content]))

(s/def
  :cognitect.aws.iam/ListPolicyTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListPolicyTagsRequest/PolicyArn]
    :opt-un
    [:cognitect.aws.iam.ListPolicyTagsRequest/Marker
     :cognitect.aws.iam.ListPolicyTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/GetRolePolicyResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.GetRolePolicyResponse/RoleName
     :cognitect.aws.iam.GetRolePolicyResponse/PolicyName
     :cognitect.aws.iam.GetRolePolicyResponse/PolicyDocument]))

(s/def
  :cognitect.aws.iam/EntityTemporarilyUnmodifiableException
  (s/keys :opt-un [:cognitect.aws.iam.EntityTemporarilyUnmodifiableException/message]))

(s/def
  :cognitect.aws.iam/KeyPairMismatchException
  (s/keys :opt-un [:cognitect.aws.iam.KeyPairMismatchException/message]))

(s/def :cognitect.aws.iam/invalidAuthenticationCodeMessage string?)

(s/def
  :cognitect.aws.iam/GetOpenIDConnectProviderResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetOpenIDConnectProviderResponse/CreateDate
     :cognitect.aws.iam.GetOpenIDConnectProviderResponse/Tags
     :cognitect.aws.iam.GetOpenIDConnectProviderResponse/ThumbprintList
     :cognitect.aws.iam.GetOpenIDConnectProviderResponse/Url
     :cognitect.aws.iam.GetOpenIDConnectProviderResponse/ClientIDList]))

(s/def
  :cognitect.aws.iam/PolicyGroup
  (s/keys
    :opt-un
    [:cognitect.aws.iam.PolicyGroup/GroupName :cognitect.aws.iam.PolicyGroup/GroupId]))

(s/def
  :cognitect.aws.iam/serialNumberType
  (s/spec #(re-matches (re-pattern "[\\w+=/:,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/LimitExceededException
  (s/keys :opt-un [:cognitect.aws.iam.LimitExceededException/message]))

(s/def
  :cognitect.aws.iam/ListAccessKeysResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListAccessKeysResponse/AccessKeyMetadata]
    :opt-un
    [:cognitect.aws.iam.ListAccessKeysResponse/Marker
     :cognitect.aws.iam.ListAccessKeysResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/SSHPublicKey
  (s/keys
    :req-un
    [:cognitect.aws.iam.SSHPublicKey/UserName
     :cognitect.aws.iam.SSHPublicKey/SSHPublicKeyId
     :cognitect.aws.iam.SSHPublicKey/Fingerprint
     :cognitect.aws.iam.SSHPublicKey/SSHPublicKeyBody
     :cognitect.aws.iam.SSHPublicKey/Status]
    :opt-un
    [:cognitect.aws.iam.SSHPublicKey/UploadDate]))

(s/def
  :cognitect.aws.iam/UpdateRoleDescriptionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UpdateRoleDescriptionRequest/RoleName
     :cognitect.aws.iam.UpdateRoleDescriptionRequest/Description]))

(s/def :cognitect.aws.iam/credentialReportNotReadyExceptionMessage string?)

(s/def
  :cognitect.aws.iam/DeleteSSHPublicKeyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteSSHPublicKeyRequest/UserName
     :cognitect.aws.iam.DeleteSSHPublicKeyRequest/SSHPublicKeyId]))

(s/def
  :cognitect.aws.iam/CertificationValueType
  (s/spec #(re-matches (re-pattern "[\\u0020-\\u00FF]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/UntagUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.UntagUserRequest/UserName :cognitect.aws.iam.UntagUserRequest/TagKeys]))

(s/def
  :cognitect.aws.iam/AttachedPermissionsBoundary
  (s/keys
    :opt-un
    [:cognitect.aws.iam.AttachedPermissionsBoundary/PermissionsBoundaryArn
     :cognitect.aws.iam.AttachedPermissionsBoundary/PermissionsBoundaryType]))

(s/def
  :cognitect.aws.iam/DetachRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DetachRolePolicyRequest/RoleName
     :cognitect.aws.iam.DetachRolePolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/GetContextKeysForPolicyResponse
  (s/keys :opt-un [:cognitect.aws.iam.GetContextKeysForPolicyResponse/ContextKeyNames]))

(s/def
  :cognitect.aws.iam/PolicyUsageType
  (s/spec string? :gen #(s/gen #{"PermissionsPolicy" "PermissionsBoundary"})))

(s/def
  :cognitect.aws.iam/ListMFADevicesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListMFADevicesRequest/Marker
     :cognitect.aws.iam.ListMFADevicesRequest/UserName
     :cognitect.aws.iam.ListMFADevicesRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/ListMFADeviceTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListMFADeviceTagsRequest/SerialNumber]
    :opt-un
    [:cognitect.aws.iam.ListMFADeviceTagsRequest/Marker
     :cognitect.aws.iam.ListMFADeviceTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/GetAccountAuthorizationDetailsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/Marker
     :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/GroupDetailList
     :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/IsTruncated
     :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/RoleDetailList
     :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/Policies
     :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/UserDetailList]))

(s/def
  :cognitect.aws.iam/certificateIdType
  (s/spec #(re-matches (re-pattern "[\\w]+") %) :gen #(gen/string)))

(s/def :cognitect.aws.iam/responseMarkerType string?)

(s/def
  :cognitect.aws.iam/PutRolePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.PutRolePolicyRequest/RoleName
     :cognitect.aws.iam.PutRolePolicyRequest/PolicyName
     :cognitect.aws.iam.PutRolePolicyRequest/PolicyDocument]))

(s/def
  :cognitect.aws.iam/DeleteUserPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeleteUserPolicyRequest/UserName
     :cognitect.aws.iam.DeleteUserPolicyRequest/PolicyName]))

(s/def :cognitect.aws.iam/PolicyUserListType (s/coll-of :cognitect.aws.iam/PolicyUser))

(s/def
  :cognitect.aws.iam/ListInstanceProfileTagsRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListInstanceProfileTagsRequest/InstanceProfileName]
    :opt-un
    [:cognitect.aws.iam.ListInstanceProfileTagsRequest/Marker
     :cognitect.aws.iam.ListInstanceProfileTagsRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/GetPolicyRequest
  (s/keys :req-un [:cognitect.aws.iam.GetPolicyRequest/PolicyArn]))

(s/def
  :cognitect.aws.iam/ListAccountAliasesResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListAccountAliasesResponse/AccountAliases]
    :opt-un
    [:cognitect.aws.iam.ListAccountAliasesResponse/Marker
     :cognitect.aws.iam.ListAccountAliasesResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/CreateAccessKeyRequest
  (s/keys :opt-un [:cognitect.aws.iam.CreateAccessKeyRequest/UserName]))

(s/def
  :cognitect.aws.iam/TagPolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagPolicyRequest/PolicyArn :cognitect.aws.iam.TagPolicyRequest/Tags]))

(s/def
  :cognitect.aws.iam/DeletePolicyVersionRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.DeletePolicyVersionRequest/PolicyArn
     :cognitect.aws.iam.DeletePolicyVersionRequest/VersionId]))

(s/def :cognitect.aws.iam/CallerIsNotManagementAccountException (s/keys))

(s/def
  :cognitect.aws.iam/ServiceSpecificCredentialsListType
  (s/coll-of :cognitect.aws.iam/ServiceSpecificCredentialMetadata))

(s/def
  :cognitect.aws.iam/ListAccessKeysRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListAccessKeysRequest/Marker
     :cognitect.aws.iam.ListAccessKeysRequest/UserName
     :cognitect.aws.iam.ListAccessKeysRequest/MaxItems]))

(s/def
  :cognitect.aws.iam/sortKeyType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"SERVICE_NAMESPACE_ASCENDING"
        "LAST_AUTHENTICATED_TIME_ASCENDING"
        "LAST_AUTHENTICATED_TIME_DESCENDING"
        "SERVICE_NAMESPACE_DESCENDING"})))

(s/def
  :cognitect.aws.iam/CreateOpenIDConnectProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.CreateOpenIDConnectProviderRequest/Url]
    :opt-un
    [:cognitect.aws.iam.CreateOpenIDConnectProviderRequest/Tags
     :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/ThumbprintList
     :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/ClientIDList]))

(s/def
  :cognitect.aws.iam/GetAccessKeyLastUsedResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.GetAccessKeyLastUsedResponse/AccessKeyLastUsed
     :cognitect.aws.iam.GetAccessKeyLastUsedResponse/UserName]))

(s/def :cognitect.aws.iam/invalidUserTypeMessage string?)

(s/def
  :cognitect.aws.iam/Policy
  (s/keys
    :opt-un
    [:cognitect.aws.iam.Policy/PermissionsBoundaryUsageCount
     :cognitect.aws.iam.Policy/PolicyName
     :cognitect.aws.iam.Policy/Path
     :cognitect.aws.iam.Policy/CreateDate
     :cognitect.aws.iam.Policy/AttachmentCount
     :cognitect.aws.iam.Policy/IsAttachable
     :cognitect.aws.iam.Policy/Tags
     :cognitect.aws.iam.Policy/DefaultVersionId
     :cognitect.aws.iam.Policy/PolicyId
     :cognitect.aws.iam.Policy/Description
     :cognitect.aws.iam.Policy/UpdateDate
     :cognitect.aws.iam.Policy/Arn]))

(s/def :cognitect.aws.iam/RoleUsageListType (s/coll-of :cognitect.aws.iam/RoleUsageType))

(s/def
  :cognitect.aws.iam/ListSigningCertificatesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListSigningCertificatesRequest/Marker
     :cognitect.aws.iam.ListSigningCertificatesRequest/UserName
     :cognitect.aws.iam.ListSigningCertificatesRequest/MaxItems]))

(s/def :cognitect.aws.iam/servicePassword string?)

(s/def
  :cognitect.aws.iam/customSuffixType
  (s/spec #(re-matches (re-pattern "[\\w+=,.@-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/DeletionTaskIdType
  (s/spec
    (s/and string? #(<= 1 (count %) 1000))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1000) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/ListSSHPublicKeysResponse
  (s/keys
    :opt-un
    [:cognitect.aws.iam.ListSSHPublicKeysResponse/Marker
     :cognitect.aws.iam.ListSSHPublicKeysResponse/IsTruncated
     :cognitect.aws.iam.ListSSHPublicKeysResponse/SSHPublicKeys]))

(s/def
  :cognitect.aws.iam/ListRoleTagsResponse
  (s/keys
    :req-un
    [:cognitect.aws.iam.ListRoleTagsResponse/Tags]
    :opt-un
    [:cognitect.aws.iam.ListRoleTagsResponse/Marker
     :cognitect.aws.iam.ListRoleTagsResponse/IsTruncated]))

(s/def
  :cognitect.aws.iam/jobIDType
  (s/spec
    (s/and string? #(<= 36 (count %) 36))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 36 36) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam/InvalidAuthenticationCodeException
  (s/keys :opt-un [:cognitect.aws.iam.InvalidAuthenticationCodeException/message]))

(s/def
  :cognitect.aws.iam/TagInstanceProfileRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagInstanceProfileRequest/InstanceProfileName
     :cognitect.aws.iam.TagInstanceProfileRequest/Tags]))

(s/def :cognitect.aws.iam/ListOrganizationsFeaturesRequest (s/keys))

(s/def
  :cognitect.aws.iam/SAMLProviderNameType
  (s/spec #(re-matches (re-pattern "[\\w._-]+") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.iam/GetServiceLinkedRoleDeletionStatusRequest
  (s/keys :req-un [:cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusRequest/DeletionTaskId]))

(s/def :cognitect.aws.iam/stringType string?)

(s/def
  :cognitect.aws.iam/TagSAMLProviderRequest
  (s/keys
    :req-un
    [:cognitect.aws.iam.TagSAMLProviderRequest/SAMLProviderArn
     :cognitect.aws.iam.TagSAMLProviderRequest/Tags]))

(s/def
  :cognitect.aws.iam/OpenIDConnectProviderUrlType
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/PasswordReusePrevention
  :cognitect.aws.iam/passwordReusePreventionType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireNumbers
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/MaxPasswordAge
  :cognitect.aws.iam/maxPasswordAgeType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireLowercaseCharacters
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/MinimumPasswordLength
  :cognitect.aws.iam/minimumPasswordLengthType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireUppercaseCharacters
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/AllowUsersToChangePassword
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/RequireSymbols
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UpdateAccountPasswordPolicyRequest/HardExpiry
  :cognitect.aws.iam/booleanObjectType)

(s/def
  :cognitect.aws.iam.DeleteAccountAliasRequest/AccountAlias
  :cognitect.aws.iam/accountAliasType)

(s/def
  :cognitect.aws.iam.ListServerCertificatesRequest/PathPrefix
  :cognitect.aws.iam/pathPrefixType)

(s/def :cognitect.aws.iam.ListServerCertificatesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListServerCertificatesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetGroupPolicyRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.GetGroupPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.UntagInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.UntagInstanceProfileRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def
  :cognitect.aws.iam.DeleteRolePermissionsBoundaryRequest/RoleName
  :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.RemoveRoleFromInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def
  :cognitect.aws.iam.RemoveRoleFromInstanceProfileRequest/RoleName
  :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.TagMFADeviceRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.TagMFADeviceRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GetInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def
  :cognitect.aws.iam.CreateServiceSpecificCredentialResponse/ServiceSpecificCredential
  :cognitect.aws.iam/ServiceSpecificCredential)

(s/def
  :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyGroups
  :cognitect.aws.iam/PolicyGroupListType)

(s/def
  :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyUsers
  :cognitect.aws.iam/PolicyUserListType)

(s/def
  :cognitect.aws.iam.ListEntitiesForPolicyResponse/PolicyRoles
  :cognitect.aws.iam/PolicyRoleListType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListEntitiesForPolicyResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.Group/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.Group/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.Group/GroupId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.Group/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.Group/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetSSHPublicKeyResponse/SSHPublicKey :cognitect.aws.iam/SSHPublicKey)

(s/def
  :cognitect.aws.iam.ListServiceSpecificCredentialsResponse/ServiceSpecificCredentials
  :cognitect.aws.iam/ServiceSpecificCredentialsListType)

(s/def :cognitect.aws.iam.DetachUserPolicyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.DetachUserPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.DeleteSigningCertificateRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.DeleteSigningCertificateRequest/CertificateId
  :cognitect.aws.iam/certificateIdType)

(s/def
  :cognitect.aws.iam.PolicyEvaluationException/message
  :cognitect.aws.iam/policyEvaluationErrorMessage)

(s/def :cognitect.aws.iam.AddUserToGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.AddUserToGroupRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.CreateUserResponse/User :cognitect.aws.iam/User)

(s/def :cognitect.aws.iam.ListGroupsResponse/Groups :cognitect.aws.iam/groupListType)

(s/def :cognitect.aws.iam.ListGroupsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListGroupsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListOrganizationsFeaturesResponse/OrganizationId
  :cognitect.aws.iam/OrganizationIdType)

(s/def
  :cognitect.aws.iam.ListOrganizationsFeaturesResponse/EnabledFeatures
  :cognitect.aws.iam/FeaturesListType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesForRoleRequest/RoleName
  :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.ListInstanceProfilesForRoleRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesForRoleRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.PutUserPermissionsBoundaryRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.PutUserPermissionsBoundaryRequest/PermissionsBoundary
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.GetUserPolicyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.GetUserPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.UpdateLoginProfileRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.UpdateLoginProfileRequest/Password :cognitect.aws.iam/passwordType)

(s/def
  :cognitect.aws.iam.UpdateLoginProfileRequest/PasswordResetRequired
  :cognitect.aws.iam/booleanObjectType)

(s/def :cognitect.aws.iam.Tag/Key :cognitect.aws.iam/tagKeyType)

(s/def :cognitect.aws.iam.Tag/Value :cognitect.aws.iam/tagValueType)

(s/def
  :cognitect.aws.iam.DeleteServiceLinkedRoleResponse/DeletionTaskId
  :cognitect.aws.iam/DeletionTaskIdType)

(s/def :cognitect.aws.iam.ContextEntry/ContextKeyName :cognitect.aws.iam/ContextKeyNameType)

(s/def :cognitect.aws.iam.ContextEntry/ContextKeyValues :cognitect.aws.iam/ContextKeyValueListType)

(s/def :cognitect.aws.iam.ContextEntry/ContextKeyType :cognitect.aws.iam/ContextKeyTypeEnum)

(s/def
  :cognitect.aws.iam.CreateInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.CreateInstanceProfileRequest/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.CreateInstanceProfileRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GenerateOrganizationsAccessReportResponse/JobId
  :cognitect.aws.iam/jobIDType)

(s/def :cognitect.aws.iam.ListAttachedRolePoliciesRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.ListAttachedRolePoliciesRequest/PathPrefix
  :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.ListAttachedRolePoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListAttachedRolePoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.ListRoleTagsRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.ListRoleTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListRoleTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.PolicyRole/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.PolicyRole/RoleId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.DeleteServiceLinkedRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.CreatePolicyVersionResponse/PolicyVersion
  :cognitect.aws.iam/PolicyVersion)

(s/def :cognitect.aws.iam.DeleteRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.DeleteRolePolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.GenerateCredentialReportResponse/State :cognitect.aws.iam/ReportStateType)

(s/def
  :cognitect.aws.iam.GenerateCredentialReportResponse/Description
  :cognitect.aws.iam/ReportStateDescriptionType)

(s/def
  :cognitect.aws.iam.OrganizationsDecisionDetail/AllowedByOrganizations
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ConcurrentModificationException/message
  :cognitect.aws.iam/ConcurrentModificationMessage)

(s/def :cognitect.aws.iam.GetRoleResponse/Role :cognitect.aws.iam/Role)

(s/def
  :cognitect.aws.iam.DeactivateMFADeviceRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.DeactivateMFADeviceRequest/SerialNumber
  :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListSAMLProviderTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.DeleteGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.SAMLPrivateKey/KeyId :cognitect.aws.iam/privateKeyIdType)

(s/def :cognitect.aws.iam.SAMLPrivateKey/Timestamp :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.MalformedPolicyDocumentException/message
  :cognitect.aws.iam/malformedPolicyDocumentMessage)

(s/def :cognitect.aws.iam.DeleteRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.AddClientIDToOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.AddClientIDToOpenIDConnectProviderRequest/ClientID
  :cognitect.aws.iam/clientIDType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/Marker
  :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/Arn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessRequest/ServiceNamespaces
  :cognitect.aws.iam/serviceNamespaceListType)

(s/def :cognitect.aws.iam.ServerCertificateMetadata/Path :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.ServerCertificateMetadata/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.ServerCertificateMetadata/ServerCertificateId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.ServerCertificateMetadata/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ServerCertificateMetadata/UploadDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.ServerCertificateMetadata/Expiration :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.CreateLoginProfileResponse/LoginProfile :cognitect.aws.iam/LoginProfile)

(s/def :cognitect.aws.iam.PolicyDetail/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.PolicyDetail/PolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.TagRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.TagRoleRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GetOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListAttachedUserPoliciesRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.ListAttachedUserPoliciesRequest/PathPrefix
  :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.ListAttachedUserPoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListAttachedUserPoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusResponse/Status
  :cognitect.aws.iam/DeletionTaskStatusType)

(s/def
  :cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusResponse/Reason
  :cognitect.aws.iam/DeletionTaskFailureReasonType)

(s/def :cognitect.aws.iam.RoleUsageType/Region :cognitect.aws.iam/RegionNameType)

(s/def :cognitect.aws.iam.RoleUsageType/Resources :cognitect.aws.iam/ArnListType)

(s/def
  :cognitect.aws.iam.TagServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.TagServerCertificateRequest/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.UploadServerCertificateRequest/Path :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.UploadServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def
  :cognitect.aws.iam.UploadServerCertificateRequest/CertificateBody
  :cognitect.aws.iam/certificateBodyType)

(s/def
  :cognitect.aws.iam.UploadServerCertificateRequest/PrivateKey
  :cognitect.aws.iam/privateKeyType)

(s/def
  :cognitect.aws.iam.UploadServerCertificateRequest/CertificateChain
  :cognitect.aws.iam/certificateChainType)

(s/def :cognitect.aws.iam.UploadServerCertificateRequest/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.GetGroupPolicyResponse/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.GetGroupPolicyResponse/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.GetGroupPolicyResponse/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.EntityDetails/EntityInfo :cognitect.aws.iam/EntityInfo)

(s/def :cognitect.aws.iam.EntityDetails/LastAuthenticated :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetUserPolicyResponse/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.GetUserPolicyResponse/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.GetUserPolicyResponse/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def
  :cognitect.aws.iam.DeleteOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.GetUserResponse/User :cognitect.aws.iam/User)

(s/def
  :cognitect.aws.iam.ListAttachedGroupPoliciesResponse/AttachedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def
  :cognitect.aws.iam.ListAttachedGroupPoliciesResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListAttachedGroupPoliciesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ServiceFailureException/message
  :cognitect.aws.iam/serviceFailureExceptionMessage)

(s/def :cognitect.aws.iam.UpdateSAMLProviderResponse/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.DisableOrganizationsRootSessionsResponse/OrganizationId
  :cognitect.aws.iam/OrganizationIdType)

(s/def
  :cognitect.aws.iam.DisableOrganizationsRootSessionsResponse/EnabledFeatures
  :cognitect.aws.iam/FeaturesListType)

(s/def :cognitect.aws.iam.SigningCertificate/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.SigningCertificate/CertificateId :cognitect.aws.iam/certificateIdType)

(s/def :cognitect.aws.iam.SigningCertificate/CertificateBody :cognitect.aws.iam/certificateBodyType)

(s/def :cognitect.aws.iam.SigningCertificate/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.SigningCertificate/UploadDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.MalformedCertificateException/message
  :cognitect.aws.iam/malformedCertificateMessage)

(s/def
  :cognitect.aws.iam.ServiceNotSupportedException/message
  :cognitect.aws.iam/serviceNotSupportedMessage)

(s/def :cognitect.aws.iam.AttachRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.AttachRolePolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.EnableOrganizationsRootCredentialsManagementResponse/OrganizationId
  :cognitect.aws.iam/OrganizationIdType)

(s/def
  :cognitect.aws.iam.EnableOrganizationsRootCredentialsManagementResponse/EnabledFeatures
  :cognitect.aws.iam/FeaturesListType)

(s/def :cognitect.aws.iam.GetPolicyVersionRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.GetPolicyVersionRequest/VersionId :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.PutUserPolicyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.PutUserPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.PutUserPolicyRequest/PolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.GetSSHPublicKeyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.GetSSHPublicKeyRequest/SSHPublicKeyId :cognitect.aws.iam/publicKeyIdType)

(s/def :cognitect.aws.iam.GetSSHPublicKeyRequest/Encoding :cognitect.aws.iam/encodingType)

(s/def
  :cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.ListOpenIDConnectProviderTagsRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.ListPolicyVersionsResponse/Versions
  :cognitect.aws.iam/policyDocumentVersionListType)

(s/def :cognitect.aws.iam.ListPolicyVersionsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListPolicyVersionsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.DeleteInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def
  :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/GroupName
  :cognitect.aws.iam/groupNameType)

(s/def
  :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/PathPrefix
  :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListAttachedGroupPoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.CreateSAMLProviderResponse/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.CreateSAMLProviderResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.CreatePolicyResponse/Policy :cognitect.aws.iam/Policy)

(s/def :cognitect.aws.iam.CreateVirtualMFADeviceRequest/Path :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.CreateVirtualMFADeviceRequest/VirtualMFADeviceName
  :cognitect.aws.iam/virtualMFADeviceName)

(s/def :cognitect.aws.iam.CreateVirtualMFADeviceRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.CreateServiceLinkedRoleRequest/AWSServiceName
  :cognitect.aws.iam/groupNameType)

(s/def
  :cognitect.aws.iam.CreateServiceLinkedRoleRequest/Description
  :cognitect.aws.iam/roleDescriptionType)

(s/def
  :cognitect.aws.iam.CreateServiceLinkedRoleRequest/CustomSuffix
  :cognitect.aws.iam/customSuffixType)

(s/def
  :cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/ServiceSpecificCredentialId
  :cognitect.aws.iam/serviceSpecificCredentialId)

(s/def
  :cognitect.aws.iam.UpdateServiceSpecificCredentialRequest/Status
  :cognitect.aws.iam/statusType)

(s/def
  :cognitect.aws.iam.DuplicateCertificateException/message
  :cognitect.aws.iam/duplicateCertificateMessage)

(s/def :cognitect.aws.iam.ListInstanceProfilesRequest/PathPrefix :cognitect.aws.iam/pathPrefixType)

(s/def :cognitect.aws.iam.ListInstanceProfilesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListInstanceProfilesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.UpdateAccessKeyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.UpdateAccessKeyRequest/AccessKeyId :cognitect.aws.iam/accessKeyIdType)

(s/def :cognitect.aws.iam.UpdateAccessKeyRequest/Status :cognitect.aws.iam/statusType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobStatus
  :cognitect.aws.iam/jobStatusType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobType
  :cognitect.aws.iam/AccessAdvisorUsageGranularityType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobCreationDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/ServicesLastAccessed
  :cognitect.aws.iam/ServicesLastAccessed)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/JobCompletionDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsResponse/Error
  :cognitect.aws.iam/ErrorDetails)

(s/def :cognitect.aws.iam.CreateGroupResponse/Group :cognitect.aws.iam/Group)

(s/def :cognitect.aws.iam.ChangePasswordRequest/OldPassword :cognitect.aws.iam/passwordType)

(s/def :cognitect.aws.iam.ChangePasswordRequest/NewPassword :cognitect.aws.iam/passwordType)

(s/def :cognitect.aws.iam.GenerateServiceLastAccessedDetailsRequest/Arn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.GenerateServiceLastAccessedDetailsRequest/Granularity
  :cognitect.aws.iam/AccessAdvisorUsageGranularityType)

(s/def :cognitect.aws.iam.ListGroupsForUserResponse/Groups :cognitect.aws.iam/groupListType)

(s/def :cognitect.aws.iam.ListGroupsForUserResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListGroupsForUserResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.GetRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.GetRolePolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.UpdateAssumeRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.UpdateAssumeRolePolicyRequest/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.SetDefaultPolicyVersionRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.SetDefaultPolicyVersionRequest/VersionId
  :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.ListUserTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.ListUserTagsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListUserTagsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListServerCertificateTagsRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.ListServerCertificateTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListServerCertificateTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetMFADeviceResponse/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.GetMFADeviceResponse/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.GetMFADeviceResponse/EnableDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetMFADeviceResponse/Certifications
  :cognitect.aws.iam/CertificationMapType)

(s/def :cognitect.aws.iam.DeletionTaskFailureReasonType/Reason :cognitect.aws.iam/ReasonType)

(s/def
  :cognitect.aws.iam.DeletionTaskFailureReasonType/RoleUsageList
  :cognitect.aws.iam/RoleUsageListType)

(s/def
  :cognitect.aws.iam.InvalidUserTypeException/message
  :cognitect.aws.iam/invalidUserTypeMessage)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobStatus
  :cognitect.aws.iam/jobStatusType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobCompletionDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/ErrorDetails
  :cognitect.aws.iam/ErrorDetails)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/AccessDetails
  :cognitect.aws.iam/AccessDetails)

(s/def :cognitect.aws.iam.GetOrganizationsAccessReportResponse/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/JobCreationDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/NumberOfServicesNotAccessed
  :cognitect.aws.iam/integerType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportResponse/NumberOfServicesAccessible
  :cognitect.aws.iam/integerType)

(s/def
  :cognitect.aws.iam.ReportGenerationLimitExceededException/message
  :cognitect.aws.iam/reportGenerationLimitExceededMessage)

(s/def :cognitect.aws.iam.VirtualMFADevice/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.VirtualMFADevice/Base32StringSeed :cognitect.aws.iam/BootstrapDatum)

(s/def :cognitect.aws.iam.VirtualMFADevice/QRCodePNG :cognitect.aws.iam/BootstrapDatum)

(s/def :cognitect.aws.iam.VirtualMFADevice/User :cognitect.aws.iam/User)

(s/def :cognitect.aws.iam.VirtualMFADevice/EnableDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.VirtualMFADevice/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.PolicyNotAttachableException/message
  :cognitect.aws.iam/policyNotAttachableMessage)

(s/def :cognitect.aws.iam.ErrorDetails/Message :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.ErrorDetails/Code :cognitect.aws.iam/stringType)

(s/def
  :cognitect.aws.iam.GetServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.GetSAMLProviderRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.OpenIdIdpCommunicationErrorException/message
  :cognitect.aws.iam/openIdIdpCommunicationErrorExceptionMessage)

(s/def
  :cognitect.aws.iam.UpdateOpenIDConnectProviderThumbprintRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.UpdateOpenIDConnectProviderThumbprintRequest/ThumbprintList
  :cognitect.aws.iam/thumbprintListType)

(s/def :cognitect.aws.iam.UntagSAMLProviderRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.UntagSAMLProviderRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def :cognitect.aws.iam.ListAccountAliasesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListAccountAliasesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.EntityAlreadyExistsException/message
  :cognitect.aws.iam/entityAlreadyExistsMessage)

(s/def :cognitect.aws.iam.AttachUserPolicyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.AttachUserPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.SimulatePolicyResponse/EvaluationResults
  :cognitect.aws.iam/EvaluationResultsListType)

(s/def :cognitect.aws.iam.SimulatePolicyResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.SimulatePolicyResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.ListRolesResponse/Roles :cognitect.aws.iam/roleListType)

(s/def :cognitect.aws.iam.ListRolesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListRolesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.UploadSSHPublicKeyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.UploadSSHPublicKeyRequest/SSHPublicKeyBody
  :cognitect.aws.iam/publicKeyMaterialType)

(s/def :cognitect.aws.iam.AccessKeyLastUsed/LastUsedDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.AccessKeyLastUsed/ServiceName :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.AccessKeyLastUsed/Region :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.DeleteSAMLProviderRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.GenerateOrganizationsAccessReportRequest/EntityPath
  :cognitect.aws.iam/organizationsEntityPathType)

(s/def
  :cognitect.aws.iam.GenerateOrganizationsAccessReportRequest/OrganizationsPolicyId
  :cognitect.aws.iam/organizationsPolicyIdType)

(s/def :cognitect.aws.iam.ListSSHPublicKeysRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.ListSSHPublicKeysRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListSSHPublicKeysRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.InstanceProfile/Path :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.InstanceProfile/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.InstanceProfile/InstanceProfileId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.InstanceProfile/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.InstanceProfile/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.InstanceProfile/Roles :cognitect.aws.iam/roleListType)

(s/def :cognitect.aws.iam.InstanceProfile/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.DisableOrganizationsRootCredentialsManagementResponse/OrganizationId
  :cognitect.aws.iam/OrganizationIdType)

(s/def
  :cognitect.aws.iam.DisableOrganizationsRootCredentialsManagementResponse/EnabledFeatures
  :cognitect.aws.iam/FeaturesListType)

(s/def
  :cognitect.aws.iam.GetServerCertificateResponse/ServerCertificate
  :cognitect.aws.iam/ServerCertificate)

(s/def
  :cognitect.aws.iam.DeleteVirtualMFADeviceRequest/SerialNumber
  :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.ListUserPoliciesRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListUserPoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListUserPoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.PutRolePermissionsBoundaryRequest/RoleName
  :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.PutRolePermissionsBoundaryRequest/PermissionsBoundary
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.TagUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.TagUserRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.UpdateSigningCertificateRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.UpdateSigningCertificateRequest/CertificateId
  :cognitect.aws.iam/certificateIdType)

(s/def :cognitect.aws.iam.UpdateSigningCertificateRequest/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.SSHPublicKeyMetadata/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.SSHPublicKeyMetadata/SSHPublicKeyId :cognitect.aws.iam/publicKeyIdType)

(s/def :cognitect.aws.iam.SSHPublicKeyMetadata/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.SSHPublicKeyMetadata/UploadDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetSAMLProviderResponse/SAMLProviderUUID
  :cognitect.aws.iam/privateKeyIdType)

(s/def
  :cognitect.aws.iam.GetSAMLProviderResponse/SAMLMetadataDocument
  :cognitect.aws.iam/SAMLMetadataDocumentType)

(s/def :cognitect.aws.iam.GetSAMLProviderResponse/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetSAMLProviderResponse/ValidUntil :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetSAMLProviderResponse/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GetSAMLProviderResponse/AssertionEncryptionMode
  :cognitect.aws.iam/assertionEncryptionModeType)

(s/def :cognitect.aws.iam.GetSAMLProviderResponse/PrivateKeyList :cognitect.aws.iam/privateKeyList)

(s/def :cognitect.aws.iam.LoginProfile/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.LoginProfile/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.LoginProfile/PasswordResetRequired :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.UntagServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.UntagServerCertificateRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def :cognitect.aws.iam.DeleteAccessKeyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.DeleteAccessKeyRequest/AccessKeyId :cognitect.aws.iam/accessKeyIdType)

(s/def :cognitect.aws.iam.SAMLProviderListEntry/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.SAMLProviderListEntry/ValidUntil :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.SAMLProviderListEntry/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.RemoveUserFromGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def
  :cognitect.aws.iam.RemoveUserFromGroupRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.PutGroupPolicyRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.PutGroupPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.PutGroupPolicyRequest/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.CreateRoleResponse/Role :cognitect.aws.iam/Role)

(s/def
  :cognitect.aws.iam.CreateOpenIDConnectProviderResponse/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.CreateOpenIDConnectProviderResponse/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.ListServiceSpecificCredentialsRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.ListServiceSpecificCredentialsRequest/ServiceName
  :cognitect.aws.iam/serviceName)

(s/def
  :cognitect.aws.iam.DeleteServiceSpecificCredentialRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.DeleteServiceSpecificCredentialRequest/ServiceSpecificCredentialId
  :cognitect.aws.iam/serviceSpecificCredentialId)

(s/def
  :cognitect.aws.iam.PermissionsBoundaryDecisionDetail/AllowedByPermissionsBoundary
  :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.MFADevice/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.MFADevice/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.MFADevice/EnableDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetAccountSummaryResponse/SummaryMap :cognitect.aws.iam/summaryMapType)

(s/def :cognitect.aws.iam.UpdateRoleDescriptionResponse/Role :cognitect.aws.iam/Role)

(s/def :cognitect.aws.iam.ListServerCertificateTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.ListServerCertificateTagsResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListServerCertificateTagsResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.ListUserTagsRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListUserTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListUserTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.CredentialReportNotReadyException/message
  :cognitect.aws.iam/credentialReportNotReadyExceptionMessage)

(s/def
  :cognitect.aws.iam.SetSecurityTokenServicePreferencesRequest/GlobalEndpointTokenVersion
  :cognitect.aws.iam/globalEndpointTokenVersion)

(s/def :cognitect.aws.iam.ListPoliciesResponse/Policies :cognitect.aws.iam/policyListType)

(s/def :cognitect.aws.iam.ListPoliciesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListPoliciesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.EvaluationResult/EvalActionName :cognitect.aws.iam/ActionNameType)

(s/def
  :cognitect.aws.iam.EvaluationResult/OrganizationsDecisionDetail
  :cognitect.aws.iam/OrganizationsDecisionDetail)

(s/def :cognitect.aws.iam.EvaluationResult/MatchedStatements :cognitect.aws.iam/StatementListType)

(s/def
  :cognitect.aws.iam.EvaluationResult/MissingContextValues
  :cognitect.aws.iam/ContextKeyNamesResultListType)

(s/def
  :cognitect.aws.iam.EvaluationResult/PermissionsBoundaryDecisionDetail
  :cognitect.aws.iam/PermissionsBoundaryDecisionDetail)

(s/def
  :cognitect.aws.iam.EvaluationResult/EvalDecisionDetails
  :cognitect.aws.iam/EvalDecisionDetailsType)

(s/def
  :cognitect.aws.iam.EvaluationResult/ResourceSpecificResults
  :cognitect.aws.iam/ResourceSpecificResultListType)

(s/def :cognitect.aws.iam.EvaluationResult/EvalResourceName :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.EvaluationResult/EvalDecision
  :cognitect.aws.iam/PolicyEvaluationDecisionType)

(s/def :cognitect.aws.iam.DetachGroupPolicyRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.DetachGroupPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ServiceSpecificCredential/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.ServiceSpecificCredential/ServiceName :cognitect.aws.iam/serviceName)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredential/ServiceUserName
  :cognitect.aws.iam/serviceUserName)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredential/ServicePassword
  :cognitect.aws.iam/servicePassword)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredential/ServiceSpecificCredentialId
  :cognitect.aws.iam/serviceSpecificCredentialId)

(s/def :cognitect.aws.iam.ServiceSpecificCredential/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.ServiceSpecificCredential/Status :cognitect.aws.iam/statusType)

(s/def
  :cognitect.aws.iam.GenerateServiceLastAccessedDetailsResponse/JobId
  :cognitect.aws.iam/jobIDType)

(s/def
  :cognitect.aws.iam.ServerCertificate/ServerCertificateMetadata
  :cognitect.aws.iam/ServerCertificateMetadata)

(s/def :cognitect.aws.iam.ServerCertificate/CertificateBody :cognitect.aws.iam/certificateBodyType)

(s/def
  :cognitect.aws.iam.ServerCertificate/CertificateChain
  :cognitect.aws.iam/certificateChainType)

(s/def :cognitect.aws.iam.ServerCertificate/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.GetGroupResponse/Group :cognitect.aws.iam/Group)

(s/def :cognitect.aws.iam.GetGroupResponse/Users :cognitect.aws.iam/userListType)

(s/def :cognitect.aws.iam.GetGroupResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.GetGroupResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.OpenIDConnectProviderListEntry/Arn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.ListAttachedRolePoliciesResponse/AttachedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def
  :cognitect.aws.iam.ListAttachedRolePoliciesResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListAttachedRolePoliciesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.TagOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.TagOpenIDConnectProviderRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessEntry/ServiceNamespace
  :cognitect.aws.iam/serviceNamespaceType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessEntry/Policies
  :cognitect.aws.iam/policyGrantingServiceAccessListType)

(s/def
  :cognitect.aws.iam.ManagedPolicyDetail/PermissionsBoundaryUsageCount
  :cognitect.aws.iam/attachmentCountType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/Path :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.ManagedPolicyDetail/AttachmentCount
  :cognitect.aws.iam/attachmentCountType)

(s/def
  :cognitect.aws.iam.ManagedPolicyDetail/DefaultVersionId
  :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/IsAttachable :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/Arn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.ManagedPolicyDetail/PolicyVersionList
  :cognitect.aws.iam/policyDocumentVersionListType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/Description :cognitect.aws.iam/policyDescriptionType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/PolicyId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.ManagedPolicyDetail/UpdateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.CreateServiceLinkedRoleResponse/Role :cognitect.aws.iam/Role)

(s/def
  :cognitect.aws.iam.UpdateSAMLProviderRequest/SAMLMetadataDocument
  :cognitect.aws.iam/SAMLMetadataDocumentType)

(s/def :cognitect.aws.iam.UpdateSAMLProviderRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.UpdateSAMLProviderRequest/AssertionEncryptionMode
  :cognitect.aws.iam/assertionEncryptionModeType)

(s/def :cognitect.aws.iam.UpdateSAMLProviderRequest/AddPrivateKey :cognitect.aws.iam/privateKeyType)

(s/def
  :cognitect.aws.iam.UpdateSAMLProviderRequest/RemovePrivateKey
  :cognitect.aws.iam/privateKeyIdType)

(s/def :cognitect.aws.iam.DeleteGroupPolicyRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.DeleteGroupPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredentialMetadata/UserName
  :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.ServiceSpecificCredentialMetadata/Status :cognitect.aws.iam/statusType)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceUserName
  :cognitect.aws.iam/serviceUserName)

(s/def :cognitect.aws.iam.ServiceSpecificCredentialMetadata/CreateDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceSpecificCredentialId
  :cognitect.aws.iam/serviceSpecificCredentialId)

(s/def
  :cognitect.aws.iam.ServiceSpecificCredentialMetadata/ServiceName
  :cognitect.aws.iam/serviceName)

(s/def :cognitect.aws.iam.CreateGroupRequest/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.CreateGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.UpdateGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.UpdateGroupRequest/NewPath :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.UpdateGroupRequest/NewGroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.ListGroupsRequest/PathPrefix :cognitect.aws.iam/pathPrefixType)

(s/def :cognitect.aws.iam.ListGroupsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListGroupsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.DeleteUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListInstanceProfileTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.ListInstanceProfileTagsResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListInstanceProfileTagsResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.User/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.User/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.User/UserId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.User/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.User/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.User/PasswordLastUsed :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.User/PermissionsBoundary :cognitect.aws.iam/AttachedPermissionsBoundary)

(s/def :cognitect.aws.iam.User/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.UploadSSHPublicKeyResponse/SSHPublicKey :cognitect.aws.iam/SSHPublicKey)

(s/def :cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListOpenIDConnectProviderTagsResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.GetAccountPasswordPolicyResponse/PasswordPolicy
  :cognitect.aws.iam/PasswordPolicy)

(s/def :cognitect.aws.iam.AccessKeyMetadata/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.AccessKeyMetadata/AccessKeyId :cognitect.aws.iam/accessKeyIdType)

(s/def :cognitect.aws.iam.AccessKeyMetadata/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.AccessKeyMetadata/CreateDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.UserDetail/PermissionsBoundary
  :cognitect.aws.iam/AttachedPermissionsBoundary)

(s/def :cognitect.aws.iam.UserDetail/GroupList :cognitect.aws.iam/groupNameListType)

(s/def :cognitect.aws.iam.UserDetail/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.UserDetail/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.UserDetail/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.UserDetail/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.UserDetail/UserId :cognitect.aws.iam/idType)

(s/def
  :cognitect.aws.iam.UserDetail/AttachedManagedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def :cognitect.aws.iam.UserDetail/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.UserDetail/UserPolicyList :cognitect.aws.iam/policyDetailListType)

(s/def :cognitect.aws.iam.CreateUserRequest/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.CreateUserRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.CreateUserRequest/PermissionsBoundary :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.CreateUserRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.UploadServerCertificateResponse/ServerCertificateMetadata
  :cognitect.aws.iam/ServerCertificateMetadata)

(s/def :cognitect.aws.iam.UploadServerCertificateResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/JobId :cognitect.aws.iam/jobIDType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetServiceLastAccessedDetailsRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.CreateVirtualMFADeviceResponse/VirtualMFADevice
  :cognitect.aws.iam/VirtualMFADevice)

(s/def
  :cognitect.aws.iam.ListSAMLProvidersResponse/SAMLProviderList
  :cognitect.aws.iam/SAMLProviderListType)

(s/def
  :cognitect.aws.iam.ListUserPoliciesResponse/PolicyNames
  :cognitect.aws.iam/policyNameListType)

(s/def :cognitect.aws.iam.ListUserPoliciesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListUserPoliciesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.CreateInstanceProfileResponse/InstanceProfile
  :cognitect.aws.iam/InstanceProfile)

(s/def
  :cognitect.aws.iam.CredentialReportExpiredException/message
  :cognitect.aws.iam/credentialReportExpiredExceptionMessage)

(s/def :cognitect.aws.iam.GetRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.UntagMFADeviceRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.UntagMFADeviceRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def
  :cognitect.aws.iam.ListServerCertificatesResponse/ServerCertificateMetadataList
  :cognitect.aws.iam/serverCertificateMetadataListType)

(s/def :cognitect.aws.iam.ListServerCertificatesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListServerCertificatesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.UntagRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.UntagRoleRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def :cognitect.aws.iam.GetOrganizationsAccessReportRequest/JobId :cognitect.aws.iam/jobIDType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetOrganizationsAccessReportRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.GetOrganizationsAccessReportRequest/SortKey
  :cognitect.aws.iam/sortKeyType)

(s/def :cognitect.aws.iam.ResyncMFADeviceRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ResyncMFADeviceRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def
  :cognitect.aws.iam.ResyncMFADeviceRequest/AuthenticationCode1
  :cognitect.aws.iam/authenticationCodeType)

(s/def
  :cognitect.aws.iam.ResyncMFADeviceRequest/AuthenticationCode2
  :cognitect.aws.iam/authenticationCodeType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesForRoleResponse/InstanceProfiles
  :cognitect.aws.iam/instanceProfileListType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesForRoleResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesForRoleResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.GetGroupRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.GetGroupRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.GetGroupRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.AttachedPolicy/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.AttachedPolicy/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/Scope :cognitect.aws.iam/policyScopeType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/OnlyAttached :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/PathPrefix :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/PolicyUsageFilter :cognitect.aws.iam/PolicyUsageType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListPoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.GetContextKeysForCustomPolicyRequest/PolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def :cognitect.aws.iam.CreateRoleRequest/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.CreateRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.CreateRoleRequest/AssumeRolePolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.CreateRoleRequest/Description :cognitect.aws.iam/roleDescriptionType)

(s/def
  :cognitect.aws.iam.CreateRoleRequest/MaxSessionDuration
  :cognitect.aws.iam/roleMaxSessionDurationType)

(s/def :cognitect.aws.iam.CreateRoleRequest/PermissionsBoundary :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.CreateRoleRequest/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.GetLoginProfileRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.DuplicateSSHPublicKeyException/message
  :cognitect.aws.iam/duplicateSSHPublicKeyMessage)

(s/def :cognitect.aws.iam.GetMFADeviceRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.GetMFADeviceRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.CreateAccessKeyResponse/AccessKey :cognitect.aws.iam/AccessKey)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobStatus
  :cognitect.aws.iam/jobStatusType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobCreationDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/JobCompletionDate
  :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/EntityDetailsList
  :cognitect.aws.iam/entityDetailsListType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesResponse/Error
  :cognitect.aws.iam/ErrorDetails)

(s/def :cognitect.aws.iam.SimulatePrincipalPolicyRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourcePolicy
  :cognitect.aws.iam/policyDocumentType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceArns
  :cognitect.aws.iam/ResourceNameListType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/CallerArn
  :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceOwner
  :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/PolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def :cognitect.aws.iam.SimulatePrincipalPolicyRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ResourceHandlingOption
  :cognitect.aws.iam/ResourceHandlingOptionType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ActionNames
  :cognitect.aws.iam/ActionNameListType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/PermissionsBoundaryPolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def
  :cognitect.aws.iam.SimulatePrincipalPolicyRequest/ContextEntries
  :cognitect.aws.iam/ContextEntryListType)

(s/def :cognitect.aws.iam.SimulatePrincipalPolicyRequest/PolicySourceArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.UpdateUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.UpdateUserRequest/NewPath :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.UpdateUserRequest/NewUserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.ResetServiceSpecificCredentialResponse/ServiceSpecificCredential
  :cognitect.aws.iam/ServiceSpecificCredential)

(s/def
  :cognitect.aws.iam.GetContextKeysForPrincipalPolicyRequest/PolicySourceArn
  :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.GetContextKeysForPrincipalPolicyRequest/PolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def :cognitect.aws.iam.EnableMFADeviceRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.EnableMFADeviceRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def
  :cognitect.aws.iam.EnableMFADeviceRequest/AuthenticationCode1
  :cognitect.aws.iam/authenticationCodeType)

(s/def
  :cognitect.aws.iam.EnableMFADeviceRequest/AuthenticationCode2
  :cognitect.aws.iam/authenticationCodeType)

(s/def
  :cognitect.aws.iam.UntagOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.UntagOpenIDConnectProviderRequest/TagKeys
  :cognitect.aws.iam/tagKeyListType)

(s/def :cognitect.aws.iam.SimulateCustomPolicyRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourcePolicy
  :cognitect.aws.iam/policyDocumentType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceArns
  :cognitect.aws.iam/ResourceNameListType)

(s/def :cognitect.aws.iam.SimulateCustomPolicyRequest/CallerArn :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceOwner
  :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/PolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def :cognitect.aws.iam.SimulateCustomPolicyRequest/Marker :cognitect.aws.iam/markerType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ResourceHandlingOption
  :cognitect.aws.iam/ResourceHandlingOptionType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ActionNames
  :cognitect.aws.iam/ActionNameListType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/PermissionsBoundaryPolicyInputList
  :cognitect.aws.iam/SimulationPolicyListType)

(s/def
  :cognitect.aws.iam.SimulateCustomPolicyRequest/ContextEntries
  :cognitect.aws.iam/ContextEntryListType)

(s/def
  :cognitect.aws.iam.ListGroupPoliciesResponse/PolicyNames
  :cognitect.aws.iam/policyNameListType)

(s/def :cognitect.aws.iam.ListGroupPoliciesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListGroupPoliciesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.AddRoleToInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.AddRoleToInstanceProfileRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.UpdateSSHPublicKeyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.UpdateSSHPublicKeyRequest/SSHPublicKeyId
  :cognitect.aws.iam/publicKeyIdType)

(s/def :cognitect.aws.iam.UpdateSSHPublicKeyRequest/Status :cognitect.aws.iam/statusType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/EvalResourceName
  :cognitect.aws.iam/ResourceNameType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/EvalResourceDecision
  :cognitect.aws.iam/PolicyEvaluationDecisionType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/MatchedStatements
  :cognitect.aws.iam/StatementListType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/MissingContextValues
  :cognitect.aws.iam/ContextKeyNamesResultListType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/EvalDecisionDetails
  :cognitect.aws.iam/EvalDecisionDetailsType)

(s/def
  :cognitect.aws.iam.ResourceSpecificResult/PermissionsBoundaryDecisionDetail
  :cognitect.aws.iam/PermissionsBoundaryDecisionDetail)

(s/def :cognitect.aws.iam.GetLoginProfileResponse/LoginProfile :cognitect.aws.iam/LoginProfile)

(s/def :cognitect.aws.iam.GetPolicyResponse/Policy :cognitect.aws.iam/Policy)

(s/def
  :cognitect.aws.iam.GetAccessKeyLastUsedRequest/AccessKeyId
  :cognitect.aws.iam/accessKeyIdType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/JobId
  :cognitect.aws.iam/jobIDType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/ServiceNamespace
  :cognitect.aws.iam/serviceNamespaceType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.GetServiceLastAccessedDetailsWithEntitiesRequest/Marker
  :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.CreateLoginProfileRequest/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.CreateLoginProfileRequest/Password :cognitect.aws.iam/passwordType)

(s/def
  :cognitect.aws.iam.CreateLoginProfileRequest/PasswordResetRequired
  :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.CreatePolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.CreatePolicyRequest/Path :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.CreatePolicyRequest/PolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.CreatePolicyRequest/Description :cognitect.aws.iam/policyDescriptionType)

(s/def :cognitect.aws.iam.CreatePolicyRequest/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.AccessDetail/ServiceName :cognitect.aws.iam/serviceNameType)

(s/def :cognitect.aws.iam.AccessDetail/ServiceNamespace :cognitect.aws.iam/serviceNamespaceType)

(s/def :cognitect.aws.iam.AccessDetail/Region :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.AccessDetail/EntityPath :cognitect.aws.iam/organizationsEntityPathType)

(s/def :cognitect.aws.iam.AccessDetail/LastAuthenticatedTime :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.AccessDetail/TotalAuthenticatedEntities :cognitect.aws.iam/integerType)

(s/def :cognitect.aws.iam.ListPolicyVersionsRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListPolicyVersionsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListPolicyVersionsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.ListVirtualMFADevicesResponse/VirtualMFADevices
  :cognitect.aws.iam/virtualMFADeviceListType)

(s/def :cognitect.aws.iam.ListVirtualMFADevicesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListVirtualMFADevicesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListSigningCertificatesResponse/Certificates
  :cognitect.aws.iam/certificateListType)

(s/def
  :cognitect.aws.iam.ListSigningCertificatesResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListSigningCertificatesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.RoleDetail/PermissionsBoundary
  :cognitect.aws.iam/AttachedPermissionsBoundary)

(s/def :cognitect.aws.iam.RoleDetail/RolePolicyList :cognitect.aws.iam/policyDetailListType)

(s/def :cognitect.aws.iam.RoleDetail/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.RoleDetail/InstanceProfileList :cognitect.aws.iam/instanceProfileListType)

(s/def :cognitect.aws.iam.RoleDetail/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.RoleDetail/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.RoleDetail/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.RoleDetail/AttachedManagedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def :cognitect.aws.iam.RoleDetail/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.RoleDetail/RoleLastUsed :cognitect.aws.iam/RoleLastUsed)

(s/def :cognitect.aws.iam.RoleDetail/AssumeRolePolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.RoleDetail/RoleId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.ServiceLastAccessed/ServiceName :cognitect.aws.iam/serviceNameType)

(s/def :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticated :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.ServiceLastAccessed/ServiceNamespace
  :cognitect.aws.iam/serviceNamespaceType)

(s/def :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticatedEntity :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ServiceLastAccessed/LastAuthenticatedRegion :cognitect.aws.iam/stringType)

(s/def
  :cognitect.aws.iam.ServiceLastAccessed/TotalAuthenticatedEntities
  :cognitect.aws.iam/integerType)

(s/def
  :cognitect.aws.iam.ServiceLastAccessed/TrackedActionsLastAccessed
  :cognitect.aws.iam/TrackedActionsLastAccessed)

(s/def
  :cognitect.aws.iam.PasswordPolicyViolationException/message
  :cognitect.aws.iam/passwordPolicyViolationMessage)

(s/def :cognitect.aws.iam.EntityInfo/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.EntityInfo/Name :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.EntityInfo/Type :cognitect.aws.iam/policyOwnerEntityType)

(s/def :cognitect.aws.iam.EntityInfo/Id :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.EntityInfo/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.RoleLastUsed/LastUsedDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.RoleLastUsed/Region :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.GetPolicyVersionResponse/PolicyVersion :cognitect.aws.iam/PolicyVersion)

(s/def :cognitect.aws.iam.UntagPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.UntagPolicyRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def
  :cognitect.aws.iam.InvalidCertificateException/message
  :cognitect.aws.iam/invalidCertificateMessage)

(s/def :cognitect.aws.iam.AttachGroupPolicyRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.AttachGroupPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.UploadSigningCertificateRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.UploadSigningCertificateRequest/CertificateBody
  :cognitect.aws.iam/certificateBodyType)

(s/def
  :cognitect.aws.iam.RemoveClientIDFromOpenIDConnectProviderRequest/OpenIDConnectProviderArn
  :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.RemoveClientIDFromOpenIDConnectProviderRequest/ClientID
  :cognitect.aws.iam/clientIDType)

(s/def :cognitect.aws.iam.DeleteConflictException/message :cognitect.aws.iam/deleteConflictMessage)

(s/def :cognitect.aws.iam.AccessKey/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.AccessKey/AccessKeyId :cognitect.aws.iam/accessKeyIdType)

(s/def :cognitect.aws.iam.AccessKey/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.AccessKey/SecretAccessKey :cognitect.aws.iam/accessKeySecretType)

(s/def :cognitect.aws.iam.AccessKey/CreateDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.ResetServiceSpecificCredentialRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.ResetServiceSpecificCredentialRequest/ServiceSpecificCredentialId
  :cognitect.aws.iam/serviceSpecificCredentialId)

(s/def :cognitect.aws.iam.NoSuchEntityException/message :cognitect.aws.iam/noSuchEntityMessage)

(s/def :cognitect.aws.iam.DeleteLoginProfileRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.UploadSigningCertificateResponse/Certificate
  :cognitect.aws.iam/SigningCertificate)

(s/def :cognitect.aws.iam.ListMFADevicesResponse/MFADevices :cognitect.aws.iam/mfaDeviceListType)

(s/def :cognitect.aws.iam.ListMFADevicesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListMFADevicesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListOpenIDConnectProvidersResponse/OpenIDConnectProviderList
  :cognitect.aws.iam/OpenIDConnectProviderListType)

(s/def :cognitect.aws.iam.PolicyVersion/Document :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.PolicyVersion/VersionId :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.PolicyVersion/IsDefaultVersion :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PolicyVersion/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.CreatePolicyVersionRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.CreatePolicyVersionRequest/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.CreatePolicyVersionRequest/SetAsDefault :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyRequest/EntityFilter :cognitect.aws.iam/EntityType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyRequest/PathPrefix :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.ListEntitiesForPolicyRequest/PolicyUsageFilter
  :cognitect.aws.iam/PolicyUsageType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListEntitiesForPolicyRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.ListRolePoliciesResponse/PolicyNames
  :cognitect.aws.iam/policyNameListType)

(s/def :cognitect.aws.iam.ListRolePoliciesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListRolePoliciesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.PasswordPolicy/PasswordReusePrevention
  :cognitect.aws.iam/passwordReusePreventionType)

(s/def :cognitect.aws.iam.PasswordPolicy/RequireNumbers :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PasswordPolicy/MaxPasswordAge :cognitect.aws.iam/maxPasswordAgeType)

(s/def :cognitect.aws.iam.PasswordPolicy/RequireLowercaseCharacters :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.PasswordPolicy/MinimumPasswordLength
  :cognitect.aws.iam/minimumPasswordLengthType)

(s/def :cognitect.aws.iam.PasswordPolicy/RequireUppercaseCharacters :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PasswordPolicy/AllowUsersToChangePassword :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PasswordPolicy/RequireSymbols :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PasswordPolicy/ExpirePasswords :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.PasswordPolicy/HardExpiry :cognitect.aws.iam/booleanObjectType)

(s/def :cognitect.aws.iam.ListRolesRequest/PathPrefix :cognitect.aws.iam/pathPrefixType)

(s/def :cognitect.aws.iam.ListRolesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListRolesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyType :cognitect.aws.iam/policyType)

(s/def :cognitect.aws.iam.PolicyGrantingServiceAccess/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.PolicyGrantingServiceAccess/EntityType
  :cognitect.aws.iam/policyOwnerEntityType)

(s/def :cognitect.aws.iam.PolicyGrantingServiceAccess/EntityName :cognitect.aws.iam/entityNameType)

(s/def :cognitect.aws.iam.ListRolePoliciesRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.ListRolePoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListRolePoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.DeletePolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListUsersResponse/Users :cognitect.aws.iam/userListType)

(s/def :cognitect.aws.iam.ListUsersResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListUsersResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.ListGroupPoliciesRequest/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.ListGroupPoliciesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListGroupPoliciesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.UpdateServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def :cognitect.aws.iam.UpdateServerCertificateRequest/NewPath :cognitect.aws.iam/pathType)

(s/def
  :cognitect.aws.iam.UpdateServerCertificateRequest/NewServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def
  :cognitect.aws.iam.UnrecognizedPublicKeyEncodingException/message
  :cognitect.aws.iam/unrecognizedPublicKeyEncodingMessage)

(s/def
  :cognitect.aws.iam.UnmodifiableEntityException/message
  :cognitect.aws.iam/unmodifiableEntityMessage)

(s/def
  :cognitect.aws.iam.CredentialReportNotPresentException/message
  :cognitect.aws.iam/credentialReportNotPresentExceptionMessage)

(s/def :cognitect.aws.iam.ListUsersRequest/PathPrefix :cognitect.aws.iam/pathPrefixType)

(s/def :cognitect.aws.iam.ListUsersRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListUsersRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.Role/PermissionsBoundary :cognitect.aws.iam/AttachedPermissionsBoundary)

(s/def :cognitect.aws.iam.Role/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.Role/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.Role/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.Role/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.Role/MaxSessionDuration :cognitect.aws.iam/roleMaxSessionDurationType)

(s/def :cognitect.aws.iam.Role/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.Role/RoleLastUsed :cognitect.aws.iam/RoleLastUsed)

(s/def :cognitect.aws.iam.Role/Description :cognitect.aws.iam/roleDescriptionType)

(s/def :cognitect.aws.iam.Role/AssumeRolePolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.Role/RoleId :cognitect.aws.iam/idType)

(s/def
  :cognitect.aws.iam.CreateSAMLProviderRequest/SAMLMetadataDocument
  :cognitect.aws.iam/SAMLMetadataDocumentType)

(s/def :cognitect.aws.iam.CreateSAMLProviderRequest/Name :cognitect.aws.iam/SAMLProviderNameType)

(s/def :cognitect.aws.iam.CreateSAMLProviderRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.CreateSAMLProviderRequest/AssertionEncryptionMode
  :cognitect.aws.iam/assertionEncryptionModeType)

(s/def :cognitect.aws.iam.CreateSAMLProviderRequest/AddPrivateKey :cognitect.aws.iam/privateKeyType)

(s/def :cognitect.aws.iam.InvalidInputException/message :cognitect.aws.iam/invalidInputMessage)

(s/def :cognitect.aws.iam.UpdateRoleRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.UpdateRoleRequest/Description :cognitect.aws.iam/roleDescriptionType)

(s/def
  :cognitect.aws.iam.UpdateRoleRequest/MaxSessionDuration
  :cognitect.aws.iam/roleMaxSessionDurationType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/PoliciesGrantingServiceAccess
  :cognitect.aws.iam/listPolicyGrantingServiceAccessResponseListType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListPoliciesGrantingServiceAccessResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListVirtualMFADevicesRequest/AssignmentStatus
  :cognitect.aws.iam/assignmentStatusType)

(s/def :cognitect.aws.iam.ListVirtualMFADevicesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListVirtualMFADevicesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.ListPolicyTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.ListPolicyTagsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListPolicyTagsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.ListInstanceProfilesResponse/InstanceProfiles
  :cognitect.aws.iam/instanceProfileListType)

(s/def :cognitect.aws.iam.ListInstanceProfilesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListInstanceProfilesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.DeleteServerCertificateRequest/ServerCertificateName
  :cognitect.aws.iam/serverCertificateNameType)

(s/def
  :cognitect.aws.iam.InvalidPublicKeyException/message
  :cognitect.aws.iam/invalidPublicKeyMessage)

(s/def
  :cognitect.aws.iam.DeleteUserPermissionsBoundaryRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.PolicyUser/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.PolicyUser/UserId :cognitect.aws.iam/idType)

(s/def
  :cognitect.aws.iam.EnableOrganizationsRootSessionsResponse/OrganizationId
  :cognitect.aws.iam/OrganizationIdType)

(s/def
  :cognitect.aws.iam.EnableOrganizationsRootSessionsResponse/EnabledFeatures
  :cognitect.aws.iam/FeaturesListType)

(s/def
  :cognitect.aws.iam.ListAttachedUserPoliciesResponse/AttachedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def
  :cognitect.aws.iam.ListAttachedUserPoliciesResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.ListAttachedUserPoliciesResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/Filter
  :cognitect.aws.iam/entityListType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/MaxItems
  :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsRequest/Marker
  :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.Statement/SourcePolicyId :cognitect.aws.iam/PolicyIdentifierType)

(s/def :cognitect.aws.iam.Statement/SourcePolicyType :cognitect.aws.iam/PolicySourceType)

(s/def :cognitect.aws.iam.Statement/StartPosition :cognitect.aws.iam/Position)

(s/def :cognitect.aws.iam.Statement/EndPosition :cognitect.aws.iam/Position)

(s/def
  :cognitect.aws.iam.GetInstanceProfileResponse/InstanceProfile
  :cognitect.aws.iam/InstanceProfile)

(s/def :cognitect.aws.iam.TrackedActionLastAccessed/ActionName :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedEntity :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedTime :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.TrackedActionLastAccessed/LastAccessedRegion
  :cognitect.aws.iam/stringType)

(s/def :cognitect.aws.iam.Position/Line :cognitect.aws.iam/LineNumber)

(s/def :cognitect.aws.iam.Position/Column :cognitect.aws.iam/ColumnNumber)

(s/def :cognitect.aws.iam.GroupDetail/Path :cognitect.aws.iam/pathType)

(s/def :cognitect.aws.iam.GroupDetail/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.GroupDetail/GroupId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.GroupDetail/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.GroupDetail/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GroupDetail/GroupPolicyList :cognitect.aws.iam/policyDetailListType)

(s/def
  :cognitect.aws.iam.GroupDetail/AttachedManagedPolicies
  :cognitect.aws.iam/attachedPoliciesListType)

(s/def
  :cognitect.aws.iam.CreateServiceSpecificCredentialRequest/UserName
  :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.CreateServiceSpecificCredentialRequest/ServiceName
  :cognitect.aws.iam/serviceName)

(s/def :cognitect.aws.iam.ListGroupsForUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListGroupsForUserRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListGroupsForUserRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.CreateAccountAliasRequest/AccountAlias
  :cognitect.aws.iam/accountAliasType)

(s/def :cognitect.aws.iam.GetCredentialReportResponse/Content :cognitect.aws.iam/ReportContentType)

(s/def
  :cognitect.aws.iam.GetCredentialReportResponse/ReportFormat
  :cognitect.aws.iam/ReportFormatType)

(s/def :cognitect.aws.iam.GetCredentialReportResponse/GeneratedTime :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.ListPolicyTagsRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.ListPolicyTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListPolicyTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetRolePolicyResponse/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.GetRolePolicyResponse/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.GetRolePolicyResponse/PolicyDocument
  :cognitect.aws.iam/policyDocumentType)

(s/def
  :cognitect.aws.iam.EntityTemporarilyUnmodifiableException/message
  :cognitect.aws.iam/entityTemporarilyUnmodifiableMessage)

(s/def
  :cognitect.aws.iam.KeyPairMismatchException/message
  :cognitect.aws.iam/keyPairMismatchMessage)

(s/def
  :cognitect.aws.iam.GetOpenIDConnectProviderResponse/Url
  :cognitect.aws.iam/OpenIDConnectProviderUrlType)

(s/def
  :cognitect.aws.iam.GetOpenIDConnectProviderResponse/ClientIDList
  :cognitect.aws.iam/clientIDListType)

(s/def
  :cognitect.aws.iam.GetOpenIDConnectProviderResponse/ThumbprintList
  :cognitect.aws.iam/thumbprintListType)

(s/def :cognitect.aws.iam.GetOpenIDConnectProviderResponse/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.GetOpenIDConnectProviderResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.PolicyGroup/GroupName :cognitect.aws.iam/groupNameType)

(s/def :cognitect.aws.iam.PolicyGroup/GroupId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.LimitExceededException/message :cognitect.aws.iam/limitExceededMessage)

(s/def
  :cognitect.aws.iam.ListAccessKeysResponse/AccessKeyMetadata
  :cognitect.aws.iam/accessKeyMetadataListType)

(s/def :cognitect.aws.iam.ListAccessKeysResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListAccessKeysResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.SSHPublicKey/UserName :cognitect.aws.iam/userNameType)

(s/def :cognitect.aws.iam.SSHPublicKey/SSHPublicKeyId :cognitect.aws.iam/publicKeyIdType)

(s/def :cognitect.aws.iam.SSHPublicKey/Fingerprint :cognitect.aws.iam/publicKeyFingerprintType)

(s/def :cognitect.aws.iam.SSHPublicKey/SSHPublicKeyBody :cognitect.aws.iam/publicKeyMaterialType)

(s/def :cognitect.aws.iam.SSHPublicKey/Status :cognitect.aws.iam/statusType)

(s/def :cognitect.aws.iam.SSHPublicKey/UploadDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.UpdateRoleDescriptionRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def
  :cognitect.aws.iam.UpdateRoleDescriptionRequest/Description
  :cognitect.aws.iam/roleDescriptionType)

(s/def :cognitect.aws.iam.DeleteSSHPublicKeyRequest/UserName :cognitect.aws.iam/userNameType)

(s/def
  :cognitect.aws.iam.DeleteSSHPublicKeyRequest/SSHPublicKeyId
  :cognitect.aws.iam/publicKeyIdType)

(s/def :cognitect.aws.iam.UntagUserRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.UntagUserRequest/TagKeys :cognitect.aws.iam/tagKeyListType)

(s/def
  :cognitect.aws.iam.AttachedPermissionsBoundary/PermissionsBoundaryType
  :cognitect.aws.iam/PermissionsBoundaryAttachmentType)

(s/def
  :cognitect.aws.iam.AttachedPermissionsBoundary/PermissionsBoundaryArn
  :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.DetachRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.DetachRolePolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.GetContextKeysForPolicyResponse/ContextKeyNames
  :cognitect.aws.iam/ContextKeyNamesResultListType)

(s/def :cognitect.aws.iam.ListMFADevicesRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListMFADevicesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListMFADevicesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsRequest/SerialNumber :cognitect.aws.iam/serialNumberType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListMFADeviceTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/UserDetailList
  :cognitect.aws.iam/userDetailListType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/GroupDetailList
  :cognitect.aws.iam/groupDetailListType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/RoleDetailList
  :cognitect.aws.iam/roleDetailListType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/Policies
  :cognitect.aws.iam/ManagedPolicyDetailListType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/IsTruncated
  :cognitect.aws.iam/booleanType)

(s/def
  :cognitect.aws.iam.GetAccountAuthorizationDetailsResponse/Marker
  :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.PutRolePolicyRequest/RoleName :cognitect.aws.iam/roleNameType)

(s/def :cognitect.aws.iam.PutRolePolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.PutRolePolicyRequest/PolicyDocument :cognitect.aws.iam/policyDocumentType)

(s/def :cognitect.aws.iam.DeleteUserPolicyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.DeleteUserPolicyRequest/PolicyName :cognitect.aws.iam/policyNameType)

(s/def
  :cognitect.aws.iam.ListInstanceProfileTagsRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.ListInstanceProfileTagsRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListInstanceProfileTagsRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def :cognitect.aws.iam.GetPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.ListAccountAliasesResponse/AccountAliases
  :cognitect.aws.iam/accountAliasListType)

(s/def :cognitect.aws.iam.ListAccountAliasesResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListAccountAliasesResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.CreateAccessKeyRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.TagPolicyRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.TagPolicyRequest/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.DeletePolicyVersionRequest/PolicyArn :cognitect.aws.iam/arnType)

(s/def
  :cognitect.aws.iam.DeletePolicyVersionRequest/VersionId
  :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.ListAccessKeysRequest/UserName :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListAccessKeysRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListAccessKeysRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/Url
  :cognitect.aws.iam/OpenIDConnectProviderUrlType)

(s/def
  :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/ClientIDList
  :cognitect.aws.iam/clientIDListType)

(s/def
  :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/ThumbprintList
  :cognitect.aws.iam/thumbprintListType)

(s/def :cognitect.aws.iam.CreateOpenIDConnectProviderRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GetAccessKeyLastUsedResponse/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def
  :cognitect.aws.iam.GetAccessKeyLastUsedResponse/AccessKeyLastUsed
  :cognitect.aws.iam/AccessKeyLastUsed)

(s/def
  :cognitect.aws.iam.Policy/PermissionsBoundaryUsageCount
  :cognitect.aws.iam/attachmentCountType)

(s/def :cognitect.aws.iam.Policy/Path :cognitect.aws.iam/policyPathType)

(s/def :cognitect.aws.iam.Policy/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.Policy/CreateDate :cognitect.aws.iam/dateType)

(s/def :cognitect.aws.iam.Policy/PolicyName :cognitect.aws.iam/policyNameType)

(s/def :cognitect.aws.iam.Policy/AttachmentCount :cognitect.aws.iam/attachmentCountType)

(s/def :cognitect.aws.iam.Policy/DefaultVersionId :cognitect.aws.iam/policyVersionIdType)

(s/def :cognitect.aws.iam.Policy/IsAttachable :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.Policy/Arn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.Policy/Description :cognitect.aws.iam/policyDescriptionType)

(s/def :cognitect.aws.iam.Policy/PolicyId :cognitect.aws.iam/idType)

(s/def :cognitect.aws.iam.Policy/UpdateDate :cognitect.aws.iam/dateType)

(s/def
  :cognitect.aws.iam.ListSigningCertificatesRequest/UserName
  :cognitect.aws.iam/existingUserNameType)

(s/def :cognitect.aws.iam.ListSigningCertificatesRequest/Marker :cognitect.aws.iam/markerType)

(s/def :cognitect.aws.iam.ListSigningCertificatesRequest/MaxItems :cognitect.aws.iam/maxItemsType)

(s/def
  :cognitect.aws.iam.ListSSHPublicKeysResponse/SSHPublicKeys
  :cognitect.aws.iam/SSHPublicKeyListType)

(s/def :cognitect.aws.iam.ListSSHPublicKeysResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListSSHPublicKeysResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def :cognitect.aws.iam.ListRoleTagsResponse/Tags :cognitect.aws.iam/tagListType)

(s/def :cognitect.aws.iam.ListRoleTagsResponse/IsTruncated :cognitect.aws.iam/booleanType)

(s/def :cognitect.aws.iam.ListRoleTagsResponse/Marker :cognitect.aws.iam/responseMarkerType)

(s/def
  :cognitect.aws.iam.InvalidAuthenticationCodeException/message
  :cognitect.aws.iam/invalidAuthenticationCodeMessage)

(s/def
  :cognitect.aws.iam.TagInstanceProfileRequest/InstanceProfileName
  :cognitect.aws.iam/instanceProfileNameType)

(s/def :cognitect.aws.iam.TagInstanceProfileRequest/Tags :cognitect.aws.iam/tagListType)

(s/def
  :cognitect.aws.iam.GetServiceLinkedRoleDeletionStatusRequest/DeletionTaskId
  :cognitect.aws.iam/DeletionTaskIdType)

(s/def :cognitect.aws.iam.TagSAMLProviderRequest/SAMLProviderArn :cognitect.aws.iam/arnType)

(s/def :cognitect.aws.iam.TagSAMLProviderRequest/Tags :cognitect.aws.iam/tagListType)

