;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.redshift-serverless.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.redshift-serverless/GetWorkgroupRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetWorkgroupRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/TableRestoreStatusList
  (s/coll-of :cognitect.aws.redshift-serverless/TableRestoreStatus))

(s/def
  :cognitect.aws.redshift-serverless/DeleteResourcePolicyRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteResourcePolicyRequest/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/CreateNamespaceRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateNamespaceRequest/namespaceName]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminPasswordSecretKmsKeyId
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/redshiftIdcApplicationArn
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/kmsKeyId
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/tags
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/defaultIamRoleArn
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/manageAdminPassword
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminUserPassword
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/logExports
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/iamRoles
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/dbName
     :cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminUsername]))

(s/def
  :cognitect.aws.redshift-serverless/ThrottlingException
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ThrottlingException/message
     :cognitect.aws.redshift-serverless.ThrottlingException/code]))

(s/def
  :cognitect.aws.redshift-serverless/SnapshotCopyConfigurations
  (s/coll-of
    :cognitect.aws.redshift-serverless/SnapshotCopyConfiguration
    :min-count
    1
    :max-count
    100))

(s/def
  :cognitect.aws.redshift-serverless/UpdateCustomDomainAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainName
     :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/workgroupName
     :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainCertificateExpiryTime]))

(s/def
  :cognitect.aws.redshift-serverless/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.TagResourceRequest/resourceArn
     :cognitect.aws.redshift-serverless.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreTableFromSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/namespaceName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/newTableName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/snapshotName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceDatabaseName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceTableName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/targetDatabaseName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/targetSchemaName
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/activateCaseSensitiveIdentifier
     :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceSchemaName]))

(s/def
  :cognitect.aws.redshift-serverless/ServiceQuotaExceededException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.ServiceQuotaExceededException/message]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteScheduledActionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.DeleteScheduledActionResponse/scheduledAction]))

(s/def
  :cognitect.aws.redshift-serverless/InternalServerException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.InternalServerException/message]))

(s/def
  :cognitect.aws.redshift-serverless/ListTableRestoreStatusRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/maxResults
     :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/nextToken
     :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/namespaceName
     :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteNamespaceRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.DeleteNamespaceRequest/namespaceName]
    :opt-un
    [:cognitect.aws.redshift-serverless.DeleteNamespaceRequest/finalSnapshotRetentionPeriod
     :cognitect.aws.redshift-serverless.DeleteNamespaceRequest/finalSnapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/ListTableRestoreStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListTableRestoreStatusResponse/nextToken
     :cognitect.aws.redshift-serverless.ListTableRestoreStatusResponse/tableRestoreStatuses]))

(s/def
  :cognitect.aws.redshift-serverless/ResourcePolicy
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ResourcePolicy/policy
     :cognitect.aws.redshift-serverless.ResourcePolicy/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteCustomDomainAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.DeleteCustomDomainAssociationRequest/customDomainName
     :cognitect.aws.redshift-serverless.DeleteCustomDomainAssociationRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/ListUsageLimitsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/CreateUsageLimitRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateUsageLimitRequest/amount
     :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/resourceArn
     :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/usageType]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateUsageLimitRequest/period
     :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/breachAction]))

(s/def
  :cognitect.aws.redshift-serverless/CreateSnapshotScheduleActionParameters
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/namespaceName
     :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/snapshotNamePrefix]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/retentionPeriod
     :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/tags]))

(s/def
  :cognitect.aws.redshift-serverless/GetNamespaceRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetNamespaceRequest/namespaceName]))

(s/def
  :cognitect.aws.redshift-serverless/Workgroup
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Workgroup/workgroupId
     :cognitect.aws.redshift-serverless.Workgroup/creationDate
     :cognitect.aws.redshift-serverless.Workgroup/patchVersion
     :cognitect.aws.redshift-serverless.Workgroup/subnetIds
     :cognitect.aws.redshift-serverless.Workgroup/baseCapacity
     :cognitect.aws.redshift-serverless.Workgroup/workgroupVersion
     :cognitect.aws.redshift-serverless.Workgroup/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.Workgroup/configParameters
     :cognitect.aws.redshift-serverless.Workgroup/namespaceName
     :cognitect.aws.redshift-serverless.Workgroup/status
     :cognitect.aws.redshift-serverless.Workgroup/maxCapacity
     :cognitect.aws.redshift-serverless.Workgroup/enhancedVpcRouting
     :cognitect.aws.redshift-serverless.Workgroup/publiclyAccessible
     :cognitect.aws.redshift-serverless.Workgroup/pricePerformanceTarget
     :cognitect.aws.redshift-serverless.Workgroup/port
     :cognitect.aws.redshift-serverless.Workgroup/crossAccountVpcs
     :cognitect.aws.redshift-serverless.Workgroup/customDomainName
     :cognitect.aws.redshift-serverless.Workgroup/ipAddressType
     :cognitect.aws.redshift-serverless.Workgroup/workgroupArn
     :cognitect.aws.redshift-serverless.Workgroup/endpoint
     :cognitect.aws.redshift-serverless.Workgroup/securityGroupIds
     :cognitect.aws.redshift-serverless.Workgroup/workgroupName
     :cognitect.aws.redshift-serverless.Workgroup/customDomainCertificateExpiryTime]))

(s/def :cognitect.aws.redshift-serverless/ParameterValue string?)

(s/def
  :cognitect.aws.redshift-serverless/Tag
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.Tag/key :cognitect.aws.redshift-serverless.Tag/value]))

(s/def
  :cognitect.aws.redshift-serverless/SecurityGroupIdList
  (s/coll-of :cognitect.aws.redshift-serverless/SecurityGroupId))

(s/def
  :cognitect.aws.redshift-serverless/ListCustomDomainAssociationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/customDomainName]))

(s/def
  :cognitect.aws.redshift-serverless/ListWorkgroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListWorkgroupsRequest/ownerAccount
     :cognitect.aws.redshift-serverless.ListWorkgroupsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListWorkgroupsRequest/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/GetCustomDomainAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainName
     :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/workgroupName
     :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainCertificateExpiryTime]))

(s/def
  :cognitect.aws.redshift-serverless/ScheduledActionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionUuid
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionName
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/targetAction
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionDescription
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/roleArn
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/nextInvocations
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/schedule
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/startTime
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/namespaceName
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/state
     :cognitect.aws.redshift-serverless.ScheduledActionResponse/endTime]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteSnapshotCopyConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.DeleteSnapshotCopyConfigurationRequest/snapshotCopyConfigurationId]))

(s/def
  :cognitect.aws.redshift-serverless/WorkgroupName
  (s/spec #(re-matches (re-pattern "^[a-z0-9-]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.redshift-serverless/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.redshift-serverless/CreateCustomDomainAssociationResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainName
     :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/workgroupName
     :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainCertificateExpiryTime]))

(s/def
  :cognitect.aws.redshift-serverless/GetScheduledActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.GetScheduledActionRequest/scheduledActionName]))

(s/def :cognitect.aws.redshift-serverless/ParameterKey string?)

(s/def
  :cognitect.aws.redshift-serverless/ListScheduledActionsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/RestoreFromSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/namespaceName
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/adminPasswordSecretKmsKeyId
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/ownerAccount
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/manageAdminPassword
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/snapshotArn
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/snapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/UsageLimitBreachAction
  (s/spec string? :gen #(s/gen #{"deactivate" "log" "emit-metric"})))

(s/def
  :cognitect.aws.redshift-serverless/RedshiftIdcApplicationArn
  (s/spec
    (s/and string? #(<= 1 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/WorkgroupStatus
  (s/spec string? :gen #(s/gen #{"AVAILABLE" "DELETING" "CREATING" "MODIFYING"})))

(s/def
  :cognitect.aws.redshift-serverless/Endpoint
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Endpoint/address
     :cognitect.aws.redshift-serverless.Endpoint/port
     :cognitect.aws.redshift-serverless.Endpoint/vpcEndpoints]))

(s/def
  :cognitect.aws.redshift-serverless/GetResourcePolicyRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetResourcePolicyRequest/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/ListEndpointAccessRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListEndpointAccessRequest/ownerAccount
     :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/vpcId
     :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/maxResults
     :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/nextToken
     :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/ListCustomDomainAssociationsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/SnapshotList
  (s/coll-of :cognitect.aws.redshift-serverless/Snapshot))

(s/def
  :cognitect.aws.redshift-serverless/VpcSecurityGroupMembershipList
  (s/coll-of :cognitect.aws.redshift-serverless/VpcSecurityGroupMembership))

(s/def
  :cognitect.aws.redshift-serverless/ListNamespacesRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/UpdateScheduledActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/scheduledActionName]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/targetAction
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/scheduledActionDescription
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/roleArn
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/enabled
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/schedule
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/startTime
     :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/endTime]))

(s/def
  :cognitect.aws.redshift-serverless/GetSnapshotRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.GetSnapshotRequest/ownerAccount
     :cognitect.aws.redshift-serverless.GetSnapshotRequest/snapshotArn
     :cognitect.aws.redshift-serverless.GetSnapshotRequest/snapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/UsageLimit
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.UsageLimit/usageLimitId
     :cognitect.aws.redshift-serverless.UsageLimit/usageLimitArn
     :cognitect.aws.redshift-serverless.UsageLimit/usageType
     :cognitect.aws.redshift-serverless.UsageLimit/amount
     :cognitect.aws.redshift-serverless.UsageLimit/period
     :cognitect.aws.redshift-serverless.UsageLimit/resourceArn
     :cognitect.aws.redshift-serverless.UsageLimit/breachAction]))

(s/def
  :cognitect.aws.redshift-serverless/NamespaceName
  (s/spec #(re-matches (re-pattern "^[a-z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/ValidationException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.ValidationException/message]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateSnapshotResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.UpdateSnapshotResponse/snapshot]))

(s/def
  :cognitect.aws.redshift-serverless/AccessDeniedException
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.AccessDeniedException/message
     :cognitect.aws.redshift-serverless.AccessDeniedException/code]))

(s/def
  :cognitect.aws.redshift-serverless/Schedule
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Schedule/cron
     :cognitect.aws.redshift-serverless.Schedule/at]))

(s/def
  :cognitect.aws.redshift-serverless/TagList
  (s/coll-of :cognitect.aws.redshift-serverless/Tag :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.redshift-serverless/UpdateSnapshotCopyConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationRequest/snapshotCopyConfigurationId]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationRequest/snapshotRetentionPeriod]))

(s/def
  :cognitect.aws.redshift-serverless/VpcSecurityGroupIdList
  (s/coll-of :cognitect.aws.redshift-serverless/VpcSecurityGroupId))

(s/def
  :cognitect.aws.redshift-serverless/ConfigParameterList
  (s/coll-of :cognitect.aws.redshift-serverless/ConfigParameter))

(s/def
  :cognitect.aws.redshift-serverless/RestoreFromRecoveryPointResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreFromRecoveryPointResponse/recoveryPointId
     :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointResponse/namespace]))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/TableRestoreStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.TableRestoreStatus/message
     :cognitect.aws.redshift-serverless.TableRestoreStatus/targetDatabaseName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/progressInMegaBytes
     :cognitect.aws.redshift-serverless.TableRestoreStatus/newTableName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/targetSchemaName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/recoveryPointId
     :cognitect.aws.redshift-serverless.TableRestoreStatus/requestTime
     :cognitect.aws.redshift-serverless.TableRestoreStatus/namespaceName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/status
     :cognitect.aws.redshift-serverless.TableRestoreStatus/tableRestoreRequestId
     :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceTableName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/workgroupName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceDatabaseName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/totalDataInMegaBytes
     :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceSchemaName
     :cognitect.aws.redshift-serverless.TableRestoreStatus/snapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/ListNamespacesResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ListNamespacesResponse/namespaces]
    :opt-un
    [:cognitect.aws.redshift-serverless.ListNamespacesResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/RecoveryPoint
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.RecoveryPoint/namespaceArn
     :cognitect.aws.redshift-serverless.RecoveryPoint/totalSizeInMegaBytes
     :cognitect.aws.redshift-serverless.RecoveryPoint/recoveryPointId
     :cognitect.aws.redshift-serverless.RecoveryPoint/recoveryPointCreateTime
     :cognitect.aws.redshift-serverless.RecoveryPoint/namespaceName
     :cognitect.aws.redshift-serverless.RecoveryPoint/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/CreateWorkgroupResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.CreateWorkgroupResponse/workgroup]))

(s/def
  :cognitect.aws.redshift-serverless/CreateSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotRequest/namespaceName
     :cognitect.aws.redshift-serverless.CreateSnapshotRequest/snapshotName]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotRequest/retentionPeriod
     :cognitect.aws.redshift-serverless.CreateSnapshotRequest/tags]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateUsageLimitResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.UpdateUsageLimitResponse/usageLimit]))

(s/def
  :cognitect.aws.redshift-serverless/AssociationList
  (s/coll-of :cognitect.aws.redshift-serverless/Association))

(s/def
  :cognitect.aws.redshift-serverless/UpdateCustomDomainAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/customDomainName
     :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/InvalidPaginationException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.InvalidPaginationException/message]))

(s/def
  :cognitect.aws.redshift-serverless/ScheduledActionAssociation
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ScheduledActionAssociation/scheduledActionName
     :cognitect.aws.redshift-serverless.ScheduledActionAssociation/namespaceName]))

(s/def
  :cognitect.aws.redshift-serverless/ListRecoveryPointsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/namespaceArn
     :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/startTime
     :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/namespaceName
     :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/endTime]))

(s/def
  :cognitect.aws.redshift-serverless/PerformanceTarget
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.PerformanceTarget/level
     :cognitect.aws.redshift-serverless.PerformanceTarget/status]))

(s/def
  :cognitect.aws.redshift-serverless/GetSnapshotResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetSnapshotResponse/snapshot]))

(s/def
  :cognitect.aws.redshift-serverless/NextInvocationsList
  (s/coll-of :cognitect.aws.redshift-serverless/Timestamp))

(s/def
  :cognitect.aws.redshift-serverless/TargetAction
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.TargetAction/createSnapshot]))

(s/def
  :cognitect.aws.redshift-serverless/IpAddressType
  (s/spec #(re-matches (re-pattern "^(ipv4|dualstack)$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/CreateEndpointAccessRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/endpointName
     :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/subnetIds
     :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/ownerAccount
     :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/vpcSecurityGroupIds]))

(s/def
  :cognitect.aws.redshift-serverless/NetworkInterface
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.NetworkInterface/subnetId
     :cognitect.aws.redshift-serverless.NetworkInterface/privateIpAddress
     :cognitect.aws.redshift-serverless.NetworkInterface/ipv6Address
     :cognitect.aws.redshift-serverless.NetworkInterface/availabilityZone
     :cognitect.aws.redshift-serverless.NetworkInterface/networkInterfaceId]))

(s/def
  :cognitect.aws.redshift-serverless/GetWorkgroupResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetWorkgroupResponse/workgroup]))

(s/def
  :cognitect.aws.redshift-serverless/PutResourcePolicyRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.PutResourcePolicyRequest/policy
     :cognitect.aws.redshift-serverless.PutResourcePolicyRequest/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateWorkgroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/subnetIds
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/baseCapacity
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/configParameters
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/maxCapacity
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/enhancedVpcRouting
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/publiclyAccessible
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/pricePerformanceTarget
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/port
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/ipAddressType
     :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/securityGroupIds]))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListSnapshotsRequest/namespaceArn
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/ownerAccount
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/startTime
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/namespaceName
     :cognitect.aws.redshift-serverless.ListSnapshotsRequest/endTime]))

(s/def :cognitect.aws.redshift-serverless/Boolean boolean?)

(s/def
  :cognitect.aws.redshift-serverless/Snapshot
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Snapshot/namespaceArn
     :cognitect.aws.redshift-serverless.Snapshot/adminPasswordSecretKmsKeyId
     :cognitect.aws.redshift-serverless.Snapshot/snapshotRetentionStartTime
     :cognitect.aws.redshift-serverless.Snapshot/adminPasswordSecretArn
     :cognitect.aws.redshift-serverless.Snapshot/accountsWithProvisionedRestoreAccess
     :cognitect.aws.redshift-serverless.Snapshot/kmsKeyId
     :cognitect.aws.redshift-serverless.Snapshot/ownerAccount
     :cognitect.aws.redshift-serverless.Snapshot/estimatedSecondsToCompletion
     :cognitect.aws.redshift-serverless.Snapshot/currentBackupRateInMegaBytesPerSecond
     :cognitect.aws.redshift-serverless.Snapshot/elapsedTimeInSeconds
     :cognitect.aws.redshift-serverless.Snapshot/snapshotCreateTime
     :cognitect.aws.redshift-serverless.Snapshot/actualIncrementalBackupSizeInMegaBytes
     :cognitect.aws.redshift-serverless.Snapshot/snapshotRetentionPeriod
     :cognitect.aws.redshift-serverless.Snapshot/snapshotArn
     :cognitect.aws.redshift-serverless.Snapshot/namespaceName
     :cognitect.aws.redshift-serverless.Snapshot/status
     :cognitect.aws.redshift-serverless.Snapshot/snapshotRemainingDays
     :cognitect.aws.redshift-serverless.Snapshot/totalBackupSizeInMegaBytes
     :cognitect.aws.redshift-serverless.Snapshot/accountsWithRestoreAccess
     :cognitect.aws.redshift-serverless.Snapshot/backupProgressInMegaBytes
     :cognitect.aws.redshift-serverless.Snapshot/snapshotName
     :cognitect.aws.redshift-serverless.Snapshot/adminUsername]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateScheduledActionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateScheduledActionResponse/scheduledAction]))

(s/def
  :cognitect.aws.redshift-serverless/ManagedWorkgroups
  (s/coll-of :cognitect.aws.redshift-serverless/ManagedWorkgroupListItem))

(s/def
  :cognitect.aws.redshift-serverless/DeleteEndpointAccessRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteEndpointAccessRequest/endpointName]))

(s/def
  :cognitect.aws.redshift-serverless/ListScheduledActionsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListScheduledActionsResponse/nextToken
     :cognitect.aws.redshift-serverless.ListScheduledActionsResponse/scheduledActions]))

(s/def :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time inst?)

(s/def
  :cognitect.aws.redshift-serverless/ListScheduledActionsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListScheduledActionsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListScheduledActionsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListScheduledActionsRequest/namespaceName]))

(s/def
  :cognitect.aws.redshift-serverless/AmazonResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 1011))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 1011) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/UsageLimitUsageType
  (s/spec string? :gen #(s/gen #{"cross-region-datasharing" "serverless-compute"})))

(s/def
  :cognitect.aws.redshift-serverless/DeleteSnapshotRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteSnapshotRequest/snapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/InsufficientCapacityException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.InsufficientCapacityException/message]))

(s/def :cognitect.aws.redshift-serverless/DbName string?)

(s/def
  :cognitect.aws.redshift-serverless/GetScheduledActionResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetScheduledActionResponse/scheduledAction]))

(s/def :cognitect.aws.redshift-serverless/IamRoleArn string?)

(s/def
  :cognitect.aws.redshift-serverless/GetEndpointAccessRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetEndpointAccessRequest/endpointName]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteSnapshotCopyConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.DeleteSnapshotCopyConfigurationResponse/snapshotCopyConfiguration]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreFromSnapshotResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/ownerAccount
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/namespace
     :cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/snapshotName]))

(s/def
  :cognitect.aws.redshift-serverless/NetworkInterfaceList
  (s/coll-of :cognitect.aws.redshift-serverless/NetworkInterface))

(s/def
  :cognitect.aws.redshift-serverless/TooManyTagsException
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.TooManyTagsException/message
     :cognitect.aws.redshift-serverless.TooManyTagsException/resourceName]))

(s/def
  :cognitect.aws.redshift-serverless/GetTableRestoreStatusResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.GetTableRestoreStatusResponse/tableRestoreStatus]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateEndpointAccessRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateEndpointAccessRequest/endpointName]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateEndpointAccessRequest/vpcSecurityGroupIds]))

(s/def
  :cognitect.aws.redshift-serverless/NamespaceStatus
  (s/spec string? :gen #(s/gen #{"AVAILABLE" "DELETING" "MODIFYING"})))

(s/def
  :cognitect.aws.redshift-serverless/VpcEndpointList
  (s/coll-of :cognitect.aws.redshift-serverless/VpcEndpoint))

(s/def
  :cognitect.aws.redshift-serverless/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift-serverless/GetTableRestoreStatusRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.GetTableRestoreStatusRequest/tableRestoreRequestId]))

(s/def
  :cognitect.aws.redshift-serverless/VpcSecurityGroupMembership
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.VpcSecurityGroupMembership/vpcSecurityGroupId
     :cognitect.aws.redshift-serverless.VpcSecurityGroupMembership/status]))

(s/def
  :cognitect.aws.redshift-serverless/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/CreateWorkgroupRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateWorkgroupRequest/namespaceName
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateWorkgroupRequest/subnetIds
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/baseCapacity
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/tags
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/configParameters
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/maxCapacity
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/enhancedVpcRouting
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/publiclyAccessible
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/pricePerformanceTarget
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/port
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/ipAddressType
     :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/securityGroupIds]))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotCopyConfigurationsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/namespaceName]))

(s/def
  :cognitect.aws.redshift-serverless/LogExport
  (s/spec string? :gen #(s/gen #{"useractivitylog" "connectionlog" "userlog"})))

(s/def
  :cognitect.aws.redshift-serverless/ManagedWorkgroupListItem
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/creationDate
     :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/managedWorkgroupName
     :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/sourceArn
     :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/status
     :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/managedWorkgroupId]))

(s/def
  :cognitect.aws.redshift-serverless/UsageLimits
  (s/coll-of :cognitect.aws.redshift-serverless/UsageLimit :min-count 1 :max-count 100))

(s/def
  :cognitect.aws.redshift-serverless/ManagedWorkgroupName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9_:\\-]+$") %) :gen #(gen/string)))

(s/def :cognitect.aws.redshift-serverless/DbPassword string?)

(s/def
  :cognitect.aws.redshift-serverless/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/ScheduledActionsList
  (s/coll-of :cognitect.aws.redshift-serverless/ScheduledActionAssociation))

(s/def
  :cognitect.aws.redshift-serverless/PutResourcePolicyResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.PutResourcePolicyResponse/resourcePolicy]))

(s/def
  :cognitect.aws.redshift-serverless/IamRoleArnList
  (s/coll-of :cognitect.aws.redshift-serverless/IamRoleArn))

(s/def :cognitect.aws.redshift-serverless/VpcSecurityGroupId string?)

(s/def :cognitect.aws.redshift-serverless/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.redshift-serverless/DeleteEndpointAccessResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.DeleteEndpointAccessResponse/endpoint]))

(s/def :cognitect.aws.redshift-serverless/SecurityGroupId string?)

(s/def
  :cognitect.aws.redshift-serverless/ListEndpointAccessResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ListEndpointAccessResponse/endpoints]
    :opt-un
    [:cognitect.aws.redshift-serverless.ListEndpointAccessResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/ListNamespacesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListNamespacesRequest/maxResults
     :cognitect.aws.redshift-serverless.ListNamespacesRequest/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/PerformanceTargetStatus
  (s/spec string? :gen #(s/gen #{"DISABLED" "ENABLED"})))

(s/def
  :cognitect.aws.redshift-serverless/UpdateEndpointAccessResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.UpdateEndpointAccessResponse/endpoint]))

(s/def :cognitect.aws.redshift-serverless/SubnetId string?)

(s/def
  :cognitect.aws.redshift-serverless/DeleteScheduledActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.DeleteScheduledActionRequest/scheduledActionName]))

(s/def :cognitect.aws.redshift-serverless/KmsKeyId string?)

(s/def
  :cognitect.aws.redshift-serverless/GetCustomDomainAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.GetCustomDomainAssociationRequest/customDomainName
     :cognitect.aws.redshift-serverless.GetCustomDomainAssociationRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/LogExportList
  (s/coll-of :cognitect.aws.redshift-serverless/LogExport :min-count 0 :max-count 16))

(s/def
  :cognitect.aws.redshift-serverless/VpcIds
  (s/coll-of :cognitect.aws.redshift-serverless/String))

(s/def
  :cognitect.aws.redshift-serverless/UpdateSnapshotCopyConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationResponse/snapshotCopyConfiguration]))

(s/def
  :cognitect.aws.redshift-serverless/CreateEndpointAccessResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.CreateEndpointAccessResponse/endpoint]))

(s/def
  :cognitect.aws.redshift-serverless/ScheduledActionName
  (s/spec #(re-matches (re-pattern "^[a-z0-9-]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/Namespace
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Namespace/namespaceArn
     :cognitect.aws.redshift-serverless.Namespace/creationDate
     :cognitect.aws.redshift-serverless.Namespace/adminPasswordSecretKmsKeyId
     :cognitect.aws.redshift-serverless.Namespace/adminPasswordSecretArn
     :cognitect.aws.redshift-serverless.Namespace/kmsKeyId
     :cognitect.aws.redshift-serverless.Namespace/defaultIamRoleArn
     :cognitect.aws.redshift-serverless.Namespace/namespaceName
     :cognitect.aws.redshift-serverless.Namespace/status
     :cognitect.aws.redshift-serverless.Namespace/logExports
     :cognitect.aws.redshift-serverless.Namespace/iamRoles
     :cognitect.aws.redshift-serverless.Namespace/dbName
     :cognitect.aws.redshift-serverless.Namespace/namespaceId
     :cognitect.aws.redshift-serverless.Namespace/adminUsername]))

(s/def
  :cognitect.aws.redshift-serverless/CreateCustomDomainAssociationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/customDomainName
     :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreTableFromRecoveryPointRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/namespaceName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/newTableName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/recoveryPointId
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceDatabaseName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceTableName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/workgroupName]
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/targetDatabaseName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/targetSchemaName
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/activateCaseSensitiveIdentifier
     :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceSchemaName]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteWorkgroupRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteWorkgroupRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/RecoveryPointList
  (s/coll-of :cognitect.aws.redshift-serverless/RecoveryPoint))

(s/def
  :cognitect.aws.redshift-serverless/GetEndpointAccessResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetEndpointAccessResponse/endpoint]))

(s/def
  :cognitect.aws.redshift-serverless/ListManagedWorkgroupsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/ConvertRecoveryPointToSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/recoveryPointId
     :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/snapshotName]
    :opt-un
    [:cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/retentionPeriod
     :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/tags]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateNamespaceRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateNamespaceRequest/namespaceName]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminPasswordSecretKmsKeyId
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/kmsKeyId
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/defaultIamRoleArn
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/manageAdminPassword
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminUserPassword
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/logExports
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/iamRoles
     :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminUsername]))

(s/def
  :cognitect.aws.redshift-serverless/CreateSnapshotCopyConfigurationRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/destinationRegion
     :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/namespaceName]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/snapshotRetentionPeriod
     :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/destinationKmsKeyId]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreTableFromRecoveryPointResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointResponse/tableRestoreStatus]))

(s/def
  :cognitect.aws.redshift-serverless/AccountIdList
  (s/coll-of :cognitect.aws.redshift-serverless/String))

(s/def
  :cognitect.aws.redshift-serverless/Long
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift-serverless/ListEndpointAccessRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/GetUsageLimitRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetUsageLimitRequest/usageLimitId]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteUsageLimitResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.DeleteUsageLimitResponse/usageLimit]))

(s/def
  :cognitect.aws.redshift-serverless/ConvertRecoveryPointToSnapshotResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotResponse/snapshot]))

(s/def
  :cognitect.aws.redshift-serverless/SubnetIdList
  (s/coll-of :cognitect.aws.redshift-serverless/SubnetId))

(s/def
  :cognitect.aws.redshift-serverless/ListWorkgroupsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/ListRecoveryPointsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/VpcEndpoint
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.VpcEndpoint/networkInterfaces
     :cognitect.aws.redshift-serverless.VpcEndpoint/vpcEndpointId
     :cognitect.aws.redshift-serverless.VpcEndpoint/vpcId]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteUsageLimitRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteUsageLimitRequest/usageLimitId]))

(s/def
  :cognitect.aws.redshift-serverless/PerformanceTargetLevelInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/CreateSnapshotCopyConfigurationResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationResponse/snapshotCopyConfiguration]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreFromRecoveryPointRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/namespaceName
     :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/recoveryPointId
     :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteWorkgroupResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteWorkgroupResponse/workgroup]))

(s/def
  :cognitect.aws.redshift-serverless/WorkgroupList
  (s/coll-of :cognitect.aws.redshift-serverless/Workgroup))

(s/def
  :cognitect.aws.redshift-serverless/GetRecoveryPointResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetRecoveryPointResponse/recoveryPoint]))

(s/def
  :cognitect.aws.redshift-serverless/ListCustomDomainAssociationsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListCustomDomainAssociationsResponse/associations
     :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UntagResourceRequest/resourceArn
     :cognitect.aws.redshift-serverless.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.redshift-serverless/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/ListWorkgroupsResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ListWorkgroupsResponse/workgroups]
    :opt-un
    [:cognitect.aws.redshift-serverless.ListWorkgroupsResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/GetCredentialsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.GetCredentialsRequest/durationSeconds
     :cognitect.aws.redshift-serverless.GetCredentialsRequest/customDomainName
     :cognitect.aws.redshift-serverless.GetCredentialsRequest/dbName
     :cognitect.aws.redshift-serverless.GetCredentialsRequest/workgroupName]))

(s/def
  :cognitect.aws.redshift-serverless/SnapshotNamePrefix
  (s/spec
    (s/and string? #(<= 1 (count %) 235))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 235) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/CreateUsageLimitResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.CreateUsageLimitResponse/usageLimit]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateSnapshotRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateSnapshotRequest/snapshotName]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateSnapshotRequest/retentionPeriod]))

(s/def
  :cognitect.aws.redshift-serverless/DeleteSnapshotResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.DeleteSnapshotResponse/snapshot]))

(s/def
  :cognitect.aws.redshift-serverless/CreateNamespaceResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.CreateNamespaceResponse/namespace]))

(s/def
  :cognitect.aws.redshift-serverless/SnapshotStatus
  (s/spec string? :gen #(s/gen #{"COPYING" "AVAILABLE" "CREATING" "FAILED" "DELETED" "CANCELLED"})))

(s/def
  :cognitect.aws.redshift-serverless/ListUsageLimitsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListUsageLimitsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/nextToken
     :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/usageType
     :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/resourceArn]))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListSnapshotsResponse/nextToken
     :cognitect.aws.redshift-serverless.ListSnapshotsResponse/snapshots]))

(s/def
  :cognitect.aws.redshift-serverless/NamespaceList
  (s/coll-of :cognitect.aws.redshift-serverless/Namespace))

(s/def
  :cognitect.aws.redshift-serverless/ListTableRestoreStatusRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/DeleteNamespaceResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.DeleteNamespaceResponse/namespace]))

(s/def
  :cognitect.aws.redshift-serverless/ManagedWorkgroupStatus
  (s/spec string? :gen #(s/gen #{"AVAILABLE" "NOT_AVAILABLE" "DELETING" "CREATING" "MODIFYING"})))

(s/def
  :cognitect.aws.redshift-serverless/CreateSnapshotResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.CreateSnapshotResponse/snapshot]))

(s/def
  :cognitect.aws.redshift-serverless/GetUsageLimitResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetUsageLimitResponse/usageLimit]))

(s/def :cognitect.aws.redshift-serverless/Timestamp inst?)

(s/def
  :cognitect.aws.redshift-serverless/State
  (s/spec string? :gen #(s/gen #{"DISABLED" "ACTIVE"})))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotCopyConfigurationsResponse
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsResponse/snapshotCopyConfigurations]
    :opt-un
    [:cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/RestoreTableFromSnapshotResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.RestoreTableFromSnapshotResponse/tableRestoreStatus]))

(s/def
  :cognitect.aws.redshift-serverless/CreateScheduledActionRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.CreateScheduledActionRequest/namespaceName
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/roleArn
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/schedule
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/scheduledActionName
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/targetAction]
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateScheduledActionRequest/scheduledActionDescription
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/enabled
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/startTime
     :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/endTime]))

(s/def :cognitect.aws.redshift-serverless/DeleteCustomDomainAssociationResponse (s/keys))

(s/def
  :cognitect.aws.redshift-serverless/EndpointAccess
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.EndpointAccess/vpcSecurityGroups
     :cognitect.aws.redshift-serverless.EndpointAccess/subnetIds
     :cognitect.aws.redshift-serverless.EndpointAccess/endpointStatus
     :cognitect.aws.redshift-serverless.EndpointAccess/address
     :cognitect.aws.redshift-serverless.EndpointAccess/port
     :cognitect.aws.redshift-serverless.EndpointAccess/vpcEndpoint
     :cognitect.aws.redshift-serverless.EndpointAccess/endpointName
     :cognitect.aws.redshift-serverless.EndpointAccess/endpointCreateTime
     :cognitect.aws.redshift-serverless.EndpointAccess/workgroupName
     :cognitect.aws.redshift-serverless.EndpointAccess/endpointArn]))

(s/def
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString
  (s/spec
    #(re-matches
      (re-pattern "arn:[\\w+=/,.@-]+:acm:[\\w+=/,.@-]*:[0-9]+:[\\w+=,.@-]+(/[\\w+=,.@-]+)*")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/UpdateUsageLimitRequest
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/usageLimitId]
    :opt-un
    [:cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/amount
     :cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/breachAction]))

(s/def
  :cognitect.aws.redshift-serverless/ListRecoveryPointsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListRecoveryPointsResponse/nextToken
     :cognitect.aws.redshift-serverless.ListRecoveryPointsResponse/recoveryPoints]))

(s/def
  :cognitect.aws.redshift-serverless/UsageLimitPeriod
  (s/spec string? :gen #(s/gen #{"weekly" "daily" "monthly"})))

(s/def
  :cognitect.aws.redshift-serverless/OwnerAccount
  (s/spec #(re-matches (re-pattern "(\\d{12})") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/CustomDomainName
  (s/spec
    #(re-matches
      (re-pattern
        "^(((?!-)[A-Za-z0-9-]{0,62}[A-Za-z0-9])\\.)+((?!-)[A-Za-z0-9-]{1,62}[A-Za-z0-9])$")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.redshift-serverless/ListUsageLimitsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListUsageLimitsResponse/usageLimits
     :cognitect.aws.redshift-serverless.ListUsageLimitsResponse/nextToken]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateNamespaceResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.UpdateNamespaceResponse/namespace]))

(s/def
  :cognitect.aws.redshift-serverless/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.redshift-serverless/Ipv6CidrBlockNotFoundException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.Ipv6CidrBlockNotFoundException/message]))

(s/def
  :cognitect.aws.redshift-serverless/Association
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.Association/customDomainCertificateArn
     :cognitect.aws.redshift-serverless.Association/customDomainName
     :cognitect.aws.redshift-serverless.Association/workgroupName
     :cognitect.aws.redshift-serverless.Association/customDomainCertificateExpiryTime]))

(s/def
  :cognitect.aws.redshift-serverless/SnapshotCopyConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotCopyConfigurationId
     :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotCopyConfigurationArn
     :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotRetentionPeriod
     :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/namespaceName
     :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/destinationKmsKeyId
     :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/destinationRegion]))

(s/def
  :cognitect.aws.redshift-serverless/ListManagedWorkgroupsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/sourceArn
     :cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/maxResults
     :cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/nextToken]))

(s/def :cognitect.aws.redshift-serverless/DbUser string?)

(s/def
  :cognitect.aws.redshift-serverless/ListTagsForResourceResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.redshift-serverless/GetCredentialsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.GetCredentialsResponse/nextRefreshTime
     :cognitect.aws.redshift-serverless.GetCredentialsResponse/dbPassword
     :cognitect.aws.redshift-serverless.GetCredentialsResponse/expiration
     :cognitect.aws.redshift-serverless.GetCredentialsResponse/dbUser]))

(s/def
  :cognitect.aws.redshift-serverless/PaginationToken
  (s/spec
    (s/and string? #(<= 8 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 8 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift-serverless/ListSnapshotCopyConfigurationsRequestMaxResultsInteger
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.redshift-serverless/GetRecoveryPointRequest
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetRecoveryPointRequest/recoveryPointId]))

(s/def
  :cognitect.aws.redshift-serverless/UpdateWorkgroupResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.UpdateWorkgroupResponse/workgroup]))

(s/def
  :cognitect.aws.redshift-serverless/GetResourcePolicyResponse
  (s/keys :opt-un [:cognitect.aws.redshift-serverless.GetResourcePolicyResponse/resourcePolicy]))

(s/def
  :cognitect.aws.redshift-serverless/SourceArn
  (s/spec
    #(re-matches
      (re-pattern
        "^arn:aws[a-z-]*:glue:[a-z0-9-]+:\\d+:(database|catalog)[a-z0-9-:]*(?:/[A-Za-z0-9-_]{1,255})*$")
      %)
    :gen
    #(gen/string)))

(s/def :cognitect.aws.redshift-serverless/String string?)

(s/def
  :cognitect.aws.redshift-serverless/GetNamespaceResponse
  (s/keys :req-un [:cognitect.aws.redshift-serverless.GetNamespaceResponse/namespace]))

(s/def :cognitect.aws.redshift-serverless/DeleteResourcePolicyResponse (s/keys))

(s/def
  :cognitect.aws.redshift-serverless/ConfigParameter
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ConfigParameter/parameterKey
     :cognitect.aws.redshift-serverless.ConfigParameter/parameterValue]))

(s/def
  :cognitect.aws.redshift-serverless/ListManagedWorkgroupsResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.ListManagedWorkgroupsResponse/nextToken
     :cognitect.aws.redshift-serverless.ListManagedWorkgroupsResponse/managedWorkgroups]))

(s/def
  :cognitect.aws.redshift-serverless/EndpointAccessList
  (s/coll-of :cognitect.aws.redshift-serverless/EndpointAccess))

(s/def
  :cognitect.aws.redshift-serverless/ResourceNotFoundException
  (s/keys
    :req-un
    [:cognitect.aws.redshift-serverless.ResourceNotFoundException/message]
    :opt-un
    [:cognitect.aws.redshift-serverless.ResourceNotFoundException/resourceName]))

(s/def
  :cognitect.aws.redshift-serverless/ConflictException
  (s/keys :req-un [:cognitect.aws.redshift-serverless.ConflictException/message]))

(s/def
  :cognitect.aws.redshift-serverless/CreateScheduledActionResponse
  (s/keys
    :opt-un
    [:cognitect.aws.redshift-serverless.CreateScheduledActionResponse/scheduledAction]))

(s/def
  :cognitect.aws.redshift-serverless/TagKeyList
  (s/coll-of :cognitect.aws.redshift-serverless/TagKey :min-count 0 :max-count 200))

(s/def
  :cognitect.aws.redshift-serverless.GetWorkgroupRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.DeleteResourcePolicyRequest/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/iamRoles
  :cognitect.aws.redshift-serverless/IamRoleArnList)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/kmsKeyId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/redshiftIdcApplicationArn
  :cognitect.aws.redshift-serverless/RedshiftIdcApplicationArn)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/defaultIamRoleArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/manageAdminPassword
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminUsername
  :cognitect.aws.redshift-serverless/DbUser)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/logExports
  :cognitect.aws.redshift-serverless/LogExportList)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminPasswordSecretKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/dbName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceRequest/adminUserPassword
  :cognitect.aws.redshift-serverless/DbPassword)

(s/def
  :cognitect.aws.redshift-serverless.ThrottlingException/code
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ThrottlingException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainCertificateExpiryTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationResponse/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.TagResourceRequest/resourceArn
  :cognitect.aws.redshift-serverless/AmazonResourceName)

(s/def
  :cognitect.aws.redshift-serverless.TagResourceRequest/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/newTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/activateCaseSensitiveIdentifier
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/targetDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/targetSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/sourceTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ServiceQuotaExceededException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteScheduledActionResponse/scheduledAction
  :cognitect.aws.redshift-serverless/ScheduledActionResponse)

(s/def
  :cognitect.aws.redshift-serverless.InternalServerException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/maxResults
  :cognitect.aws.redshift-serverless/ListTableRestoreStatusRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusRequest/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteNamespaceRequest/finalSnapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteNamespaceRequest/finalSnapshotRetentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.DeleteNamespaceRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListTableRestoreStatusResponse/tableRestoreStatuses
  :cognitect.aws.redshift-serverless/TableRestoreStatusList)

(s/def
  :cognitect.aws.redshift-serverless.ResourcePolicy/policy
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ResourcePolicy/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteCustomDomainAssociationRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.DeleteCustomDomainAssociationRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/amount
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/breachAction
  :cognitect.aws.redshift-serverless/UsageLimitBreachAction)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/period
  :cognitect.aws.redshift-serverless/UsageLimitPeriod)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitRequest/usageType
  :cognitect.aws.redshift-serverless/UsageLimitUsageType)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/retentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/snapshotNamePrefix
  :cognitect.aws.redshift-serverless/SnapshotNamePrefix)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotScheduleActionParameters/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.GetNamespaceRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/crossAccountVpcs
  :cognitect.aws.redshift-serverless/VpcIds)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/patchVersion
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/subnetIds
  :cognitect.aws.redshift-serverless/SubnetIdList)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/workgroupArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/baseCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/configParameters
  :cognitect.aws.redshift-serverless/ConfigParameterList)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/pricePerformanceTarget
  :cognitect.aws.redshift-serverless/PerformanceTarget)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/workgroupId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/enhancedVpcRouting
  :cognitect.aws.redshift-serverless/Boolean)

(s/def :cognitect.aws.redshift-serverless.Workgroup/port :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/securityGroupIds
  :cognitect.aws.redshift-serverless/SecurityGroupIdList)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/status
  :cognitect.aws.redshift-serverless/WorkgroupStatus)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/customDomainCertificateExpiryTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/workgroupVersion
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/ipAddressType
  :cognitect.aws.redshift-serverless/IpAddressType)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/maxCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/endpoint
  :cognitect.aws.redshift-serverless/Endpoint)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/creationDate
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Workgroup/publiclyAccessible
  :cognitect.aws.redshift-serverless/Boolean)

(s/def :cognitect.aws.redshift-serverless.Tag/key :cognitect.aws.redshift-serverless/TagKey)

(s/def :cognitect.aws.redshift-serverless.Tag/value :cognitect.aws.redshift-serverless/TagValue)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListCustomDomainAssociationsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListWorkgroupsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListWorkgroupsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListWorkgroupsRequest/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListWorkgroupsRequest/ownerAccount
  :cognitect.aws.redshift-serverless/OwnerAccount)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainCertificateExpiryTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationResponse/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/schedule
  :cognitect.aws.redshift-serverless/Schedule)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/startTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/endTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/state
  :cognitect.aws.redshift-serverless/State)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionUuid
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/nextInvocations
  :cognitect.aws.redshift-serverless/NextInvocationsList)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/targetAction
  :cognitect.aws.redshift-serverless/TargetAction)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/scheduledActionDescription
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionResponse/roleArn
  :cognitect.aws.redshift-serverless/IamRoleArn)

(s/def
  :cognitect.aws.redshift-serverless.DeleteSnapshotCopyConfigurationRequest/snapshotCopyConfigurationId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainCertificateExpiryTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationResponse/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.GetScheduledActionRequest/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/adminPasswordSecretKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/manageAdminPassword
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/ownerAccount
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/snapshotArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.Endpoint/address
  :cognitect.aws.redshift-serverless/String)

(s/def :cognitect.aws.redshift-serverless.Endpoint/port :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Endpoint/vpcEndpoints
  :cognitect.aws.redshift-serverless/VpcEndpointList)

(s/def
  :cognitect.aws.redshift-serverless.GetResourcePolicyRequest/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/maxResults
  :cognitect.aws.redshift-serverless/ListEndpointAccessRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/ownerAccount
  :cognitect.aws.redshift-serverless/OwnerAccount)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/vpcId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessRequest/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/enabled
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/endTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/roleArn
  :cognitect.aws.redshift-serverless/IamRoleArn)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/schedule
  :cognitect.aws.redshift-serverless/Schedule)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/scheduledActionDescription
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/startTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionRequest/targetAction
  :cognitect.aws.redshift-serverless/TargetAction)

(s/def
  :cognitect.aws.redshift-serverless.GetSnapshotRequest/ownerAccount
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.GetSnapshotRequest/snapshotArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.GetSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def :cognitect.aws.redshift-serverless.UsageLimit/amount :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/breachAction
  :cognitect.aws.redshift-serverless/UsageLimitBreachAction)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/period
  :cognitect.aws.redshift-serverless/UsageLimitPeriod)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/usageLimitArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/usageLimitId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UsageLimit/usageType
  :cognitect.aws.redshift-serverless/UsageLimitUsageType)

(s/def
  :cognitect.aws.redshift-serverless.ValidationException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotResponse/snapshot
  :cognitect.aws.redshift-serverless/Snapshot)

(s/def
  :cognitect.aws.redshift-serverless.AccessDeniedException/code
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.AccessDeniedException/message
  :cognitect.aws.redshift-serverless/String)

(s/def :cognitect.aws.redshift-serverless.Schedule/at :cognitect.aws.redshift-serverless/Timestamp)

(s/def :cognitect.aws.redshift-serverless.Schedule/cron :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationRequest/snapshotCopyConfigurationId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationRequest/snapshotRetentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointResponse/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/totalDataInMegaBytes
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/newTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/tableRestoreRequestId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/requestTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/targetDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/status
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/targetSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/sourceTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/progressInMegaBytes
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TableRestoreStatus/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListNamespacesResponse/namespaces
  :cognitect.aws.redshift-serverless/NamespaceList)

(s/def
  :cognitect.aws.redshift-serverless.ListNamespacesResponse/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/namespaceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/recoveryPointCreateTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/totalSizeInMegaBytes
  :cognitect.aws.redshift-serverless/Double)

(s/def
  :cognitect.aws.redshift-serverless.RecoveryPoint/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupResponse/workgroup
  :cognitect.aws.redshift-serverless/Workgroup)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotRequest/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotRequest/retentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotRequest/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateUsageLimitResponse/usageLimit
  :cognitect.aws.redshift-serverless/UsageLimit)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateCustomDomainAssociationRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.InvalidPaginationException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionAssociation/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ScheduledActionAssociation/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/endTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListRecoveryPointsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/namespaceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsRequest/startTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.PerformanceTarget/level
  :cognitect.aws.redshift-serverless/PerformanceTargetLevelInteger)

(s/def
  :cognitect.aws.redshift-serverless.PerformanceTarget/status
  :cognitect.aws.redshift-serverless/PerformanceTargetStatus)

(s/def
  :cognitect.aws.redshift-serverless.GetSnapshotResponse/snapshot
  :cognitect.aws.redshift-serverless/Snapshot)

(s/def
  :cognitect.aws.redshift-serverless.TargetAction/createSnapshot
  :cognitect.aws.redshift-serverless/CreateSnapshotScheduleActionParameters)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/endpointName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/ownerAccount
  :cognitect.aws.redshift-serverless/OwnerAccount)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/subnetIds
  :cognitect.aws.redshift-serverless/SubnetIdList)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/vpcSecurityGroupIds
  :cognitect.aws.redshift-serverless/VpcSecurityGroupIdList)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessRequest/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.NetworkInterface/availabilityZone
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.NetworkInterface/ipv6Address
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.NetworkInterface/networkInterfaceId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.NetworkInterface/privateIpAddress
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.NetworkInterface/subnetId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.GetWorkgroupResponse/workgroup
  :cognitect.aws.redshift-serverless/Workgroup)

(s/def
  :cognitect.aws.redshift-serverless.PutResourcePolicyRequest/policy
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.PutResourcePolicyRequest/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/subnetIds
  :cognitect.aws.redshift-serverless/SubnetIdList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/baseCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/configParameters
  :cognitect.aws.redshift-serverless/ConfigParameterList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/pricePerformanceTarget
  :cognitect.aws.redshift-serverless/PerformanceTarget)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/enhancedVpcRouting
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/port
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/securityGroupIds
  :cognitect.aws.redshift-serverless/SecurityGroupIdList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/ipAddressType
  :cognitect.aws.redshift-serverless/IpAddressType)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/maxCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupRequest/publiclyAccessible
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/endTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListSnapshotsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/namespaceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/ownerAccount
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsRequest/startTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotRetentionStartTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/adminPasswordSecretArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/accountsWithRestoreAccess
  :cognitect.aws.redshift-serverless/AccountIdList)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/kmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotRemainingDays
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotRetentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/elapsedTimeInSeconds
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/totalBackupSizeInMegaBytes
  :cognitect.aws.redshift-serverless/Double)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/backupProgressInMegaBytes
  :cognitect.aws.redshift-serverless/Double)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/adminUsername
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/accountsWithProvisionedRestoreAccess
  :cognitect.aws.redshift-serverless/AccountIdList)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/status
  :cognitect.aws.redshift-serverless/SnapshotStatus)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/ownerAccount
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/estimatedSecondsToCompletion
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/adminPasswordSecretKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotCreateTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/currentBackupRateInMegaBytesPerSecond
  :cognitect.aws.redshift-serverless/Double)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/namespaceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Snapshot/actualIncrementalBackupSizeInMegaBytes
  :cognitect.aws.redshift-serverless/Double)

(s/def
  :cognitect.aws.redshift-serverless.UpdateScheduledActionResponse/scheduledAction
  :cognitect.aws.redshift-serverless/ScheduledActionResponse)

(s/def
  :cognitect.aws.redshift-serverless.DeleteEndpointAccessRequest/endpointName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListScheduledActionsResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListScheduledActionsResponse/scheduledActions
  :cognitect.aws.redshift-serverless/ScheduledActionsList)

(s/def
  :cognitect.aws.redshift-serverless.ListScheduledActionsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListScheduledActionsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListScheduledActionsRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ListScheduledActionsRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.DeleteSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.InsufficientCapacityException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.GetScheduledActionResponse/scheduledAction
  :cognitect.aws.redshift-serverless/ScheduledActionResponse)

(s/def
  :cognitect.aws.redshift-serverless.GetEndpointAccessRequest/endpointName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteSnapshotCopyConfigurationResponse/snapshotCopyConfiguration
  :cognitect.aws.redshift-serverless/SnapshotCopyConfiguration)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/ownerAccount
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromSnapshotResponse/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TooManyTagsException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.TooManyTagsException/resourceName
  :cognitect.aws.redshift-serverless/AmazonResourceName)

(s/def
  :cognitect.aws.redshift-serverless.GetTableRestoreStatusResponse/tableRestoreStatus
  :cognitect.aws.redshift-serverless/TableRestoreStatus)

(s/def
  :cognitect.aws.redshift-serverless.UpdateEndpointAccessRequest/endpointName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateEndpointAccessRequest/vpcSecurityGroupIds
  :cognitect.aws.redshift-serverless/VpcSecurityGroupIdList)

(s/def
  :cognitect.aws.redshift-serverless.GetTableRestoreStatusRequest/tableRestoreRequestId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.VpcSecurityGroupMembership/status
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.VpcSecurityGroupMembership/vpcSecurityGroupId
  :cognitect.aws.redshift-serverless/VpcSecurityGroupId)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/subnetIds
  :cognitect.aws.redshift-serverless/SubnetIdList)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/baseCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/configParameters
  :cognitect.aws.redshift-serverless/ConfigParameterList)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/pricePerformanceTarget
  :cognitect.aws.redshift-serverless/PerformanceTarget)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/enhancedVpcRouting
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/port
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/securityGroupIds
  :cognitect.aws.redshift-serverless/SecurityGroupIdList)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/ipAddressType
  :cognitect.aws.redshift-serverless/IpAddressType)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/maxCapacity
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.CreateWorkgroupRequest/publiclyAccessible
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListSnapshotCopyConfigurationsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/creationDate
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/managedWorkgroupId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/managedWorkgroupName
  :cognitect.aws.redshift-serverless/ManagedWorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/sourceArn
  :cognitect.aws.redshift-serverless/SourceArn)

(s/def
  :cognitect.aws.redshift-serverless.ManagedWorkgroupListItem/status
  :cognitect.aws.redshift-serverless/ManagedWorkgroupStatus)

(s/def
  :cognitect.aws.redshift-serverless.ListTagsForResourceRequest/resourceArn
  :cognitect.aws.redshift-serverless/AmazonResourceName)

(s/def
  :cognitect.aws.redshift-serverless.PutResourcePolicyResponse/resourcePolicy
  :cognitect.aws.redshift-serverless/ResourcePolicy)

(s/def
  :cognitect.aws.redshift-serverless.DeleteEndpointAccessResponse/endpoint
  :cognitect.aws.redshift-serverless/EndpointAccess)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessResponse/endpoints
  :cognitect.aws.redshift-serverless/EndpointAccessList)

(s/def
  :cognitect.aws.redshift-serverless.ListEndpointAccessResponse/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListNamespacesRequest/maxResults
  :cognitect.aws.redshift-serverless/ListNamespacesRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListNamespacesRequest/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateEndpointAccessResponse/endpoint
  :cognitect.aws.redshift-serverless/EndpointAccess)

(s/def
  :cognitect.aws.redshift-serverless.DeleteScheduledActionRequest/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.GetCustomDomainAssociationRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotCopyConfigurationResponse/snapshotCopyConfiguration
  :cognitect.aws.redshift-serverless/SnapshotCopyConfiguration)

(s/def
  :cognitect.aws.redshift-serverless.CreateEndpointAccessResponse/endpoint
  :cognitect.aws.redshift-serverless/EndpointAccess)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/adminPasswordSecretArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/iamRoles
  :cognitect.aws.redshift-serverless/IamRoleArnList)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/kmsKeyId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/defaultIamRoleArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/adminUsername
  :cognitect.aws.redshift-serverless/DbUser)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/status
  :cognitect.aws.redshift-serverless/NamespaceStatus)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/namespaceId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/logExports
  :cognitect.aws.redshift-serverless/LogExportList)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/adminPasswordSecretKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/creationDate
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/dbName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Namespace/namespaceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.CreateCustomDomainAssociationRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/newTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/activateCaseSensitiveIdentifier
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/targetDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceDatabaseName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/targetSchemaName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/namespaceName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointRequest/sourceTableName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteWorkgroupRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.GetEndpointAccessResponse/endpoint
  :cognitect.aws.redshift-serverless/EndpointAccess)

(s/def
  :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/retentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotRequest/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/iamRoles
  :cognitect.aws.redshift-serverless/IamRoleArnList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/kmsKeyId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/defaultIamRoleArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/manageAdminPassword
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminUsername
  :cognitect.aws.redshift-serverless/DbUser)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/logExports
  :cognitect.aws.redshift-serverless/LogExportList)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminPasswordSecretKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceRequest/adminUserPassword
  :cognitect.aws.redshift-serverless/DbPassword)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/destinationKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/destinationRegion
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationRequest/snapshotRetentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromRecoveryPointResponse/tableRestoreStatus
  :cognitect.aws.redshift-serverless/TableRestoreStatus)

(s/def
  :cognitect.aws.redshift-serverless.GetUsageLimitRequest/usageLimitId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteUsageLimitResponse/usageLimit
  :cognitect.aws.redshift-serverless/UsageLimit)

(s/def
  :cognitect.aws.redshift-serverless.ConvertRecoveryPointToSnapshotResponse/snapshot
  :cognitect.aws.redshift-serverless/Snapshot)

(s/def
  :cognitect.aws.redshift-serverless.VpcEndpoint/networkInterfaces
  :cognitect.aws.redshift-serverless/NetworkInterfaceList)

(s/def
  :cognitect.aws.redshift-serverless.VpcEndpoint/vpcEndpointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.VpcEndpoint/vpcId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteUsageLimitRequest/usageLimitId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotCopyConfigurationResponse/snapshotCopyConfiguration
  :cognitect.aws.redshift-serverless/SnapshotCopyConfiguration)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.RestoreFromRecoveryPointRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.DeleteWorkgroupResponse/workgroup
  :cognitect.aws.redshift-serverless/Workgroup)

(s/def
  :cognitect.aws.redshift-serverless.GetRecoveryPointResponse/recoveryPoint
  :cognitect.aws.redshift-serverless/RecoveryPoint)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsResponse/associations
  :cognitect.aws.redshift-serverless/AssociationList)

(s/def
  :cognitect.aws.redshift-serverless.ListCustomDomainAssociationsResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.UntagResourceRequest/resourceArn
  :cognitect.aws.redshift-serverless/AmazonResourceName)

(s/def
  :cognitect.aws.redshift-serverless.UntagResourceRequest/tagKeys
  :cognitect.aws.redshift-serverless/TagKeyList)

(s/def
  :cognitect.aws.redshift-serverless.ListWorkgroupsResponse/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListWorkgroupsResponse/workgroups
  :cognitect.aws.redshift-serverless/WorkgroupList)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsRequest/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsRequest/dbName
  :cognitect.aws.redshift-serverless/DbName)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsRequest/durationSeconds
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsRequest/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.CreateUsageLimitResponse/usageLimit
  :cognitect.aws.redshift-serverless/UsageLimit)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotRequest/retentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.UpdateSnapshotRequest/snapshotName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.DeleteSnapshotResponse/snapshot
  :cognitect.aws.redshift-serverless/Snapshot)

(s/def
  :cognitect.aws.redshift-serverless.CreateNamespaceResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListUsageLimitsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/resourceArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsRequest/usageType
  :cognitect.aws.redshift-serverless/UsageLimitUsageType)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsResponse/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotsResponse/snapshots
  :cognitect.aws.redshift-serverless/SnapshotList)

(s/def
  :cognitect.aws.redshift-serverless.DeleteNamespaceResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.CreateSnapshotResponse/snapshot
  :cognitect.aws.redshift-serverless/Snapshot)

(s/def
  :cognitect.aws.redshift-serverless.GetUsageLimitResponse/usageLimit
  :cognitect.aws.redshift-serverless/UsageLimit)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListSnapshotCopyConfigurationsResponse/snapshotCopyConfigurations
  :cognitect.aws.redshift-serverless/SnapshotCopyConfigurations)

(s/def
  :cognitect.aws.redshift-serverless.RestoreTableFromSnapshotResponse/tableRestoreStatus
  :cognitect.aws.redshift-serverless/TableRestoreStatus)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/schedule
  :cognitect.aws.redshift-serverless/Schedule)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/startTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/endTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/scheduledActionName
  :cognitect.aws.redshift-serverless/ScheduledActionName)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/targetAction
  :cognitect.aws.redshift-serverless/TargetAction)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/scheduledActionDescription
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/enabled
  :cognitect.aws.redshift-serverless/Boolean)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionRequest/roleArn
  :cognitect.aws.redshift-serverless/IamRoleArn)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/vpcSecurityGroups
  :cognitect.aws.redshift-serverless/VpcSecurityGroupMembershipList)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/address
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/subnetIds
  :cognitect.aws.redshift-serverless/SubnetIdList)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/workgroupName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/port
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/endpointName
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/endpointCreateTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/endpointStatus
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/endpointArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.EndpointAccess/vpcEndpoint
  :cognitect.aws.redshift-serverless/VpcEndpoint)

(s/def
  :cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/amount
  :cognitect.aws.redshift-serverless/Long)

(s/def
  :cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/breachAction
  :cognitect.aws.redshift-serverless/UsageLimitBreachAction)

(s/def
  :cognitect.aws.redshift-serverless.UpdateUsageLimitRequest/usageLimitId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsResponse/nextToken
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ListRecoveryPointsResponse/recoveryPoints
  :cognitect.aws.redshift-serverless/RecoveryPointList)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListUsageLimitsResponse/usageLimits
  :cognitect.aws.redshift-serverless/UsageLimits)

(s/def
  :cognitect.aws.redshift-serverless.UpdateNamespaceResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.Ipv6CidrBlockNotFoundException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.Association/customDomainCertificateArn
  :cognitect.aws.redshift-serverless/CustomDomainCertificateArnString)

(s/def
  :cognitect.aws.redshift-serverless.Association/customDomainCertificateExpiryTime
  :cognitect.aws.redshift-serverless/SyntheticTimestamp_date_time)

(s/def
  :cognitect.aws.redshift-serverless.Association/customDomainName
  :cognitect.aws.redshift-serverless/CustomDomainName)

(s/def
  :cognitect.aws.redshift-serverless.Association/workgroupName
  :cognitect.aws.redshift-serverless/WorkgroupName)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/destinationKmsKeyId
  :cognitect.aws.redshift-serverless/KmsKeyId)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/destinationRegion
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/namespaceName
  :cognitect.aws.redshift-serverless/NamespaceName)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotCopyConfigurationArn
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotCopyConfigurationId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.SnapshotCopyConfiguration/snapshotRetentionPeriod
  :cognitect.aws.redshift-serverless/Integer)

(s/def
  :cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/maxResults
  :cognitect.aws.redshift-serverless/ListManagedWorkgroupsRequestMaxResultsInteger)

(s/def
  :cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ListManagedWorkgroupsRequest/sourceArn
  :cognitect.aws.redshift-serverless/SourceArn)

(s/def
  :cognitect.aws.redshift-serverless.ListTagsForResourceResponse/tags
  :cognitect.aws.redshift-serverless/TagList)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsResponse/dbPassword
  :cognitect.aws.redshift-serverless/DbPassword)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsResponse/dbUser
  :cognitect.aws.redshift-serverless/DbUser)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsResponse/expiration
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.GetCredentialsResponse/nextRefreshTime
  :cognitect.aws.redshift-serverless/Timestamp)

(s/def
  :cognitect.aws.redshift-serverless.GetRecoveryPointRequest/recoveryPointId
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.UpdateWorkgroupResponse/workgroup
  :cognitect.aws.redshift-serverless/Workgroup)

(s/def
  :cognitect.aws.redshift-serverless.GetResourcePolicyResponse/resourcePolicy
  :cognitect.aws.redshift-serverless/ResourcePolicy)

(s/def
  :cognitect.aws.redshift-serverless.GetNamespaceResponse/namespace
  :cognitect.aws.redshift-serverless/Namespace)

(s/def
  :cognitect.aws.redshift-serverless.ConfigParameter/parameterKey
  :cognitect.aws.redshift-serverless/ParameterKey)

(s/def
  :cognitect.aws.redshift-serverless.ConfigParameter/parameterValue
  :cognitect.aws.redshift-serverless/ParameterValue)

(s/def
  :cognitect.aws.redshift-serverless.ListManagedWorkgroupsResponse/managedWorkgroups
  :cognitect.aws.redshift-serverless/ManagedWorkgroups)

(s/def
  :cognitect.aws.redshift-serverless.ListManagedWorkgroupsResponse/nextToken
  :cognitect.aws.redshift-serverless/PaginationToken)

(s/def
  :cognitect.aws.redshift-serverless.ResourceNotFoundException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.ResourceNotFoundException/resourceName
  :cognitect.aws.redshift-serverless/AmazonResourceName)

(s/def
  :cognitect.aws.redshift-serverless.ConflictException/message
  :cognitect.aws.redshift-serverless/String)

(s/def
  :cognitect.aws.redshift-serverless.CreateScheduledActionResponse/scheduledAction
  :cognitect.aws.redshift-serverless/ScheduledActionResponse)

