;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.redshift.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroupMembership
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSecurityGroupMembership/ClusterSecurityGroupName
     :cognitect.aws.redshift.ClusterSecurityGroupMembership/Status]))

(s/def
  :cognitect.aws.redshift/CreateTagsMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateTagsMessage/ResourceName
     :cognitect.aws.redshift.CreateTagsMessage/Tags]))

(s/def
  :cognitect.aws.redshift/ResizeClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.ResizeClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/DescribeDefaultClusterParametersMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/ParameterGroupFamily]
    :opt-un
    [:cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/MaxRecords
     :cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/Marker]))

(s/def
  :cognitect.aws.redshift/TableRestoreStatusList
  (s/coll-of :cognitect.aws.redshift/TableRestoreStatus))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroup
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterGroup/Tags
     :cognitect.aws.redshift.ClusterParameterGroup/ParameterGroupFamily
     :cognitect.aws.redshift.ClusterParameterGroup/ParameterGroupName
     :cognitect.aws.redshift.ClusterParameterGroup/Description]))

(s/def
  :cognitect.aws.redshift/DescribeAccountAttributesMessage
  (s/keys :opt-un [:cognitect.aws.redshift.DescribeAccountAttributesMessage/AttributeNames]))

(s/def
  :cognitect.aws.redshift/SnapshotSortingEntity
  (s/keys
    :req-un
    [:cognitect.aws.redshift.SnapshotSortingEntity/Attribute]
    :opt-un
    [:cognitect.aws.redshift.SnapshotSortingEntity/SortOrder]))

(s/def
  :cognitect.aws.redshift/AvailabilityZone
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.AvailabilityZone/SupportedPlatforms
     :cognitect.aws.redshift.AvailabilityZone/Name]))

(s/def
  :cognitect.aws.redshift/ModifyEventSubscriptionMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyEventSubscriptionMessage/SubscriptionName]
    :opt-un
    [:cognitect.aws.redshift.ModifyEventSubscriptionMessage/Severity
     :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SourceIds
     :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SourceType
     :cognitect.aws.redshift.ModifyEventSubscriptionMessage/Enabled
     :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SnsTopicArn
     :cognitect.aws.redshift.ModifyEventSubscriptionMessage/EventCategories]))

(s/def
  :cognitect.aws.redshift/DisableSnapshotCopyResult
  (s/keys :opt-un [:cognitect.aws.redshift.DisableSnapshotCopyResult/Cluster]))

(s/def
  :cognitect.aws.redshift/ModifyClusterDbRevisionMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterDbRevisionMessage/ClusterIdentifier
     :cognitect.aws.redshift.ModifyClusterDbRevisionMessage/RevisionTarget]))

(s/def
  :cognitect.aws.redshift/SnapshotAttributeToSortBy
  (s/spec string? :gen #(s/gen #{"CREATE_TIME" "SOURCE_TYPE" "TOTAL_SIZE"})))

(s/def
  :cognitect.aws.redshift/AccountsWithRestoreAccessList
  (s/coll-of :cognitect.aws.redshift/AccountWithRestoreAccess))

(s/def
  :cognitect.aws.redshift/OrderableClusterOption
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.OrderableClusterOption/ClusterType
     :cognitect.aws.redshift.OrderableClusterOption/ClusterVersion
     :cognitect.aws.redshift.OrderableClusterOption/AvailabilityZones
     :cognitect.aws.redshift.OrderableClusterOption/NodeType]))

(s/def
  :cognitect.aws.redshift/RevisionTarget
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.RevisionTarget/DatabaseRevision
     :cognitect.aws.redshift.RevisionTarget/Description
     :cognitect.aws.redshift.RevisionTarget/DatabaseRevisionReleaseDate]))

(s/def
  :cognitect.aws.redshift/AttributeValueList
  (s/coll-of :cognitect.aws.redshift/AttributeValueTarget))

(s/def
  :cognitect.aws.redshift/CopyClusterSnapshotResult
  (s/keys :opt-un [:cognitect.aws.redshift.CopyClusterSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.redshift/RestoreStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.RestoreStatus/SnapshotSizeInMegaBytes
     :cognitect.aws.redshift.RestoreStatus/CurrentRestoreRateInMegaBytesPerSecond
     :cognitect.aws.redshift.RestoreStatus/ProgressInMegaBytes
     :cognitect.aws.redshift.RestoreStatus/Status
     :cognitect.aws.redshift.RestoreStatus/EstimatedTimeToCompletionInSeconds
     :cognitect.aws.redshift.RestoreStatus/ElapsedTimeInSeconds]))

(s/def :cognitect.aws.redshift/TStamp inst?)

(s/def
  :cognitect.aws.redshift/ClusterSubnetGroup
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSubnetGroup/Subnets
     :cognitect.aws.redshift.ClusterSubnetGroup/ClusterSubnetGroupName
     :cognitect.aws.redshift.ClusterSubnetGroup/Tags
     :cognitect.aws.redshift.ClusterSubnetGroup/SubnetGroupStatus
     :cognitect.aws.redshift.ClusterSubnetGroup/Description
     :cognitect.aws.redshift.ClusterSubnetGroup/VpcId]))

(s/def
  :cognitect.aws.redshift/DescribeReservedNodesMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeReservedNodesMessage/MaxRecords
     :cognitect.aws.redshift.DescribeReservedNodesMessage/Marker
     :cognitect.aws.redshift.DescribeReservedNodesMessage/ReservedNodeId]))

(s/def
  :cognitect.aws.redshift/CreateClusterSubnetGroupResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateClusterSubnetGroupResult/ClusterSubnetGroup]))

(s/def
  :cognitect.aws.redshift/ClustersMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClustersMessage/Marker
     :cognitect.aws.redshift.ClustersMessage/Clusters]))

(s/def
  :cognitect.aws.redshift/SnapshotSortingEntityList
  (s/coll-of :cognitect.aws.redshift/SnapshotSortingEntity))

(s/def
  :cognitect.aws.redshift/RevokeSnapshotAccessResult
  (s/keys :opt-un [:cognitect.aws.redshift.RevokeSnapshotAccessResult/Snapshot]))

(s/def :cognitect.aws.redshift/ValueStringList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOptionsFilterList
  (s/coll-of :cognitect.aws.redshift/NodeConfigurationOptionsFilter))

(s/def
  :cognitect.aws.redshift/CreateClusterSecurityGroupResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateClusterSecurityGroupResult/ClusterSecurityGroup]))

(s/def
  :cognitect.aws.redshift/DescribeClusterVersionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterVersionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterVersionsMessage/Marker
     :cognitect.aws.redshift.DescribeClusterVersionsMessage/ClusterParameterGroupFamily
     :cognitect.aws.redshift.DescribeClusterVersionsMessage/ClusterVersion]))

(s/def
  :cognitect.aws.redshift/SupportedOperation
  (s/keys :opt-un [:cognitect.aws.redshift.SupportedOperation/OperationName]))

(s/def
  :cognitect.aws.redshift/ClusterAssociatedToSchedule
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterAssociatedToSchedule/ScheduleAssociationState
     :cognitect.aws.redshift.ClusterAssociatedToSchedule/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/CreateHsmClientCertificateMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateHsmClientCertificateMessage/HsmClientCertificateIdentifier]
    :opt-un
    [:cognitect.aws.redshift.CreateHsmClientCertificateMessage/Tags]))

(s/def
  :cognitect.aws.redshift/OrderableClusterOptionsList
  (s/coll-of :cognitect.aws.redshift/OrderableClusterOption))

(s/def
  :cognitect.aws.redshift/EventsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EventsMessage/Marker :cognitect.aws.redshift.EventsMessage/Events]))

(s/def
  :cognitect.aws.redshift/ClusterIamRole
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterIamRole/ApplyStatus
     :cognitect.aws.redshift.ClusterIamRole/IamRoleArn]))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroupStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterGroupStatus/ClusterParameterStatusList
     :cognitect.aws.redshift.ClusterParameterGroupStatus/ParameterGroupName
     :cognitect.aws.redshift.ClusterParameterGroupStatus/ParameterApplyStatus]))

(s/def
  :cognitect.aws.redshift/AccountAttributeList
  (s/keys :opt-un [:cognitect.aws.redshift.AccountAttributeList/AccountAttributes]))

(s/def
  :cognitect.aws.redshift/ClusterParameterStatusList
  (s/coll-of :cognitect.aws.redshift/ClusterParameterStatus))

(s/def
  :cognitect.aws.redshift/ScheduledActionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ScheduledActionsMessage/Marker
     :cognitect.aws.redshift.ScheduledActionsMessage/ScheduledActions]))

(s/def :cognitect.aws.redshift/SnapshotIdentifierList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/Tag
  (s/keys :opt-un [:cognitect.aws.redshift.Tag/Key :cognitect.aws.redshift.Tag/Value]))

(s/def
  :cognitect.aws.redshift/DescribeSnapshotSchedulesOutputMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeSnapshotSchedulesOutputMessage/Marker
     :cognitect.aws.redshift.DescribeSnapshotSchedulesOutputMessage/SnapshotSchedules]))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOption
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.NodeConfigurationOption/NumberOfNodes
     :cognitect.aws.redshift.NodeConfigurationOption/EstimatedDiskUtilizationPercent
     :cognitect.aws.redshift.NodeConfigurationOption/Mode
     :cognitect.aws.redshift.NodeConfigurationOption/NodeType]))

(s/def
  :cognitect.aws.redshift/ElasticIpStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ElasticIpStatus/Status
     :cognitect.aws.redshift.ElasticIpStatus/ElasticIp]))

(s/def
  :cognitect.aws.redshift/ResizeClusterMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ResizeClusterMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ResizeClusterMessage/NumberOfNodes
     :cognitect.aws.redshift.ResizeClusterMessage/ClusterType
     :cognitect.aws.redshift.ResizeClusterMessage/Classic
     :cognitect.aws.redshift.ResizeClusterMessage/NodeType]))

(s/def
  :cognitect.aws.redshift/MaintenanceTrack
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.MaintenanceTrack/DatabaseVersion
     :cognitect.aws.redshift.MaintenanceTrack/UpdateTargets
     :cognitect.aws.redshift.MaintenanceTrack/MaintenanceTrackName]))

(s/def
  :cognitect.aws.redshift/BatchSnapshotOperationErrorList
  (s/coll-of :cognitect.aws.redshift/SnapshotErrorMessage))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroupNameMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterGroupNameMessage/ParameterGroupStatus
     :cognitect.aws.redshift.ClusterParameterGroupNameMessage/ParameterGroupName]))

(s/def
  :cognitect.aws.redshift/ModifyClusterSubnetGroupResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterSubnetGroupResult/ClusterSubnetGroup]))

(s/def
  :cognitect.aws.redshift/DescribeClusterSecurityGroupsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/TagKeys
     :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/TagValues
     :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/ClusterSecurityGroupName
     :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/Marker]))

(s/def
  :cognitect.aws.redshift/BatchSnapshotOperationErrors
  (s/coll-of :cognitect.aws.redshift/SnapshotErrorMessage))

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroups
  (s/coll-of :cognitect.aws.redshift/ClusterSecurityGroup))

(s/def
  :cognitect.aws.redshift/DeleteClusterMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteClusterMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.DeleteClusterMessage/SkipFinalClusterSnapshot
     :cognitect.aws.redshift.DeleteClusterMessage/FinalClusterSnapshotIdentifier
     :cognitect.aws.redshift.DeleteClusterMessage/FinalClusterSnapshotRetentionPeriod]))

(s/def
  :cognitect.aws.redshift/RotateEncryptionKeyMessage
  (s/keys :req-un [:cognitect.aws.redshift.RotateEncryptionKeyMessage/ClusterIdentifier]))

(s/def :cognitect.aws.redshift/ParametersList (s/coll-of :cognitect.aws.redshift/Parameter))

(s/def
  :cognitect.aws.redshift/TableRestoreStatusType
  (s/spec string? :gen #(s/gen #{"CANCELED" "IN_PROGRESS" "PENDING" "SUCCEEDED" "FAILED"})))

(s/def :cognitect.aws.redshift/AttributeNameList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/PendingModifiedValues
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.PendingModifiedValues/EnhancedVpcRouting
     :cognitect.aws.redshift.PendingModifiedValues/PubliclyAccessible
     :cognitect.aws.redshift.PendingModifiedValues/ClusterIdentifier
     :cognitect.aws.redshift.PendingModifiedValues/NumberOfNodes
     :cognitect.aws.redshift.PendingModifiedValues/ClusterType
     :cognitect.aws.redshift.PendingModifiedValues/MasterUserPassword
     :cognitect.aws.redshift.PendingModifiedValues/EncryptionType
     :cognitect.aws.redshift.PendingModifiedValues/MaintenanceTrackName
     :cognitect.aws.redshift.PendingModifiedValues/ClusterVersion
     :cognitect.aws.redshift.PendingModifiedValues/AutomatedSnapshotRetentionPeriod
     :cognitect.aws.redshift.PendingModifiedValues/NodeType]))

(s/def
  :cognitect.aws.redshift/UsageLimitList
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.UsageLimitList/Marker
     :cognitect.aws.redshift.UsageLimitList/UsageLimits]))

(s/def
  :cognitect.aws.redshift/ModifyClusterMaintenanceMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterMaintenanceMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceEndTime
     :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceIdentifier
     :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceStartTime
     :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenance
     :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceDuration]))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOptionsFilter
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.NodeConfigurationOptionsFilter/Values
     :cognitect.aws.redshift.NodeConfigurationOptionsFilter/Operator
     :cognitect.aws.redshift.NodeConfigurationOptionsFilter/Name]))

(s/def
  :cognitect.aws.redshift/ResizeProgressMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ResizeProgressMessage/AvgResizeRateInMegaBytesPerSecond
     :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesNotStarted
     :cognitect.aws.redshift.ResizeProgressMessage/DataTransferProgressPercent
     :cognitect.aws.redshift.ResizeProgressMessage/TotalResizeDataInMegaBytes
     :cognitect.aws.redshift.ResizeProgressMessage/TargetClusterType
     :cognitect.aws.redshift.ResizeProgressMessage/ProgressInMegaBytes
     :cognitect.aws.redshift.ResizeProgressMessage/Status
     :cognitect.aws.redshift.ResizeProgressMessage/ResizeType
     :cognitect.aws.redshift.ResizeProgressMessage/Message
     :cognitect.aws.redshift.ResizeProgressMessage/TargetNodeType
     :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesCompleted
     :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesInProgress
     :cognitect.aws.redshift.ResizeProgressMessage/TargetEncryptionType
     :cognitect.aws.redshift.ResizeProgressMessage/EstimatedTimeToCompletionInSeconds
     :cognitect.aws.redshift.ResizeProgressMessage/TargetNumberOfNodes
     :cognitect.aws.redshift.ResizeProgressMessage/ElapsedTimeInSeconds]))

(s/def
  :cognitect.aws.redshift/UsageLimitBreachAction
  (s/spec string? :gen #(s/gen #{"log" "disable" "emit-metric"})))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOptionList
  (s/coll-of :cognitect.aws.redshift/NodeConfigurationOption))

(s/def
  :cognitect.aws.redshift/EC2SecurityGroup
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EC2SecurityGroup/EC2SecurityGroupOwnerId
     :cognitect.aws.redshift.EC2SecurityGroup/Tags
     :cognitect.aws.redshift.EC2SecurityGroup/Status
     :cognitect.aws.redshift.EC2SecurityGroup/EC2SecurityGroupName]))

(s/def
  :cognitect.aws.redshift/Endpoint
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Endpoint/Address
     :cognitect.aws.redshift.Endpoint/VpcEndpoints
     :cognitect.aws.redshift.Endpoint/Port]))

(s/def
  :cognitect.aws.redshift/DescribeEventCategoriesMessage
  (s/keys :opt-un [:cognitect.aws.redshift.DescribeEventCategoriesMessage/SourceType]))

(s/def :cognitect.aws.redshift/SnapshotList (s/coll-of :cognitect.aws.redshift/Snapshot))

(s/def
  :cognitect.aws.redshift/CreateClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/ModifyUsageLimitMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyUsageLimitMessage/UsageLimitId]
    :opt-un
    [:cognitect.aws.redshift.ModifyUsageLimitMessage/Amount
     :cognitect.aws.redshift.ModifyUsageLimitMessage/BreachAction]))

(s/def
  :cognitect.aws.redshift/VpcSecurityGroupMembershipList
  (s/coll-of :cognitect.aws.redshift/VpcSecurityGroupMembership))

(s/def
  :cognitect.aws.redshift/AcceptReservedNodeExchangeInputMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.AcceptReservedNodeExchangeInputMessage/ReservedNodeId
     :cognitect.aws.redshift.AcceptReservedNodeExchangeInputMessage/TargetReservedNodeOfferingId]))

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroup
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSecurityGroup/ClusterSecurityGroupName
     :cognitect.aws.redshift.ClusterSecurityGroup/Tags
     :cognitect.aws.redshift.ClusterSecurityGroup/Description
     :cognitect.aws.redshift.ClusterSecurityGroup/IPRanges
     :cognitect.aws.redshift.ClusterSecurityGroup/EC2SecurityGroups]))

(s/def
  :cognitect.aws.redshift/ParameterGroupList
  (s/coll-of :cognitect.aws.redshift/ClusterParameterGroup))

(s/def
  :cognitect.aws.redshift/UsageLimit
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.UsageLimit/Period
     :cognitect.aws.redshift.UsageLimit/Amount
     :cognitect.aws.redshift.UsageLimit/BreachAction
     :cognitect.aws.redshift.UsageLimit/FeatureType
     :cognitect.aws.redshift.UsageLimit/ClusterIdentifier
     :cognitect.aws.redshift.UsageLimit/Tags
     :cognitect.aws.redshift.UsageLimit/LimitType
     :cognitect.aws.redshift.UsageLimit/UsageLimitId]))

(s/def
  :cognitect.aws.redshift/TaggedResourceList
  (s/coll-of :cognitect.aws.redshift/TaggedResource))

(s/def :cognitect.aws.redshift/VpcEndpointsList (s/coll-of :cognitect.aws.redshift/VpcEndpoint))

(s/def
  :cognitect.aws.redshift/PauseClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.PauseClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/DeleteTagsMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteTagsMessage/ResourceName
     :cognitect.aws.redshift.DeleteTagsMessage/TagKeys]))

(s/def :cognitect.aws.redshift/TagList (s/coll-of :cognitect.aws.redshift/Tag))

(s/def
  :cognitect.aws.redshift/ClusterVersion
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterVersion/ClusterParameterGroupFamily
     :cognitect.aws.redshift.ClusterVersion/Description
     :cognitect.aws.redshift.ClusterVersion/ClusterVersion]))

(s/def
  :cognitect.aws.redshift/Subnet
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Subnet/SubnetIdentifier
     :cognitect.aws.redshift.Subnet/SubnetStatus
     :cognitect.aws.redshift.Subnet/SubnetAvailabilityZone]))

(s/def
  :cognitect.aws.redshift/ClusterSubnetGroupMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSubnetGroupMessage/Marker
     :cognitect.aws.redshift.ClusterSubnetGroupMessage/ClusterSubnetGroups]))

(s/def :cognitect.aws.redshift/VpcSecurityGroupIdList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/CreateClusterParameterGroupResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.CreateClusterParameterGroupResult/ClusterParameterGroup]))

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroupMembershipList
  (s/coll-of :cognitect.aws.redshift/ClusterSecurityGroupMembership))

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroupMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSecurityGroupMessage/Marker
     :cognitect.aws.redshift.ClusterSecurityGroupMessage/ClusterSecurityGroups]))

(s/def :cognitect.aws.redshift/ScheduledSnapshotTimeList (s/coll-of :cognitect.aws.redshift/TStamp))

(s/def
  :cognitect.aws.redshift/GetReservedNodeExchangeOfferingsOutputMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.GetReservedNodeExchangeOfferingsOutputMessage/Marker
     :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsOutputMessage/ReservedNodeOfferings]))

(s/def
  :cognitect.aws.redshift/CancelResizeMessage
  (s/keys :req-un [:cognitect.aws.redshift.CancelResizeMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/TableRestoreStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.TableRestoreStatus/SnapshotIdentifier
     :cognitect.aws.redshift.TableRestoreStatus/TargetSchemaName
     :cognitect.aws.redshift.TableRestoreStatus/SourceSchemaName
     :cognitect.aws.redshift.TableRestoreStatus/TotalDataInMegaBytes
     :cognitect.aws.redshift.TableRestoreStatus/ClusterIdentifier
     :cognitect.aws.redshift.TableRestoreStatus/RequestTime
     :cognitect.aws.redshift.TableRestoreStatus/NewTableName
     :cognitect.aws.redshift.TableRestoreStatus/ProgressInMegaBytes
     :cognitect.aws.redshift.TableRestoreStatus/SourceDatabaseName
     :cognitect.aws.redshift.TableRestoreStatus/Status
     :cognitect.aws.redshift.TableRestoreStatus/Message
     :cognitect.aws.redshift.TableRestoreStatus/SourceTableName
     :cognitect.aws.redshift.TableRestoreStatus/TableRestoreRequestId
     :cognitect.aws.redshift.TableRestoreStatus/TargetDatabaseName]))

(s/def
  :cognitect.aws.redshift/CreateEventSubscriptionResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateEventSubscriptionResult/EventSubscription]))

(s/def
  :cognitect.aws.redshift/EventCategoriesMap
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EventCategoriesMap/Events
     :cognitect.aws.redshift.EventCategoriesMap/SourceType]))

(s/def
  :cognitect.aws.redshift/ClusterDbRevision
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterDbRevision/ClusterIdentifier
     :cognitect.aws.redshift.ClusterDbRevision/DatabaseRevisionReleaseDate
     :cognitect.aws.redshift.ClusterDbRevision/CurrentDatabaseRevision
     :cognitect.aws.redshift.ClusterDbRevision/RevisionTargets]))

(s/def :cognitect.aws.redshift/DbGroupList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/RevokeClusterSecurityGroupIngressMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/ClusterSecurityGroupName]
    :opt-un
    [:cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/EC2SecurityGroupOwnerId
     :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/CIDRIP
     :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/EC2SecurityGroupName]))

(s/def
  :cognitect.aws.redshift/UpdateTarget
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.UpdateTarget/SupportedOperations
     :cognitect.aws.redshift.UpdateTarget/DatabaseVersion
     :cognitect.aws.redshift.UpdateTarget/MaintenanceTrackName]))

(s/def
  :cognitect.aws.redshift/RestoreTableFromClusterSnapshotResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.RestoreTableFromClusterSnapshotResult/TableRestoreStatus]))

(s/def
  :cognitect.aws.redshift/ResumeClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.ResumeClusterResult/Cluster]))

(s/def :cognitect.aws.redshift/Mode (s/spec string? :gen #(s/gen #{"standard" "high-performance"})))

(s/def :cognitect.aws.redshift/EventInfoMapList (s/coll-of :cognitect.aws.redshift/EventInfoMap))

(s/def
  :cognitect.aws.redshift/ModifyEventSubscriptionResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyEventSubscriptionResult/EventSubscription]))

(s/def
  :cognitect.aws.redshift/CreateSnapshotScheduleMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.CreateSnapshotScheduleMessage/DryRun
     :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleDescription
     :cognitect.aws.redshift.CreateSnapshotScheduleMessage/Tags
     :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleIdentifier
     :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleDefinitions
     :cognitect.aws.redshift.CreateSnapshotScheduleMessage/NextInvocations]))

(s/def
  :cognitect.aws.redshift/DescribeClusterSubnetGroupsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/TagKeys
     :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/TagValues
     :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/ClusterSubnetGroupName
     :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/Marker]))

(s/def
  :cognitect.aws.redshift/ClusterVersionList
  (s/coll-of :cognitect.aws.redshift/ClusterVersion))

(s/def
  :cognitect.aws.redshift/DeleteEventSubscriptionMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteEventSubscriptionMessage/SubscriptionName]))

(s/def
  :cognitect.aws.redshift/OperatorType
  (s/spec string? :gen #(s/gen #{"lt" "eq" "gt" "ge" "le" "between" "in"})))

(s/def
  :cognitect.aws.redshift/CreateSnapshotCopyGrantResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateSnapshotCopyGrantResult/SnapshotCopyGrant]))

(s/def
  :cognitect.aws.redshift/SupportedOperationList
  (s/coll-of :cognitect.aws.redshift/SupportedOperation))

(s/def
  :cognitect.aws.redshift/ActionType
  (s/spec string? :gen #(s/gen #{"restore-cluster" "resize-cluster" "recommend-node-config"})))

(s/def
  :cognitect.aws.redshift/TaggedResourceListMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.TaggedResourceListMessage/Marker
     :cognitect.aws.redshift.TaggedResourceListMessage/TaggedResources]))

(s/def
  :cognitect.aws.redshift/ModifyClusterSnapshotResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.redshift/GetReservedNodeExchangeOfferingsInputMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/ReservedNodeId]
    :opt-un
    [:cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/MaxRecords
     :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/Marker]))

(s/def
  :cognitect.aws.redshift/DescribeLoggingStatusMessage
  (s/keys :req-un [:cognitect.aws.redshift.DescribeLoggingStatusMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/SnapshotCopyGrantMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.SnapshotCopyGrantMessage/SnapshotCopyGrants
     :cognitect.aws.redshift.SnapshotCopyGrantMessage/Marker]))

(s/def
  :cognitect.aws.redshift/DescribeUsageLimitsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeUsageLimitsMessage/TagKeys
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/TagValues
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/FeatureType
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/Marker
     :cognitect.aws.redshift.DescribeUsageLimitsMessage/UsageLimitId]))

(s/def
  :cognitect.aws.redshift/DescribeEventsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeEventsMessage/EndTime
     :cognitect.aws.redshift.DescribeEventsMessage/StartTime
     :cognitect.aws.redshift.DescribeEventsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeEventsMessage/Marker
     :cognitect.aws.redshift.DescribeEventsMessage/SourceType
     :cognitect.aws.redshift.DescribeEventsMessage/Duration
     :cognitect.aws.redshift.DescribeEventsMessage/SourceIdentifier]))

(s/def :cognitect.aws.redshift/ReservedNodeList (s/coll-of :cognitect.aws.redshift/ReservedNode))

(s/def :cognitect.aws.redshift/SortByOrder (s/spec string? :gen #(s/gen #{"DESC" "ASC"})))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroupsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterGroupsMessage/Marker
     :cognitect.aws.redshift.ClusterParameterGroupsMessage/ParameterGroups]))

(s/def
  :cognitect.aws.redshift/ScheduledActionFilter
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ScheduledActionFilter/Name
     :cognitect.aws.redshift.ScheduledActionFilter/Values]))

(s/def
  :cognitect.aws.redshift/RevokeSnapshotAccessMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.RevokeSnapshotAccessMessage/SnapshotIdentifier
     :cognitect.aws.redshift.RevokeSnapshotAccessMessage/AccountWithRestoreAccess]
    :opt-un
    [:cognitect.aws.redshift.RevokeSnapshotAccessMessage/SnapshotClusterIdentifier]))

(s/def :cognitect.aws.redshift/ClusterList (s/coll-of :cognitect.aws.redshift/Cluster))

(s/def
  :cognitect.aws.redshift/BatchModifyClusterSnapshotsMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/SnapshotIdentifierList]
    :opt-un
    [:cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/Force]))

(s/def
  :cognitect.aws.redshift/ScheduledActionTypeValues
  (s/spec string? :gen #(s/gen #{"ResizeCluster" "ResumeCluster" "PauseCluster"})))

(s/def
  :cognitect.aws.redshift/DescribeTableRestoreStatusMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeTableRestoreStatusMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/MaxRecords
     :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/Marker
     :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/TableRestoreRequestId]))

(s/def
  :cognitect.aws.redshift/OrderableClusterOptionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.OrderableClusterOptionsMessage/Marker
     :cognitect.aws.redshift.OrderableClusterOptionsMessage/OrderableClusterOptions]))

(s/def
  :cognitect.aws.redshift/ResizeInfo
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ResizeInfo/AllowCancelResize
     :cognitect.aws.redshift.ResizeInfo/ResizeType]))

(s/def
  :cognitect.aws.redshift/AssociatedClusterList
  (s/coll-of :cognitect.aws.redshift/ClusterAssociatedToSchedule))

(s/def :cognitect.aws.redshift/Boolean boolean?)

(s/def
  :cognitect.aws.redshift/Snapshot
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Snapshot/SnapshotIdentifier
     :cognitect.aws.redshift.Snapshot/RestorableNodeTypes
     :cognitect.aws.redshift.Snapshot/SnapshotCreateTime
     :cognitect.aws.redshift.Snapshot/EnhancedVpcRouting
     :cognitect.aws.redshift.Snapshot/ManualSnapshotRemainingDays
     :cognitect.aws.redshift.Snapshot/SourceRegion
     :cognitect.aws.redshift.Snapshot/EncryptedWithHSM
     :cognitect.aws.redshift.Snapshot/Encrypted
     :cognitect.aws.redshift.Snapshot/OwnerAccount
     :cognitect.aws.redshift.Snapshot/ClusterIdentifier
     :cognitect.aws.redshift.Snapshot/NumberOfNodes
     :cognitect.aws.redshift.Snapshot/Tags
     :cognitect.aws.redshift.Snapshot/DBName
     :cognitect.aws.redshift.Snapshot/EstimatedSecondsToCompletion
     :cognitect.aws.redshift.Snapshot/AvailabilityZone
     :cognitect.aws.redshift.Snapshot/Status
     :cognitect.aws.redshift.Snapshot/SnapshotType
     :cognitect.aws.redshift.Snapshot/ActualIncrementalBackupSizeInMegaBytes
     :cognitect.aws.redshift.Snapshot/MasterUsername
     :cognitect.aws.redshift.Snapshot/BackupProgressInMegaBytes
     :cognitect.aws.redshift.Snapshot/AccountsWithRestoreAccess
     :cognitect.aws.redshift.Snapshot/Port
     :cognitect.aws.redshift.Snapshot/EngineFullVersion
     :cognitect.aws.redshift.Snapshot/VpcId
     :cognitect.aws.redshift.Snapshot/MaintenanceTrackName
     :cognitect.aws.redshift.Snapshot/KmsKeyId
     :cognitect.aws.redshift.Snapshot/ClusterCreateTime
     :cognitect.aws.redshift.Snapshot/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.Snapshot/ClusterVersion
     :cognitect.aws.redshift.Snapshot/ElapsedTimeInSeconds
     :cognitect.aws.redshift.Snapshot/SnapshotRetentionStartTime
     :cognitect.aws.redshift.Snapshot/CurrentBackupRateInMegaBytesPerSecond
     :cognitect.aws.redshift.Snapshot/NodeType
     :cognitect.aws.redshift.Snapshot/TotalBackupSizeInMegaBytes]))

(s/def
  :cognitect.aws.redshift/ReservedNodeOfferingType
  (s/spec string? :gen #(s/gen #{"Regular" "Upgradable"})))

(s/def
  :cognitect.aws.redshift/Event
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Event/Severity
     :cognitect.aws.redshift.Event/SourceType
     :cognitect.aws.redshift.Event/Date
     :cognitect.aws.redshift.Event/Message
     :cognitect.aws.redshift.Event/EventCategories
     :cognitect.aws.redshift.Event/SourceIdentifier
     :cognitect.aws.redshift.Event/EventId]))

(s/def
  :cognitect.aws.redshift/ModifySnapshotScheduleMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifySnapshotScheduleMessage/ScheduleIdentifier
     :cognitect.aws.redshift.ModifySnapshotScheduleMessage/ScheduleDefinitions]))

(s/def
  :cognitect.aws.redshift/ModifyClusterIamRolesResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterIamRolesResult/Cluster]))

(s/def
  :cognitect.aws.redshift/DeferredMaintenanceWindow
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceEndTime
     :cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceIdentifier
     :cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceStartTime]))

(s/def
  :cognitect.aws.redshift/AuthorizeSnapshotAccessMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/SnapshotIdentifier
     :cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/AccountWithRestoreAccess]
    :opt-un
    [:cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/SnapshotClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/ClusterSecurityGroupNameList
  (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/SnapshotScheduleList
  (s/coll-of :cognitect.aws.redshift/SnapshotSchedule))

(s/def :cognitect.aws.redshift/ImportTablesInProgress (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/ScheduledActionType
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ScheduledActionType/ResizeCluster
     :cognitect.aws.redshift.ScheduledActionType/ResumeCluster
     :cognitect.aws.redshift.ScheduledActionType/PauseCluster]))

(s/def
  :cognitect.aws.redshift/SnapshotCopyGrant
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.SnapshotCopyGrant/Tags
     :cognitect.aws.redshift.SnapshotCopyGrant/KmsKeyId
     :cognitect.aws.redshift.SnapshotCopyGrant/SnapshotCopyGrantName]))

(s/def
  :cognitect.aws.redshift/ModifyClusterSnapshotScheduleMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/ScheduleIdentifier
     :cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/DisassociateSchedule]))

(s/def
  :cognitect.aws.redshift/ScheduledActionFilterName
  (s/spec string? :gen #(s/gen #{"cluster-identifier" "iam-role"})))

(s/def
  :cognitect.aws.redshift/ClusterIamRoleList
  (s/coll-of :cognitect.aws.redshift/ClusterIamRole))

(s/def
  :cognitect.aws.redshift/TaggedResource
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.TaggedResource/ResourceName
     :cognitect.aws.redshift.TaggedResource/ResourceType
     :cognitect.aws.redshift.TaggedResource/Tag]))

(s/def :cognitect.aws.redshift/EventList (s/coll-of :cognitect.aws.redshift/Event))

(s/def
  :cognitect.aws.redshift/DescribeClusterParametersMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DescribeClusterParametersMessage/ParameterGroupName]
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterParametersMessage/Source
     :cognitect.aws.redshift.DescribeClusterParametersMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterParametersMessage/Marker]))

(s/def
  :cognitect.aws.redshift/EventInfoMap
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EventInfoMap/Severity
     :cognitect.aws.redshift.EventInfoMap/EventCategories
     :cognitect.aws.redshift.EventInfoMap/EventDescription
     :cognitect.aws.redshift.EventInfoMap/EventId]))

(s/def
  :cognitect.aws.redshift/SupportedPlatform
  (s/keys :opt-un [:cognitect.aws.redshift.SupportedPlatform/Name]))

(s/def :cognitect.aws.redshift/BooleanOptional boolean?)

(s/def
  :cognitect.aws.redshift/DescribeNodeConfigurationOptionsMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/ActionType]
    :opt-un
    [:cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/SnapshotIdentifier
     :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/OwnerAccount
     :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/Marker
     :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/Filters]))

(s/def :cognitect.aws.redshift/ImportTablesCompleted (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/Integer
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift/ScheduledActionState
  (s/spec string? :gen #(s/gen #{"DISABLED" "ACTIVE"})))

(s/def
  :cognitect.aws.redshift/DeleteClusterParameterGroupMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteClusterParameterGroupMessage/ParameterGroupName]))

(s/def
  :cognitect.aws.redshift/CopyClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CopyClusterSnapshotMessage/SourceSnapshotIdentifier
     :cognitect.aws.redshift.CopyClusterSnapshotMessage/TargetSnapshotIdentifier]
    :opt-un
    [:cognitect.aws.redshift.CopyClusterSnapshotMessage/SourceSnapshotClusterIdentifier
     :cognitect.aws.redshift.CopyClusterSnapshotMessage/ManualSnapshotRetentionPeriod]))

(s/def :cognitect.aws.redshift/IPRangeList (s/coll-of :cognitect.aws.redshift/IPRange))

(s/def
  :cognitect.aws.redshift/DescribeClusterTracksMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterTracksMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterTracksMessage/Marker
     :cognitect.aws.redshift.DescribeClusterTracksMessage/MaintenanceTrackName]))

(s/def
  :cognitect.aws.redshift/DescribeResizeMessage
  (s/keys :req-un [:cognitect.aws.redshift.DescribeResizeMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/VpcSecurityGroupMembership
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.VpcSecurityGroupMembership/Status
     :cognitect.aws.redshift.VpcSecurityGroupMembership/VpcSecurityGroupId]))

(s/def
  :cognitect.aws.redshift/DescribeClusterParameterGroupsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/TagKeys
     :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/TagValues
     :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/Marker
     :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/ParameterGroupName]))

(s/def
  :cognitect.aws.redshift/TrackListMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.TrackListMessage/MaintenanceTracks
     :cognitect.aws.redshift.TrackListMessage/Marker]))

(s/def
  :cognitect.aws.redshift/DescribeTagsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeTagsMessage/TagKeys
     :cognitect.aws.redshift.DescribeTagsMessage/TagValues
     :cognitect.aws.redshift.DescribeTagsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeTagsMessage/Marker
     :cognitect.aws.redshift.DescribeTagsMessage/ResourceName
     :cognitect.aws.redshift.DescribeTagsMessage/ResourceType]))

(s/def
  :cognitect.aws.redshift/ModifyClusterMaintenanceResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterMaintenanceResult/Cluster]))

(s/def
  :cognitect.aws.redshift/EventSubscriptionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EventSubscriptionsMessage/Marker
     :cognitect.aws.redshift.EventSubscriptionsMessage/EventSubscriptionsList]))

(s/def
  :cognitect.aws.redshift/ReservedNodesMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ReservedNodesMessage/Marker
     :cognitect.aws.redshift.ReservedNodesMessage/ReservedNodes]))

(s/def
  :cognitect.aws.redshift/DescribeClusterDbRevisionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/Marker]))

(s/def :cognitect.aws.redshift/ClusterNodesList (s/coll-of :cognitect.aws.redshift/ClusterNode))

(s/def
  :cognitect.aws.redshift/RecurringChargeList
  (s/coll-of :cognitect.aws.redshift/RecurringCharge))

(s/def
  :cognitect.aws.redshift/DeleteClusterSnapshotMessageList
  (s/coll-of :cognitect.aws.redshift/DeleteClusterSnapshotMessage))

(s/def :cognitect.aws.redshift/UsageLimits (s/coll-of :cognitect.aws.redshift/UsageLimit))

(s/def
  :cognitect.aws.redshift/EnableSnapshotCopyResult
  (s/keys :opt-un [:cognitect.aws.redshift.EnableSnapshotCopyResult/Cluster]))

(s/def
  :cognitect.aws.redshift/TableRestoreStatusMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.TableRestoreStatusMessage/TableRestoreStatusDetails
     :cognitect.aws.redshift.TableRestoreStatusMessage/Marker]))

(s/def
  :cognitect.aws.redshift/ModifyScheduledActionMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyScheduledActionMessage/ScheduledActionName]
    :opt-un
    [:cognitect.aws.redshift.ModifyScheduledActionMessage/Enable
     :cognitect.aws.redshift.ModifyScheduledActionMessage/EndTime
     :cognitect.aws.redshift.ModifyScheduledActionMessage/StartTime
     :cognitect.aws.redshift.ModifyScheduledActionMessage/IamRole
     :cognitect.aws.redshift.ModifyScheduledActionMessage/ScheduledActionDescription
     :cognitect.aws.redshift.ModifyScheduledActionMessage/TargetAction
     :cognitect.aws.redshift.ModifyScheduledActionMessage/Schedule]))

(s/def
  :cognitect.aws.redshift/EventSubscription
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.EventSubscription/Severity
     :cognitect.aws.redshift.EventSubscription/SourceIdsList
     :cognitect.aws.redshift.EventSubscription/CustomerAwsId
     :cognitect.aws.redshift.EventSubscription/Tags
     :cognitect.aws.redshift.EventSubscription/SourceType
     :cognitect.aws.redshift.EventSubscription/Enabled
     :cognitect.aws.redshift.EventSubscription/Status
     :cognitect.aws.redshift.EventSubscription/SnsTopicArn
     :cognitect.aws.redshift.EventSubscription/EventCategoriesList
     :cognitect.aws.redshift.EventSubscription/CustSubscriptionId
     :cognitect.aws.redshift.EventSubscription/SubscriptionCreationTime]))

(s/def
  :cognitect.aws.redshift/ResumeClusterMessage
  (s/keys :req-un [:cognitect.aws.redshift.ResumeClusterMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/SnapshotSchedule
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.SnapshotSchedule/ScheduleDescription
     :cognitect.aws.redshift.SnapshotSchedule/Tags
     :cognitect.aws.redshift.SnapshotSchedule/AssociatedClusterCount
     :cognitect.aws.redshift.SnapshotSchedule/AssociatedClusters
     :cognitect.aws.redshift.SnapshotSchedule/ScheduleIdentifier
     :cognitect.aws.redshift.SnapshotSchedule/ScheduleDefinitions
     :cognitect.aws.redshift.SnapshotSchedule/NextInvocations]))

(s/def
  :cognitect.aws.redshift/AttributeValueTarget
  (s/keys :opt-un [:cognitect.aws.redshift.AttributeValueTarget/AttributeValue]))

(s/def
  :cognitect.aws.redshift/HsmStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.HsmStatus/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.HsmStatus/Status
     :cognitect.aws.redshift.HsmStatus/HsmConfigurationIdentifier]))

(s/def
  :cognitect.aws.redshift/PurchaseReservedNodeOfferingResult
  (s/keys :opt-un [:cognitect.aws.redshift.PurchaseReservedNodeOfferingResult/ReservedNode]))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroupDetails
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterGroupDetails/Parameters
     :cognitect.aws.redshift.ClusterParameterGroupDetails/Marker]))

(s/def
  :cognitect.aws.redshift/DeferredMaintenanceWindowsList
  (s/coll-of :cognitect.aws.redshift/DeferredMaintenanceWindow))

(s/def
  :cognitect.aws.redshift/DeleteSnapshotCopyGrantMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteSnapshotCopyGrantMessage/SnapshotCopyGrantName]))

(s/def
  :cognitect.aws.redshift/DeleteClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteClusterSnapshotMessage/SnapshotIdentifier]
    :opt-un
    [:cognitect.aws.redshift.DeleteClusterSnapshotMessage/SnapshotClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/RestoreFromClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterIdentifier
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotIdentifier]
    :opt-un
    [:cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/EnhancedVpcRouting
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/PubliclyAccessible
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/PreferredMaintenanceWindow
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/OwnerAccount
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterSubnetGroupName
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/NumberOfNodes
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/VpcSecurityGroupIds
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AvailabilityZone
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterSecurityGroups
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AdditionalInfo
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ElasticIp
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AvailabilityZoneRelocation
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/HsmConfigurationIdentifier
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/Port
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/MaintenanceTrackName
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/KmsKeyId
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AllowVersionUpgrade
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AutomatedSnapshotRetentionPeriod
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/IamRoles
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotScheduleIdentifier
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/NodeType
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotClusterIdentifier
     :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterParameterGroupName]))

(s/def :cognitect.aws.redshift/IamRoleArnList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/ModifyClusterParameterGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterParameterGroupMessage/ParameterGroupName
     :cognitect.aws.redshift.ModifyClusterParameterGroupMessage/Parameters]))

(s/def :cognitect.aws.redshift/PendingActionsList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/ParameterApplyType
  (s/spec string? :gen #(s/gen #{"dynamic" "static"})))

(s/def
  :cognitect.aws.redshift/DeleteClusterSubnetGroupMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteClusterSubnetGroupMessage/ClusterSubnetGroupName]))

(s/def
  :cognitect.aws.redshift/DefaultClusterParameters
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DefaultClusterParameters/Parameters
     :cognitect.aws.redshift.DefaultClusterParameters/Marker
     :cognitect.aws.redshift.DefaultClusterParameters/ParameterGroupFamily]))

(s/def
  :cognitect.aws.redshift/ScheduledActionFilterList
  (s/coll-of :cognitect.aws.redshift/ScheduledActionFilter))

(s/def
  :cognitect.aws.redshift/ClusterSnapshotCopyStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterSnapshotCopyStatus/DestinationRegion
     :cognitect.aws.redshift.ClusterSnapshotCopyStatus/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.ClusterSnapshotCopyStatus/RetentionPeriod
     :cognitect.aws.redshift.ClusterSnapshotCopyStatus/SnapshotCopyGrantName]))

(s/def :cognitect.aws.redshift/SourceIdsList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/HsmConfigurationList
  (s/coll-of :cognitect.aws.redshift/HsmConfiguration))

(s/def
  :cognitect.aws.redshift/BatchModifyClusterSnapshotsOutputMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.BatchModifyClusterSnapshotsOutputMessage/Resources
     :cognitect.aws.redshift.BatchModifyClusterSnapshotsOutputMessage/Errors]))

(s/def
  :cognitect.aws.redshift/EnableSnapshotCopyMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.EnableSnapshotCopyMessage/ClusterIdentifier
     :cognitect.aws.redshift.EnableSnapshotCopyMessage/DestinationRegion]
    :opt-un
    [:cognitect.aws.redshift.EnableSnapshotCopyMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.EnableSnapshotCopyMessage/RetentionPeriod
     :cognitect.aws.redshift.EnableSnapshotCopyMessage/SnapshotCopyGrantName]))

(s/def :cognitect.aws.redshift/RestorableNodeTypeList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOptionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.NodeConfigurationOptionsMessage/NodeConfigurationOptionList
     :cognitect.aws.redshift.NodeConfigurationOptionsMessage/Marker]))

(s/def
  :cognitect.aws.redshift/RevokeClusterSecurityGroupIngressResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.RevokeClusterSecurityGroupIngressResult/ClusterSecurityGroup]))

(s/def
  :cognitect.aws.redshift/ReservedNodeOfferingsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ReservedNodeOfferingsMessage/Marker
     :cognitect.aws.redshift.ReservedNodeOfferingsMessage/ReservedNodeOfferings]))

(s/def
  :cognitect.aws.redshift/ClusterDbRevisionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterDbRevisionsMessage/Marker
     :cognitect.aws.redshift.ClusterDbRevisionsMessage/ClusterDbRevisions]))

(s/def
  :cognitect.aws.redshift/ClusterDbRevisionsList
  (s/coll-of :cognitect.aws.redshift/ClusterDbRevision))

(s/def
  :cognitect.aws.redshift/ClusterVersionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterVersionsMessage/Marker
     :cognitect.aws.redshift.ClusterVersionsMessage/ClusterVersions]))

(s/def
  :cognitect.aws.redshift/DeleteScheduledActionMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteScheduledActionMessage/ScheduledActionName]))

(s/def
  :cognitect.aws.redshift/RestoreTableFromClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/ClusterIdentifier
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SnapshotIdentifier
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceDatabaseName
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceTableName
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/NewTableName]
    :opt-un
    [:cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/TargetSchemaName
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceSchemaName
     :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/TargetDatabaseName]))

(s/def
  :cognitect.aws.redshift/DeleteHsmConfigurationMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteHsmConfigurationMessage/HsmConfigurationIdentifier]))

(s/def
  :cognitect.aws.redshift/CreateHsmConfigurationResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateHsmConfigurationResult/HsmConfiguration]))

(s/def
  :cognitect.aws.redshift/AcceptReservedNodeExchangeOutputMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.AcceptReservedNodeExchangeOutputMessage/ExchangedReservedNode]))

(s/def
  :cognitect.aws.redshift/DeleteClusterSnapshotResult
  (s/keys :opt-un [:cognitect.aws.redshift.DeleteClusterSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.redshift/DisableLoggingMessage
  (s/keys :req-un [:cognitect.aws.redshift.DisableLoggingMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/ModifySnapshotCopyRetentionPeriodResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodResult/Cluster]))

(s/def
  :cognitect.aws.redshift/DeleteUsageLimitMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteUsageLimitMessage/UsageLimitId]))

(s/def
  :cognitect.aws.redshift/RotateEncryptionKeyResult
  (s/keys :opt-un [:cognitect.aws.redshift.RotateEncryptionKeyResult/Cluster]))

(s/def
  :cognitect.aws.redshift/AvailabilityZoneList
  (s/coll-of :cognitect.aws.redshift/AvailabilityZone))

(s/def
  :cognitect.aws.redshift/DataTransferProgress
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DataTransferProgress/TotalDataInMegaBytes
     :cognitect.aws.redshift.DataTransferProgress/DataTransferredInMegaBytes
     :cognitect.aws.redshift.DataTransferProgress/Status
     :cognitect.aws.redshift.DataTransferProgress/CurrentRateInMegaBytesPerSecond
     :cognitect.aws.redshift.DataTransferProgress/EstimatedTimeToCompletionInSeconds
     :cognitect.aws.redshift.DataTransferProgress/ElapsedTimeInSeconds]))

(s/def
  :cognitect.aws.redshift/ScheduledAction
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ScheduledAction/EndTime
     :cognitect.aws.redshift.ScheduledAction/StartTime
     :cognitect.aws.redshift.ScheduledAction/ScheduledActionName
     :cognitect.aws.redshift.ScheduledAction/IamRole
     :cognitect.aws.redshift.ScheduledAction/ScheduledActionDescription
     :cognitect.aws.redshift.ScheduledAction/TargetAction
     :cognitect.aws.redshift.ScheduledAction/State
     :cognitect.aws.redshift.ScheduledAction/Schedule
     :cognitect.aws.redshift.ScheduledAction/NextInvocations]))

(s/def :cognitect.aws.redshift/ScheduleDefinitionList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/HsmClientCertificate
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.HsmClientCertificate/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.HsmClientCertificate/Tags
     :cognitect.aws.redshift.HsmClientCertificate/HsmClientCertificatePublicKey]))

(s/def
  :cognitect.aws.redshift/BatchDeleteClusterSnapshotsResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.BatchDeleteClusterSnapshotsResult/Resources
     :cognitect.aws.redshift.BatchDeleteClusterSnapshotsResult/Errors]))

(s/def :cognitect.aws.redshift/SubnetIdentifierList (s/coll-of :cognitect.aws.redshift/String))

(s/def :cognitect.aws.redshift/SubnetList (s/coll-of :cognitect.aws.redshift/Subnet))

(s/def
  :cognitect.aws.redshift/IPRange
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.IPRange/Tags
     :cognitect.aws.redshift.IPRange/Status
     :cognitect.aws.redshift.IPRange/CIDRIP]))

(s/def
  :cognitect.aws.redshift/CreateSnapshotCopyGrantMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/SnapshotCopyGrantName]
    :opt-un
    [:cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/Tags
     :cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/KmsKeyId]))

(s/def
  :cognitect.aws.redshift/NodeConfigurationOptionsFilterName
  (s/spec
    string?
    :gen
    #(s/gen #{"NumberOfNodes" "EstimatedDiskUtilizationPercent" "Mode" "NodeType"})))

(s/def
  :cognitect.aws.redshift/DeleteClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.DeleteClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/PauseClusterMessage
  (s/keys :req-un [:cognitect.aws.redshift.PauseClusterMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/AccountAttribute
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.AccountAttribute/AttributeName
     :cognitect.aws.redshift.AccountAttribute/AttributeValues]))

(s/def
  :cognitect.aws.redshift/RecurringCharge
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.RecurringCharge/RecurringChargeFrequency
     :cognitect.aws.redshift.RecurringCharge/RecurringChargeAmount]))

(s/def :cognitect.aws.redshift/AttributeList (s/coll-of :cognitect.aws.redshift/AccountAttribute))

(s/def
  :cognitect.aws.redshift/RebootClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.RebootClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/ModifySnapshotCopyRetentionPeriodMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/ClusterIdentifier
     :cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/RetentionPeriod]
    :opt-un
    [:cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/Manual]))

(s/def
  :cognitect.aws.redshift/CreateEventSubscriptionMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateEventSubscriptionMessage/SubscriptionName
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/SnsTopicArn]
    :opt-un
    [:cognitect.aws.redshift.CreateEventSubscriptionMessage/Severity
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/Tags
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/SourceIds
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/SourceType
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/Enabled
     :cognitect.aws.redshift.CreateEventSubscriptionMessage/EventCategories]))

(s/def
  :cognitect.aws.redshift/HsmConfigurationMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.HsmConfigurationMessage/HsmConfigurations
     :cognitect.aws.redshift.HsmConfigurationMessage/Marker]))

(s/def
  :cognitect.aws.redshift/CreateScheduledActionMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateScheduledActionMessage/ScheduledActionName
     :cognitect.aws.redshift.CreateScheduledActionMessage/TargetAction
     :cognitect.aws.redshift.CreateScheduledActionMessage/Schedule
     :cognitect.aws.redshift.CreateScheduledActionMessage/IamRole]
    :opt-un
    [:cognitect.aws.redshift.CreateScheduledActionMessage/Enable
     :cognitect.aws.redshift.CreateScheduledActionMessage/EndTime
     :cognitect.aws.redshift.CreateScheduledActionMessage/StartTime
     :cognitect.aws.redshift.CreateScheduledActionMessage/ScheduledActionDescription]))

(s/def
  :cognitect.aws.redshift/CreateClusterParameterGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateClusterParameterGroupMessage/ParameterGroupName
     :cognitect.aws.redshift.CreateClusterParameterGroupMessage/ParameterGroupFamily
     :cognitect.aws.redshift.CreateClusterParameterGroupMessage/Description]
    :opt-un
    [:cognitect.aws.redshift.CreateClusterParameterGroupMessage/Tags]))

(s/def
  :cognitect.aws.redshift/DeleteHsmClientCertificateMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteHsmClientCertificateMessage/HsmClientCertificateIdentifier]))

(s/def
  :cognitect.aws.redshift/ClusterNode
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterNode/PublicIPAddress
     :cognitect.aws.redshift.ClusterNode/NodeRole
     :cognitect.aws.redshift.ClusterNode/PrivateIPAddress]))

(s/def
  :cognitect.aws.redshift/SnapshotMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.SnapshotMessage/Snapshots
     :cognitect.aws.redshift.SnapshotMessage/Marker]))

(s/def
  :cognitect.aws.redshift/DescribeHsmClientCertificatesMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/TagKeys
     :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/TagValues
     :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/MaxRecords
     :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/Marker]))

(s/def
  :cognitect.aws.redshift/HsmConfiguration
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.HsmConfiguration/Tags
     :cognitect.aws.redshift.HsmConfiguration/HsmConfigurationIdentifier
     :cognitect.aws.redshift.HsmConfiguration/Description
     :cognitect.aws.redshift.HsmConfiguration/HsmPartitionName
     :cognitect.aws.redshift.HsmConfiguration/HsmIpAddress]))

(s/def :cognitect.aws.redshift/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift/ReservedNodeOffering
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ReservedNodeOffering/CurrencyCode
     :cognitect.aws.redshift.ReservedNodeOffering/FixedPrice
     :cognitect.aws.redshift.ReservedNodeOffering/ReservedNodeOfferingType
     :cognitect.aws.redshift.ReservedNodeOffering/ReservedNodeOfferingId
     :cognitect.aws.redshift.ReservedNodeOffering/Duration
     :cognitect.aws.redshift.ReservedNodeOffering/UsagePrice
     :cognitect.aws.redshift.ReservedNodeOffering/RecurringCharges
     :cognitect.aws.redshift.ReservedNodeOffering/OfferingType
     :cognitect.aws.redshift.ReservedNodeOffering/NodeType]))

(s/def
  :cognitect.aws.redshift/CreateClusterSubnetGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateClusterSubnetGroupMessage/ClusterSubnetGroupName
     :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/Description
     :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/SubnetIds]
    :opt-un
    [:cognitect.aws.redshift.CreateClusterSubnetGroupMessage/Tags]))

(s/def
  :cognitect.aws.redshift/SupportedPlatformsList
  (s/coll-of :cognitect.aws.redshift/SupportedPlatform))

(s/def
  :cognitect.aws.redshift/Cluster
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Cluster/ClusterPublicKey
     :cognitect.aws.redshift.Cluster/EnhancedVpcRouting
     :cognitect.aws.redshift.Cluster/PubliclyAccessible
     :cognitect.aws.redshift.Cluster/NextMaintenanceWindowStartTime
     :cognitect.aws.redshift.Cluster/PreferredMaintenanceWindow
     :cognitect.aws.redshift.Cluster/Encrypted
     :cognitect.aws.redshift.Cluster/ClusterIdentifier
     :cognitect.aws.redshift.Cluster/ClusterSnapshotCopyStatus
     :cognitect.aws.redshift.Cluster/ClusterSubnetGroupName
     :cognitect.aws.redshift.Cluster/NumberOfNodes
     :cognitect.aws.redshift.Cluster/ElasticResizeNumberOfNodeOptions
     :cognitect.aws.redshift.Cluster/Tags
     :cognitect.aws.redshift.Cluster/ClusterAvailabilityStatus
     :cognitect.aws.redshift.Cluster/DBName
     :cognitect.aws.redshift.Cluster/ClusterParameterGroups
     :cognitect.aws.redshift.Cluster/AvailabilityZone
     :cognitect.aws.redshift.Cluster/PendingActions
     :cognitect.aws.redshift.Cluster/ClusterSecurityGroups
     :cognitect.aws.redshift.Cluster/MasterUsername
     :cognitect.aws.redshift.Cluster/AvailabilityZoneRelocationStatus
     :cognitect.aws.redshift.Cluster/SnapshotScheduleState
     :cognitect.aws.redshift.Cluster/ExpectedNextSnapshotScheduleTimeStatus
     :cognitect.aws.redshift.Cluster/DataTransferProgress
     :cognitect.aws.redshift.Cluster/ClusterStatus
     :cognitect.aws.redshift.Cluster/VpcId
     :cognitect.aws.redshift.Cluster/MaintenanceTrackName
     :cognitect.aws.redshift.Cluster/KmsKeyId
     :cognitect.aws.redshift.Cluster/RestoreStatus
     :cognitect.aws.redshift.Cluster/ClusterCreateTime
     :cognitect.aws.redshift.Cluster/ClusterRevisionNumber
     :cognitect.aws.redshift.Cluster/AllowVersionUpgrade
     :cognitect.aws.redshift.Cluster/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.Cluster/ClusterVersion
     :cognitect.aws.redshift.Cluster/ModifyStatus
     :cognitect.aws.redshift.Cluster/Endpoint
     :cognitect.aws.redshift.Cluster/AutomatedSnapshotRetentionPeriod
     :cognitect.aws.redshift.Cluster/IamRoles
     :cognitect.aws.redshift.Cluster/ResizeInfo
     :cognitect.aws.redshift.Cluster/ExpectedNextSnapshotScheduleTime
     :cognitect.aws.redshift.Cluster/VpcSecurityGroups
     :cognitect.aws.redshift.Cluster/SnapshotScheduleIdentifier
     :cognitect.aws.redshift.Cluster/DeferredMaintenanceWindows
     :cognitect.aws.redshift.Cluster/ClusterNodes
     :cognitect.aws.redshift.Cluster/HsmStatus
     :cognitect.aws.redshift.Cluster/ElasticIpStatus
     :cognitect.aws.redshift.Cluster/NodeType
     :cognitect.aws.redshift.Cluster/PendingModifiedValues
     :cognitect.aws.redshift.Cluster/ClusterNamespaceArn]))

(s/def
  :cognitect.aws.redshift/SnapshotCopyGrantList
  (s/coll-of :cognitect.aws.redshift/SnapshotCopyGrant))

(s/def :cognitect.aws.redshift/TagValueList (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/DescribeClusterSnapshotsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClusterSnapshotsMessage/TagKeys
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/TagValues
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SnapshotIdentifier
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/EndTime
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/StartTime
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/OwnerAccount
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/Marker
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SnapshotType
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/ClusterExists
     :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SortingEntities]))

(s/def
  :cognitect.aws.redshift/ClusterCredentials
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterCredentials/DbUser
     :cognitect.aws.redshift.ClusterCredentials/DbPassword
     :cognitect.aws.redshift.ClusterCredentials/Expiration]))

(s/def
  :cognitect.aws.redshift/ClusterParameterStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ClusterParameterStatus/ParameterName
     :cognitect.aws.redshift.ClusterParameterStatus/ParameterApplyErrorDescription
     :cognitect.aws.redshift.ClusterParameterStatus/ParameterApplyStatus]))

(s/def
  :cognitect.aws.redshift/VpcEndpoint
  (s/keys :opt-un [:cognitect.aws.redshift.VpcEndpoint/VpcEndpointId]))

(s/def
  :cognitect.aws.redshift/EligibleTracksToUpdateList
  (s/coll-of :cognitect.aws.redshift/UpdateTarget))

(s/def
  :cognitect.aws.redshift/Parameter
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.Parameter/DataType
     :cognitect.aws.redshift.Parameter/ParameterName
     :cognitect.aws.redshift.Parameter/Source
     :cognitect.aws.redshift.Parameter/MinimumEngineVersion
     :cognitect.aws.redshift.Parameter/AllowedValues
     :cognitect.aws.redshift.Parameter/ApplyType
     :cognitect.aws.redshift.Parameter/Description
     :cognitect.aws.redshift.Parameter/IsModifiable
     :cognitect.aws.redshift.Parameter/ParameterValue]))

(s/def
  :cognitect.aws.redshift/UsageLimitLimitType
  (s/spec string? :gen #(s/gen #{"time" "data-scanned"})))

(s/def
  :cognitect.aws.redshift/DescribeDefaultClusterParametersResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeDefaultClusterParametersResult/DefaultClusterParameters]))

(s/def
  :cognitect.aws.redshift/UsageLimitFeatureType
  (s/spec string? :gen #(s/gen #{"spectrum" "concurrency-scaling"})))

(s/def
  :cognitect.aws.redshift/IntegerOptional
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift/CreateClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateClusterSnapshotMessage/SnapshotIdentifier
     :cognitect.aws.redshift.CreateClusterSnapshotMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.CreateClusterSnapshotMessage/Tags
     :cognitect.aws.redshift.CreateClusterSnapshotMessage/ManualSnapshotRetentionPeriod]))

(s/def
  :cognitect.aws.redshift/ScheduledActionList
  (s/coll-of :cognitect.aws.redshift/ScheduledAction))

(s/def
  :cognitect.aws.redshift/EventSubscriptionsList
  (s/coll-of :cognitect.aws.redshift/EventSubscription))

(s/def
  :cognitect.aws.redshift/ModifyClusterMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterMessage/EnhancedVpcRouting
     :cognitect.aws.redshift.ModifyClusterMessage/PubliclyAccessible
     :cognitect.aws.redshift.ModifyClusterMessage/PreferredMaintenanceWindow
     :cognitect.aws.redshift.ModifyClusterMessage/Encrypted
     :cognitect.aws.redshift.ModifyClusterMessage/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.ModifyClusterMessage/NumberOfNodes
     :cognitect.aws.redshift.ModifyClusterMessage/VpcSecurityGroupIds
     :cognitect.aws.redshift.ModifyClusterMessage/AvailabilityZone
     :cognitect.aws.redshift.ModifyClusterMessage/ClusterType
     :cognitect.aws.redshift.ModifyClusterMessage/MasterUserPassword
     :cognitect.aws.redshift.ModifyClusterMessage/ClusterSecurityGroups
     :cognitect.aws.redshift.ModifyClusterMessage/ElasticIp
     :cognitect.aws.redshift.ModifyClusterMessage/AvailabilityZoneRelocation
     :cognitect.aws.redshift.ModifyClusterMessage/HsmConfigurationIdentifier
     :cognitect.aws.redshift.ModifyClusterMessage/Port
     :cognitect.aws.redshift.ModifyClusterMessage/MaintenanceTrackName
     :cognitect.aws.redshift.ModifyClusterMessage/KmsKeyId
     :cognitect.aws.redshift.ModifyClusterMessage/AllowVersionUpgrade
     :cognitect.aws.redshift.ModifyClusterMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.ModifyClusterMessage/ClusterVersion
     :cognitect.aws.redshift.ModifyClusterMessage/AutomatedSnapshotRetentionPeriod
     :cognitect.aws.redshift.ModifyClusterMessage/NewClusterIdentifier
     :cognitect.aws.redshift.ModifyClusterMessage/NodeType
     :cognitect.aws.redshift.ModifyClusterMessage/ClusterParameterGroupName]))

(s/def
  :cognitect.aws.redshift/EnableLoggingMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.EnableLoggingMessage/ClusterIdentifier
     :cognitect.aws.redshift.EnableLoggingMessage/BucketName]
    :opt-un
    [:cognitect.aws.redshift.EnableLoggingMessage/S3KeyPrefix]))

(s/def
  :cognitect.aws.redshift/RevisionTargetsList
  (s/coll-of :cognitect.aws.redshift/RevisionTarget))

(s/def
  :cognitect.aws.redshift/GetClusterCredentialsMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.GetClusterCredentialsMessage/DbUser
     :cognitect.aws.redshift.GetClusterCredentialsMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.GetClusterCredentialsMessage/DurationSeconds
     :cognitect.aws.redshift.GetClusterCredentialsMessage/DbName
     :cognitect.aws.redshift.GetClusterCredentialsMessage/AutoCreate
     :cognitect.aws.redshift.GetClusterCredentialsMessage/DbGroups]))

(s/def
  :cognitect.aws.redshift/ReservedNode
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.ReservedNode/CurrencyCode
     :cognitect.aws.redshift.ReservedNode/StartTime
     :cognitect.aws.redshift.ReservedNode/NodeCount
     :cognitect.aws.redshift.ReservedNode/FixedPrice
     :cognitect.aws.redshift.ReservedNode/ReservedNodeOfferingType
     :cognitect.aws.redshift.ReservedNode/ReservedNodeOfferingId
     :cognitect.aws.redshift.ReservedNode/Duration
     :cognitect.aws.redshift.ReservedNode/ReservedNodeId
     :cognitect.aws.redshift.ReservedNode/UsagePrice
     :cognitect.aws.redshift.ReservedNode/State
     :cognitect.aws.redshift.ReservedNode/RecurringCharges
     :cognitect.aws.redshift.ReservedNode/OfferingType
     :cognitect.aws.redshift.ReservedNode/NodeType]))

(s/def
  :cognitect.aws.redshift/CreateUsageLimitMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateUsageLimitMessage/ClusterIdentifier
     :cognitect.aws.redshift.CreateUsageLimitMessage/FeatureType
     :cognitect.aws.redshift.CreateUsageLimitMessage/LimitType
     :cognitect.aws.redshift.CreateUsageLimitMessage/Amount]
    :opt-un
    [:cognitect.aws.redshift.CreateUsageLimitMessage/Period
     :cognitect.aws.redshift.CreateUsageLimitMessage/BreachAction
     :cognitect.aws.redshift.CreateUsageLimitMessage/Tags]))

(s/def
  :cognitect.aws.redshift/DescribeScheduledActionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeScheduledActionsMessage/EndTime
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/Active
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/StartTime
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/Marker
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/ScheduledActionName
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/TargetActionType
     :cognitect.aws.redshift.DescribeScheduledActionsMessage/Filters]))

(s/def
  :cognitect.aws.redshift/DescribeSnapshotSchedulesMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/TagKeys
     :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/TagValues
     :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/MaxRecords
     :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/Marker
     :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/ScheduleIdentifier]))

(s/def
  :cognitect.aws.redshift/AuthorizeClusterSecurityGroupIngressMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/ClusterSecurityGroupName]
    :opt-un
    [:cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/EC2SecurityGroupOwnerId
     :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/CIDRIP
     :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/EC2SecurityGroupName]))

(s/def
  :cognitect.aws.redshift/CreateClusterMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateClusterMessage/ClusterIdentifier
     :cognitect.aws.redshift.CreateClusterMessage/NodeType
     :cognitect.aws.redshift.CreateClusterMessage/MasterUsername
     :cognitect.aws.redshift.CreateClusterMessage/MasterUserPassword]
    :opt-un
    [:cognitect.aws.redshift.CreateClusterMessage/EnhancedVpcRouting
     :cognitect.aws.redshift.CreateClusterMessage/PubliclyAccessible
     :cognitect.aws.redshift.CreateClusterMessage/PreferredMaintenanceWindow
     :cognitect.aws.redshift.CreateClusterMessage/Encrypted
     :cognitect.aws.redshift.CreateClusterMessage/HsmClientCertificateIdentifier
     :cognitect.aws.redshift.CreateClusterMessage/ClusterSubnetGroupName
     :cognitect.aws.redshift.CreateClusterMessage/NumberOfNodes
     :cognitect.aws.redshift.CreateClusterMessage/Tags
     :cognitect.aws.redshift.CreateClusterMessage/DBName
     :cognitect.aws.redshift.CreateClusterMessage/VpcSecurityGroupIds
     :cognitect.aws.redshift.CreateClusterMessage/AvailabilityZone
     :cognitect.aws.redshift.CreateClusterMessage/ClusterType
     :cognitect.aws.redshift.CreateClusterMessage/ClusterSecurityGroups
     :cognitect.aws.redshift.CreateClusterMessage/AdditionalInfo
     :cognitect.aws.redshift.CreateClusterMessage/ElasticIp
     :cognitect.aws.redshift.CreateClusterMessage/AvailabilityZoneRelocation
     :cognitect.aws.redshift.CreateClusterMessage/HsmConfigurationIdentifier
     :cognitect.aws.redshift.CreateClusterMessage/Port
     :cognitect.aws.redshift.CreateClusterMessage/MaintenanceTrackName
     :cognitect.aws.redshift.CreateClusterMessage/KmsKeyId
     :cognitect.aws.redshift.CreateClusterMessage/AllowVersionUpgrade
     :cognitect.aws.redshift.CreateClusterMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.CreateClusterMessage/ClusterVersion
     :cognitect.aws.redshift.CreateClusterMessage/AutomatedSnapshotRetentionPeriod
     :cognitect.aws.redshift.CreateClusterMessage/IamRoles
     :cognitect.aws.redshift.CreateClusterMessage/SnapshotScheduleIdentifier
     :cognitect.aws.redshift.CreateClusterMessage/ClusterParameterGroupName]))

(s/def
  :cognitect.aws.redshift/DeleteSnapshotScheduleMessage
  (s/keys :req-un [:cognitect.aws.redshift.DeleteSnapshotScheduleMessage/ScheduleIdentifier]))

(s/def
  :cognitect.aws.redshift/CreateHsmConfigurationMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmConfigurationIdentifier
     :cognitect.aws.redshift.CreateHsmConfigurationMessage/Description
     :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmIpAddress
     :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmPartitionName
     :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmPartitionPassword
     :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmServerPublicCertificate]
    :opt-un
    [:cognitect.aws.redshift.CreateHsmConfigurationMessage/Tags]))

(s/def
  :cognitect.aws.redshift/ClusterSubnetGroups
  (s/coll-of :cognitect.aws.redshift/ClusterSubnetGroup))

(s/def
  :cognitect.aws.redshift/DisableSnapshotCopyMessage
  (s/keys :req-un [:cognitect.aws.redshift.DisableSnapshotCopyMessage/ClusterIdentifier]))

(s/def
  :cognitect.aws.redshift/ClusterParameterGroupStatusList
  (s/coll-of :cognitect.aws.redshift/ClusterParameterGroupStatus))

(s/def
  :cognitect.aws.redshift/DescribeEventSubscriptionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeEventSubscriptionsMessage/TagKeys
     :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/TagValues
     :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/Marker
     :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/SubscriptionName]))

(s/def
  :cognitect.aws.redshift/RestoreFromClusterSnapshotResult
  (s/keys :opt-un [:cognitect.aws.redshift.RestoreFromClusterSnapshotResult/Cluster]))

(s/def
  :cognitect.aws.redshift/ScheduleState
  (s/spec string? :gen #(s/gen #{"ACTIVE" "FAILED" "MODIFYING"})))

(s/def
  :cognitect.aws.redshift/ModifyClusterSnapshotMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterSnapshotMessage/SnapshotIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterSnapshotMessage/ManualSnapshotRetentionPeriod
     :cognitect.aws.redshift.ModifyClusterSnapshotMessage/Force]))

(s/def
  :cognitect.aws.redshift/PurchaseReservedNodeOfferingMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.PurchaseReservedNodeOfferingMessage/ReservedNodeOfferingId]
    :opt-un
    [:cognitect.aws.redshift.PurchaseReservedNodeOfferingMessage/NodeCount]))

(s/def
  :cognitect.aws.redshift/AuthorizeSnapshotAccessResult
  (s/keys :opt-un [:cognitect.aws.redshift.AuthorizeSnapshotAccessResult/Snapshot]))

(s/def
  :cognitect.aws.redshift/UsageLimitPeriod
  (s/spec string? :gen #(s/gen #{"weekly" "daily" "monthly"})))

(s/def
  :cognitect.aws.redshift/AuthorizeClusterSecurityGroupIngressResult
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressResult/ClusterSecurityGroup]))

(s/def
  :cognitect.aws.redshift/LoggingStatus
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.LoggingStatus/LastSuccessfulDeliveryTime
     :cognitect.aws.redshift.LoggingStatus/LastFailureTime
     :cognitect.aws.redshift.LoggingStatus/LoggingEnabled
     :cognitect.aws.redshift.LoggingStatus/LastFailureMessage
     :cognitect.aws.redshift.LoggingStatus/S3KeyPrefix
     :cognitect.aws.redshift.LoggingStatus/BucketName]))

(s/def
  :cognitect.aws.redshift/SnapshotErrorMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.SnapshotErrorMessage/SnapshotIdentifier
     :cognitect.aws.redshift.SnapshotErrorMessage/FailureReason
     :cognitect.aws.redshift.SnapshotErrorMessage/SnapshotClusterIdentifier
     :cognitect.aws.redshift.SnapshotErrorMessage/FailureCode]))

(s/def
  :cognitect.aws.redshift/AccountWithRestoreAccess
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.AccountWithRestoreAccess/AccountId
     :cognitect.aws.redshift.AccountWithRestoreAccess/AccountAlias]))

(s/def :cognitect.aws.redshift/ImportTablesNotStarted (s/coll-of :cognitect.aws.redshift/String))

(s/def
  :cognitect.aws.redshift/Double
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.redshift/BatchDeleteClusterSnapshotsRequest
  (s/keys :req-un [:cognitect.aws.redshift.BatchDeleteClusterSnapshotsRequest/Identifiers]))

(s/def
  :cognitect.aws.redshift/DescribeHsmConfigurationsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeHsmConfigurationsMessage/TagKeys
     :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/TagValues
     :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/Marker
     :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/HsmConfigurationIdentifier]))

(s/def
  :cognitect.aws.redshift/EventCategoriesMessage
  (s/keys :opt-un [:cognitect.aws.redshift.EventCategoriesMessage/EventCategoriesMapList]))

(s/def
  :cognitect.aws.redshift/DescribeClustersMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeClustersMessage/TagKeys
     :cognitect.aws.redshift.DescribeClustersMessage/TagValues
     :cognitect.aws.redshift.DescribeClustersMessage/ClusterIdentifier
     :cognitect.aws.redshift.DescribeClustersMessage/MaxRecords
     :cognitect.aws.redshift.DescribeClustersMessage/Marker]))

(s/def
  :cognitect.aws.redshift/CreateClusterSecurityGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.CreateClusterSecurityGroupMessage/ClusterSecurityGroupName
     :cognitect.aws.redshift.CreateClusterSecurityGroupMessage/Description]
    :opt-un
    [:cognitect.aws.redshift.CreateClusterSecurityGroupMessage/Tags]))

(s/def :cognitect.aws.redshift/ScheduledActionTimeList (s/coll-of :cognitect.aws.redshift/TStamp))

(s/def
  :cognitect.aws.redshift/DeleteClusterSecurityGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.DeleteClusterSecurityGroupMessage/ClusterSecurityGroupName]))

(s/def
  :cognitect.aws.redshift/CreateHsmClientCertificateResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateHsmClientCertificateResult/HsmClientCertificate]))

(s/def
  :cognitect.aws.redshift/LongOptional
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.redshift/ModifyClusterIamRolesMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterIamRolesMessage/ClusterIdentifier]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterIamRolesMessage/RemoveIamRoles
     :cognitect.aws.redshift.ModifyClusterIamRolesMessage/AddIamRoles]))

(s/def
  :cognitect.aws.redshift/CreateClusterSnapshotResult
  (s/keys :opt-un [:cognitect.aws.redshift.CreateClusterSnapshotResult/Snapshot]))

(s/def
  :cognitect.aws.redshift/ModifyClusterResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterResult/Cluster]))

(s/def
  :cognitect.aws.redshift/EC2SecurityGroupList
  (s/coll-of :cognitect.aws.redshift/EC2SecurityGroup))

(s/def
  :cognitect.aws.redshift/DescribeOrderableClusterOptionsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/Marker
     :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/ClusterVersion
     :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/NodeType]))

(s/def
  :cognitect.aws.redshift/DescribeReservedNodeOfferingsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/Marker
     :cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/ReservedNodeOfferingId]))

(s/def
  :cognitect.aws.redshift/EventCategoriesMapList
  (s/coll-of :cognitect.aws.redshift/EventCategoriesMap))

(s/def
  :cognitect.aws.redshift/HsmClientCertificateList
  (s/coll-of :cognitect.aws.redshift/HsmClientCertificate))

(s/def
  :cognitect.aws.redshift/ModifyClusterDbRevisionResult
  (s/keys :opt-un [:cognitect.aws.redshift.ModifyClusterDbRevisionResult/Cluster]))

(s/def
  :cognitect.aws.redshift/CustomerStorageMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.CustomerStorageMessage/TotalProvisionedStorageInMegaBytes
     :cognitect.aws.redshift.CustomerStorageMessage/TotalBackupSizeInMegaBytes]))

(s/def
  :cognitect.aws.redshift/DescribeSnapshotCopyGrantsMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/TagKeys
     :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/TagValues
     :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/MaxRecords
     :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/Marker
     :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/SnapshotCopyGrantName]))

(s/def
  :cognitect.aws.redshift/SourceType
  (s/spec
    string?
    :gen
    #(s/gen
      #{"cluster-parameter-group" "cluster" "cluster-snapshot" "cluster-security-group"
        "scheduled-action"})))

(s/def
  :cognitect.aws.redshift/String
  (s/spec
    (s/and string? #(>= 2147483647 (count %)))
    :gen
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose 0 2147483647) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.redshift/ModifyClusterSubnetGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/ClusterSubnetGroupName
     :cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/SubnetIds]
    :opt-un
    [:cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/Description]))

(s/def
  :cognitect.aws.redshift/DoubleOptional
  (s/spec double? :gen #(gen/double* {:infinite? false, :NaN? false})))

(s/def
  :cognitect.aws.redshift/ResetClusterParameterGroupMessage
  (s/keys
    :req-un
    [:cognitect.aws.redshift.ResetClusterParameterGroupMessage/ParameterGroupName]
    :opt-un
    [:cognitect.aws.redshift.ResetClusterParameterGroupMessage/Parameters
     :cognitect.aws.redshift.ResetClusterParameterGroupMessage/ResetAllParameters]))

(s/def
  :cognitect.aws.redshift/RebootClusterMessage
  (s/keys :req-un [:cognitect.aws.redshift.RebootClusterMessage/ClusterIdentifier]))

(s/def :cognitect.aws.redshift/TrackList (s/coll-of :cognitect.aws.redshift/MaintenanceTrack))

(s/def
  :cognitect.aws.redshift/ReservedNodeOfferingList
  (s/coll-of :cognitect.aws.redshift/ReservedNodeOffering))

(s/def
  :cognitect.aws.redshift/HsmClientCertificateMessage
  (s/keys
    :opt-un
    [:cognitect.aws.redshift.HsmClientCertificateMessage/HsmClientCertificates
     :cognitect.aws.redshift.HsmClientCertificateMessage/Marker]))

(s/def :cognitect.aws.redshift/EventCategoriesList (s/coll-of :cognitect.aws.redshift/String))

(s/def :cognitect.aws.redshift/TagKeyList (s/coll-of :cognitect.aws.redshift/String))

(s/def :cognitect.aws.redshift/SensitiveString string?)

(s/def
  :cognitect.aws.redshift.ClusterSecurityGroupMembership/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSecurityGroupMembership/Status :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateTagsMessage/ResourceName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateTagsMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.ResizeClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/ParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeDefaultClusterParametersMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroup/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroup/ParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterParameterGroup/Description :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterParameterGroup/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DescribeAccountAttributesMessage/AttributeNames
  :cognitect.aws.redshift/AttributeNameList)

(s/def
  :cognitect.aws.redshift.SnapshotSortingEntity/Attribute
  :cognitect.aws.redshift/SnapshotAttributeToSortBy)

(s/def :cognitect.aws.redshift.SnapshotSortingEntity/SortOrder :cognitect.aws.redshift/SortByOrder)

(s/def :cognitect.aws.redshift.AvailabilityZone/Name :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AvailabilityZone/SupportedPlatforms
  :cognitect.aws.redshift/SupportedPlatformsList)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SubscriptionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SnsTopicArn
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SourceType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/SourceIds
  :cognitect.aws.redshift/SourceIdsList)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/EventCategories
  :cognitect.aws.redshift/EventCategoriesList)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/Severity
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionMessage/Enabled
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.DisableSnapshotCopyResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.ModifyClusterDbRevisionMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterDbRevisionMessage/RevisionTarget
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.OrderableClusterOption/ClusterVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.OrderableClusterOption/ClusterType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.OrderableClusterOption/NodeType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.OrderableClusterOption/AvailabilityZones
  :cognitect.aws.redshift/AvailabilityZoneList)

(s/def :cognitect.aws.redshift.RevisionTarget/DatabaseRevision :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.RevisionTarget/Description :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevisionTarget/DatabaseRevisionReleaseDate
  :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.CopyClusterSnapshotResult/Snapshot :cognitect.aws.redshift/Snapshot)

(s/def :cognitect.aws.redshift.RestoreStatus/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreStatus/CurrentRestoreRateInMegaBytesPerSecond
  :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.RestoreStatus/SnapshotSizeInMegaBytes :cognitect.aws.redshift/Long)

(s/def :cognitect.aws.redshift.RestoreStatus/ProgressInMegaBytes :cognitect.aws.redshift/Long)

(s/def :cognitect.aws.redshift.RestoreStatus/ElapsedTimeInSeconds :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.RestoreStatus/EstimatedTimeToCompletionInSeconds
  :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.ClusterSubnetGroup/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSubnetGroup/Description :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSubnetGroup/VpcId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSubnetGroup/SubnetGroupStatus :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSubnetGroup/Subnets :cognitect.aws.redshift/SubnetList)

(s/def :cognitect.aws.redshift.ClusterSubnetGroup/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DescribeReservedNodesMessage/ReservedNodeId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeReservedNodesMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeReservedNodesMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSubnetGroupResult/ClusterSubnetGroup
  :cognitect.aws.redshift/ClusterSubnetGroup)

(s/def :cognitect.aws.redshift.ClustersMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClustersMessage/Clusters :cognitect.aws.redshift/ClusterList)

(s/def :cognitect.aws.redshift.RevokeSnapshotAccessResult/Snapshot :cognitect.aws.redshift/Snapshot)

(s/def
  :cognitect.aws.redshift.CreateClusterSecurityGroupResult/ClusterSecurityGroup
  :cognitect.aws.redshift/ClusterSecurityGroup)

(s/def
  :cognitect.aws.redshift.DescribeClusterVersionsMessage/ClusterVersion
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterVersionsMessage/ClusterParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterVersionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeClusterVersionsMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SupportedOperation/OperationName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterAssociatedToSchedule/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterAssociatedToSchedule/ScheduleAssociationState
  :cognitect.aws.redshift/ScheduleState)

(s/def
  :cognitect.aws.redshift.CreateHsmClientCertificateMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmClientCertificateMessage/Tags
  :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.EventsMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventsMessage/Events :cognitect.aws.redshift/EventList)

(s/def :cognitect.aws.redshift.ClusterIamRole/IamRoleArn :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterIamRole/ApplyStatus :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupStatus/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupStatus/ParameterApplyStatus
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupStatus/ClusterParameterStatusList
  :cognitect.aws.redshift/ClusterParameterStatusList)

(s/def
  :cognitect.aws.redshift.AccountAttributeList/AccountAttributes
  :cognitect.aws.redshift/AttributeList)

(s/def :cognitect.aws.redshift.ScheduledActionsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ScheduledActionsMessage/ScheduledActions
  :cognitect.aws.redshift/ScheduledActionList)

(s/def :cognitect.aws.redshift.Tag/Key :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Tag/Value :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesOutputMessage/SnapshotSchedules
  :cognitect.aws.redshift/SnapshotScheduleList)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesOutputMessage/Marker
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.NodeConfigurationOption/NodeType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOption/NumberOfNodes
  :cognitect.aws.redshift/Integer)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOption/EstimatedDiskUtilizationPercent
  :cognitect.aws.redshift/DoubleOptional)

(s/def :cognitect.aws.redshift.NodeConfigurationOption/Mode :cognitect.aws.redshift/Mode)

(s/def :cognitect.aws.redshift.ElasticIpStatus/ElasticIp :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ElasticIpStatus/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ResizeClusterMessage/ClusterType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ResizeClusterMessage/NodeType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeClusterMessage/NumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.ResizeClusterMessage/Classic :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.MaintenanceTrack/MaintenanceTrackName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.MaintenanceTrack/DatabaseVersion :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.MaintenanceTrack/UpdateTargets
  :cognitect.aws.redshift/EligibleTracksToUpdateList)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupNameMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupNameMessage/ParameterGroupStatus
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSubnetGroupResult/ClusterSubnetGroup
  :cognitect.aws.redshift/ClusterSubnetGroup)

(s/def
  :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeClusterSecurityGroupsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.DeleteClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteClusterMessage/SkipFinalClusterSnapshot
  :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.DeleteClusterMessage/FinalClusterSnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteClusterMessage/FinalClusterSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.RotateEncryptionKeyMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/NumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/PubliclyAccessible
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.PendingModifiedValues/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.PendingModifiedValues/ClusterVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.PendingModifiedValues/EncryptionType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/EnhancedVpcRouting
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/MaintenanceTrackName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/AutomatedSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.PendingModifiedValues/ClusterType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PendingModifiedValues/MasterUserPassword
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.UsageLimitList/UsageLimits :cognitect.aws.redshift/UsageLimits)

(s/def :cognitect.aws.redshift.UsageLimitList/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenance
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceStartTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceEndTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceMessage/DeferMaintenanceDuration
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOptionsFilter/Name
  :cognitect.aws.redshift/NodeConfigurationOptionsFilterName)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOptionsFilter/Operator
  :cognitect.aws.redshift/OperatorType)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOptionsFilter/Values
  :cognitect.aws.redshift/ValueStringList)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/TargetNumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/AvgResizeRateInMegaBytesPerSecond
  :cognitect.aws.redshift/DoubleOptional)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/ElapsedTimeInSeconds
  :cognitect.aws.redshift/LongOptional)

(s/def :cognitect.aws.redshift.ResizeProgressMessage/Message :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/ProgressInMegaBytes
  :cognitect.aws.redshift/LongOptional)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/EstimatedTimeToCompletionInSeconds
  :cognitect.aws.redshift/LongOptional)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/DataTransferProgressPercent
  :cognitect.aws.redshift/DoubleOptional)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesInProgress
  :cognitect.aws.redshift/ImportTablesInProgress)

(s/def :cognitect.aws.redshift.ResizeProgressMessage/TargetNodeType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesCompleted
  :cognitect.aws.redshift/ImportTablesCompleted)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/TargetEncryptionType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/TotalResizeDataInMegaBytes
  :cognitect.aws.redshift/LongOptional)

(s/def :cognitect.aws.redshift.ResizeProgressMessage/ResizeType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/TargetClusterType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResizeProgressMessage/ImportTablesNotStarted
  :cognitect.aws.redshift/ImportTablesNotStarted)

(s/def :cognitect.aws.redshift.ResizeProgressMessage/Status :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EC2SecurityGroup/Status :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EC2SecurityGroup/EC2SecurityGroupName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EC2SecurityGroup/EC2SecurityGroupOwnerId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EC2SecurityGroup/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.Endpoint/Address :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Endpoint/Port :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.Endpoint/VpcEndpoints :cognitect.aws.redshift/VpcEndpointsList)

(s/def
  :cognitect.aws.redshift.DescribeEventCategoriesMessage/SourceType
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.ModifyUsageLimitMessage/UsageLimitId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ModifyUsageLimitMessage/Amount :cognitect.aws.redshift/LongOptional)

(s/def
  :cognitect.aws.redshift.ModifyUsageLimitMessage/BreachAction
  :cognitect.aws.redshift/UsageLimitBreachAction)

(s/def
  :cognitect.aws.redshift.AcceptReservedNodeExchangeInputMessage/ReservedNodeId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AcceptReservedNodeExchangeInputMessage/TargetReservedNodeOfferingId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterSecurityGroup/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSecurityGroup/Description :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterSecurityGroup/EC2SecurityGroups
  :cognitect.aws.redshift/EC2SecurityGroupList)

(s/def :cognitect.aws.redshift.ClusterSecurityGroup/IPRanges :cognitect.aws.redshift/IPRangeList)

(s/def :cognitect.aws.redshift.ClusterSecurityGroup/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.UsageLimit/UsageLimitId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.UsageLimit/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.UsageLimit/FeatureType :cognitect.aws.redshift/UsageLimitFeatureType)

(s/def :cognitect.aws.redshift.UsageLimit/LimitType :cognitect.aws.redshift/UsageLimitLimitType)

(s/def :cognitect.aws.redshift.UsageLimit/Amount :cognitect.aws.redshift/Long)

(s/def :cognitect.aws.redshift.UsageLimit/Period :cognitect.aws.redshift/UsageLimitPeriod)

(s/def
  :cognitect.aws.redshift.UsageLimit/BreachAction
  :cognitect.aws.redshift/UsageLimitBreachAction)

(s/def :cognitect.aws.redshift.UsageLimit/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.PauseClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.DeleteTagsMessage/ResourceName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DeleteTagsMessage/TagKeys :cognitect.aws.redshift/TagKeyList)

(s/def :cognitect.aws.redshift.ClusterVersion/ClusterVersion :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterVersion/ClusterParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterVersion/Description :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Subnet/SubnetIdentifier :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Subnet/SubnetAvailabilityZone
  :cognitect.aws.redshift/AvailabilityZone)

(s/def :cognitect.aws.redshift.Subnet/SubnetStatus :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterSubnetGroupMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterSubnetGroupMessage/ClusterSubnetGroups
  :cognitect.aws.redshift/ClusterSubnetGroups)

(s/def
  :cognitect.aws.redshift.CreateClusterParameterGroupResult/ClusterParameterGroup
  :cognitect.aws.redshift/ClusterParameterGroup)

(s/def :cognitect.aws.redshift.ClusterSecurityGroupMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterSecurityGroupMessage/ClusterSecurityGroups
  :cognitect.aws.redshift/ClusterSecurityGroups)

(s/def
  :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsOutputMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsOutputMessage/ReservedNodeOfferings
  :cognitect.aws.redshift/ReservedNodeOfferingList)

(s/def :cognitect.aws.redshift.CancelResizeMessage/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/Message :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.TableRestoreStatus/ProgressInMegaBytes
  :cognitect.aws.redshift/LongOptional)

(s/def
  :cognitect.aws.redshift.TableRestoreStatus/TableRestoreRequestId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/NewTableName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/TargetDatabaseName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/SourceSchemaName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/SourceDatabaseName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/RequestTime :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.TableRestoreStatus/TotalDataInMegaBytes
  :cognitect.aws.redshift/LongOptional)

(s/def :cognitect.aws.redshift.TableRestoreStatus/SourceTableName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/TargetSchemaName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TableRestoreStatus/SnapshotIdentifier :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.TableRestoreStatus/Status
  :cognitect.aws.redshift/TableRestoreStatusType)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionResult/EventSubscription
  :cognitect.aws.redshift/EventSubscription)

(s/def :cognitect.aws.redshift.EventCategoriesMap/SourceType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventCategoriesMap/Events :cognitect.aws.redshift/EventInfoMapList)

(s/def :cognitect.aws.redshift.ClusterDbRevision/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterDbRevision/CurrentDatabaseRevision
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterDbRevision/DatabaseRevisionReleaseDate
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ClusterDbRevision/RevisionTargets
  :cognitect.aws.redshift/RevisionTargetsList)

(s/def
  :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/CIDRIP
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/EC2SecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressMessage/EC2SecurityGroupOwnerId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.UpdateTarget/MaintenanceTrackName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.UpdateTarget/DatabaseVersion :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.UpdateTarget/SupportedOperations
  :cognitect.aws.redshift/SupportedOperationList)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotResult/TableRestoreStatus
  :cognitect.aws.redshift/TableRestoreStatus)

(s/def :cognitect.aws.redshift.ResumeClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.ModifyEventSubscriptionResult/EventSubscription
  :cognitect.aws.redshift/EventSubscription)

(s/def
  :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleDefinitions
  :cognitect.aws.redshift/ScheduleDefinitionList)

(s/def
  :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateSnapshotScheduleMessage/ScheduleDescription
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateSnapshotScheduleMessage/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.CreateSnapshotScheduleMessage/DryRun
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.CreateSnapshotScheduleMessage/NextInvocations
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeClusterSubnetGroupsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.DeleteEventSubscriptionMessage/SubscriptionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateSnapshotCopyGrantResult/SnapshotCopyGrant
  :cognitect.aws.redshift/SnapshotCopyGrant)

(s/def
  :cognitect.aws.redshift.TaggedResourceListMessage/TaggedResources
  :cognitect.aws.redshift/TaggedResourceList)

(s/def :cognitect.aws.redshift.TaggedResourceListMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotResult/Snapshot
  :cognitect.aws.redshift/Snapshot)

(s/def
  :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/ReservedNodeId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.GetReservedNodeExchangeOfferingsInputMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeLoggingStatusMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotCopyGrantMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.SnapshotCopyGrantMessage/SnapshotCopyGrants
  :cognitect.aws.redshift/SnapshotCopyGrantList)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/UsageLimitId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/FeatureType
  :cognitect.aws.redshift/UsageLimitFeatureType)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeUsageLimitsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeUsageLimitsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.DescribeEventsMessage/SourceIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DescribeEventsMessage/SourceType :cognitect.aws.redshift/SourceType)

(s/def :cognitect.aws.redshift.DescribeEventsMessage/StartTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.DescribeEventsMessage/EndTime :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DescribeEventsMessage/Duration
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeEventsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeEventsMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterParameterGroupsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupsMessage/ParameterGroups
  :cognitect.aws.redshift/ParameterGroupList)

(s/def
  :cognitect.aws.redshift.ScheduledActionFilter/Name
  :cognitect.aws.redshift/ScheduledActionFilterName)

(s/def :cognitect.aws.redshift.ScheduledActionFilter/Values :cognitect.aws.redshift/ValueStringList)

(s/def
  :cognitect.aws.redshift.RevokeSnapshotAccessMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeSnapshotAccessMessage/SnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeSnapshotAccessMessage/AccountWithRestoreAccess
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/SnapshotIdentifierList
  :cognitect.aws.redshift/SnapshotIdentifierList)

(s/def
  :cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.BatchModifyClusterSnapshotsMessage/Force
  :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/TableRestoreRequestId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeTableRestoreStatusMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.OrderableClusterOptionsMessage/OrderableClusterOptions
  :cognitect.aws.redshift/OrderableClusterOptionsList)

(s/def :cognitect.aws.redshift.OrderableClusterOptionsMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ResizeInfo/ResizeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ResizeInfo/AllowCancelResize :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Snapshot/Port :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.Snapshot/AvailabilityZone :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/ElapsedTimeInSeconds :cognitect.aws.redshift/Long)

(s/def :cognitect.aws.redshift.Snapshot/NumberOfNodes :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.Snapshot/MasterUsername :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Snapshot/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.Snapshot/CurrentBackupRateInMegaBytesPerSecond
  :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.Snapshot/SnapshotType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/ClusterVersion :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Snapshot/ActualIncrementalBackupSizeInMegaBytes
  :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.Snapshot/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.Snapshot/EngineFullVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/EstimatedSecondsToCompletion :cognitect.aws.redshift/Long)

(s/def :cognitect.aws.redshift.Snapshot/DBName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Snapshot/RestorableNodeTypes
  :cognitect.aws.redshift/RestorableNodeTypeList)

(s/def :cognitect.aws.redshift.Snapshot/EncryptedWithHSM :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Snapshot/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/BackupProgressInMegaBytes :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.Snapshot/Encrypted :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Snapshot/SnapshotRetentionStartTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Snapshot/SnapshotCreateTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Snapshot/EnhancedVpcRouting :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Snapshot/MaintenanceTrackName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/KmsKeyId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Snapshot/ManualSnapshotRemainingDays
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.Snapshot/AccountsWithRestoreAccess
  :cognitect.aws.redshift/AccountsWithRestoreAccessList)

(s/def :cognitect.aws.redshift.Snapshot/ClusterCreateTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Snapshot/OwnerAccount :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/SourceRegion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/SnapshotIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/TotalBackupSizeInMegaBytes :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.Snapshot/VpcId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Snapshot/Status :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Event/SourceIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Event/SourceType :cognitect.aws.redshift/SourceType)

(s/def :cognitect.aws.redshift.Event/Message :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Event/EventCategories :cognitect.aws.redshift/EventCategoriesList)

(s/def :cognitect.aws.redshift.Event/Severity :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Event/Date :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Event/EventId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifySnapshotScheduleMessage/ScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifySnapshotScheduleMessage/ScheduleDefinitions
  :cognitect.aws.redshift/ScheduleDefinitionList)

(s/def :cognitect.aws.redshift.ModifyClusterIamRolesResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceStartTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DeferredMaintenanceWindow/DeferMaintenanceEndTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/SnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AuthorizeSnapshotAccessMessage/AccountWithRestoreAccess
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ScheduledActionType/ResizeCluster
  :cognitect.aws.redshift/ResizeClusterMessage)

(s/def
  :cognitect.aws.redshift.ScheduledActionType/PauseCluster
  :cognitect.aws.redshift/PauseClusterMessage)

(s/def
  :cognitect.aws.redshift.ScheduledActionType/ResumeCluster
  :cognitect.aws.redshift/ResumeClusterMessage)

(s/def
  :cognitect.aws.redshift.SnapshotCopyGrant/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotCopyGrant/KmsKeyId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotCopyGrant/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/ScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotScheduleMessage/DisassociateSchedule
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.TaggedResource/Tag :cognitect.aws.redshift/Tag)

(s/def :cognitect.aws.redshift.TaggedResource/ResourceName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.TaggedResource/ResourceType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParametersMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParametersMessage/Source
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParametersMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterParametersMessage/Marker
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventInfoMap/EventId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EventInfoMap/EventCategories
  :cognitect.aws.redshift/EventCategoriesList)

(s/def :cognitect.aws.redshift.EventInfoMap/EventDescription :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventInfoMap/Severity :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SupportedPlatform/Name :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/ActionType
  :cognitect.aws.redshift/ActionType)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/OwnerAccount
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/Filters
  :cognitect.aws.redshift/NodeConfigurationOptionsFilterList)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeNodeConfigurationOptionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DeleteClusterParameterGroupMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CopyClusterSnapshotMessage/SourceSnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CopyClusterSnapshotMessage/SourceSnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CopyClusterSnapshotMessage/TargetSnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CopyClusterSnapshotMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterTracksMessage/MaintenanceTrackName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterTracksMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeClusterTracksMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeResizeMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.VpcSecurityGroupMembership/VpcSecurityGroupId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.VpcSecurityGroupMembership/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeClusterParameterGroupsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def :cognitect.aws.redshift.TrackListMessage/MaintenanceTracks :cognitect.aws.redshift/TrackList)

(s/def :cognitect.aws.redshift.TrackListMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DescribeTagsMessage/ResourceName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DescribeTagsMessage/ResourceType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeTagsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeTagsMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DescribeTagsMessage/TagKeys :cognitect.aws.redshift/TagKeyList)

(s/def :cognitect.aws.redshift.DescribeTagsMessage/TagValues :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.ModifyClusterMaintenanceResult/Cluster
  :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.EventSubscriptionsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EventSubscriptionsMessage/EventSubscriptionsList
  :cognitect.aws.redshift/EventSubscriptionsList)

(s/def :cognitect.aws.redshift.ReservedNodesMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ReservedNodesMessage/ReservedNodes
  :cognitect.aws.redshift/ReservedNodeList)

(s/def
  :cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterDbRevisionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EnableSnapshotCopyResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.TableRestoreStatusMessage/TableRestoreStatusDetails
  :cognitect.aws.redshift/TableRestoreStatusList)

(s/def :cognitect.aws.redshift.TableRestoreStatusMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyScheduledActionMessage/ScheduledActionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyScheduledActionMessage/TargetAction
  :cognitect.aws.redshift/ScheduledActionType)

(s/def :cognitect.aws.redshift.ModifyScheduledActionMessage/Schedule :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ModifyScheduledActionMessage/IamRole :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyScheduledActionMessage/ScheduledActionDescription
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyScheduledActionMessage/StartTime
  :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.ModifyScheduledActionMessage/EndTime :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ModifyScheduledActionMessage/Enable
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.EventSubscription/Severity :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventSubscription/SnsTopicArn :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventSubscription/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.EventSubscription/CustSubscriptionId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EventSubscription/SourceIdsList
  :cognitect.aws.redshift/SourceIdsList)

(s/def :cognitect.aws.redshift.EventSubscription/CustomerAwsId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EventSubscription/Enabled :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.EventSubscription/SourceType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EventSubscription/EventCategoriesList
  :cognitect.aws.redshift/EventCategoriesList)

(s/def :cognitect.aws.redshift.EventSubscription/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EventSubscription/SubscriptionCreationTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ResumeClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.SnapshotSchedule/ScheduleDefinitions
  :cognitect.aws.redshift/ScheduleDefinitionList)

(s/def :cognitect.aws.redshift.SnapshotSchedule/ScheduleIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotSchedule/ScheduleDescription :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotSchedule/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.SnapshotSchedule/NextInvocations
  :cognitect.aws.redshift/ScheduledSnapshotTimeList)

(s/def
  :cognitect.aws.redshift.SnapshotSchedule/AssociatedClusterCount
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.SnapshotSchedule/AssociatedClusters
  :cognitect.aws.redshift/AssociatedClusterList)

(s/def :cognitect.aws.redshift.AttributeValueTarget/AttributeValue :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.HsmStatus/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmStatus/HsmConfigurationIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmStatus/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PurchaseReservedNodeOfferingResult/ReservedNode
  :cognitect.aws.redshift/ReservedNode)

(s/def
  :cognitect.aws.redshift.ClusterParameterGroupDetails/Parameters
  :cognitect.aws.redshift/ParametersList)

(s/def :cognitect.aws.redshift.ClusterParameterGroupDetails/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteSnapshotCopyGrantMessage/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteClusterSnapshotMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteClusterSnapshotMessage/SnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/Port
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AvailabilityZone
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/NumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterSecurityGroups
  :cognitect.aws.redshift/ClusterSecurityGroupNameList)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/PubliclyAccessible
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/NodeType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/PreferredMaintenanceWindow
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ElasticIp
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/EnhancedVpcRouting
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/MaintenanceTrackName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/KmsKeyId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/ClusterParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/IamRoles
  :cognitect.aws.redshift/IamRoleArnList)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AutomatedSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AvailabilityZoneRelocation
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/VpcSecurityGroupIds
  :cognitect.aws.redshift/VpcSecurityGroupIdList)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AdditionalInfo
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/OwnerAccount
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotMessage/AllowVersionUpgrade
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterParameterGroupMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterParameterGroupMessage/Parameters
  :cognitect.aws.redshift/ParametersList)

(s/def
  :cognitect.aws.redshift.DeleteClusterSubnetGroupMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DefaultClusterParameters/ParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DefaultClusterParameters/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DefaultClusterParameters/Parameters
  :cognitect.aws.redshift/ParametersList)

(s/def
  :cognitect.aws.redshift.ClusterSnapshotCopyStatus/DestinationRegion
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterSnapshotCopyStatus/RetentionPeriod
  :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.ClusterSnapshotCopyStatus/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/Integer)

(s/def
  :cognitect.aws.redshift.ClusterSnapshotCopyStatus/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.BatchModifyClusterSnapshotsOutputMessage/Resources
  :cognitect.aws.redshift/SnapshotIdentifierList)

(s/def
  :cognitect.aws.redshift.BatchModifyClusterSnapshotsOutputMessage/Errors
  :cognitect.aws.redshift/BatchSnapshotOperationErrors)

(s/def
  :cognitect.aws.redshift.EnableSnapshotCopyMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EnableSnapshotCopyMessage/DestinationRegion
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EnableSnapshotCopyMessage/RetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.EnableSnapshotCopyMessage/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.EnableSnapshotCopyMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOptionsMessage/NodeConfigurationOptionList
  :cognitect.aws.redshift/NodeConfigurationOptionList)

(s/def
  :cognitect.aws.redshift.NodeConfigurationOptionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RevokeClusterSecurityGroupIngressResult/ClusterSecurityGroup
  :cognitect.aws.redshift/ClusterSecurityGroup)

(s/def :cognitect.aws.redshift.ReservedNodeOfferingsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ReservedNodeOfferingsMessage/ReservedNodeOfferings
  :cognitect.aws.redshift/ReservedNodeOfferingList)

(s/def :cognitect.aws.redshift.ClusterDbRevisionsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterDbRevisionsMessage/ClusterDbRevisions
  :cognitect.aws.redshift/ClusterDbRevisionsList)

(s/def :cognitect.aws.redshift.ClusterVersionsMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterVersionsMessage/ClusterVersions
  :cognitect.aws.redshift/ClusterVersionList)

(s/def
  :cognitect.aws.redshift.DeleteScheduledActionMessage/ScheduledActionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceDatabaseName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceSchemaName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/SourceTableName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/TargetDatabaseName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/TargetSchemaName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.RestoreTableFromClusterSnapshotMessage/NewTableName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DeleteHsmConfigurationMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationResult/HsmConfiguration
  :cognitect.aws.redshift/HsmConfiguration)

(s/def
  :cognitect.aws.redshift.AcceptReservedNodeExchangeOutputMessage/ExchangedReservedNode
  :cognitect.aws.redshift/ReservedNode)

(s/def
  :cognitect.aws.redshift.DeleteClusterSnapshotResult/Snapshot
  :cognitect.aws.redshift/Snapshot)

(s/def
  :cognitect.aws.redshift.DisableLoggingMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodResult/Cluster
  :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.DeleteUsageLimitMessage/UsageLimitId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.RotateEncryptionKeyResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.DataTransferProgress/Status :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DataTransferProgress/CurrentRateInMegaBytesPerSecond
  :cognitect.aws.redshift/DoubleOptional)

(s/def
  :cognitect.aws.redshift.DataTransferProgress/TotalDataInMegaBytes
  :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.DataTransferProgress/DataTransferredInMegaBytes
  :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.DataTransferProgress/EstimatedTimeToCompletionInSeconds
  :cognitect.aws.redshift/LongOptional)

(s/def
  :cognitect.aws.redshift.DataTransferProgress/ElapsedTimeInSeconds
  :cognitect.aws.redshift/LongOptional)

(s/def :cognitect.aws.redshift.ScheduledAction/EndTime :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.ScheduledAction/ScheduledActionDescription
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ScheduledAction/Schedule :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ScheduledAction/TargetAction
  :cognitect.aws.redshift/ScheduledActionType)

(s/def :cognitect.aws.redshift.ScheduledAction/IamRole :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ScheduledAction/StartTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.ScheduledAction/ScheduledActionName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ScheduledAction/State :cognitect.aws.redshift/ScheduledActionState)

(s/def
  :cognitect.aws.redshift.ScheduledAction/NextInvocations
  :cognitect.aws.redshift/ScheduledActionTimeList)

(s/def
  :cognitect.aws.redshift.HsmClientCertificate/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.HsmClientCertificate/HsmClientCertificatePublicKey
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmClientCertificate/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.BatchDeleteClusterSnapshotsResult/Resources
  :cognitect.aws.redshift/SnapshotIdentifierList)

(s/def
  :cognitect.aws.redshift.BatchDeleteClusterSnapshotsResult/Errors
  :cognitect.aws.redshift/BatchSnapshotOperationErrorList)

(s/def :cognitect.aws.redshift.IPRange/Status :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.IPRange/CIDRIP :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.IPRange/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/KmsKeyId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateSnapshotCopyGrantMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.DeleteClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def :cognitect.aws.redshift.PauseClusterMessage/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.AccountAttribute/AttributeName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AccountAttribute/AttributeValues
  :cognitect.aws.redshift/AttributeValueList)

(s/def :cognitect.aws.redshift.RecurringCharge/RecurringChargeAmount :cognitect.aws.redshift/Double)

(s/def
  :cognitect.aws.redshift.RecurringCharge/RecurringChargeFrequency
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.RebootClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/RetentionPeriod
  :cognitect.aws.redshift/Integer)

(s/def
  :cognitect.aws.redshift.ModifySnapshotCopyRetentionPeriodMessage/Manual
  :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/SubscriptionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/SnsTopicArn
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/SourceType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/SourceIds
  :cognitect.aws.redshift/SourceIdsList)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/EventCategories
  :cognitect.aws.redshift/EventCategoriesList)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/Severity
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateEventSubscriptionMessage/Enabled
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.CreateEventSubscriptionMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.HsmConfigurationMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.HsmConfigurationMessage/HsmConfigurations
  :cognitect.aws.redshift/HsmConfigurationList)

(s/def
  :cognitect.aws.redshift.CreateScheduledActionMessage/ScheduledActionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateScheduledActionMessage/TargetAction
  :cognitect.aws.redshift/ScheduledActionType)

(s/def :cognitect.aws.redshift.CreateScheduledActionMessage/Schedule :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateScheduledActionMessage/IamRole :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateScheduledActionMessage/ScheduledActionDescription
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateScheduledActionMessage/StartTime
  :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.CreateScheduledActionMessage/EndTime :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.CreateScheduledActionMessage/Enable
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterParameterGroupMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterParameterGroupMessage/ParameterGroupFamily
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterParameterGroupMessage/Description
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterParameterGroupMessage/Tags
  :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DeleteHsmClientCertificateMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterNode/NodeRole :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterNode/PrivateIPAddress :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterNode/PublicIPAddress :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotMessage/Snapshots :cognitect.aws.redshift/SnapshotList)

(s/def
  :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeHsmClientCertificatesMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.HsmConfiguration/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmConfiguration/Description :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmConfiguration/HsmIpAddress :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmConfiguration/HsmPartitionName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmConfiguration/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.ReservedNodeOffering/RecurringCharges
  :cognitect.aws.redshift/RecurringChargeList)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/CurrencyCode :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ReservedNodeOffering/ReservedNodeOfferingType
  :cognitect.aws.redshift/ReservedNodeOfferingType)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/FixedPrice :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/Duration :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/UsagePrice :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.ReservedNodeOffering/OfferingType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ReservedNodeOffering/ReservedNodeOfferingId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/Description
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/SubnetIds
  :cognitect.aws.redshift/SubnetIdentifierList)

(s/def :cognitect.aws.redshift.CreateClusterSubnetGroupMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.Cluster/AvailabilityZone :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/RestoreStatus :cognitect.aws.redshift/RestoreStatus)

(s/def :cognitect.aws.redshift.Cluster/SnapshotScheduleIdentifier :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Cluster/ExpectedNextSnapshotScheduleTimeStatus
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ElasticIpStatus :cognitect.aws.redshift/ElasticIpStatus)

(s/def :cognitect.aws.redshift.Cluster/NumberOfNodes :cognitect.aws.redshift/Integer)

(s/def
  :cognitect.aws.redshift.Cluster/ClusterSecurityGroups
  :cognitect.aws.redshift/ClusterSecurityGroupMembershipList)

(s/def :cognitect.aws.redshift.Cluster/PubliclyAccessible :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.Cluster/PendingModifiedValues
  :cognitect.aws.redshift/PendingModifiedValues)

(s/def :cognitect.aws.redshift.Cluster/Endpoint :cognitect.aws.redshift/Endpoint)

(s/def :cognitect.aws.redshift.Cluster/MasterUsername :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Cluster/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.Cluster/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterNodes :cognitect.aws.redshift/ClusterNodesList)

(s/def
  :cognitect.aws.redshift.Cluster/VpcSecurityGroups
  :cognitect.aws.redshift/VpcSecurityGroupMembershipList)

(s/def :cognitect.aws.redshift.Cluster/ClusterAvailabilityStatus :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.Cluster/ClusterRevisionNumber :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Cluster/ElasticResizeNumberOfNodeOptions
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ResizeInfo :cognitect.aws.redshift/ResizeInfo)

(s/def :cognitect.aws.redshift.Cluster/DBName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/PreferredMaintenanceWindow :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterSubnetGroupName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterNamespaceArn :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterIdentifier :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/Encrypted :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Cluster/HsmStatus :cognitect.aws.redshift/HsmStatus)

(s/def
  :cognitect.aws.redshift.Cluster/ClusterSnapshotCopyStatus
  :cognitect.aws.redshift/ClusterSnapshotCopyStatus)

(s/def :cognitect.aws.redshift.Cluster/EnhancedVpcRouting :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Cluster/MaintenanceTrackName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/KmsKeyId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Cluster/DataTransferProgress
  :cognitect.aws.redshift/DataTransferProgress)

(s/def :cognitect.aws.redshift.Cluster/IamRoles :cognitect.aws.redshift/ClusterIamRoleList)

(s/def :cognitect.aws.redshift.Cluster/ClusterStatus :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.Cluster/AutomatedSnapshotRetentionPeriod
  :cognitect.aws.redshift/Integer)

(s/def
  :cognitect.aws.redshift.Cluster/ClusterParameterGroups
  :cognitect.aws.redshift/ClusterParameterGroupStatusList)

(s/def :cognitect.aws.redshift.Cluster/SnapshotScheduleState :cognitect.aws.redshift/ScheduleState)

(s/def
  :cognitect.aws.redshift.Cluster/DeferredMaintenanceWindows
  :cognitect.aws.redshift/DeferredMaintenanceWindowsList)

(s/def
  :cognitect.aws.redshift.Cluster/AvailabilityZoneRelocationStatus
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterPublicKey :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ClusterCreateTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Cluster/PendingActions :cognitect.aws.redshift/PendingActionsList)

(s/def
  :cognitect.aws.redshift.Cluster/NextMaintenanceWindowStartTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.Cluster/ExpectedNextSnapshotScheduleTime
  :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.Cluster/VpcId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/ModifyStatus :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Cluster/AllowVersionUpgrade :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/EndTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SnapshotType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/ClusterExists
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SortingEntities
  :cognitect.aws.redshift/SnapshotSortingEntityList)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/StartTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/OwnerAccount
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeClusterSnapshotsMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ClusterCredentials/DbUser :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterCredentials/DbPassword
  :cognitect.aws.redshift/SensitiveString)

(s/def :cognitect.aws.redshift.ClusterCredentials/Expiration :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.ClusterParameterStatus/ParameterName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterStatus/ParameterApplyStatus
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ClusterParameterStatus/ParameterApplyErrorDescription
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.VpcEndpoint/VpcEndpointId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/ParameterValue :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/ParameterName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/AllowedValues :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/MinimumEngineVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/IsModifiable :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.Parameter/Description :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/ApplyType :cognitect.aws.redshift/ParameterApplyType)

(s/def :cognitect.aws.redshift.Parameter/Source :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.Parameter/DataType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeDefaultClusterParametersResult/DefaultClusterParameters
  :cognitect.aws.redshift/DefaultClusterParameters)

(s/def
  :cognitect.aws.redshift.CreateClusterSnapshotMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSnapshotMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSnapshotMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.CreateClusterSnapshotMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/Port :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/AvailabilityZone :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/NumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/ClusterSecurityGroups
  :cognitect.aws.redshift/ClusterSecurityGroupNameList)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/PubliclyAccessible
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/ClusterVersion :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/PreferredMaintenanceWindow
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/ElasticIp :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/Encrypted
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/EnhancedVpcRouting
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/MaintenanceTrackName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/KmsKeyId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/NewClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/ClusterParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/AutomatedSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/AvailabilityZoneRelocation
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/VpcSecurityGroupIds
  :cognitect.aws.redshift/VpcSecurityGroupIdList)

(s/def :cognitect.aws.redshift.ModifyClusterMessage/ClusterType :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/MasterUserPassword
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterMessage/AllowVersionUpgrade
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.EnableLoggingMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EnableLoggingMessage/BucketName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.EnableLoggingMessage/S3KeyPrefix :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.GetClusterCredentialsMessage/DbUser :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.GetClusterCredentialsMessage/DbName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.GetClusterCredentialsMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.GetClusterCredentialsMessage/DurationSeconds
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.GetClusterCredentialsMessage/AutoCreate
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.GetClusterCredentialsMessage/DbGroups
  :cognitect.aws.redshift/DbGroupList)

(s/def
  :cognitect.aws.redshift.ReservedNode/RecurringCharges
  :cognitect.aws.redshift/RecurringChargeList)

(s/def :cognitect.aws.redshift.ReservedNode/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ReservedNode/CurrencyCode :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ReservedNode/ReservedNodeOfferingType
  :cognitect.aws.redshift/ReservedNodeOfferingType)

(s/def :cognitect.aws.redshift.ReservedNode/ReservedNodeId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ReservedNode/NodeCount :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.ReservedNode/FixedPrice :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.ReservedNode/StartTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.ReservedNode/Duration :cognitect.aws.redshift/Integer)

(s/def :cognitect.aws.redshift.ReservedNode/UsagePrice :cognitect.aws.redshift/Double)

(s/def :cognitect.aws.redshift.ReservedNode/State :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ReservedNode/OfferingType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.ReservedNode/ReservedNodeOfferingId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateUsageLimitMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateUsageLimitMessage/FeatureType
  :cognitect.aws.redshift/UsageLimitFeatureType)

(s/def
  :cognitect.aws.redshift.CreateUsageLimitMessage/LimitType
  :cognitect.aws.redshift/UsageLimitLimitType)

(s/def :cognitect.aws.redshift.CreateUsageLimitMessage/Amount :cognitect.aws.redshift/Long)

(s/def
  :cognitect.aws.redshift.CreateUsageLimitMessage/Period
  :cognitect.aws.redshift/UsageLimitPeriod)

(s/def
  :cognitect.aws.redshift.CreateUsageLimitMessage/BreachAction
  :cognitect.aws.redshift/UsageLimitBreachAction)

(s/def :cognitect.aws.redshift.CreateUsageLimitMessage/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/ScheduledActionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/TargetActionType
  :cognitect.aws.redshift/ScheduledActionTypeValues)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/StartTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/EndTime
  :cognitect.aws.redshift/TStamp)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/Active
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/Filters
  :cognitect.aws.redshift/ScheduledActionFilterList)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeScheduledActionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/ScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotSchedulesMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/CIDRIP
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/EC2SecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressMessage/EC2SecurityGroupOwnerId
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/Port :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.CreateClusterMessage/AvailabilityZone :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/SnapshotScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/NumberOfNodes
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/HsmClientCertificateIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/ClusterSecurityGroups
  :cognitect.aws.redshift/ClusterSecurityGroupNameList)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/PubliclyAccessible
  :cognitect.aws.redshift/BooleanOptional)

(s/def :cognitect.aws.redshift.CreateClusterMessage/MasterUsername :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.CreateClusterMessage/NodeType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/ClusterVersion :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/Tags :cognitect.aws.redshift/TagList)

(s/def :cognitect.aws.redshift.CreateClusterMessage/DBName :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/PreferredMaintenanceWindow
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/ElasticIp :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/Encrypted
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/EnhancedVpcRouting
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/MaintenanceTrackName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/KmsKeyId :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/ClusterParameterGroupName
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/IamRoles :cognitect.aws.redshift/IamRoleArnList)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/AutomatedSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/AvailabilityZoneRelocation
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/VpcSecurityGroupIds
  :cognitect.aws.redshift/VpcSecurityGroupIdList)

(s/def :cognitect.aws.redshift.CreateClusterMessage/ClusterType :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateClusterMessage/AdditionalInfo :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/MasterUserPassword
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterMessage/AllowVersionUpgrade
  :cognitect.aws.redshift/BooleanOptional)

(s/def
  :cognitect.aws.redshift.DeleteSnapshotScheduleMessage/ScheduleIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/Description
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmIpAddress
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmPartitionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmPartitionPassword
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmConfigurationMessage/HsmServerPublicCertificate
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.CreateHsmConfigurationMessage/Tags :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DisableSnapshotCopyMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/SubscriptionName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeEventSubscriptionsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.RestoreFromClusterSnapshotResult/Cluster
  :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSnapshotMessage/ManualSnapshotRetentionPeriod
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.ModifyClusterSnapshotMessage/Force :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.PurchaseReservedNodeOfferingMessage/ReservedNodeOfferingId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.PurchaseReservedNodeOfferingMessage/NodeCount
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.AuthorizeSnapshotAccessResult/Snapshot
  :cognitect.aws.redshift/Snapshot)

(s/def
  :cognitect.aws.redshift.AuthorizeClusterSecurityGroupIngressResult/ClusterSecurityGroup
  :cognitect.aws.redshift/ClusterSecurityGroup)

(s/def :cognitect.aws.redshift.LoggingStatus/LoggingEnabled :cognitect.aws.redshift/Boolean)

(s/def :cognitect.aws.redshift.LoggingStatus/BucketName :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.LoggingStatus/S3KeyPrefix :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.LoggingStatus/LastSuccessfulDeliveryTime
  :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.LoggingStatus/LastFailureTime :cognitect.aws.redshift/TStamp)

(s/def :cognitect.aws.redshift.LoggingStatus/LastFailureMessage :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.SnapshotErrorMessage/SnapshotIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.SnapshotErrorMessage/SnapshotClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotErrorMessage/FailureCode :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.SnapshotErrorMessage/FailureReason :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.AccountWithRestoreAccess/AccountId :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.AccountWithRestoreAccess/AccountAlias :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.BatchDeleteClusterSnapshotsRequest/Identifiers
  :cognitect.aws.redshift/DeleteClusterSnapshotMessageList)

(s/def
  :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/HsmConfigurationIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeHsmConfigurationsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.EventCategoriesMessage/EventCategoriesMapList
  :cognitect.aws.redshift/EventCategoriesMapList)

(s/def
  :cognitect.aws.redshift.DescribeClustersMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeClustersMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def :cognitect.aws.redshift.DescribeClustersMessage/Marker :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.DescribeClustersMessage/TagKeys :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeClustersMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.CreateClusterSecurityGroupMessage/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSecurityGroupMessage/Description
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateClusterSecurityGroupMessage/Tags
  :cognitect.aws.redshift/TagList)

(s/def
  :cognitect.aws.redshift.DeleteClusterSecurityGroupMessage/ClusterSecurityGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.CreateHsmClientCertificateResult/HsmClientCertificate
  :cognitect.aws.redshift/HsmClientCertificate)

(s/def
  :cognitect.aws.redshift.ModifyClusterIamRolesMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterIamRolesMessage/AddIamRoles
  :cognitect.aws.redshift/IamRoleArnList)

(s/def
  :cognitect.aws.redshift.ModifyClusterIamRolesMessage/RemoveIamRoles
  :cognitect.aws.redshift/IamRoleArnList)

(s/def
  :cognitect.aws.redshift.CreateClusterSnapshotResult/Snapshot
  :cognitect.aws.redshift/Snapshot)

(s/def :cognitect.aws.redshift.ModifyClusterResult/Cluster :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/ClusterVersion
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/NodeType
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeOrderableClusterOptionsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/ReservedNodeOfferingId
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeReservedNodeOfferingsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterDbRevisionResult/Cluster
  :cognitect.aws.redshift/Cluster)

(s/def
  :cognitect.aws.redshift.CustomerStorageMessage/TotalBackupSizeInMegaBytes
  :cognitect.aws.redshift/Double)

(s/def
  :cognitect.aws.redshift.CustomerStorageMessage/TotalProvisionedStorageInMegaBytes
  :cognitect.aws.redshift/Double)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/SnapshotCopyGrantName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/MaxRecords
  :cognitect.aws.redshift/IntegerOptional)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/Marker
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/TagKeys
  :cognitect.aws.redshift/TagKeyList)

(s/def
  :cognitect.aws.redshift.DescribeSnapshotCopyGrantsMessage/TagValues
  :cognitect.aws.redshift/TagValueList)

(s/def
  :cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/ClusterSubnetGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/Description
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ModifyClusterSubnetGroupMessage/SubnetIds
  :cognitect.aws.redshift/SubnetIdentifierList)

(s/def
  :cognitect.aws.redshift.ResetClusterParameterGroupMessage/ParameterGroupName
  :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.ResetClusterParameterGroupMessage/ResetAllParameters
  :cognitect.aws.redshift/Boolean)

(s/def
  :cognitect.aws.redshift.ResetClusterParameterGroupMessage/Parameters
  :cognitect.aws.redshift/ParametersList)

(s/def
  :cognitect.aws.redshift.RebootClusterMessage/ClusterIdentifier
  :cognitect.aws.redshift/String)

(s/def :cognitect.aws.redshift.HsmClientCertificateMessage/Marker :cognitect.aws.redshift/String)

(s/def
  :cognitect.aws.redshift.HsmClientCertificateMessage/HsmClientCertificates
  :cognitect.aws.redshift/HsmClientCertificateList)

