;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.sqs.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.sqs/QueueAttributeMap
  (s/map-of :cognitect.aws.sqs/QueueAttributeName :cognitect.aws.sqs/String))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ChangeMessageVisibilityBatchRequest/QueueUrl
     :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequest/Entries]))

(s/def :cognitect.aws.sqs/MessageAttributeName string?)

(s/def
  :cognitect.aws.sqs/MessageBodySystemAttributeMap
  (s/map-of
    :cognitect.aws.sqs/MessageSystemAttributeNameForSends
    :cognitect.aws.sqs/MessageSystemAttributeValue))

(s/def
  :cognitect.aws.sqs/SendMessageResult
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.SendMessageResult/MD5OfMessageAttributes
     :cognitect.aws.sqs.SendMessageResult/MessageId
     :cognitect.aws.sqs.SendMessageResult/SequenceNumber
     :cognitect.aws.sqs.SendMessageResult/MD5OfMessageBody
     :cognitect.aws.sqs.SendMessageResult/MD5OfMessageSystemAttributes]))

(s/def
  :cognitect.aws.sqs/ListQueueTagsRequest
  (s/keys :req-un [:cognitect.aws.sqs.ListQueueTagsRequest/QueueUrl]))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchRequestEntryList
  (s/coll-of :cognitect.aws.sqs/ChangeMessageVisibilityBatchRequestEntry))

(s/def
  :cognitect.aws.sqs/SendMessageBatchResultEntry
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SendMessageBatchResultEntry/Id
     :cognitect.aws.sqs.SendMessageBatchResultEntry/MessageId
     :cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageBody]
    :opt-un
    [:cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageAttributes
     :cognitect.aws.sqs.SendMessageBatchResultEntry/SequenceNumber
     :cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageSystemAttributes]))

(s/def
  :cognitect.aws.sqs/SendMessageBatchRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SendMessageBatchRequestEntry/Id
     :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageBody]
    :opt-un
    [:cognitect.aws.sqs.SendMessageBatchRequestEntry/DelaySeconds
     :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageAttributes
     :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageSystemAttributes
     :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageGroupId
     :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageDeduplicationId]))

(s/def :cognitect.aws.sqs/TagMap (s/map-of :cognitect.aws.sqs/TagKey :cognitect.aws.sqs/TagValue))

(s/def :cognitect.aws.sqs/ActionNameList (s/coll-of :cognitect.aws.sqs/String))

(s/def :cognitect.aws.sqs/AttributeNameList (s/coll-of :cognitect.aws.sqs/QueueAttributeName))

(s/def
  :cognitect.aws.sqs/SetQueueAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SetQueueAttributesRequest/QueueUrl
     :cognitect.aws.sqs.SetQueueAttributesRequest/Attributes]))

(s/def
  :cognitect.aws.sqs/Message
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.Message/MD5OfMessageAttributes
     :cognitect.aws.sqs.Message/MessageId
     :cognitect.aws.sqs.Message/Body
     :cognitect.aws.sqs.Message/MessageAttributes
     :cognitect.aws.sqs.Message/ReceiptHandle
     :cognitect.aws.sqs.Message/Attributes
     :cognitect.aws.sqs.Message/MD5OfBody]))

(s/def
  :cognitect.aws.sqs/CancelMessageMoveTaskResult
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.CancelMessageMoveTaskResult/ApproximateNumberOfMessagesMoved]))

(s/def
  :cognitect.aws.sqs/BatchResultErrorEntryList
  (s/coll-of :cognitect.aws.sqs/BatchResultErrorEntry))

(s/def
  :cognitect.aws.sqs/DeleteMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.DeleteMessageRequest/QueueUrl
     :cognitect.aws.sqs.DeleteMessageRequest/ReceiptHandle]))

(s/def :cognitect.aws.sqs/Token string?)

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/Id
     :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/ReceiptHandle]
    :opt-un
    [:cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/VisibilityTimeout]))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchResultEntry
  (s/keys :req-un [:cognitect.aws.sqs.DeleteMessageBatchResultEntry/Id]))

(s/def
  :cognitect.aws.sqs/QueueAttributeName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"DelaySeconds"
        "DeduplicationScope"
        "FifoQueue"
        "FifoThroughputLimit"
        "CreatedTimestamp"
        "ContentBasedDeduplication"
        "RedrivePolicy"
        "SqsManagedSseEnabled"
        "KmsDataKeyReusePeriodSeconds"
        "ApproximateNumberOfMessagesDelayed"
        "RedriveAllowPolicy"
        "LastModifiedTimestamp"
        "ApproximateNumberOfMessagesNotVisible"
        "ApproximateNumberOfMessages"
        "MessageRetentionPeriod"
        "VisibilityTimeout"
        "Policy"
        "QueueArn"
        "All"
        "MaximumMessageSize"
        "ReceiveMessageWaitTimeSeconds"
        "KmsMasterKeyId"})))

(s/def
  :cognitect.aws.sqs/StartMessageMoveTaskResult
  (s/keys :opt-un [:cognitect.aws.sqs.StartMessageMoveTaskResult/TaskHandle]))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchResultEntryList
  (s/coll-of :cognitect.aws.sqs/DeleteMessageBatchResultEntry))

(s/def :cognitect.aws.sqs/Boolean boolean?)

(s/def
  :cognitect.aws.sqs/ListQueuesResult
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.ListQueuesResult/QueueUrls :cognitect.aws.sqs.ListQueuesResult/NextToken]))

(s/def
  :cognitect.aws.sqs/Binary
  (s/or :byte-array bytes? :input-stream #(instance? java.io.InputStream %)))

(s/def :cognitect.aws.sqs/MessageList (s/coll-of :cognitect.aws.sqs/Message))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchResultEntry
  (s/keys :req-un [:cognitect.aws.sqs.ChangeMessageVisibilityBatchResultEntry/Id]))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchResult
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ChangeMessageVisibilityBatchResult/Successful
     :cognitect.aws.sqs.ChangeMessageVisibilityBatchResult/Failed]))

(s/def
  :cognitect.aws.sqs/ReceiveMessageResult
  (s/keys :opt-un [:cognitect.aws.sqs.ReceiveMessageResult/Messages]))

(s/def
  :cognitect.aws.sqs/SendMessageBatchRequestEntryList
  (s/coll-of :cognitect.aws.sqs/SendMessageBatchRequestEntry))

(s/def :cognitect.aws.sqs/Integer (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sqs/CancelMessageMoveTaskRequest
  (s/keys :req-un [:cognitect.aws.sqs.CancelMessageMoveTaskRequest/TaskHandle]))

(s/def
  :cognitect.aws.sqs/SendMessageBatchRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SendMessageBatchRequest/QueueUrl
     :cognitect.aws.sqs.SendMessageBatchRequest/Entries]))

(s/def :cognitect.aws.sqs/TagValue string?)

(s/def
  :cognitect.aws.sqs/ListMessageMoveTasksResult
  (s/keys :opt-un [:cognitect.aws.sqs.ListMessageMoveTasksResult/Results]))

(s/def
  :cognitect.aws.sqs/CreateQueueResult
  (s/keys :opt-un [:cognitect.aws.sqs.CreateQueueResult/QueueUrl]))

(s/def
  :cognitect.aws.sqs/DeleteQueueRequest
  (s/keys :req-un [:cognitect.aws.sqs.DeleteQueueRequest/QueueUrl]))

(s/def
  :cognitect.aws.sqs/MessageSystemAttributeName
  (s/spec
    string?
    :gen
    #(s/gen
      #{"AWSTraceHeader"
        "SentTimestamp"
        "SenderId"
        "SequenceNumber"
        "DeadLetterQueueSourceArn"
        "ApproximateReceiveCount"
        "MessageGroupId"
        "ApproximateFirstReceiveTimestamp"
        "MessageDeduplicationId"})))

(s/def
  :cognitect.aws.sqs/MessageSystemAttributeNameForSends
  (s/spec string? :gen #(s/gen #{"AWSTraceHeader"})))

(s/def
  :cognitect.aws.sqs/ReceiveMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ReceiveMessageRequest/QueueUrl]
    :opt-un
    [:cognitect.aws.sqs.ReceiveMessageRequest/AttributeNames
     :cognitect.aws.sqs.ReceiveMessageRequest/WaitTimeSeconds
     :cognitect.aws.sqs.ReceiveMessageRequest/ReceiveRequestAttemptId
     :cognitect.aws.sqs.ReceiveMessageRequest/VisibilityTimeout
     :cognitect.aws.sqs.ReceiveMessageRequest/MaxNumberOfMessages
     :cognitect.aws.sqs.ReceiveMessageRequest/MessageAttributeNames]))

(s/def
  :cognitect.aws.sqs/GetQueueUrlRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.GetQueueUrlRequest/QueueName]
    :opt-un
    [:cognitect.aws.sqs.GetQueueUrlRequest/QueueOwnerAWSAccountId]))

(s/def
  :cognitect.aws.sqs/UntagQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.UntagQueueRequest/QueueUrl :cognitect.aws.sqs.UntagQueueRequest/TagKeys]))

(s/def :cognitect.aws.sqs/BinaryList (s/coll-of :cognitect.aws.sqs/Binary))

(s/def
  :cognitect.aws.sqs/PurgeQueueRequest
  (s/keys :req-un [:cognitect.aws.sqs.PurgeQueueRequest/QueueUrl]))

(s/def
  :cognitect.aws.sqs/CreateQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.CreateQueueRequest/QueueName]
    :opt-un
    [:cognitect.aws.sqs.CreateQueueRequest/tags :cognitect.aws.sqs.CreateQueueRequest/Attributes]))

(s/def :cognitect.aws.sqs/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sqs/ListDeadLetterSourceQueuesRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/QueueUrl]
    :opt-un
    [:cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/NextToken
     :cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/MaxResults]))

(s/def
  :cognitect.aws.sqs/ListMessageMoveTasksResultEntry
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.ListMessageMoveTasksResultEntry/ApproximateNumberOfMessagesMoved
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/Status
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/MaxNumberOfMessagesPerSecond
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/DestinationArn
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/SourceArn
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/TaskHandle
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/FailureReason
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/StartedTimestamp
     :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/ApproximateNumberOfMessagesToMove]))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.DeleteMessageBatchRequest/QueueUrl
     :cognitect.aws.sqs.DeleteMessageBatchRequest/Entries]))

(s/def
  :cognitect.aws.sqs/AddPermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.AddPermissionRequest/QueueUrl
     :cognitect.aws.sqs.AddPermissionRequest/Label
     :cognitect.aws.sqs.AddPermissionRequest/AWSAccountIds
     :cognitect.aws.sqs.AddPermissionRequest/Actions]))

(s/def
  :cognitect.aws.sqs/MessageAttributeValue
  (s/keys
    :req-un
    [:cognitect.aws.sqs.MessageAttributeValue/DataType]
    :opt-un
    [:cognitect.aws.sqs.MessageAttributeValue/StringListValues
     :cognitect.aws.sqs.MessageAttributeValue/StringValue
     :cognitect.aws.sqs.MessageAttributeValue/BinaryValue
     :cognitect.aws.sqs.MessageAttributeValue/BinaryListValues]))

(s/def
  :cognitect.aws.sqs/ListQueuesRequest
  (s/keys
    :opt-un
    [:cognitect.aws.sqs.ListQueuesRequest/NextToken
     :cognitect.aws.sqs.ListQueuesRequest/MaxResults
     :cognitect.aws.sqs.ListQueuesRequest/QueueNamePrefix]))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchRequestEntry
  (s/keys
    :req-un
    [:cognitect.aws.sqs.DeleteMessageBatchRequestEntry/Id
     :cognitect.aws.sqs.DeleteMessageBatchRequestEntry/ReceiptHandle]))

(s/def :cognitect.aws.sqs/TagKey string?)

(s/def
  :cognitect.aws.sqs/GetQueueUrlResult
  (s/keys :opt-un [:cognitect.aws.sqs.GetQueueUrlResult/QueueUrl]))

(s/def
  :cognitect.aws.sqs/ListQueueTagsResult
  (s/keys :opt-un [:cognitect.aws.sqs.ListQueueTagsResult/Tags]))

(s/def
  :cognitect.aws.sqs/ListDeadLetterSourceQueuesResult
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ListDeadLetterSourceQueuesResult/queueUrls]
    :opt-un
    [:cognitect.aws.sqs.ListDeadLetterSourceQueuesResult/NextToken]))

(s/def
  :cognitect.aws.sqs/MessageAttributeNameList
  (s/coll-of :cognitect.aws.sqs/MessageAttributeName))

(s/def :cognitect.aws.sqs/AWSAccountIdList (s/coll-of :cognitect.aws.sqs/String))

(s/def
  :cognitect.aws.sqs/SendMessageBatchResultEntryList
  (s/coll-of :cognitect.aws.sqs/SendMessageBatchResultEntry))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchRequestEntryList
  (s/coll-of :cognitect.aws.sqs/DeleteMessageBatchRequestEntry))

(s/def
  :cognitect.aws.sqs/GetQueueAttributesResult
  (s/keys :opt-un [:cognitect.aws.sqs.GetQueueAttributesResult/Attributes]))

(s/def :cognitect.aws.sqs/StringList (s/coll-of :cognitect.aws.sqs/String))

(s/def
  :cognitect.aws.sqs/MessageBodyAttributeMap
  (s/map-of :cognitect.aws.sqs/String :cognitect.aws.sqs/MessageAttributeValue))

(s/def
  :cognitect.aws.sqs/SendMessageBatchResult
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SendMessageBatchResult/Successful
     :cognitect.aws.sqs.SendMessageBatchResult/Failed]))

(s/def
  :cognitect.aws.sqs/StartMessageMoveTaskRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.StartMessageMoveTaskRequest/SourceArn]
    :opt-un
    [:cognitect.aws.sqs.StartMessageMoveTaskRequest/MaxNumberOfMessagesPerSecond
     :cognitect.aws.sqs.StartMessageMoveTaskRequest/DestinationArn]))

(s/def
  :cognitect.aws.sqs/GetQueueAttributesRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.GetQueueAttributesRequest/QueueUrl]
    :opt-un
    [:cognitect.aws.sqs.GetQueueAttributesRequest/AttributeNames]))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ChangeMessageVisibilityRequest/QueueUrl
     :cognitect.aws.sqs.ChangeMessageVisibilityRequest/ReceiptHandle
     :cognitect.aws.sqs.ChangeMessageVisibilityRequest/VisibilityTimeout]))

(s/def
  :cognitect.aws.sqs/BatchResultErrorEntry
  (s/keys
    :req-un
    [:cognitect.aws.sqs.BatchResultErrorEntry/Id
     :cognitect.aws.sqs.BatchResultErrorEntry/SenderFault
     :cognitect.aws.sqs.BatchResultErrorEntry/Code]
    :opt-un
    [:cognitect.aws.sqs.BatchResultErrorEntry/Message]))

(s/def
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchResultEntryList
  (s/coll-of :cognitect.aws.sqs/ChangeMessageVisibilityBatchResultEntry))

(s/def
  :cognitect.aws.sqs/ListMessageMoveTasksRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.ListMessageMoveTasksRequest/SourceArn]
    :opt-un
    [:cognitect.aws.sqs.ListMessageMoveTasksRequest/MaxResults]))

(s/def
  :cognitect.aws.sqs/SendMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.SendMessageRequest/QueueUrl
     :cognitect.aws.sqs.SendMessageRequest/MessageBody]
    :opt-un
    [:cognitect.aws.sqs.SendMessageRequest/DelaySeconds
     :cognitect.aws.sqs.SendMessageRequest/MessageAttributes
     :cognitect.aws.sqs.SendMessageRequest/MessageSystemAttributes
     :cognitect.aws.sqs.SendMessageRequest/MessageGroupId
     :cognitect.aws.sqs.SendMessageRequest/MessageDeduplicationId]))

(s/def
  :cognitect.aws.sqs/BoxedInteger
  (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.sqs/MessageSystemAttributeMap
  (s/map-of :cognitect.aws.sqs/MessageSystemAttributeName :cognitect.aws.sqs/String))

(s/def
  :cognitect.aws.sqs/DeleteMessageBatchResult
  (s/keys
    :req-un
    [:cognitect.aws.sqs.DeleteMessageBatchResult/Successful
     :cognitect.aws.sqs.DeleteMessageBatchResult/Failed]))

(s/def
  :cognitect.aws.sqs/RemovePermissionRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.RemovePermissionRequest/QueueUrl
     :cognitect.aws.sqs.RemovePermissionRequest/Label]))

(s/def :cognitect.aws.sqs/String string?)

(s/def
  :cognitect.aws.sqs/ListMessageMoveTasksResultEntryList
  (s/coll-of :cognitect.aws.sqs/ListMessageMoveTasksResultEntry))

(s/def
  :cognitect.aws.sqs/TagQueueRequest
  (s/keys
    :req-un
    [:cognitect.aws.sqs.TagQueueRequest/QueueUrl :cognitect.aws.sqs.TagQueueRequest/Tags]))

(s/def :cognitect.aws.sqs/TagKeyList (s/coll-of :cognitect.aws.sqs/TagKey))

(s/def
  :cognitect.aws.sqs/MessageSystemAttributeValue
  (s/keys
    :req-un
    [:cognitect.aws.sqs.MessageSystemAttributeValue/DataType]
    :opt-un
    [:cognitect.aws.sqs.MessageSystemAttributeValue/StringListValues
     :cognitect.aws.sqs.MessageSystemAttributeValue/StringValue
     :cognitect.aws.sqs.MessageSystemAttributeValue/BinaryValue
     :cognitect.aws.sqs.MessageSystemAttributeValue/BinaryListValues]))

(s/def :cognitect.aws.sqs/QueueUrlList (s/coll-of :cognitect.aws.sqs/String))

(s/def :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequest/Entries
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchRequestEntryList)

(s/def :cognitect.aws.sqs.SendMessageResult/MD5OfMessageBody :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageResult/MD5OfMessageAttributes :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageResult/MD5OfMessageSystemAttributes :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageResult/MessageId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageResult/SequenceNumber :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListQueueTagsRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchResultEntry/Id :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchResultEntry/MessageId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageBody :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageAttributes
  :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.SendMessageBatchResultEntry/MD5OfMessageSystemAttributes
  :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchResultEntry/SequenceNumber :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchRequestEntry/Id :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageBody :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchRequestEntry/DelaySeconds :cognitect.aws.sqs/Integer)

(s/def
  :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageAttributes
  :cognitect.aws.sqs/MessageBodyAttributeMap)

(s/def
  :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageSystemAttributes
  :cognitect.aws.sqs/MessageBodySystemAttributeMap)

(s/def
  :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageDeduplicationId
  :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchRequestEntry/MessageGroupId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SetQueueAttributesRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SetQueueAttributesRequest/Attributes :cognitect.aws.sqs/QueueAttributeMap)

(s/def :cognitect.aws.sqs.Message/MessageId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.Message/ReceiptHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.Message/MD5OfBody :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.Message/Body :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.Message/Attributes :cognitect.aws.sqs/MessageSystemAttributeMap)

(s/def :cognitect.aws.sqs.Message/MD5OfMessageAttributes :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.Message/MessageAttributes :cognitect.aws.sqs/MessageBodyAttributeMap)

(s/def
  :cognitect.aws.sqs.CancelMessageMoveTaskResult/ApproximateNumberOfMessagesMoved
  :cognitect.aws.sqs/Long)

(s/def :cognitect.aws.sqs.DeleteMessageRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.DeleteMessageRequest/ReceiptHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/Id :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/ReceiptHandle
  :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityBatchRequestEntry/VisibilityTimeout
  :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.DeleteMessageBatchResultEntry/Id :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.StartMessageMoveTaskResult/TaskHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListQueuesResult/QueueUrls :cognitect.aws.sqs/QueueUrlList)

(s/def :cognitect.aws.sqs.ListQueuesResult/NextToken :cognitect.aws.sqs/Token)

(s/def :cognitect.aws.sqs.ChangeMessageVisibilityBatchResultEntry/Id :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityBatchResult/Successful
  :cognitect.aws.sqs/ChangeMessageVisibilityBatchResultEntryList)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityBatchResult/Failed
  :cognitect.aws.sqs/BatchResultErrorEntryList)

(s/def :cognitect.aws.sqs.ReceiveMessageResult/Messages :cognitect.aws.sqs/MessageList)

(s/def :cognitect.aws.sqs.CancelMessageMoveTaskRequest/TaskHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageBatchRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.SendMessageBatchRequest/Entries
  :cognitect.aws.sqs/SendMessageBatchRequestEntryList)

(s/def
  :cognitect.aws.sqs.ListMessageMoveTasksResult/Results
  :cognitect.aws.sqs/ListMessageMoveTasksResultEntryList)

(s/def :cognitect.aws.sqs.CreateQueueResult/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.DeleteQueueRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/AttributeNames :cognitect.aws.sqs/AttributeNameList)

(s/def
  :cognitect.aws.sqs.ReceiveMessageRequest/MessageAttributeNames
  :cognitect.aws.sqs/MessageAttributeNameList)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/MaxNumberOfMessages :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/VisibilityTimeout :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/WaitTimeSeconds :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.ReceiveMessageRequest/ReceiveRequestAttemptId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.GetQueueUrlRequest/QueueName :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.GetQueueUrlRequest/QueueOwnerAWSAccountId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.UntagQueueRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.UntagQueueRequest/TagKeys :cognitect.aws.sqs/TagKeyList)

(s/def :cognitect.aws.sqs.PurgeQueueRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.CreateQueueRequest/QueueName :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.CreateQueueRequest/Attributes :cognitect.aws.sqs/QueueAttributeMap)

(s/def :cognitect.aws.sqs.CreateQueueRequest/tags :cognitect.aws.sqs/TagMap)

(s/def :cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/NextToken :cognitect.aws.sqs/Token)

(s/def
  :cognitect.aws.sqs.ListDeadLetterSourceQueuesRequest/MaxResults
  :cognitect.aws.sqs/BoxedInteger)

(s/def
  :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/ApproximateNumberOfMessagesToMove
  :cognitect.aws.sqs/Long)

(s/def
  :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/MaxNumberOfMessagesPerSecond
  :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/DestinationArn :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/TaskHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/StartedTimestamp :cognitect.aws.sqs/Long)

(s/def
  :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/ApproximateNumberOfMessagesMoved
  :cognitect.aws.sqs/Long)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/FailureReason :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/SourceArn :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksResultEntry/Status :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.DeleteMessageBatchRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.DeleteMessageBatchRequest/Entries
  :cognitect.aws.sqs/DeleteMessageBatchRequestEntryList)

(s/def :cognitect.aws.sqs.AddPermissionRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.AddPermissionRequest/Label :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.AddPermissionRequest/AWSAccountIds :cognitect.aws.sqs/AWSAccountIdList)

(s/def :cognitect.aws.sqs.AddPermissionRequest/Actions :cognitect.aws.sqs/ActionNameList)

(s/def :cognitect.aws.sqs.MessageAttributeValue/StringValue :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.MessageAttributeValue/BinaryValue :cognitect.aws.sqs/Binary)

(s/def :cognitect.aws.sqs.MessageAttributeValue/StringListValues :cognitect.aws.sqs/StringList)

(s/def :cognitect.aws.sqs.MessageAttributeValue/BinaryListValues :cognitect.aws.sqs/BinaryList)

(s/def :cognitect.aws.sqs.MessageAttributeValue/DataType :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListQueuesRequest/QueueNamePrefix :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListQueuesRequest/NextToken :cognitect.aws.sqs/Token)

(s/def :cognitect.aws.sqs.ListQueuesRequest/MaxResults :cognitect.aws.sqs/BoxedInteger)

(s/def :cognitect.aws.sqs.DeleteMessageBatchRequestEntry/Id :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.DeleteMessageBatchRequestEntry/ReceiptHandle :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.GetQueueUrlResult/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListQueueTagsResult/Tags :cognitect.aws.sqs/TagMap)

(s/def
  :cognitect.aws.sqs.ListDeadLetterSourceQueuesResult/queueUrls
  :cognitect.aws.sqs/QueueUrlList)

(s/def :cognitect.aws.sqs.ListDeadLetterSourceQueuesResult/NextToken :cognitect.aws.sqs/Token)

(s/def :cognitect.aws.sqs.GetQueueAttributesResult/Attributes :cognitect.aws.sqs/QueueAttributeMap)

(s/def
  :cognitect.aws.sqs.SendMessageBatchResult/Successful
  :cognitect.aws.sqs/SendMessageBatchResultEntryList)

(s/def
  :cognitect.aws.sqs.SendMessageBatchResult/Failed
  :cognitect.aws.sqs/BatchResultErrorEntryList)

(s/def :cognitect.aws.sqs.StartMessageMoveTaskRequest/SourceArn :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.StartMessageMoveTaskRequest/DestinationArn :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.StartMessageMoveTaskRequest/MaxNumberOfMessagesPerSecond
  :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.GetQueueAttributesRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.GetQueueAttributesRequest/AttributeNames
  :cognitect.aws.sqs/AttributeNameList)

(s/def :cognitect.aws.sqs.ChangeMessageVisibilityRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ChangeMessageVisibilityRequest/ReceiptHandle :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.ChangeMessageVisibilityRequest/VisibilityTimeout
  :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.BatchResultErrorEntry/Id :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.BatchResultErrorEntry/SenderFault :cognitect.aws.sqs/Boolean)

(s/def :cognitect.aws.sqs.BatchResultErrorEntry/Code :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.BatchResultErrorEntry/Message :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksRequest/SourceArn :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.ListMessageMoveTasksRequest/MaxResults :cognitect.aws.sqs/Integer)

(s/def :cognitect.aws.sqs.SendMessageRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageRequest/MessageBody :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageRequest/DelaySeconds :cognitect.aws.sqs/Integer)

(s/def
  :cognitect.aws.sqs.SendMessageRequest/MessageAttributes
  :cognitect.aws.sqs/MessageBodyAttributeMap)

(s/def
  :cognitect.aws.sqs.SendMessageRequest/MessageSystemAttributes
  :cognitect.aws.sqs/MessageBodySystemAttributeMap)

(s/def :cognitect.aws.sqs.SendMessageRequest/MessageDeduplicationId :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.SendMessageRequest/MessageGroupId :cognitect.aws.sqs/String)

(s/def
  :cognitect.aws.sqs.DeleteMessageBatchResult/Successful
  :cognitect.aws.sqs/DeleteMessageBatchResultEntryList)

(s/def
  :cognitect.aws.sqs.DeleteMessageBatchResult/Failed
  :cognitect.aws.sqs/BatchResultErrorEntryList)

(s/def :cognitect.aws.sqs.RemovePermissionRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.RemovePermissionRequest/Label :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.TagQueueRequest/QueueUrl :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.TagQueueRequest/Tags :cognitect.aws.sqs/TagMap)

(s/def :cognitect.aws.sqs.MessageSystemAttributeValue/StringValue :cognitect.aws.sqs/String)

(s/def :cognitect.aws.sqs.MessageSystemAttributeValue/BinaryValue :cognitect.aws.sqs/Binary)

(s/def
  :cognitect.aws.sqs.MessageSystemAttributeValue/StringListValues
  :cognitect.aws.sqs/StringList)

(s/def
  :cognitect.aws.sqs.MessageSystemAttributeValue/BinaryListValues
  :cognitect.aws.sqs/BinaryList)

(s/def :cognitect.aws.sqs.MessageSystemAttributeValue/DataType :cognitect.aws.sqs/String)

