/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.Keyword;
import com.cognitect.transit.Ratio;
import com.cognitect.transit.TaggedValue;
import com.cognitect.transit.TransitFactory;
import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.impl.AbstractParser;
import com.cognitect.transit.impl.AbstractWriteHandler;
import com.cognitect.transit.impl.LinkImpl;
import com.cognitect.transit.impl.Quote;
import com.cognitect.transit.impl.TagProvider;
import com.cognitect.transit.impl.TagProviderAware;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;

public class WriteHandlers {

    public static class LinkWriteHandler
    extends AbstractWriteHandler<LinkImpl, Object> {
        @Override
        public String tag(LinkImpl o) {
            return "link";
        }

        @Override
        public Object rep(LinkImpl o) {
            return o.toMap();
        }
    }

    public static class UUIDWriteHandler
    extends AbstractWriteHandler<UUID, Object> {
        @Override
        public String tag(UUID ignored) {
            return "u";
        }

        @Override
        public Object rep(UUID uuid) {
            long[] l = new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()};
            return l;
        }

        @Override
        public String stringRep(UUID o) {
            return o.toString();
        }
    }

    public static class ToStringWriteHandler
    extends AbstractWriteHandler<Object, Object> {
        private final String t;

        public ToStringWriteHandler(String t) {
            this.t = t;
        }

        @Override
        public String tag(Object ignored) {
            return this.t;
        }

        @Override
        public Object rep(Object o) {
            return o.toString();
        }

        @Override
        public String stringRep(Object o) {
            return (String)this.rep(o);
        }
    }

    public static class TimeWriteHandler
    implements WriteHandler<Date, Object> {
        @Override
        public String tag(Date ignored) {
            return "m";
        }

        @Override
        public Object rep(Date o) {
            return o.getTime();
        }

        @Override
        public String stringRep(Date o) {
            return this.rep(o).toString();
        }

        @Override
        public WriteHandler<Date, String> getVerboseHandler() {
            return new WriteHandler<Date, String>(){

                @Override
                public String tag(Date ignored) {
                    return "t";
                }

                @Override
                public String rep(Date o) {
                    return AbstractParser.getDateTimeFormat().format(o);
                }

                @Override
                public String stringRep(Date o) {
                    return this.rep(o);
                }

                @Override
                public WriteHandler<Date, String> getVerboseHandler() {
                    return this;
                }
            };
        }
    }

    public static class TaggedValueWriteHandler
    extends AbstractWriteHandler<TaggedValue, Object> {
        @Override
        public String tag(TaggedValue o) {
            return o.getTag();
        }

        @Override
        public Object rep(TaggedValue o) {
            return o.getRep();
        }
    }

    public static class SetWriteHandler
    extends AbstractWriteHandler<Set<Object>, Object> {
        @Override
        public String tag(Set<Object> ignored) {
            return "set";
        }

        @Override
        public Object rep(Set<Object> o) {
            return TransitFactory.taggedValue("array", o);
        }
    }

    public static class RatioWriteHandler
    extends AbstractWriteHandler<Ratio, Object> {
        @Override
        public String tag(Ratio o) {
            return "ratio";
        }

        @Override
        public Object rep(Ratio o) {
            Ratio r = o;
            ArrayList<BigInteger> l = new ArrayList<BigInteger>();
            l.add(r.getNumerator());
            l.add(r.getDenominator());
            return l;
        }
    }

    public static class QuoteAbstractEmitter
    extends AbstractWriteHandler<Object, Object> {
        @Override
        public String tag(Object ignored) {
            return "'";
        }

        @Override
        public Object rep(Object o) {
            return ((Quote)o).o;
        }

        @Override
        public String stringRep(Object o) {
            throw new RuntimeException();
        }
    }

    public static class ObjectWriteHandler
    extends AbstractWriteHandler<Object, Object> {
        private String throwException(Object ignored) {
            throw new UnsupportedOperationException("Cannot marshal object of type " + ignored.getClass().getCanonicalName());
        }

        @Override
        public String tag(Object ignored) {
            return this.throwException(ignored);
        }

        @Override
        public Object rep(Object ignored) {
            return this.throwException(ignored);
        }

        @Override
        public String stringRep(Object ignored) {
            return this.throwException(ignored);
        }
    }

    public static class IntegerWriteHandler
    extends AbstractWriteHandler<Number, Object> {
        @Override
        public String tag(Number ignored) {
            return "i";
        }

        @Override
        public Number rep(Number o) {
            return o;
        }

        @Override
        public String stringRep(Number o) {
            return o.toString();
        }
    }

    public static class DoubleWriteHandler
    extends AbstractWriteHandler<Double, Object> {
        @Override
        public String tag(Double d) {
            if (d.isNaN() || d.isInfinite()) {
                return "z";
            }
            return "d";
        }

        @Override
        public Object rep(Double d) {
            if (d.isNaN()) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return d;
        }

        @Override
        public String stringRep(Double d) {
            return this.rep(d).toString();
        }
    }

    public static class FloatWriteHandler
    extends AbstractWriteHandler<Float, Object> {
        @Override
        public String tag(Float d) {
            if (d.isNaN() || d.isInfinite()) {
                return "z";
            }
            return "d";
        }

        @Override
        public Object rep(Float d) {
            if (d.isNaN()) {
                return "NaN";
            }
            if (d.floatValue() == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d.floatValue() == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return d;
        }

        @Override
        public String stringRep(Float d) {
            return this.rep(d).toString();
        }
    }

    public static class NullWriteHandler
    extends AbstractWriteHandler<Object, Object> {
        @Override
        public String tag(Object ignored) {
            return "_";
        }

        @Override
        public Object rep(Object ignored) {
            return null;
        }

        @Override
        public String stringRep(Object ignored) {
            return "";
        }
    }

    public static class MapWriteHandler
    extends AbstractWriteHandler<Map<Object, Object>, Object>
    implements TagProviderAware {
        private TagProvider tagProvider;

        @Override
        public void setTagProvider(TagProvider tagProvider) {
            this.tagProvider = tagProvider;
        }

        private boolean stringableKeys(Map<Object, Object> m) {
            for (Object key : m.keySet()) {
                String tag = this.tagProvider.getTag(key);
                if (tag != null && tag.length() > 1) {
                    return false;
                }
                if (tag != null || key instanceof String) continue;
                return false;
            }
            return true;
        }

        @Override
        public String tag(Map<Object, Object> o) {
            if (this.stringableKeys(o)) {
                return "map";
            }
            return "cmap";
        }

        @Override
        public Object rep(Map<Object, Object> o) {
            if (this.stringableKeys(o)) {
                return o.entrySet();
            }
            ArrayList<Object> l = new ArrayList<Object>(2 * o.size());
            for (Map.Entry<Object, Object> e : o.entrySet()) {
                l.add(e.getKey());
                l.add(e.getValue());
            }
            return TransitFactory.taggedValue("array", l);
        }
    }

    public static class ListWriteHandler
    extends AbstractWriteHandler<List<Object>, Object> {
        @Override
        public String tag(List<Object> o) {
            if (o instanceof RandomAccess) {
                return "array";
            }
            return "list";
        }

        @Override
        public Object rep(List<Object> o) {
            if (o instanceof LinkedList) {
                return TransitFactory.taggedValue("array", o);
            }
            return o;
        }
    }

    public static class KeywordWriteHandler
    extends AbstractWriteHandler<Keyword, Object> {
        @Override
        public String tag(Keyword ignored) {
            return ":";
        }

        @Override
        public Object rep(Keyword o) {
            return this.stringRep(o);
        }

        @Override
        public String stringRep(Keyword o) {
            return o.toString().substring(1);
        }
    }

    public static class BooleanWriteHandler
    extends AbstractWriteHandler<Boolean, Object> {
        @Override
        public String tag(Boolean ignored) {
            return "?";
        }

        @Override
        public Object rep(Boolean o) {
            return o;
        }

        @Override
        public String stringRep(Boolean o) {
            return o.toString();
        }
    }

    public static class BinaryWriteHandler
    extends AbstractWriteHandler<byte[], Object> {
        @Override
        public String tag(byte[] ignored) {
            return "b";
        }

        @Override
        public Object rep(byte[] o) {
            return o;
        }
    }

    public static class ArrayWriteHandler
    extends AbstractWriteHandler<Object, Object> {
        @Override
        public String tag(Object ignored) {
            return "array";
        }

        @Override
        public Object rep(Object o) {
            return o;
        }
    }
}

