/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.Writer;
import com.cognitect.transit.impl.Cache;
import com.cognitect.transit.impl.JsonEmitter;
import com.cognitect.transit.impl.JsonVerboseEmitter;
import com.cognitect.transit.impl.MsgpackEmitter;
import com.cognitect.transit.impl.WriteCache;
import com.cognitect.transit.impl.WriteHandlerMap;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.msgpack.MessagePack;
import org.msgpack.packer.Packer;

public class WriterFactory {
    private static final Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> handlerCache = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WriteHandlerMap handlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        WriteHandlerMap writeHandlerMap;
        if (customHandlers instanceof WriteHandlerMap) {
            return new WriteHandlerMap(customHandlers);
        }
        Map<Map<Class, WriteHandler<?, ?>>, WriteHandlerMap> map = handlerCache;
        synchronized (map) {
            writeHandlerMap = handlerCache.get(customHandlers);
            if (writeHandlerMap == null) {
                writeHandlerMap = new WriteHandlerMap(customHandlers);
                handlerCache.put(customHandlers, writeHandlerMap);
            }
        }
        return new WriteHandlerMap(writeHandlerMap);
    }

    private static WriteHandlerMap verboseHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        return WriterFactory.handlerMap(customHandlers).verboseWriteHandlerMap();
    }

    public static <T> Writer<T> getJsonInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers, boolean verboseMode) throws IOException {
        JsonGenerator gen = new JsonFactory().createGenerator(out);
        final JsonEmitter emitter = verboseMode ? new JsonVerboseEmitter(gen, WriterFactory.verboseHandlerMap(customHandlers)) : new JsonEmitter(gen, WriterFactory.handlerMap(customHandlers));
        final WriteCache writeCache = new WriteCache(!verboseMode);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <T> Writer<T> getMsgpackInstance(final OutputStream out, Map<Class, WriteHandler<?, ?>> customHandlers) throws IOException {
        Packer packer = new MessagePack().createPacker(out);
        final MsgpackEmitter emitter = new MsgpackEmitter(packer, WriterFactory.handlerMap(customHandlers));
        final WriteCache writeCache = new WriteCache(true);
        return new Writer<T>(){

            @Override
            public void write(T o) {
                try {
                    emitter.emit(o, false, writeCache.init());
                    out.flush();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

