/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api;

import com.cohere.api.CohereBuilder;
import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiApiError;
import com.cohere.api.core.CohereApiError;
import com.cohere.api.core.MediaTypes;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.Stream;
import com.cohere.api.core.Suppliers;
import com.cohere.api.errors.CohereApiBadRequestError;
import com.cohere.api.errors.CohereApiClientClosedRequestError;
import com.cohere.api.errors.CohereApiForbiddenError;
import com.cohere.api.errors.CohereApiGatewayTimeoutError;
import com.cohere.api.errors.CohereApiInternalServerError;
import com.cohere.api.errors.CohereApiNotFoundError;
import com.cohere.api.errors.CohereApiNotImplementedError;
import com.cohere.api.errors.CohereApiServiceUnavailableError;
import com.cohere.api.errors.CohereApiTooManyRequestsError;
import com.cohere.api.errors.CohereApiUnauthorizedError;
import com.cohere.api.errors.CohereApiUnprocessableEntityError;
import com.cohere.api.requests.ChatRequest;
import com.cohere.api.requests.ChatStreamRequest;
import com.cohere.api.requests.ClassifyRequest;
import com.cohere.api.requests.DetokenizeRequest;
import com.cohere.api.requests.EmbedRequest;
import com.cohere.api.requests.GenerateRequest;
import com.cohere.api.requests.GenerateStreamRequest;
import com.cohere.api.requests.RerankRequest;
import com.cohere.api.requests.SummarizeRequest;
import com.cohere.api.requests.TokenizeRequest;
import com.cohere.api.resources.connectors.ConnectorsClient;
import com.cohere.api.resources.datasets.DatasetsClient;
import com.cohere.api.resources.embedjobs.EmbedJobsClient;
import com.cohere.api.resources.finetuning.FinetuningClient;
import com.cohere.api.resources.models.ModelsClient;
import com.cohere.api.resources.v2.V2Client;
import com.cohere.api.types.CheckApiKeyResponse;
import com.cohere.api.types.ClassifyResponse;
import com.cohere.api.types.ClientClosedRequestErrorBody;
import com.cohere.api.types.DetokenizeResponse;
import com.cohere.api.types.EmbedResponse;
import com.cohere.api.types.GatewayTimeoutErrorBody;
import com.cohere.api.types.GenerateStreamedResponse;
import com.cohere.api.types.Generation;
import com.cohere.api.types.NonStreamedChatResponse;
import com.cohere.api.types.NotImplementedErrorBody;
import com.cohere.api.types.RerankResponse;
import com.cohere.api.types.StreamedChatResponse;
import com.cohere.api.types.SummarizeResponse;
import com.cohere.api.types.TokenizeResponse;
import com.cohere.api.types.TooManyRequestsErrorBody;
import com.cohere.api.types.UnprocessableEntityErrorBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class Cohere {
    protected final ClientOptions clientOptions;
    protected final Supplier<V2Client> v2Client;
    protected final Supplier<EmbedJobsClient> embedJobsClient;
    protected final Supplier<DatasetsClient> datasetsClient;
    protected final Supplier<ConnectorsClient> connectorsClient;
    protected final Supplier<ModelsClient> modelsClient;
    protected final Supplier<FinetuningClient> finetuningClient;

    public Cohere(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.v2Client = Suppliers.memoize(() -> new V2Client(clientOptions));
        this.embedJobsClient = Suppliers.memoize(() -> new EmbedJobsClient(clientOptions));
        this.datasetsClient = Suppliers.memoize(() -> new DatasetsClient(clientOptions));
        this.connectorsClient = Suppliers.memoize(() -> new ConnectorsClient(clientOptions));
        this.modelsClient = Suppliers.memoize(() -> new ModelsClient(clientOptions));
        this.finetuningClient = Suppliers.memoize(() -> new FinetuningClient(clientOptions));
    }

    public Iterable<StreamedChatResponse> chatStream(ChatStreamRequest request) {
        return this.chatStream(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<StreamedChatResponse> chatStream(ChatStreamRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/chat").build();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("message", request.getMessage());
        if (request.getModel().isPresent()) {
            properties.put("model", request.getModel());
        }
        properties.put("stream", request.getStream());
        if (request.getPreamble().isPresent()) {
            properties.put("preamble", request.getPreamble());
        }
        if (request.getChatHistory().isPresent()) {
            properties.put("chat_history", request.getChatHistory());
        }
        if (request.getConversationId().isPresent()) {
            properties.put("conversation_id", request.getConversationId());
        }
        if (request.getPromptTruncation().isPresent()) {
            properties.put("prompt_truncation", request.getPromptTruncation());
        }
        if (request.getConnectors().isPresent()) {
            properties.put("connectors", request.getConnectors());
        }
        if (request.getSearchQueriesOnly().isPresent()) {
            properties.put("search_queries_only", request.getSearchQueriesOnly());
        }
        if (request.getDocuments().isPresent()) {
            properties.put("documents", request.getDocuments());
        }
        if (request.getCitationQuality().isPresent()) {
            properties.put("citation_quality", request.getCitationQuality());
        }
        if (request.getTemperature().isPresent()) {
            properties.put("temperature", request.getTemperature());
        }
        if (request.getMaxTokens().isPresent()) {
            properties.put("max_tokens", request.getMaxTokens());
        }
        if (request.getMaxInputTokens().isPresent()) {
            properties.put("max_input_tokens", request.getMaxInputTokens());
        }
        if (request.getK().isPresent()) {
            properties.put("k", request.getK());
        }
        if (request.getP().isPresent()) {
            properties.put("p", request.getP());
        }
        if (request.getSeed().isPresent()) {
            properties.put("seed", request.getSeed());
        }
        if (request.getStopSequences().isPresent()) {
            properties.put("stop_sequences", request.getStopSequences());
        }
        if (request.getFrequencyPenalty().isPresent()) {
            properties.put("frequency_penalty", request.getFrequencyPenalty());
        }
        if (request.getPresencePenalty().isPresent()) {
            properties.put("presence_penalty", request.getPresencePenalty());
        }
        if (request.getRawPrompting().isPresent()) {
            properties.put("raw_prompting", request.getRawPrompting());
        }
        if (request.getReturnPrompt().isPresent()) {
            properties.put("return_prompt", request.getReturnPrompt());
        }
        if (request.getTools().isPresent()) {
            properties.put("tools", request.getTools());
        }
        if (request.getToolResults().isPresent()) {
            properties.put("tool_results", request.getToolResults());
        }
        if (request.getForceSingleStep().isPresent()) {
            properties.put("force_single_step", request.getForceSingleStep());
        }
        if (request.getResponseFormat().isPresent()) {
            properties.put("response_format", request.getResponseFormat());
        }
        if (request.getSafetyMode().isPresent()) {
            properties.put("safety_mode", request.getSafetyMode());
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        if (request.getAccepts().isPresent()) {
            _requestBuilder.addHeader("Accepts", request.getAccepts().get());
        }
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Stream<StreamedChatResponse> stream = new Stream<StreamedChatResponse>(StreamedChatResponse.class, responseBody.charStream(), "\n");
                return stream;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public NonStreamedChatResponse chat(ChatRequest request) {
        return this.chat(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonStreamedChatResponse chat(ChatRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/chat").build();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("message", request.getMessage());
        if (request.getModel().isPresent()) {
            properties.put("model", request.getModel());
        }
        properties.put("stream", request.getStream());
        if (request.getPreamble().isPresent()) {
            properties.put("preamble", request.getPreamble());
        }
        if (request.getChatHistory().isPresent()) {
            properties.put("chat_history", request.getChatHistory());
        }
        if (request.getConversationId().isPresent()) {
            properties.put("conversation_id", request.getConversationId());
        }
        if (request.getPromptTruncation().isPresent()) {
            properties.put("prompt_truncation", request.getPromptTruncation());
        }
        if (request.getConnectors().isPresent()) {
            properties.put("connectors", request.getConnectors());
        }
        if (request.getSearchQueriesOnly().isPresent()) {
            properties.put("search_queries_only", request.getSearchQueriesOnly());
        }
        if (request.getDocuments().isPresent()) {
            properties.put("documents", request.getDocuments());
        }
        if (request.getCitationQuality().isPresent()) {
            properties.put("citation_quality", request.getCitationQuality());
        }
        if (request.getTemperature().isPresent()) {
            properties.put("temperature", request.getTemperature());
        }
        if (request.getMaxTokens().isPresent()) {
            properties.put("max_tokens", request.getMaxTokens());
        }
        if (request.getMaxInputTokens().isPresent()) {
            properties.put("max_input_tokens", request.getMaxInputTokens());
        }
        if (request.getK().isPresent()) {
            properties.put("k", request.getK());
        }
        if (request.getP().isPresent()) {
            properties.put("p", request.getP());
        }
        if (request.getSeed().isPresent()) {
            properties.put("seed", request.getSeed());
        }
        if (request.getStopSequences().isPresent()) {
            properties.put("stop_sequences", request.getStopSequences());
        }
        if (request.getFrequencyPenalty().isPresent()) {
            properties.put("frequency_penalty", request.getFrequencyPenalty());
        }
        if (request.getPresencePenalty().isPresent()) {
            properties.put("presence_penalty", request.getPresencePenalty());
        }
        if (request.getRawPrompting().isPresent()) {
            properties.put("raw_prompting", request.getRawPrompting());
        }
        if (request.getReturnPrompt().isPresent()) {
            properties.put("return_prompt", request.getReturnPrompt());
        }
        if (request.getTools().isPresent()) {
            properties.put("tools", request.getTools());
        }
        if (request.getToolResults().isPresent()) {
            properties.put("tool_results", request.getToolResults());
        }
        if (request.getForceSingleStep().isPresent()) {
            properties.put("force_single_step", request.getForceSingleStep());
        }
        if (request.getResponseFormat().isPresent()) {
            properties.put("response_format", request.getResponseFormat());
        }
        if (request.getSafetyMode().isPresent()) {
            properties.put("safety_mode", request.getSafetyMode());
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        if (request.getAccepts().isPresent()) {
            _requestBuilder.addHeader("Accepts", request.getAccepts().get());
        }
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                NonStreamedChatResponse nonStreamedChatResponse = (NonStreamedChatResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NonStreamedChatResponse.class);
                return nonStreamedChatResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public Iterable<GenerateStreamedResponse> generateStream(GenerateStreamRequest request) {
        return this.generateStream(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<GenerateStreamedResponse> generateStream(GenerateStreamRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/generate").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Stream<GenerateStreamedResponse> stream = new Stream<GenerateStreamedResponse>(GenerateStreamedResponse.class, responseBody.charStream(), "\n");
                return stream;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public Generation generate(GenerateRequest request) {
        return this.generate(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Generation generate(GenerateRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/generate").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Generation generation = (Generation)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Generation.class);
                return generation;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public EmbedResponse embed() {
        return this.embed(EmbedRequest.builder().build());
    }

    public EmbedResponse embed(EmbedRequest request) {
        return this.embed(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbedResponse embed(EmbedRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/embed").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                EmbedResponse embedResponse = (EmbedResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), EmbedResponse.class);
                return embedResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public RerankResponse rerank(RerankRequest request) {
        return this.rerank(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RerankResponse rerank(RerankRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/rerank").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                RerankResponse rerankResponse = (RerankResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RerankResponse.class);
                return rerankResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public ClassifyResponse classify(ClassifyRequest request) {
        return this.classify(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassifyResponse classify(ClassifyRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/classify").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ClassifyResponse classifyResponse = (ClassifyResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ClassifyResponse.class);
                return classifyResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public SummarizeResponse summarize(SummarizeRequest request) {
        return this.summarize(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SummarizeResponse summarize(SummarizeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/summarize").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SummarizeResponse summarizeResponse = (SummarizeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SummarizeResponse.class);
                return summarizeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public TokenizeResponse tokenize(TokenizeRequest request) {
        return this.tokenize(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenizeResponse tokenize(TokenizeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/tokenize").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                TokenizeResponse tokenizeResponse = (TokenizeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), TokenizeResponse.class);
                return tokenizeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public DetokenizeResponse detokenize(DetokenizeRequest request) {
        return this.detokenize(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DetokenizeResponse detokenize(DetokenizeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/detokenize").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DetokenizeResponse detokenizeResponse = (DetokenizeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DetokenizeResponse.class);
                return detokenizeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public CheckApiKeyResponse checkApiKey() {
        return this.checkApiKey(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckApiKeyResponse checkApiKey(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/check-api-key").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CheckApiKeyResponse checkApiKeyResponse = (CheckApiKeyResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CheckApiKeyResponse.class);
                return checkApiKeyResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public V2Client v2() {
        return this.v2Client.get();
    }

    public EmbedJobsClient embedJobs() {
        return this.embedJobsClient.get();
    }

    public DatasetsClient datasets() {
        return this.datasetsClient.get();
    }

    public ConnectorsClient connectors() {
        return this.connectorsClient.get();
    }

    public ModelsClient models() {
        return this.modelsClient.get();
    }

    public FinetuningClient finetuning() {
        return this.finetuningClient.get();
    }

    public static CohereBuilder builder() {
        return new CohereBuilder();
    }
}

