/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api;

import com.cohere.api.Cohere;
import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.Environment;

public final class CohereBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String token = System.getenv("CO_API_KEY");
    private String clientName = null;
    private Environment environment = Environment.PRODUCTION;

    public CohereBuilder token(String token) {
        this.token = token;
        return this;
    }

    public CohereBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public CohereBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public CohereBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public Cohere build() {
        if (this.token == null) {
            throw new RuntimeException("Please provide token or set the CO_API_KEY environment variable.");
        }
        this.clientOptionsBuilder.addHeader("Authorization", "Bearer " + this.token);
        if (this.clientName != null) {
            this.clientOptionsBuilder.addHeader("X-Client-Name", this.clientName);
        }
        this.clientOptionsBuilder.environment(this.environment);
        return new Cohere(this.clientOptionsBuilder.build());
    }
}

