/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.core;

import com.cohere.api.core.Environment;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.RetryInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class ClientOptions {
    private final Environment environment;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;
    private final OkHttpClient httpClient;

    private ClientOptions(Environment environment, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers, OkHttpClient httpClient) {
        this.environment = environment;
        this.headers = new HashMap<String, String>();
        this.headers.putAll(headers);
        this.headers.putAll((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("X-Fern-Language", "JAVA");
                this.put("X-Fern-SDK-Name", "com.cohere.fern:api-sdk");
                this.put("X-Fern-SDK-Version", "1.4.1");
            }
        });
        this.headerSuppliers = headerSuppliers;
        this.httpClient = httpClient;
    }

    public Environment environment() {
        return this.environment;
    }

    public Map<String, String> headers(RequestOptions requestOptions) {
        HashMap<String, String> values = new HashMap<String, String>(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> values.put((String)key, (String)supplier.get()));
        if (requestOptions != null) {
            values.putAll(requestOptions.getHeaders());
        }
        return values;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public OkHttpClient httpClientWithTimeout(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        return this.httpClient.newBuilder().callTimeout((long)requestOptions.getTimeout().get().intValue(), requestOptions.getTimeoutTimeUnit()).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Environment environment;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public ClientOptions build() {
            OkHttpClient okhttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetryInterceptor(3)).build();
            return new ClientOptions(this.environment, this.headers, this.headerSuppliers, okhttpClient);
        }
    }
}

