/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DetokenizeRequest {
    private final List<Integer> tokens;
    private final String model;
    private final Map<String, Object> additionalProperties;

    private DetokenizeRequest(List<Integer> tokens, String model, Map<String, Object> additionalProperties) {
        this.tokens = tokens;
        this.model = model;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tokens")
    public List<Integer> getTokens() {
        return this.tokens;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetokenizeRequest && this.equalTo((DetokenizeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DetokenizeRequest other) {
        return this.tokens.equals(other.tokens) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.tokens, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    _FinalStage {
        private String model;
        private List<Integer> tokens = new ArrayList<Integer>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DetokenizeRequest other) {
            this.tokens(other.getTokens());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage addAllTokens(List<Integer> tokens) {
            this.tokens.addAll(tokens);
            return this;
        }

        @Override
        public _FinalStage addTokens(Integer tokens) {
            this.tokens.add(tokens);
            return this;
        }

        @Override
        @JsonSetter(value="tokens", nulls=Nulls.SKIP)
        public _FinalStage tokens(List<Integer> tokens) {
            this.tokens.clear();
            this.tokens.addAll(tokens);
            return this;
        }

        @Override
        public DetokenizeRequest build() {
            return new DetokenizeRequest(this.tokens, this.model, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DetokenizeRequest build();

        public _FinalStage tokens(List<Integer> var1);

        public _FinalStage addTokens(Integer var1);

        public _FinalStage addAllTokens(List<Integer> var1);
    }

    public static interface ModelStage {
        public _FinalStage model(String var1);

        public Builder from(DetokenizeRequest var1);
    }
}

