/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.GenerateRequestReturnLikelihoods;
import com.cohere.api.types.GenerateRequestTruncate;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GenerateRequest {
    private final String prompt;
    private final Optional<String> model;
    private final Optional<Integer> numGenerations;
    private final Optional<Integer> maxTokens;
    private final Optional<GenerateRequestTruncate> truncate;
    private final Optional<Double> temperature;
    private final Optional<Integer> seed;
    private final Optional<String> preset;
    private final Optional<List<String>> endSequences;
    private final Optional<List<String>> stopSequences;
    private final Optional<Integer> k;
    private final Optional<Double> p;
    private final Optional<Double> frequencyPenalty;
    private final Optional<Double> presencePenalty;
    private final Optional<GenerateRequestReturnLikelihoods> returnLikelihoods;
    private final Optional<Boolean> rawPrompting;
    private final Map<String, Object> additionalProperties;

    private GenerateRequest(String prompt, Optional<String> model, Optional<Integer> numGenerations, Optional<Integer> maxTokens, Optional<GenerateRequestTruncate> truncate, Optional<Double> temperature, Optional<Integer> seed, Optional<String> preset, Optional<List<String>> endSequences, Optional<List<String>> stopSequences, Optional<Integer> k, Optional<Double> p, Optional<Double> frequencyPenalty, Optional<Double> presencePenalty, Optional<GenerateRequestReturnLikelihoods> returnLikelihoods, Optional<Boolean> rawPrompting, Map<String, Object> additionalProperties) {
        this.prompt = prompt;
        this.model = model;
        this.numGenerations = numGenerations;
        this.maxTokens = maxTokens;
        this.truncate = truncate;
        this.temperature = temperature;
        this.seed = seed;
        this.preset = preset;
        this.endSequences = endSequences;
        this.stopSequences = stopSequences;
        this.k = k;
        this.p = p;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.returnLikelihoods = returnLikelihoods;
        this.rawPrompting = rawPrompting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="prompt")
    public String getPrompt() {
        return this.prompt;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="num_generations")
    public Optional<Integer> getNumGenerations() {
        return this.numGenerations;
    }

    @JsonProperty(value="stream")
    public Boolean getStream() {
        return false;
    }

    @JsonProperty(value="max_tokens")
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="truncate")
    public Optional<GenerateRequestTruncate> getTruncate() {
        return this.truncate;
    }

    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="seed")
    public Optional<Integer> getSeed() {
        return this.seed;
    }

    @JsonProperty(value="preset")
    public Optional<String> getPreset() {
        return this.preset;
    }

    @JsonProperty(value="end_sequences")
    public Optional<List<String>> getEndSequences() {
        return this.endSequences;
    }

    @JsonProperty(value="stop_sequences")
    public Optional<List<String>> getStopSequences() {
        return this.stopSequences;
    }

    @JsonProperty(value="k")
    public Optional<Integer> getK() {
        return this.k;
    }

    @JsonProperty(value="p")
    public Optional<Double> getP() {
        return this.p;
    }

    @JsonProperty(value="frequency_penalty")
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="return_likelihoods")
    public Optional<GenerateRequestReturnLikelihoods> getReturnLikelihoods() {
        return this.returnLikelihoods;
    }

    @JsonProperty(value="raw_prompting")
    public Optional<Boolean> getRawPrompting() {
        return this.rawPrompting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerateRequest && this.equalTo((GenerateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateRequest other) {
        return this.prompt.equals(other.prompt) && this.model.equals(other.model) && this.numGenerations.equals(other.numGenerations) && this.maxTokens.equals(other.maxTokens) && this.truncate.equals(other.truncate) && this.temperature.equals(other.temperature) && this.seed.equals(other.seed) && this.preset.equals(other.preset) && this.endSequences.equals(other.endSequences) && this.stopSequences.equals(other.stopSequences) && this.k.equals(other.k) && this.p.equals(other.p) && this.frequencyPenalty.equals(other.frequencyPenalty) && this.presencePenalty.equals(other.presencePenalty) && this.returnLikelihoods.equals(other.returnLikelihoods) && this.rawPrompting.equals(other.rawPrompting);
    }

    public int hashCode() {
        return Objects.hash(this.prompt, this.model, this.numGenerations, this.maxTokens, this.truncate, this.temperature, this.seed, this.preset, this.endSequences, this.stopSequences, this.k, this.p, this.frequencyPenalty, this.presencePenalty, this.returnLikelihoods, this.rawPrompting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PromptStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PromptStage,
    _FinalStage {
        private String prompt;
        private Optional<Boolean> rawPrompting = Optional.empty();
        private Optional<GenerateRequestReturnLikelihoods> returnLikelihoods = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private Optional<Double> p = Optional.empty();
        private Optional<Integer> k = Optional.empty();
        private Optional<List<String>> stopSequences = Optional.empty();
        private Optional<List<String>> endSequences = Optional.empty();
        private Optional<String> preset = Optional.empty();
        private Optional<Integer> seed = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<GenerateRequestTruncate> truncate = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Integer> numGenerations = Optional.empty();
        private Optional<String> model = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GenerateRequest other) {
            this.prompt(other.getPrompt());
            this.model(other.getModel());
            this.numGenerations(other.getNumGenerations());
            this.maxTokens(other.getMaxTokens());
            this.truncate(other.getTruncate());
            this.temperature(other.getTemperature());
            this.seed(other.getSeed());
            this.preset(other.getPreset());
            this.endSequences(other.getEndSequences());
            this.stopSequences(other.getStopSequences());
            this.k(other.getK());
            this.p(other.getP());
            this.frequencyPenalty(other.getFrequencyPenalty());
            this.presencePenalty(other.getPresencePenalty());
            this.returnLikelihoods(other.getReturnLikelihoods());
            this.rawPrompting(other.getRawPrompting());
            return this;
        }

        @Override
        @JsonSetter(value="prompt")
        public _FinalStage prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public _FinalStage rawPrompting(Boolean rawPrompting) {
            this.rawPrompting = Optional.of(rawPrompting);
            return this;
        }

        @Override
        @JsonSetter(value="raw_prompting", nulls=Nulls.SKIP)
        public _FinalStage rawPrompting(Optional<Boolean> rawPrompting) {
            this.rawPrompting = rawPrompting;
            return this;
        }

        @Override
        public _FinalStage returnLikelihoods(GenerateRequestReturnLikelihoods returnLikelihoods) {
            this.returnLikelihoods = Optional.of(returnLikelihoods);
            return this;
        }

        @Override
        @JsonSetter(value="return_likelihoods", nulls=Nulls.SKIP)
        public _FinalStage returnLikelihoods(Optional<GenerateRequestReturnLikelihoods> returnLikelihoods) {
            this.returnLikelihoods = returnLikelihoods;
            return this;
        }

        @Override
        public _FinalStage presencePenalty(Double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        @Override
        @JsonSetter(value="presence_penalty", nulls=Nulls.SKIP)
        public _FinalStage presencePenalty(Optional<Double> presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Override
        public _FinalStage frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        @Override
        @JsonSetter(value="frequency_penalty", nulls=Nulls.SKIP)
        public _FinalStage frequencyPenalty(Optional<Double> frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Override
        public _FinalStage p(Double p) {
            this.p = Optional.of(p);
            return this;
        }

        @Override
        @JsonSetter(value="p", nulls=Nulls.SKIP)
        public _FinalStage p(Optional<Double> p) {
            this.p = p;
            return this;
        }

        @Override
        public _FinalStage k(Integer k) {
            this.k = Optional.of(k);
            return this;
        }

        @Override
        @JsonSetter(value="k", nulls=Nulls.SKIP)
        public _FinalStage k(Optional<Integer> k) {
            this.k = k;
            return this;
        }

        @Override
        public _FinalStage stopSequences(List<String> stopSequences) {
            this.stopSequences = Optional.of(stopSequences);
            return this;
        }

        @Override
        @JsonSetter(value="stop_sequences", nulls=Nulls.SKIP)
        public _FinalStage stopSequences(Optional<List<String>> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public _FinalStage endSequences(List<String> endSequences) {
            this.endSequences = Optional.of(endSequences);
            return this;
        }

        @Override
        @JsonSetter(value="end_sequences", nulls=Nulls.SKIP)
        public _FinalStage endSequences(Optional<List<String>> endSequences) {
            this.endSequences = endSequences;
            return this;
        }

        @Override
        public _FinalStage preset(String preset) {
            this.preset = Optional.of(preset);
            return this;
        }

        @Override
        @JsonSetter(value="preset", nulls=Nulls.SKIP)
        public _FinalStage preset(Optional<String> preset) {
            this.preset = preset;
            return this;
        }

        @Override
        public _FinalStage seed(Integer seed) {
            this.seed = Optional.of(seed);
            return this;
        }

        @Override
        @JsonSetter(value="seed", nulls=Nulls.SKIP)
        public _FinalStage seed(Optional<Integer> seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage truncate(GenerateRequestTruncate truncate) {
            this.truncate = Optional.of(truncate);
            return this;
        }

        @Override
        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public _FinalStage truncate(Optional<GenerateRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        @Override
        public _FinalStage maxTokens(Integer maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxTokens(Optional<Integer> maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public _FinalStage numGenerations(Integer numGenerations) {
            this.numGenerations = Optional.of(numGenerations);
            return this;
        }

        @Override
        @JsonSetter(value="num_generations", nulls=Nulls.SKIP)
        public _FinalStage numGenerations(Optional<Integer> numGenerations) {
            this.numGenerations = numGenerations;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public GenerateRequest build() {
            return new GenerateRequest(this.prompt, this.model, this.numGenerations, this.maxTokens, this.truncate, this.temperature, this.seed, this.preset, this.endSequences, this.stopSequences, this.k, this.p, this.frequencyPenalty, this.presencePenalty, this.returnLikelihoods, this.rawPrompting, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GenerateRequest build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage numGenerations(Optional<Integer> var1);

        public _FinalStage numGenerations(Integer var1);

        public _FinalStage maxTokens(Optional<Integer> var1);

        public _FinalStage maxTokens(Integer var1);

        public _FinalStage truncate(Optional<GenerateRequestTruncate> var1);

        public _FinalStage truncate(GenerateRequestTruncate var1);

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);

        public _FinalStage seed(Optional<Integer> var1);

        public _FinalStage seed(Integer var1);

        public _FinalStage preset(Optional<String> var1);

        public _FinalStage preset(String var1);

        public _FinalStage endSequences(Optional<List<String>> var1);

        public _FinalStage endSequences(List<String> var1);

        public _FinalStage stopSequences(Optional<List<String>> var1);

        public _FinalStage stopSequences(List<String> var1);

        public _FinalStage k(Optional<Integer> var1);

        public _FinalStage k(Integer var1);

        public _FinalStage p(Optional<Double> var1);

        public _FinalStage p(Double var1);

        public _FinalStage frequencyPenalty(Optional<Double> var1);

        public _FinalStage frequencyPenalty(Double var1);

        public _FinalStage presencePenalty(Optional<Double> var1);

        public _FinalStage presencePenalty(Double var1);

        public _FinalStage returnLikelihoods(Optional<GenerateRequestReturnLikelihoods> var1);

        public _FinalStage returnLikelihoods(GenerateRequestReturnLikelihoods var1);

        public _FinalStage rawPrompting(Optional<Boolean> var1);

        public _FinalStage rawPrompting(Boolean var1);
    }

    public static interface PromptStage {
        public _FinalStage prompt(String var1);

        public Builder from(GenerateRequest var1);
    }
}

