/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.requests;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TokenizeRequest {
    private final String text;
    private final String model;
    private final Map<String, Object> additionalProperties;

    private TokenizeRequest(String text, String model, Map<String, Object> additionalProperties) {
        this.text = text;
        this.model = model;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TokenizeRequest && this.equalTo((TokenizeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TokenizeRequest other) {
        return this.text.equals(other.text) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    ModelStage,
    _FinalStage {
        private String text;
        private String model;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TokenizeRequest other) {
            this.text(other.getText());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public ModelStage text(String text) {
            this.text = text;
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        public TokenizeRequest build() {
            return new TokenizeRequest(this.text, this.model, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TokenizeRequest build();
    }

    public static interface ModelStage {
        public _FinalStage model(String var1);
    }

    public static interface TextStage {
        public ModelStage text(String var1);

        public Builder from(TokenizeRequest var1);
    }
}

