/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.connectors;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiApiError;
import com.cohere.api.core.CohereApiError;
import com.cohere.api.core.MediaTypes;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.errors.CohereApiBadRequestError;
import com.cohere.api.errors.CohereApiClientClosedRequestError;
import com.cohere.api.errors.CohereApiForbiddenError;
import com.cohere.api.errors.CohereApiGatewayTimeoutError;
import com.cohere.api.errors.CohereApiInternalServerError;
import com.cohere.api.errors.CohereApiNotFoundError;
import com.cohere.api.errors.CohereApiNotImplementedError;
import com.cohere.api.errors.CohereApiServiceUnavailableError;
import com.cohere.api.errors.CohereApiTooManyRequestsError;
import com.cohere.api.errors.CohereApiUnauthorizedError;
import com.cohere.api.errors.CohereApiUnprocessableEntityError;
import com.cohere.api.resources.connectors.requests.ConnectorsListRequest;
import com.cohere.api.resources.connectors.requests.ConnectorsOAuthAuthorizeRequest;
import com.cohere.api.resources.connectors.requests.CreateConnectorRequest;
import com.cohere.api.resources.connectors.requests.UpdateConnectorRequest;
import com.cohere.api.types.ClientClosedRequestErrorBody;
import com.cohere.api.types.CreateConnectorResponse;
import com.cohere.api.types.GatewayTimeoutErrorBody;
import com.cohere.api.types.GetConnectorResponse;
import com.cohere.api.types.ListConnectorsResponse;
import com.cohere.api.types.NotImplementedErrorBody;
import com.cohere.api.types.OAuthAuthorizeResponse;
import com.cohere.api.types.TooManyRequestsErrorBody;
import com.cohere.api.types.UnprocessableEntityErrorBody;
import com.cohere.api.types.UpdateConnectorResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ConnectorsClient {
    protected final ClientOptions clientOptions;

    public ConnectorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ListConnectorsResponse list() {
        return this.list(ConnectorsListRequest.builder().build());
    }

    public ListConnectorsResponse list(ConnectorsListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListConnectorsResponse list(ConnectorsListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors");
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListConnectorsResponse listConnectorsResponse = (ListConnectorsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListConnectorsResponse.class);
                return listConnectorsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public CreateConnectorResponse create(CreateConnectorRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateConnectorResponse create(CreateConnectorRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CreateConnectorResponse createConnectorResponse = (CreateConnectorResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateConnectorResponse.class);
                return createConnectorResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public GetConnectorResponse get(String id) {
        return this.get(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetConnectorResponse get(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetConnectorResponse getConnectorResponse = (GetConnectorResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetConnectorResponse.class);
                return getConnectorResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public Map<String, Object> delete(String id) {
        return this.delete(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> delete(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Map map = (Map)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                return map;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public UpdateConnectorResponse update(String id) {
        return this.update(id, UpdateConnectorRequest.builder().build());
    }

    public UpdateConnectorResponse update(String id, UpdateConnectorRequest request) {
        return this.update(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpdateConnectorResponse update(String id, UpdateConnectorRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors").addPathSegment(id).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpdateConnectorResponse updateConnectorResponse = (UpdateConnectorResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateConnectorResponse.class);
                return updateConnectorResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public OAuthAuthorizeResponse oAuthAuthorize(String id) {
        return this.oAuthAuthorize(id, ConnectorsOAuthAuthorizeRequest.builder().build());
    }

    public OAuthAuthorizeResponse oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request) {
        return this.oAuthAuthorize(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuthAuthorizeResponse oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/connectors").addPathSegment(id).addPathSegments("oauth/authorize");
        if (request.getAfterTokenRedirect().isPresent()) {
            httpUrl.addQueryParameter("after_token_redirect", request.getAfterTokenRedirect().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                OAuthAuthorizeResponse oAuthAuthorizeResponse = (OAuthAuthorizeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), OAuthAuthorizeResponse.class);
                return oAuthAuthorizeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }
}

