/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.connectors.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CreateConnectorOAuth;
import com.cohere.api.types.CreateConnectorServiceAuth;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateConnectorRequest {
    private final String name;
    private final Optional<String> description;
    private final String url;
    private final Optional<List<String>> excludes;
    private final Optional<CreateConnectorOAuth> oauth;
    private final Optional<Boolean> active;
    private final Optional<Boolean> continueOnFailure;
    private final Optional<CreateConnectorServiceAuth> serviceAuth;
    private final Map<String, Object> additionalProperties;

    private CreateConnectorRequest(String name, Optional<String> description, String url, Optional<List<String>> excludes, Optional<CreateConnectorOAuth> oauth, Optional<Boolean> active, Optional<Boolean> continueOnFailure, Optional<CreateConnectorServiceAuth> serviceAuth, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.excludes = excludes;
        this.oauth = oauth;
        this.active = active;
        this.continueOnFailure = continueOnFailure;
        this.serviceAuth = serviceAuth;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="excludes")
    public Optional<List<String>> getExcludes() {
        return this.excludes;
    }

    @JsonProperty(value="oauth")
    public Optional<CreateConnectorOAuth> getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="active")
    public Optional<Boolean> getActive() {
        return this.active;
    }

    @JsonProperty(value="continue_on_failure")
    public Optional<Boolean> getContinueOnFailure() {
        return this.continueOnFailure;
    }

    @JsonProperty(value="service_auth")
    public Optional<CreateConnectorServiceAuth> getServiceAuth() {
        return this.serviceAuth;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateConnectorRequest && this.equalTo((CreateConnectorRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateConnectorRequest other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.url.equals(other.url) && this.excludes.equals(other.excludes) && this.oauth.equals(other.oauth) && this.active.equals(other.active) && this.continueOnFailure.equals(other.continueOnFailure) && this.serviceAuth.equals(other.serviceAuth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.url, this.excludes, this.oauth, this.active, this.continueOnFailure, this.serviceAuth);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    UrlStage,
    _FinalStage {
        private String name;
        private String url;
        private Optional<CreateConnectorServiceAuth> serviceAuth = Optional.empty();
        private Optional<Boolean> continueOnFailure = Optional.empty();
        private Optional<Boolean> active = Optional.empty();
        private Optional<CreateConnectorOAuth> oauth = Optional.empty();
        private Optional<List<String>> excludes = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateConnectorRequest other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.url(other.getUrl());
            this.excludes(other.getExcludes());
            this.oauth(other.getOauth());
            this.active(other.getActive());
            this.continueOnFailure(other.getContinueOnFailure());
            this.serviceAuth(other.getServiceAuth());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UrlStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage serviceAuth(CreateConnectorServiceAuth serviceAuth) {
            this.serviceAuth = Optional.of(serviceAuth);
            return this;
        }

        @Override
        @JsonSetter(value="service_auth", nulls=Nulls.SKIP)
        public _FinalStage serviceAuth(Optional<CreateConnectorServiceAuth> serviceAuth) {
            this.serviceAuth = serviceAuth;
            return this;
        }

        @Override
        public _FinalStage continueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = Optional.of(continueOnFailure);
            return this;
        }

        @Override
        @JsonSetter(value="continue_on_failure", nulls=Nulls.SKIP)
        public _FinalStage continueOnFailure(Optional<Boolean> continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        @Override
        public _FinalStage active(Boolean active) {
            this.active = Optional.of(active);
            return this;
        }

        @Override
        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public _FinalStage active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        @Override
        public _FinalStage oauth(CreateConnectorOAuth oauth) {
            this.oauth = Optional.of(oauth);
            return this;
        }

        @Override
        @JsonSetter(value="oauth", nulls=Nulls.SKIP)
        public _FinalStage oauth(Optional<CreateConnectorOAuth> oauth) {
            this.oauth = oauth;
            return this;
        }

        @Override
        public _FinalStage excludes(List<String> excludes) {
            this.excludes = Optional.of(excludes);
            return this;
        }

        @Override
        @JsonSetter(value="excludes", nulls=Nulls.SKIP)
        public _FinalStage excludes(Optional<List<String>> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this.name, this.description, this.url, this.excludes, this.oauth, this.active, this.continueOnFailure, this.serviceAuth, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateConnectorRequest build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage excludes(Optional<List<String>> var1);

        public _FinalStage excludes(List<String> var1);

        public _FinalStage oauth(Optional<CreateConnectorOAuth> var1);

        public _FinalStage oauth(CreateConnectorOAuth var1);

        public _FinalStage active(Optional<Boolean> var1);

        public _FinalStage active(Boolean var1);

        public _FinalStage continueOnFailure(Optional<Boolean> var1);

        public _FinalStage continueOnFailure(Boolean var1);

        public _FinalStage serviceAuth(Optional<CreateConnectorServiceAuth> var1);

        public _FinalStage serviceAuth(CreateConnectorServiceAuth var1);
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);
    }

    public static interface NameStage {
        public UrlStage name(String var1);

        public Builder from(CreateConnectorRequest var1);
    }
}

