/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.connectors.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CreateConnectorOAuth;
import com.cohere.api.types.CreateConnectorServiceAuth;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UpdateConnectorRequest {
    private final Optional<String> name;
    private final Optional<String> url;
    private final Optional<List<String>> excludes;
    private final Optional<CreateConnectorOAuth> oauth;
    private final Optional<Boolean> active;
    private final Optional<Boolean> continueOnFailure;
    private final Optional<CreateConnectorServiceAuth> serviceAuth;
    private final Map<String, Object> additionalProperties;

    private UpdateConnectorRequest(Optional<String> name, Optional<String> url, Optional<List<String>> excludes, Optional<CreateConnectorOAuth> oauth, Optional<Boolean> active, Optional<Boolean> continueOnFailure, Optional<CreateConnectorServiceAuth> serviceAuth, Map<String, Object> additionalProperties) {
        this.name = name;
        this.url = url;
        this.excludes = excludes;
        this.oauth = oauth;
        this.active = active;
        this.continueOnFailure = continueOnFailure;
        this.serviceAuth = serviceAuth;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="excludes")
    public Optional<List<String>> getExcludes() {
        return this.excludes;
    }

    @JsonProperty(value="oauth")
    public Optional<CreateConnectorOAuth> getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="active")
    public Optional<Boolean> getActive() {
        return this.active;
    }

    @JsonProperty(value="continue_on_failure")
    public Optional<Boolean> getContinueOnFailure() {
        return this.continueOnFailure;
    }

    @JsonProperty(value="service_auth")
    public Optional<CreateConnectorServiceAuth> getServiceAuth() {
        return this.serviceAuth;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateConnectorRequest && this.equalTo((UpdateConnectorRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateConnectorRequest other) {
        return this.name.equals(other.name) && this.url.equals(other.url) && this.excludes.equals(other.excludes) && this.oauth.equals(other.oauth) && this.active.equals(other.active) && this.continueOnFailure.equals(other.continueOnFailure) && this.serviceAuth.equals(other.serviceAuth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.excludes, this.oauth, this.active, this.continueOnFailure, this.serviceAuth);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<List<String>> excludes = Optional.empty();
        private Optional<CreateConnectorOAuth> oauth = Optional.empty();
        private Optional<Boolean> active = Optional.empty();
        private Optional<Boolean> continueOnFailure = Optional.empty();
        private Optional<CreateConnectorServiceAuth> serviceAuth = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateConnectorRequest other) {
            this.name(other.getName());
            this.url(other.getUrl());
            this.excludes(other.getExcludes());
            this.oauth(other.getOauth());
            this.active(other.getActive());
            this.continueOnFailure(other.getContinueOnFailure());
            this.serviceAuth(other.getServiceAuth());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.of(url);
            return this;
        }

        @JsonSetter(value="excludes", nulls=Nulls.SKIP)
        public Builder excludes(Optional<List<String>> excludes) {
            this.excludes = excludes;
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = Optional.of(excludes);
            return this;
        }

        @JsonSetter(value="oauth", nulls=Nulls.SKIP)
        public Builder oauth(Optional<CreateConnectorOAuth> oauth) {
            this.oauth = oauth;
            return this;
        }

        public Builder oauth(CreateConnectorOAuth oauth) {
            this.oauth = Optional.of(oauth);
            return this;
        }

        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public Builder active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = Optional.of(active);
            return this;
        }

        @JsonSetter(value="continue_on_failure", nulls=Nulls.SKIP)
        public Builder continueOnFailure(Optional<Boolean> continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        public Builder continueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = Optional.of(continueOnFailure);
            return this;
        }

        @JsonSetter(value="service_auth", nulls=Nulls.SKIP)
        public Builder serviceAuth(Optional<CreateConnectorServiceAuth> serviceAuth) {
            this.serviceAuth = serviceAuth;
            return this;
        }

        public Builder serviceAuth(CreateConnectorServiceAuth serviceAuth) {
            this.serviceAuth = Optional.of(serviceAuth);
            return this;
        }

        public UpdateConnectorRequest build() {
            return new UpdateConnectorRequest(this.name, this.url, this.excludes, this.oauth, this.active, this.continueOnFailure, this.serviceAuth, this.additionalProperties);
        }
    }
}

