/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiApiError;
import com.cohere.api.core.CohereApiError;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.errors.CohereApiBadRequestError;
import com.cohere.api.errors.CohereApiClientClosedRequestError;
import com.cohere.api.errors.CohereApiForbiddenError;
import com.cohere.api.errors.CohereApiGatewayTimeoutError;
import com.cohere.api.errors.CohereApiInternalServerError;
import com.cohere.api.errors.CohereApiNotFoundError;
import com.cohere.api.errors.CohereApiNotImplementedError;
import com.cohere.api.errors.CohereApiServiceUnavailableError;
import com.cohere.api.errors.CohereApiTooManyRequestsError;
import com.cohere.api.errors.CohereApiUnauthorizedError;
import com.cohere.api.errors.CohereApiUnprocessableEntityError;
import com.cohere.api.resources.datasets.requests.DatasetsCreateRequest;
import com.cohere.api.resources.datasets.requests.DatasetsListRequest;
import com.cohere.api.resources.datasets.types.DatasetsCreateResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetUsageResponse;
import com.cohere.api.resources.datasets.types.DatasetsListResponse;
import com.cohere.api.types.ClientClosedRequestErrorBody;
import com.cohere.api.types.GatewayTimeoutErrorBody;
import com.cohere.api.types.NotImplementedErrorBody;
import com.cohere.api.types.TooManyRequestsErrorBody;
import com.cohere.api.types.UnprocessableEntityErrorBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DatasetsClient {
    protected final ClientOptions clientOptions;

    public DatasetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public DatasetsListResponse list() {
        return this.list(DatasetsListRequest.builder().build());
    }

    public DatasetsListResponse list(DatasetsListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatasetsListResponse list(DatasetsListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/datasets");
        if (request.getDatasetType().isPresent()) {
            httpUrl.addQueryParameter("datasetType", request.getDatasetType().get());
        }
        if (request.getBefore().isPresent()) {
            httpUrl.addQueryParameter("before", request.getBefore().get().toString());
        }
        if (request.getAfter().isPresent()) {
            httpUrl.addQueryParameter("after", request.getAfter().get().toString());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        if (request.getValidationStatus().isPresent()) {
            httpUrl.addQueryParameter("validationStatus", request.getValidationStatus().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DatasetsListResponse datasetsListResponse = (DatasetsListResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DatasetsListResponse.class);
                return datasetsListResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public DatasetsCreateResponse create(File data, Optional<File> evalData, DatasetsCreateRequest request) {
        return this.create(data, evalData, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatasetsCreateResponse create(File data, Optional<File> evalData, DatasetsCreateRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/datasets");
        httpUrl.addQueryParameter("name", request.getName());
        httpUrl.addQueryParameter("type", request.getType().toString());
        if (request.getKeepOriginalFile().isPresent()) {
            httpUrl.addQueryParameter("keep_original_file", request.getKeepOriginalFile().get().toString());
        }
        if (request.getSkipMalformedInput().isPresent()) {
            httpUrl.addQueryParameter("skip_malformed_input", request.getSkipMalformedInput().get().toString());
        }
        if (request.getKeepFields().isPresent()) {
            httpUrl.addQueryParameter("keep_fields", request.getKeepFields().get());
        }
        if (request.getOptionalFields().isPresent()) {
            httpUrl.addQueryParameter("optional_fields", request.getOptionalFields().get());
        }
        if (request.getTextSeparator().isPresent()) {
            httpUrl.addQueryParameter("text_separator", request.getTextSeparator().get());
        }
        if (request.getCsvDelimiter().isPresent()) {
            httpUrl.addQueryParameter("csv_delimiter", request.getCsvDelimiter().get());
        }
        if (request.getDryRun().isPresent()) {
            httpUrl.addQueryParameter("dry_run", request.getDryRun().get().toString());
        }
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            String dataMimeType = Files.probeContentType(data.toPath());
            MediaType dataMimeTypeMediaType = dataMimeType != null ? MediaType.parse((String)dataMimeType) : null;
            body.addFormDataPart("data", data.getName(), RequestBody.create((MediaType)dataMimeTypeMediaType, (File)data));
            if (evalData.isPresent()) {
                String evalDataMimeType = Files.probeContentType(evalData.get().toPath());
                MediaType evalDataMimeTypeMediaType = evalDataMimeType != null ? MediaType.parse((String)evalDataMimeType) : null;
                body.addFormDataPart("eval_data", evalData.get().getName(), RequestBody.create((MediaType)evalDataMimeTypeMediaType, (File)evalData.get()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", (RequestBody)body.build()).headers(Headers.of(this.clientOptions.headers(requestOptions)));
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DatasetsCreateResponse datasetsCreateResponse = (DatasetsCreateResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DatasetsCreateResponse.class);
                return datasetsCreateResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public DatasetsGetUsageResponse getUsage() {
        return this.getUsage(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatasetsGetUsageResponse getUsage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/datasets/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DatasetsGetUsageResponse datasetsGetUsageResponse = (DatasetsGetUsageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DatasetsGetUsageResponse.class);
                return datasetsGetUsageResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public DatasetsGetResponse get(String id) {
        return this.get(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatasetsGetResponse get(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/datasets").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DatasetsGetResponse datasetsGetResponse = (DatasetsGetResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DatasetsGetResponse.class);
                return datasetsGetResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public Map<String, Object> delete(String id) {
        return this.delete(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> delete(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/datasets").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Map map = (Map)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                return map;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }
}

