/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.DatasetValidationStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DatasetsListRequest {
    private final Optional<String> datasetType;
    private final Optional<OffsetDateTime> before;
    private final Optional<OffsetDateTime> after;
    private final Optional<Double> limit;
    private final Optional<Double> offset;
    private final Optional<DatasetValidationStatus> validationStatus;
    private final Map<String, Object> additionalProperties;

    private DatasetsListRequest(Optional<String> datasetType, Optional<OffsetDateTime> before, Optional<OffsetDateTime> after, Optional<Double> limit, Optional<Double> offset, Optional<DatasetValidationStatus> validationStatus, Map<String, Object> additionalProperties) {
        this.datasetType = datasetType;
        this.before = before;
        this.after = after;
        this.limit = limit;
        this.offset = offset;
        this.validationStatus = validationStatus;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="datasetType")
    public Optional<String> getDatasetType() {
        return this.datasetType;
    }

    @JsonProperty(value="before")
    public Optional<OffsetDateTime> getBefore() {
        return this.before;
    }

    @JsonProperty(value="after")
    public Optional<OffsetDateTime> getAfter() {
        return this.after;
    }

    @JsonProperty(value="limit")
    public Optional<Double> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Double> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="validationStatus")
    public Optional<DatasetValidationStatus> getValidationStatus() {
        return this.validationStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetsListRequest && this.equalTo((DatasetsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetsListRequest other) {
        return this.datasetType.equals(other.datasetType) && this.before.equals(other.before) && this.after.equals(other.after) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.validationStatus.equals(other.validationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.datasetType, this.before, this.after, this.limit, this.offset, this.validationStatus);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> datasetType = Optional.empty();
        private Optional<OffsetDateTime> before = Optional.empty();
        private Optional<OffsetDateTime> after = Optional.empty();
        private Optional<Double> limit = Optional.empty();
        private Optional<Double> offset = Optional.empty();
        private Optional<DatasetValidationStatus> validationStatus = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DatasetsListRequest other) {
            this.datasetType(other.getDatasetType());
            this.before(other.getBefore());
            this.after(other.getAfter());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.validationStatus(other.getValidationStatus());
            return this;
        }

        @JsonSetter(value="datasetType", nulls=Nulls.SKIP)
        public Builder datasetType(Optional<String> datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public Builder datasetType(String datasetType) {
            this.datasetType = Optional.of(datasetType);
            return this;
        }

        @JsonSetter(value="before", nulls=Nulls.SKIP)
        public Builder before(Optional<OffsetDateTime> before) {
            this.before = before;
            return this;
        }

        public Builder before(OffsetDateTime before) {
            this.before = Optional.of(before);
            return this;
        }

        @JsonSetter(value="after", nulls=Nulls.SKIP)
        public Builder after(Optional<OffsetDateTime> after) {
            this.after = after;
            return this;
        }

        public Builder after(OffsetDateTime after) {
            this.after = Optional.of(after);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Double> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Double limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Double> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Double offset) {
            this.offset = Optional.of(offset);
            return this;
        }

        @JsonSetter(value="validationStatus", nulls=Nulls.SKIP)
        public Builder validationStatus(Optional<DatasetValidationStatus> validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        public Builder validationStatus(DatasetValidationStatus validationStatus) {
            this.validationStatus = Optional.of(validationStatus);
            return this;
        }

        public DatasetsListRequest build() {
            return new DatasetsListRequest(this.datasetType, this.before, this.after, this.limit, this.offset, this.validationStatus, this.additionalProperties);
        }
    }
}

