/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DatasetsCreateResponseDatasetPartsItem {
    private final Optional<String> name;
    private final Optional<Double> numRows;
    private final Optional<List<String>> samples;
    private final Optional<String> partKind;
    private final Map<String, Object> additionalProperties;

    private DatasetsCreateResponseDatasetPartsItem(Optional<String> name, Optional<Double> numRows, Optional<List<String>> samples, Optional<String> partKind, Map<String, Object> additionalProperties) {
        this.name = name;
        this.numRows = numRows;
        this.samples = samples;
        this.partKind = partKind;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="num_rows")
    public Optional<Double> getNumRows() {
        return this.numRows;
    }

    @JsonProperty(value="samples")
    public Optional<List<String>> getSamples() {
        return this.samples;
    }

    @JsonProperty(value="part_kind")
    public Optional<String> getPartKind() {
        return this.partKind;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetsCreateResponseDatasetPartsItem && this.equalTo((DatasetsCreateResponseDatasetPartsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetsCreateResponseDatasetPartsItem other) {
        return this.name.equals(other.name) && this.numRows.equals(other.numRows) && this.samples.equals(other.samples) && this.partKind.equals(other.partKind);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.numRows, this.samples, this.partKind);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Double> numRows = Optional.empty();
        private Optional<List<String>> samples = Optional.empty();
        private Optional<String> partKind = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DatasetsCreateResponseDatasetPartsItem other) {
            this.name(other.getName());
            this.numRows(other.getNumRows());
            this.samples(other.getSamples());
            this.partKind(other.getPartKind());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="num_rows", nulls=Nulls.SKIP)
        public Builder numRows(Optional<Double> numRows) {
            this.numRows = numRows;
            return this;
        }

        public Builder numRows(Double numRows) {
            this.numRows = Optional.of(numRows);
            return this;
        }

        @JsonSetter(value="samples", nulls=Nulls.SKIP)
        public Builder samples(Optional<List<String>> samples) {
            this.samples = samples;
            return this;
        }

        public Builder samples(List<String> samples) {
            this.samples = Optional.of(samples);
            return this;
        }

        @JsonSetter(value="part_kind", nulls=Nulls.SKIP)
        public Builder partKind(Optional<String> partKind) {
            this.partKind = partKind;
            return this;
        }

        public Builder partKind(String partKind) {
            this.partKind = Optional.of(partKind);
            return this;
        }

        public DatasetsCreateResponseDatasetPartsItem build() {
            return new DatasetsCreateResponseDatasetPartsItem(this.name, this.numRows, this.samples, this.partKind, this.additionalProperties);
        }
    }
}

