/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.embedjobs.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.embedjobs.types.CreateEmbedJobRequestTruncate;
import com.cohere.api.types.EmbedInputType;
import com.cohere.api.types.EmbeddingType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateEmbedJobRequest {
    private final String model;
    private final String datasetId;
    private final EmbedInputType inputType;
    private final Optional<String> name;
    private final Optional<List<EmbeddingType>> embeddingTypes;
    private final Optional<CreateEmbedJobRequestTruncate> truncate;
    private final Map<String, Object> additionalProperties;

    private CreateEmbedJobRequest(String model, String datasetId, EmbedInputType inputType, Optional<String> name, Optional<List<EmbeddingType>> embeddingTypes, Optional<CreateEmbedJobRequestTruncate> truncate, Map<String, Object> additionalProperties) {
        this.model = model;
        this.datasetId = datasetId;
        this.inputType = inputType;
        this.name = name;
        this.embeddingTypes = embeddingTypes;
        this.truncate = truncate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="dataset_id")
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="input_type")
    public EmbedInputType getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="embedding_types")
    public Optional<List<EmbeddingType>> getEmbeddingTypes() {
        return this.embeddingTypes;
    }

    @JsonProperty(value="truncate")
    public Optional<CreateEmbedJobRequestTruncate> getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateEmbedJobRequest && this.equalTo((CreateEmbedJobRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEmbedJobRequest other) {
        return this.model.equals(other.model) && this.datasetId.equals(other.datasetId) && this.inputType.equals((Object)other.inputType) && this.name.equals(other.name) && this.embeddingTypes.equals(other.embeddingTypes) && this.truncate.equals(other.truncate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.datasetId, this.inputType, this.name, this.embeddingTypes, this.truncate});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    DatasetIdStage,
    InputTypeStage,
    _FinalStage {
        private String model;
        private String datasetId;
        private EmbedInputType inputType;
        private Optional<CreateEmbedJobRequestTruncate> truncate = Optional.empty();
        private Optional<List<EmbeddingType>> embeddingTypes = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateEmbedJobRequest other) {
            this.model(other.getModel());
            this.datasetId(other.getDatasetId());
            this.inputType(other.getInputType());
            this.name(other.getName());
            this.embeddingTypes(other.getEmbeddingTypes());
            this.truncate(other.getTruncate());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public DatasetIdStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        @JsonSetter(value="dataset_id")
        public InputTypeStage datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        @Override
        @JsonSetter(value="input_type")
        public _FinalStage inputType(EmbedInputType inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public _FinalStage truncate(CreateEmbedJobRequestTruncate truncate) {
            this.truncate = Optional.of(truncate);
            return this;
        }

        @Override
        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public _FinalStage truncate(Optional<CreateEmbedJobRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        @Override
        public _FinalStage embeddingTypes(List<EmbeddingType> embeddingTypes) {
            this.embeddingTypes = Optional.of(embeddingTypes);
            return this;
        }

        @Override
        @JsonSetter(value="embedding_types", nulls=Nulls.SKIP)
        public _FinalStage embeddingTypes(Optional<List<EmbeddingType>> embeddingTypes) {
            this.embeddingTypes = embeddingTypes;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateEmbedJobRequest build() {
            return new CreateEmbedJobRequest(this.model, this.datasetId, this.inputType, this.name, this.embeddingTypes, this.truncate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateEmbedJobRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage embeddingTypes(Optional<List<EmbeddingType>> var1);

        public _FinalStage embeddingTypes(List<EmbeddingType> var1);

        public _FinalStage truncate(Optional<CreateEmbedJobRequestTruncate> var1);

        public _FinalStage truncate(CreateEmbedJobRequestTruncate var1);
    }

    public static interface InputTypeStage {
        public _FinalStage inputType(EmbedInputType var1);
    }

    public static interface DatasetIdStage {
        public InputTypeStage datasetId(String var1);
    }

    public static interface ModelStage {
        public DatasetIdStage model(String var1);

        public Builder from(CreateEmbedJobRequest var1);
    }
}

