/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.LoraTargetModules;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Hyperparameters {
    private final Optional<Integer> earlyStoppingPatience;
    private final Optional<Double> earlyStoppingThreshold;
    private final Optional<Integer> trainBatchSize;
    private final Optional<Integer> trainEpochs;
    private final Optional<Double> learningRate;
    private final Optional<Integer> loraAlpha;
    private final Optional<Integer> loraRank;
    private final Optional<LoraTargetModules> loraTargetModules;
    private final Map<String, Object> additionalProperties;

    private Hyperparameters(Optional<Integer> earlyStoppingPatience, Optional<Double> earlyStoppingThreshold, Optional<Integer> trainBatchSize, Optional<Integer> trainEpochs, Optional<Double> learningRate, Optional<Integer> loraAlpha, Optional<Integer> loraRank, Optional<LoraTargetModules> loraTargetModules, Map<String, Object> additionalProperties) {
        this.earlyStoppingPatience = earlyStoppingPatience;
        this.earlyStoppingThreshold = earlyStoppingThreshold;
        this.trainBatchSize = trainBatchSize;
        this.trainEpochs = trainEpochs;
        this.learningRate = learningRate;
        this.loraAlpha = loraAlpha;
        this.loraRank = loraRank;
        this.loraTargetModules = loraTargetModules;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="early_stopping_patience")
    public Optional<Integer> getEarlyStoppingPatience() {
        return this.earlyStoppingPatience;
    }

    @JsonProperty(value="early_stopping_threshold")
    public Optional<Double> getEarlyStoppingThreshold() {
        return this.earlyStoppingThreshold;
    }

    @JsonProperty(value="train_batch_size")
    public Optional<Integer> getTrainBatchSize() {
        return this.trainBatchSize;
    }

    @JsonProperty(value="train_epochs")
    public Optional<Integer> getTrainEpochs() {
        return this.trainEpochs;
    }

    @JsonProperty(value="learning_rate")
    public Optional<Double> getLearningRate() {
        return this.learningRate;
    }

    @JsonProperty(value="lora_alpha")
    public Optional<Integer> getLoraAlpha() {
        return this.loraAlpha;
    }

    @JsonProperty(value="lora_rank")
    public Optional<Integer> getLoraRank() {
        return this.loraRank;
    }

    @JsonProperty(value="lora_target_modules")
    public Optional<LoraTargetModules> getLoraTargetModules() {
        return this.loraTargetModules;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Hyperparameters && this.equalTo((Hyperparameters)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Hyperparameters other) {
        return this.earlyStoppingPatience.equals(other.earlyStoppingPatience) && this.earlyStoppingThreshold.equals(other.earlyStoppingThreshold) && this.trainBatchSize.equals(other.trainBatchSize) && this.trainEpochs.equals(other.trainEpochs) && this.learningRate.equals(other.learningRate) && this.loraAlpha.equals(other.loraAlpha) && this.loraRank.equals(other.loraRank) && this.loraTargetModules.equals(other.loraTargetModules);
    }

    public int hashCode() {
        return Objects.hash(this.earlyStoppingPatience, this.earlyStoppingThreshold, this.trainBatchSize, this.trainEpochs, this.learningRate, this.loraAlpha, this.loraRank, this.loraTargetModules);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> earlyStoppingPatience = Optional.empty();
        private Optional<Double> earlyStoppingThreshold = Optional.empty();
        private Optional<Integer> trainBatchSize = Optional.empty();
        private Optional<Integer> trainEpochs = Optional.empty();
        private Optional<Double> learningRate = Optional.empty();
        private Optional<Integer> loraAlpha = Optional.empty();
        private Optional<Integer> loraRank = Optional.empty();
        private Optional<LoraTargetModules> loraTargetModules = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Hyperparameters other) {
            this.earlyStoppingPatience(other.getEarlyStoppingPatience());
            this.earlyStoppingThreshold(other.getEarlyStoppingThreshold());
            this.trainBatchSize(other.getTrainBatchSize());
            this.trainEpochs(other.getTrainEpochs());
            this.learningRate(other.getLearningRate());
            this.loraAlpha(other.getLoraAlpha());
            this.loraRank(other.getLoraRank());
            this.loraTargetModules(other.getLoraTargetModules());
            return this;
        }

        @JsonSetter(value="early_stopping_patience", nulls=Nulls.SKIP)
        public Builder earlyStoppingPatience(Optional<Integer> earlyStoppingPatience) {
            this.earlyStoppingPatience = earlyStoppingPatience;
            return this;
        }

        public Builder earlyStoppingPatience(Integer earlyStoppingPatience) {
            this.earlyStoppingPatience = Optional.of(earlyStoppingPatience);
            return this;
        }

        @JsonSetter(value="early_stopping_threshold", nulls=Nulls.SKIP)
        public Builder earlyStoppingThreshold(Optional<Double> earlyStoppingThreshold) {
            this.earlyStoppingThreshold = earlyStoppingThreshold;
            return this;
        }

        public Builder earlyStoppingThreshold(Double earlyStoppingThreshold) {
            this.earlyStoppingThreshold = Optional.of(earlyStoppingThreshold);
            return this;
        }

        @JsonSetter(value="train_batch_size", nulls=Nulls.SKIP)
        public Builder trainBatchSize(Optional<Integer> trainBatchSize) {
            this.trainBatchSize = trainBatchSize;
            return this;
        }

        public Builder trainBatchSize(Integer trainBatchSize) {
            this.trainBatchSize = Optional.of(trainBatchSize);
            return this;
        }

        @JsonSetter(value="train_epochs", nulls=Nulls.SKIP)
        public Builder trainEpochs(Optional<Integer> trainEpochs) {
            this.trainEpochs = trainEpochs;
            return this;
        }

        public Builder trainEpochs(Integer trainEpochs) {
            this.trainEpochs = Optional.of(trainEpochs);
            return this;
        }

        @JsonSetter(value="learning_rate", nulls=Nulls.SKIP)
        public Builder learningRate(Optional<Double> learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = Optional.of(learningRate);
            return this;
        }

        @JsonSetter(value="lora_alpha", nulls=Nulls.SKIP)
        public Builder loraAlpha(Optional<Integer> loraAlpha) {
            this.loraAlpha = loraAlpha;
            return this;
        }

        public Builder loraAlpha(Integer loraAlpha) {
            this.loraAlpha = Optional.of(loraAlpha);
            return this;
        }

        @JsonSetter(value="lora_rank", nulls=Nulls.SKIP)
        public Builder loraRank(Optional<Integer> loraRank) {
            this.loraRank = loraRank;
            return this;
        }

        public Builder loraRank(Integer loraRank) {
            this.loraRank = Optional.of(loraRank);
            return this;
        }

        @JsonSetter(value="lora_target_modules", nulls=Nulls.SKIP)
        public Builder loraTargetModules(Optional<LoraTargetModules> loraTargetModules) {
            this.loraTargetModules = loraTargetModules;
            return this;
        }

        public Builder loraTargetModules(LoraTargetModules loraTargetModules) {
            this.loraTargetModules = Optional.of(loraTargetModules);
            return this;
        }

        public Hyperparameters build() {
            return new Hyperparameters(this.earlyStoppingPatience, this.earlyStoppingThreshold, this.trainBatchSize, this.trainEpochs, this.learningRate, this.loraAlpha, this.loraRank, this.loraTargetModules, this.additionalProperties);
        }
    }
}

