/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WandbConfig {
    private final String project;
    private final String apiKey;
    private final Optional<String> entity;
    private final Map<String, Object> additionalProperties;

    private WandbConfig(String project, String apiKey, Optional<String> entity, Map<String, Object> additionalProperties) {
        this.project = project;
        this.apiKey = apiKey;
        this.entity = entity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="project")
    public String getProject() {
        return this.project;
    }

    @JsonProperty(value="api_key")
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="entity")
    public Optional<String> getEntity() {
        return this.entity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WandbConfig && this.equalTo((WandbConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WandbConfig other) {
        return this.project.equals(other.project) && this.apiKey.equals(other.apiKey) && this.entity.equals(other.entity);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.apiKey, this.entity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProjectStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProjectStage,
    ApiKeyStage,
    _FinalStage {
        private String project;
        private String apiKey;
        private Optional<String> entity = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WandbConfig other) {
            this.project(other.getProject());
            this.apiKey(other.getApiKey());
            this.entity(other.getEntity());
            return this;
        }

        @Override
        @JsonSetter(value="project")
        public ApiKeyStage project(String project) {
            this.project = project;
            return this;
        }

        @Override
        @JsonSetter(value="api_key")
        public _FinalStage apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public _FinalStage entity(String entity) {
            this.entity = Optional.of(entity);
            return this;
        }

        @Override
        @JsonSetter(value="entity", nulls=Nulls.SKIP)
        public _FinalStage entity(Optional<String> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public WandbConfig build() {
            return new WandbConfig(this.project, this.apiKey, this.entity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WandbConfig build();

        public _FinalStage entity(Optional<String> var1);

        public _FinalStage entity(String var1);
    }

    public static interface ApiKeyStage {
        public _FinalStage apiKey(String var1);
    }

    public static interface ProjectStage {
        public ApiKeyStage project(String var1);

        public Builder from(WandbConfig var1);
    }
}

