/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.models;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiApiError;
import com.cohere.api.core.CohereApiError;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.errors.CohereApiBadRequestError;
import com.cohere.api.errors.CohereApiClientClosedRequestError;
import com.cohere.api.errors.CohereApiForbiddenError;
import com.cohere.api.errors.CohereApiGatewayTimeoutError;
import com.cohere.api.errors.CohereApiInternalServerError;
import com.cohere.api.errors.CohereApiNotFoundError;
import com.cohere.api.errors.CohereApiNotImplementedError;
import com.cohere.api.errors.CohereApiServiceUnavailableError;
import com.cohere.api.errors.CohereApiTooManyRequestsError;
import com.cohere.api.errors.CohereApiUnauthorizedError;
import com.cohere.api.errors.CohereApiUnprocessableEntityError;
import com.cohere.api.resources.models.requests.ModelsListRequest;
import com.cohere.api.types.ClientClosedRequestErrorBody;
import com.cohere.api.types.GatewayTimeoutErrorBody;
import com.cohere.api.types.GetModelResponse;
import com.cohere.api.types.ListModelsResponse;
import com.cohere.api.types.NotImplementedErrorBody;
import com.cohere.api.types.TooManyRequestsErrorBody;
import com.cohere.api.types.UnprocessableEntityErrorBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ModelsClient {
    protected final ClientOptions clientOptions;

    public ModelsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public GetModelResponse get(String model) {
        return this.get(model, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetModelResponse get(String model, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/models").addPathSegment(model).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetModelResponse getModelResponse = (GetModelResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetModelResponse.class);
                return getModelResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public ListModelsResponse list() {
        return this.list(ModelsListRequest.builder().build());
    }

    public ListModelsResponse list(ModelsListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListModelsResponse list(ModelsListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v1/models");
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getPageToken().isPresent()) {
            httpUrl.addQueryParameter("page_token", request.getPageToken().get());
        }
        if (request.getEndpoint().isPresent()) {
            httpUrl.addQueryParameter("endpoint", request.getEndpoint().get().toString());
        }
        if (request.getDefaultOnly().isPresent()) {
            httpUrl.addQueryParameter("default_only", request.getDefaultOnly().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListModelsResponse listModelsResponse = (ListModelsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListModelsResponse.class);
                return listModelsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }
}

