/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.models.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CompatibleEndpoint;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ModelsListRequest {
    private final Optional<Double> pageSize;
    private final Optional<String> pageToken;
    private final Optional<CompatibleEndpoint> endpoint;
    private final Optional<Boolean> defaultOnly;
    private final Map<String, Object> additionalProperties;

    private ModelsListRequest(Optional<Double> pageSize, Optional<String> pageToken, Optional<CompatibleEndpoint> endpoint, Optional<Boolean> defaultOnly, Map<String, Object> additionalProperties) {
        this.pageSize = pageSize;
        this.pageToken = pageToken;
        this.endpoint = endpoint;
        this.defaultOnly = defaultOnly;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page_size")
    public Optional<Double> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_token")
    public Optional<String> getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="endpoint")
    public Optional<CompatibleEndpoint> getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="default_only")
    public Optional<Boolean> getDefaultOnly() {
        return this.defaultOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ModelsListRequest && this.equalTo((ModelsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ModelsListRequest other) {
        return this.pageSize.equals(other.pageSize) && this.pageToken.equals(other.pageToken) && this.endpoint.equals(other.endpoint) && this.defaultOnly.equals(other.defaultOnly);
    }

    public int hashCode() {
        return Objects.hash(this.pageSize, this.pageToken, this.endpoint, this.defaultOnly);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> pageSize = Optional.empty();
        private Optional<String> pageToken = Optional.empty();
        private Optional<CompatibleEndpoint> endpoint = Optional.empty();
        private Optional<Boolean> defaultOnly = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ModelsListRequest other) {
            this.pageSize(other.getPageSize());
            this.pageToken(other.getPageToken());
            this.endpoint(other.getEndpoint());
            this.defaultOnly(other.getDefaultOnly());
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Double> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Double pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="page_token", nulls=Nulls.SKIP)
        public Builder pageToken(Optional<String> pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = Optional.of(pageToken);
            return this;
        }

        @JsonSetter(value="endpoint", nulls=Nulls.SKIP)
        public Builder endpoint(Optional<CompatibleEndpoint> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(CompatibleEndpoint endpoint) {
            this.endpoint = Optional.of(endpoint);
            return this;
        }

        @JsonSetter(value="default_only", nulls=Nulls.SKIP)
        public Builder defaultOnly(Optional<Boolean> defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = Optional.of(defaultOnly);
            return this;
        }

        public ModelsListRequest build() {
            return new ModelsListRequest(this.pageSize, this.pageToken, this.endpoint, this.defaultOnly, this.additionalProperties);
        }
    }
}

