/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.CohereApiApiError;
import com.cohere.api.core.CohereApiError;
import com.cohere.api.core.MediaTypes;
import com.cohere.api.core.ObjectMappers;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.Stream;
import com.cohere.api.errors.CohereApiBadRequestError;
import com.cohere.api.errors.CohereApiClientClosedRequestError;
import com.cohere.api.errors.CohereApiForbiddenError;
import com.cohere.api.errors.CohereApiGatewayTimeoutError;
import com.cohere.api.errors.CohereApiInternalServerError;
import com.cohere.api.errors.CohereApiNotFoundError;
import com.cohere.api.errors.CohereApiNotImplementedError;
import com.cohere.api.errors.CohereApiServiceUnavailableError;
import com.cohere.api.errors.CohereApiTooManyRequestsError;
import com.cohere.api.errors.CohereApiUnauthorizedError;
import com.cohere.api.errors.CohereApiUnprocessableEntityError;
import com.cohere.api.resources.v2.requests.V2ChatRequest;
import com.cohere.api.resources.v2.requests.V2ChatStreamRequest;
import com.cohere.api.resources.v2.requests.V2EmbedRequest;
import com.cohere.api.resources.v2.requests.V2RerankRequest;
import com.cohere.api.resources.v2.types.V2RerankResponse;
import com.cohere.api.types.ChatResponse;
import com.cohere.api.types.ClientClosedRequestErrorBody;
import com.cohere.api.types.EmbedByTypeResponse;
import com.cohere.api.types.GatewayTimeoutErrorBody;
import com.cohere.api.types.NotImplementedErrorBody;
import com.cohere.api.types.StreamedChatResponseV2;
import com.cohere.api.types.TooManyRequestsErrorBody;
import com.cohere.api.types.UnprocessableEntityErrorBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class V2Client {
    protected final ClientOptions clientOptions;

    public V2Client(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public Iterable<StreamedChatResponseV2> chatStream(V2ChatStreamRequest request) {
        return this.chatStream(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<StreamedChatResponseV2> chatStream(V2ChatStreamRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/chat").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Stream<StreamedChatResponseV2> stream = new Stream<StreamedChatResponseV2>(StreamedChatResponseV2.class, responseBody.charStream(), "\n");
                return stream;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public ChatResponse chat(V2ChatRequest request) {
        return this.chat(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChatResponse chat(V2ChatRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/chat").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ChatResponse chatResponse = (ChatResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ChatResponse.class);
                return chatResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public EmbedByTypeResponse embed(V2EmbedRequest request) {
        return this.embed(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbedByTypeResponse embed(V2EmbedRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/embed").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                EmbedByTypeResponse embedByTypeResponse = (EmbedByTypeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), EmbedByTypeResponse.class);
                return embedByTypeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }

    public V2RerankResponse rerank(V2RerankRequest request) {
        return this.rerank(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V2RerankResponse rerank(V2RerankRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/rerank").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new CohereApiError("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                V2RerankResponse v2RerankResponse = (V2RerankResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), V2RerankResponse.class);
                return v2RerankResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new CohereApiBadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new CohereApiUnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new CohereApiForbiddenError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new CohereApiNotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 422: {
                        throw new CohereApiUnprocessableEntityError((UnprocessableEntityErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UnprocessableEntityErrorBody.class));
                    }
                    case 429: {
                        throw new CohereApiTooManyRequestsError((TooManyRequestsErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TooManyRequestsErrorBody.class));
                    }
                    case 499: {
                        throw new CohereApiClientClosedRequestError((ClientClosedRequestErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ClientClosedRequestErrorBody.class));
                    }
                    case 500: {
                        throw new CohereApiInternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 501: {
                        throw new CohereApiNotImplementedError((NotImplementedErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, NotImplementedErrorBody.class));
                    }
                    case 503: {
                        throw new CohereApiServiceUnavailableError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 504: {
                        throw new CohereApiGatewayTimeoutError((GatewayTimeoutErrorBody)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, GatewayTimeoutErrorBody.class));
                    }
                }
                throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new CohereApiApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new CohereApiError("Network error executing HTTP request", e);
        }
    }
}

