/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.v2.types.V2ChatRequestDocumentsItem;
import com.cohere.api.resources.v2.types.V2ChatRequestSafetyMode;
import com.cohere.api.types.ChatMessageV2;
import com.cohere.api.types.CitationOptions;
import com.cohere.api.types.ResponseFormatV2;
import com.cohere.api.types.ToolV2;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class V2ChatRequest {
    private final String model;
    private final List<ChatMessageV2> messages;
    private final Optional<List<ToolV2>> tools;
    private final Optional<List<V2ChatRequestDocumentsItem>> documents;
    private final Optional<CitationOptions> citationOptions;
    private final Optional<ResponseFormatV2> responseFormat;
    private final Optional<V2ChatRequestSafetyMode> safetyMode;
    private final Optional<Integer> maxTokens;
    private final Optional<List<String>> stopSequences;
    private final Optional<Double> temperature;
    private final Optional<Integer> seed;
    private final Optional<Double> frequencyPenalty;
    private final Optional<Double> presencePenalty;
    private final Optional<Double> k;
    private final Optional<Double> p;
    private final Optional<Boolean> returnPrompt;
    private final Optional<Boolean> logprobs;
    private final Map<String, Object> additionalProperties;

    private V2ChatRequest(String model, List<ChatMessageV2> messages, Optional<List<ToolV2>> tools, Optional<List<V2ChatRequestDocumentsItem>> documents, Optional<CitationOptions> citationOptions, Optional<ResponseFormatV2> responseFormat, Optional<V2ChatRequestSafetyMode> safetyMode, Optional<Integer> maxTokens, Optional<List<String>> stopSequences, Optional<Double> temperature, Optional<Integer> seed, Optional<Double> frequencyPenalty, Optional<Double> presencePenalty, Optional<Double> k, Optional<Double> p, Optional<Boolean> returnPrompt, Optional<Boolean> logprobs, Map<String, Object> additionalProperties) {
        this.model = model;
        this.messages = messages;
        this.tools = tools;
        this.documents = documents;
        this.citationOptions = citationOptions;
        this.responseFormat = responseFormat;
        this.safetyMode = safetyMode;
        this.maxTokens = maxTokens;
        this.stopSequences = stopSequences;
        this.temperature = temperature;
        this.seed = seed;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.k = k;
        this.p = p;
        this.returnPrompt = returnPrompt;
        this.logprobs = logprobs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="messages")
    public List<ChatMessageV2> getMessages() {
        return this.messages;
    }

    @JsonProperty(value="tools")
    public Optional<List<ToolV2>> getTools() {
        return this.tools;
    }

    @JsonProperty(value="documents")
    public Optional<List<V2ChatRequestDocumentsItem>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="citation_options")
    public Optional<CitationOptions> getCitationOptions() {
        return this.citationOptions;
    }

    @JsonProperty(value="response_format")
    public Optional<ResponseFormatV2> getResponseFormat() {
        return this.responseFormat;
    }

    @JsonProperty(value="safety_mode")
    public Optional<V2ChatRequestSafetyMode> getSafetyMode() {
        return this.safetyMode;
    }

    @JsonProperty(value="max_tokens")
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="stop_sequences")
    public Optional<List<String>> getStopSequences() {
        return this.stopSequences;
    }

    @JsonProperty(value="temperature")
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @JsonProperty(value="seed")
    public Optional<Integer> getSeed() {
        return this.seed;
    }

    @JsonProperty(value="frequency_penalty")
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="k")
    public Optional<Double> getK() {
        return this.k;
    }

    @JsonProperty(value="p")
    public Optional<Double> getP() {
        return this.p;
    }

    @JsonProperty(value="return_prompt")
    public Optional<Boolean> getReturnPrompt() {
        return this.returnPrompt;
    }

    @JsonProperty(value="logprobs")
    public Optional<Boolean> getLogprobs() {
        return this.logprobs;
    }

    @JsonProperty(value="stream")
    public Boolean getStream() {
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2ChatRequest && this.equalTo((V2ChatRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2ChatRequest other) {
        return this.model.equals(other.model) && this.messages.equals(other.messages) && this.tools.equals(other.tools) && this.documents.equals(other.documents) && this.citationOptions.equals(other.citationOptions) && this.responseFormat.equals(other.responseFormat) && this.safetyMode.equals(other.safetyMode) && this.maxTokens.equals(other.maxTokens) && this.stopSequences.equals(other.stopSequences) && this.temperature.equals(other.temperature) && this.seed.equals(other.seed) && this.frequencyPenalty.equals(other.frequencyPenalty) && this.presencePenalty.equals(other.presencePenalty) && this.k.equals(other.k) && this.p.equals(other.p) && this.returnPrompt.equals(other.returnPrompt) && this.logprobs.equals(other.logprobs);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.messages, this.tools, this.documents, this.citationOptions, this.responseFormat, this.safetyMode, this.maxTokens, this.stopSequences, this.temperature, this.seed, this.frequencyPenalty, this.presencePenalty, this.k, this.p, this.returnPrompt, this.logprobs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    _FinalStage {
        private String model;
        private Optional<Boolean> logprobs = Optional.empty();
        private Optional<Boolean> returnPrompt = Optional.empty();
        private Optional<Double> p = Optional.empty();
        private Optional<Double> k = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private Optional<Integer> seed = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<List<String>> stopSequences = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<V2ChatRequestSafetyMode> safetyMode = Optional.empty();
        private Optional<ResponseFormatV2> responseFormat = Optional.empty();
        private Optional<CitationOptions> citationOptions = Optional.empty();
        private Optional<List<V2ChatRequestDocumentsItem>> documents = Optional.empty();
        private Optional<List<ToolV2>> tools = Optional.empty();
        private List<ChatMessageV2> messages = new ArrayList<ChatMessageV2>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2ChatRequest other) {
            this.model(other.getModel());
            this.messages(other.getMessages());
            this.tools(other.getTools());
            this.documents(other.getDocuments());
            this.citationOptions(other.getCitationOptions());
            this.responseFormat(other.getResponseFormat());
            this.safetyMode(other.getSafetyMode());
            this.maxTokens(other.getMaxTokens());
            this.stopSequences(other.getStopSequences());
            this.temperature(other.getTemperature());
            this.seed(other.getSeed());
            this.frequencyPenalty(other.getFrequencyPenalty());
            this.presencePenalty(other.getPresencePenalty());
            this.k(other.getK());
            this.p(other.getP());
            this.returnPrompt(other.getReturnPrompt());
            this.logprobs(other.getLogprobs());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage logprobs(Boolean logprobs) {
            this.logprobs = Optional.of(logprobs);
            return this;
        }

        @Override
        @JsonSetter(value="logprobs", nulls=Nulls.SKIP)
        public _FinalStage logprobs(Optional<Boolean> logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @Override
        public _FinalStage returnPrompt(Boolean returnPrompt) {
            this.returnPrompt = Optional.of(returnPrompt);
            return this;
        }

        @Override
        @JsonSetter(value="return_prompt", nulls=Nulls.SKIP)
        public _FinalStage returnPrompt(Optional<Boolean> returnPrompt) {
            this.returnPrompt = returnPrompt;
            return this;
        }

        @Override
        public _FinalStage p(Double p) {
            this.p = Optional.of(p);
            return this;
        }

        @Override
        @JsonSetter(value="p", nulls=Nulls.SKIP)
        public _FinalStage p(Optional<Double> p) {
            this.p = p;
            return this;
        }

        @Override
        public _FinalStage k(Double k) {
            this.k = Optional.of(k);
            return this;
        }

        @Override
        @JsonSetter(value="k", nulls=Nulls.SKIP)
        public _FinalStage k(Optional<Double> k) {
            this.k = k;
            return this;
        }

        @Override
        public _FinalStage presencePenalty(Double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        @Override
        @JsonSetter(value="presence_penalty", nulls=Nulls.SKIP)
        public _FinalStage presencePenalty(Optional<Double> presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Override
        public _FinalStage frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        @Override
        @JsonSetter(value="frequency_penalty", nulls=Nulls.SKIP)
        public _FinalStage frequencyPenalty(Optional<Double> frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Override
        public _FinalStage seed(Integer seed) {
            this.seed = Optional.of(seed);
            return this;
        }

        @Override
        @JsonSetter(value="seed", nulls=Nulls.SKIP)
        public _FinalStage seed(Optional<Integer> seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public _FinalStage stopSequences(List<String> stopSequences) {
            this.stopSequences = Optional.of(stopSequences);
            return this;
        }

        @Override
        @JsonSetter(value="stop_sequences", nulls=Nulls.SKIP)
        public _FinalStage stopSequences(Optional<List<String>> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public _FinalStage maxTokens(Integer maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxTokens(Optional<Integer> maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public _FinalStage safetyMode(V2ChatRequestSafetyMode safetyMode) {
            this.safetyMode = Optional.of(safetyMode);
            return this;
        }

        @Override
        @JsonSetter(value="safety_mode", nulls=Nulls.SKIP)
        public _FinalStage safetyMode(Optional<V2ChatRequestSafetyMode> safetyMode) {
            this.safetyMode = safetyMode;
            return this;
        }

        @Override
        public _FinalStage responseFormat(ResponseFormatV2 responseFormat) {
            this.responseFormat = Optional.of(responseFormat);
            return this;
        }

        @Override
        @JsonSetter(value="response_format", nulls=Nulls.SKIP)
        public _FinalStage responseFormat(Optional<ResponseFormatV2> responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Override
        public _FinalStage citationOptions(CitationOptions citationOptions) {
            this.citationOptions = Optional.of(citationOptions);
            return this;
        }

        @Override
        @JsonSetter(value="citation_options", nulls=Nulls.SKIP)
        public _FinalStage citationOptions(Optional<CitationOptions> citationOptions) {
            this.citationOptions = citationOptions;
            return this;
        }

        @Override
        public _FinalStage documents(List<V2ChatRequestDocumentsItem> documents) {
            this.documents = Optional.of(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<V2ChatRequestDocumentsItem>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage tools(List<ToolV2> tools) {
            this.tools = Optional.of(tools);
            return this;
        }

        @Override
        @JsonSetter(value="tools", nulls=Nulls.SKIP)
        public _FinalStage tools(Optional<List<ToolV2>> tools) {
            this.tools = tools;
            return this;
        }

        @Override
        public _FinalStage addAllMessages(List<ChatMessageV2> messages) {
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public _FinalStage addMessages(ChatMessageV2 messages) {
            this.messages.add(messages);
            return this;
        }

        @Override
        @JsonSetter(value="messages", nulls=Nulls.SKIP)
        public _FinalStage messages(List<ChatMessageV2> messages) {
            this.messages.clear();
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public V2ChatRequest build() {
            return new V2ChatRequest(this.model, this.messages, this.tools, this.documents, this.citationOptions, this.responseFormat, this.safetyMode, this.maxTokens, this.stopSequences, this.temperature, this.seed, this.frequencyPenalty, this.presencePenalty, this.k, this.p, this.returnPrompt, this.logprobs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2ChatRequest build();

        public _FinalStage messages(List<ChatMessageV2> var1);

        public _FinalStage addMessages(ChatMessageV2 var1);

        public _FinalStage addAllMessages(List<ChatMessageV2> var1);

        public _FinalStage tools(Optional<List<ToolV2>> var1);

        public _FinalStage tools(List<ToolV2> var1);

        public _FinalStage documents(Optional<List<V2ChatRequestDocumentsItem>> var1);

        public _FinalStage documents(List<V2ChatRequestDocumentsItem> var1);

        public _FinalStage citationOptions(Optional<CitationOptions> var1);

        public _FinalStage citationOptions(CitationOptions var1);

        public _FinalStage responseFormat(Optional<ResponseFormatV2> var1);

        public _FinalStage responseFormat(ResponseFormatV2 var1);

        public _FinalStage safetyMode(Optional<V2ChatRequestSafetyMode> var1);

        public _FinalStage safetyMode(V2ChatRequestSafetyMode var1);

        public _FinalStage maxTokens(Optional<Integer> var1);

        public _FinalStage maxTokens(Integer var1);

        public _FinalStage stopSequences(Optional<List<String>> var1);

        public _FinalStage stopSequences(List<String> var1);

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);

        public _FinalStage seed(Optional<Integer> var1);

        public _FinalStage seed(Integer var1);

        public _FinalStage frequencyPenalty(Optional<Double> var1);

        public _FinalStage frequencyPenalty(Double var1);

        public _FinalStage presencePenalty(Optional<Double> var1);

        public _FinalStage presencePenalty(Double var1);

        public _FinalStage k(Optional<Double> var1);

        public _FinalStage k(Double var1);

        public _FinalStage p(Optional<Double> var1);

        public _FinalStage p(Double var1);

        public _FinalStage returnPrompt(Optional<Boolean> var1);

        public _FinalStage returnPrompt(Boolean var1);

        public _FinalStage logprobs(Optional<Boolean> var1);

        public _FinalStage logprobs(Boolean var1);
    }

    public static interface ModelStage {
        public _FinalStage model(String var1);

        public Builder from(V2ChatRequest var1);
    }
}

