/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.v2.types.V2EmbedRequestTruncate;
import com.cohere.api.types.EmbedInputType;
import com.cohere.api.types.EmbeddingType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class V2EmbedRequest {
    private final Optional<List<String>> texts;
    private final Optional<List<String>> images;
    private final String model;
    private final EmbedInputType inputType;
    private final List<EmbeddingType> embeddingTypes;
    private final Optional<V2EmbedRequestTruncate> truncate;
    private final Map<String, Object> additionalProperties;

    private V2EmbedRequest(Optional<List<String>> texts, Optional<List<String>> images, String model, EmbedInputType inputType, List<EmbeddingType> embeddingTypes, Optional<V2EmbedRequestTruncate> truncate, Map<String, Object> additionalProperties) {
        this.texts = texts;
        this.images = images;
        this.model = model;
        this.inputType = inputType;
        this.embeddingTypes = embeddingTypes;
        this.truncate = truncate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="texts")
    public Optional<List<String>> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="images")
    public Optional<List<String>> getImages() {
        return this.images;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="input_type")
    public EmbedInputType getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="embedding_types")
    public List<EmbeddingType> getEmbeddingTypes() {
        return this.embeddingTypes;
    }

    @JsonProperty(value="truncate")
    public Optional<V2EmbedRequestTruncate> getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2EmbedRequest && this.equalTo((V2EmbedRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2EmbedRequest other) {
        return this.texts.equals(other.texts) && this.images.equals(other.images) && this.model.equals(other.model) && this.inputType.equals((Object)other.inputType) && this.embeddingTypes.equals(other.embeddingTypes) && this.truncate.equals(other.truncate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.texts, this.images, this.model, this.inputType, this.embeddingTypes, this.truncate});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    InputTypeStage,
    _FinalStage {
        private String model;
        private EmbedInputType inputType;
        private Optional<V2EmbedRequestTruncate> truncate = Optional.empty();
        private List<EmbeddingType> embeddingTypes = new ArrayList<EmbeddingType>();
        private Optional<List<String>> images = Optional.empty();
        private Optional<List<String>> texts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2EmbedRequest other) {
            this.texts(other.getTexts());
            this.images(other.getImages());
            this.model(other.getModel());
            this.inputType(other.getInputType());
            this.embeddingTypes(other.getEmbeddingTypes());
            this.truncate(other.getTruncate());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public InputTypeStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        @JsonSetter(value="input_type")
        public _FinalStage inputType(EmbedInputType inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public _FinalStage truncate(V2EmbedRequestTruncate truncate) {
            this.truncate = Optional.of(truncate);
            return this;
        }

        @Override
        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public _FinalStage truncate(Optional<V2EmbedRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        @Override
        public _FinalStage addAllEmbeddingTypes(List<EmbeddingType> embeddingTypes) {
            this.embeddingTypes.addAll(embeddingTypes);
            return this;
        }

        @Override
        public _FinalStage addEmbeddingTypes(EmbeddingType embeddingTypes) {
            this.embeddingTypes.add(embeddingTypes);
            return this;
        }

        @Override
        @JsonSetter(value="embedding_types", nulls=Nulls.SKIP)
        public _FinalStage embeddingTypes(List<EmbeddingType> embeddingTypes) {
            this.embeddingTypes.clear();
            this.embeddingTypes.addAll(embeddingTypes);
            return this;
        }

        @Override
        public _FinalStage images(List<String> images) {
            this.images = Optional.of(images);
            return this;
        }

        @Override
        @JsonSetter(value="images", nulls=Nulls.SKIP)
        public _FinalStage images(Optional<List<String>> images) {
            this.images = images;
            return this;
        }

        @Override
        public _FinalStage texts(List<String> texts) {
            this.texts = Optional.of(texts);
            return this;
        }

        @Override
        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public _FinalStage texts(Optional<List<String>> texts) {
            this.texts = texts;
            return this;
        }

        @Override
        public V2EmbedRequest build() {
            return new V2EmbedRequest(this.texts, this.images, this.model, this.inputType, this.embeddingTypes, this.truncate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2EmbedRequest build();

        public _FinalStage texts(Optional<List<String>> var1);

        public _FinalStage texts(List<String> var1);

        public _FinalStage images(Optional<List<String>> var1);

        public _FinalStage images(List<String> var1);

        public _FinalStage embeddingTypes(List<EmbeddingType> var1);

        public _FinalStage addEmbeddingTypes(EmbeddingType var1);

        public _FinalStage addAllEmbeddingTypes(List<EmbeddingType> var1);

        public _FinalStage truncate(Optional<V2EmbedRequestTruncate> var1);

        public _FinalStage truncate(V2EmbedRequestTruncate var1);
    }

    public static interface InputTypeStage {
        public _FinalStage inputType(EmbedInputType var1);
    }

    public static interface ModelStage {
        public InputTypeStage model(String var1);

        public Builder from(V2EmbedRequest var1);
    }
}

