/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.v2.types.V2RerankRequestDocumentsItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class V2RerankRequest {
    private final String model;
    private final String query;
    private final List<V2RerankRequestDocumentsItem> documents;
    private final Optional<Integer> topN;
    private final Optional<List<String>> rankFields;
    private final Optional<Boolean> returnDocuments;
    private final Optional<Integer> maxChunksPerDoc;
    private final Map<String, Object> additionalProperties;

    private V2RerankRequest(String model, String query, List<V2RerankRequestDocumentsItem> documents, Optional<Integer> topN, Optional<List<String>> rankFields, Optional<Boolean> returnDocuments, Optional<Integer> maxChunksPerDoc, Map<String, Object> additionalProperties) {
        this.model = model;
        this.query = query;
        this.documents = documents;
        this.topN = topN;
        this.rankFields = rankFields;
        this.returnDocuments = returnDocuments;
        this.maxChunksPerDoc = maxChunksPerDoc;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="documents")
    public List<V2RerankRequestDocumentsItem> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="top_n")
    public Optional<Integer> getTopN() {
        return this.topN;
    }

    @JsonProperty(value="rank_fields")
    public Optional<List<String>> getRankFields() {
        return this.rankFields;
    }

    @JsonProperty(value="return_documents")
    public Optional<Boolean> getReturnDocuments() {
        return this.returnDocuments;
    }

    @JsonProperty(value="max_chunks_per_doc")
    public Optional<Integer> getMaxChunksPerDoc() {
        return this.maxChunksPerDoc;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2RerankRequest && this.equalTo((V2RerankRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2RerankRequest other) {
        return this.model.equals(other.model) && this.query.equals(other.query) && this.documents.equals(other.documents) && this.topN.equals(other.topN) && this.rankFields.equals(other.rankFields) && this.returnDocuments.equals(other.returnDocuments) && this.maxChunksPerDoc.equals(other.maxChunksPerDoc);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.query, this.documents, this.topN, this.rankFields, this.returnDocuments, this.maxChunksPerDoc);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    QueryStage,
    _FinalStage {
        private String model;
        private String query;
        private Optional<Integer> maxChunksPerDoc = Optional.empty();
        private Optional<Boolean> returnDocuments = Optional.empty();
        private Optional<List<String>> rankFields = Optional.empty();
        private Optional<Integer> topN = Optional.empty();
        private List<V2RerankRequestDocumentsItem> documents = new ArrayList<V2RerankRequestDocumentsItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2RerankRequest other) {
            this.model(other.getModel());
            this.query(other.getQuery());
            this.documents(other.getDocuments());
            this.topN(other.getTopN());
            this.rankFields(other.getRankFields());
            this.returnDocuments(other.getReturnDocuments());
            this.maxChunksPerDoc(other.getMaxChunksPerDoc());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public QueryStage model(String model) {
            this.model = model;
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(String query) {
            this.query = query;
            return this;
        }

        @Override
        public _FinalStage maxChunksPerDoc(Integer maxChunksPerDoc) {
            this.maxChunksPerDoc = Optional.of(maxChunksPerDoc);
            return this;
        }

        @Override
        @JsonSetter(value="max_chunks_per_doc", nulls=Nulls.SKIP)
        public _FinalStage maxChunksPerDoc(Optional<Integer> maxChunksPerDoc) {
            this.maxChunksPerDoc = maxChunksPerDoc;
            return this;
        }

        @Override
        public _FinalStage returnDocuments(Boolean returnDocuments) {
            this.returnDocuments = Optional.of(returnDocuments);
            return this;
        }

        @Override
        @JsonSetter(value="return_documents", nulls=Nulls.SKIP)
        public _FinalStage returnDocuments(Optional<Boolean> returnDocuments) {
            this.returnDocuments = returnDocuments;
            return this;
        }

        @Override
        public _FinalStage rankFields(List<String> rankFields) {
            this.rankFields = Optional.of(rankFields);
            return this;
        }

        @Override
        @JsonSetter(value="rank_fields", nulls=Nulls.SKIP)
        public _FinalStage rankFields(Optional<List<String>> rankFields) {
            this.rankFields = rankFields;
            return this;
        }

        @Override
        public _FinalStage topN(Integer topN) {
            this.topN = Optional.of(topN);
            return this;
        }

        @Override
        @JsonSetter(value="top_n", nulls=Nulls.SKIP)
        public _FinalStage topN(Optional<Integer> topN) {
            this.topN = topN;
            return this;
        }

        @Override
        public _FinalStage addAllDocuments(List<V2RerankRequestDocumentsItem> documents) {
            this.documents.addAll(documents);
            return this;
        }

        @Override
        public _FinalStage addDocuments(V2RerankRequestDocumentsItem documents) {
            this.documents.add(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(List<V2RerankRequestDocumentsItem> documents) {
            this.documents.clear();
            this.documents.addAll(documents);
            return this;
        }

        @Override
        public V2RerankRequest build() {
            return new V2RerankRequest(this.model, this.query, this.documents, this.topN, this.rankFields, this.returnDocuments, this.maxChunksPerDoc, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2RerankRequest build();

        public _FinalStage documents(List<V2RerankRequestDocumentsItem> var1);

        public _FinalStage addDocuments(V2RerankRequestDocumentsItem var1);

        public _FinalStage addAllDocuments(List<V2RerankRequestDocumentsItem> var1);

        public _FinalStage topN(Optional<Integer> var1);

        public _FinalStage topN(Integer var1);

        public _FinalStage rankFields(Optional<List<String>> var1);

        public _FinalStage rankFields(List<String> var1);

        public _FinalStage returnDocuments(Optional<Boolean> var1);

        public _FinalStage returnDocuments(Boolean var1);

        public _FinalStage maxChunksPerDoc(Optional<Integer> var1);

        public _FinalStage maxChunksPerDoc(Integer var1);
    }

    public static interface QueryStage {
        public _FinalStage query(String var1);
    }

    public static interface ModelStage {
        public QueryStage model(String var1);

        public Builder from(V2RerankRequest var1);
    }
}

