/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMetaApiVersion;
import com.cohere.api.types.ApiMetaBilledUnits;
import com.cohere.api.types.ApiMetaTokens;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ApiMeta {
    private final Optional<ApiMetaApiVersion> apiVersion;
    private final Optional<ApiMetaBilledUnits> billedUnits;
    private final Optional<ApiMetaTokens> tokens;
    private final Optional<List<String>> warnings;
    private final Map<String, Object> additionalProperties;

    private ApiMeta(Optional<ApiMetaApiVersion> apiVersion, Optional<ApiMetaBilledUnits> billedUnits, Optional<ApiMetaTokens> tokens, Optional<List<String>> warnings, Map<String, Object> additionalProperties) {
        this.apiVersion = apiVersion;
        this.billedUnits = billedUnits;
        this.tokens = tokens;
        this.warnings = warnings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="api_version")
    public Optional<ApiMetaApiVersion> getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="billed_units")
    public Optional<ApiMetaBilledUnits> getBilledUnits() {
        return this.billedUnits;
    }

    @JsonProperty(value="tokens")
    public Optional<ApiMetaTokens> getTokens() {
        return this.tokens;
    }

    @JsonProperty(value="warnings")
    public Optional<List<String>> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiMeta && this.equalTo((ApiMeta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiMeta other) {
        return this.apiVersion.equals(other.apiVersion) && this.billedUnits.equals(other.billedUnits) && this.tokens.equals(other.tokens) && this.warnings.equals(other.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.billedUnits, this.tokens, this.warnings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ApiMetaApiVersion> apiVersion = Optional.empty();
        private Optional<ApiMetaBilledUnits> billedUnits = Optional.empty();
        private Optional<ApiMetaTokens> tokens = Optional.empty();
        private Optional<List<String>> warnings = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ApiMeta other) {
            this.apiVersion(other.getApiVersion());
            this.billedUnits(other.getBilledUnits());
            this.tokens(other.getTokens());
            this.warnings(other.getWarnings());
            return this;
        }

        @JsonSetter(value="api_version", nulls=Nulls.SKIP)
        public Builder apiVersion(Optional<ApiMetaApiVersion> apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(ApiMetaApiVersion apiVersion) {
            this.apiVersion = Optional.of(apiVersion);
            return this;
        }

        @JsonSetter(value="billed_units", nulls=Nulls.SKIP)
        public Builder billedUnits(Optional<ApiMetaBilledUnits> billedUnits) {
            this.billedUnits = billedUnits;
            return this;
        }

        public Builder billedUnits(ApiMetaBilledUnits billedUnits) {
            this.billedUnits = Optional.of(billedUnits);
            return this;
        }

        @JsonSetter(value="tokens", nulls=Nulls.SKIP)
        public Builder tokens(Optional<ApiMetaTokens> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Builder tokens(ApiMetaTokens tokens) {
            this.tokens = Optional.of(tokens);
            return this;
        }

        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public Builder warnings(Optional<List<String>> warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder warnings(List<String> warnings) {
            this.warnings = Optional.of(warnings);
            return this;
        }

        public ApiMeta build() {
            return new ApiMeta(this.apiVersion, this.billedUnits, this.tokens, this.warnings, this.additionalProperties);
        }
    }
}

