/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.AssistantMessageContentItem;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class AssistantMessageContent {
    private final Object value;
    private final int type;

    private AssistantMessageContent(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((List)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AssistantMessageContent && this.equalTo((AssistantMessageContent)other);
    }

    private boolean equalTo(AssistantMessageContent other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static AssistantMessageContent of(String value) {
        return new AssistantMessageContent(value, 0);
    }

    public static AssistantMessageContent of(List<AssistantMessageContentItem> value) {
        return new AssistantMessageContent(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<AssistantMessageContent> {
        Deserializer() {
            super(AssistantMessageContent.class);
        }

        public AssistantMessageContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return AssistantMessageContent.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return AssistantMessageContent.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<AssistantMessageContentItem>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(List<AssistantMessageContentItem> var1);
    }
}

