/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatConnector {
    private final String id;
    private final Optional<String> userAccessToken;
    private final Optional<Boolean> continueOnFailure;
    private final Optional<Map<String, Object>> options;
    private final Map<String, Object> additionalProperties;

    private ChatConnector(String id, Optional<String> userAccessToken, Optional<Boolean> continueOnFailure, Optional<Map<String, Object>> options, Map<String, Object> additionalProperties) {
        this.id = id;
        this.userAccessToken = userAccessToken;
        this.continueOnFailure = continueOnFailure;
        this.options = options;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="user_access_token")
    public Optional<String> getUserAccessToken() {
        return this.userAccessToken;
    }

    @JsonProperty(value="continue_on_failure")
    public Optional<Boolean> getContinueOnFailure() {
        return this.continueOnFailure;
    }

    @JsonProperty(value="options")
    public Optional<Map<String, Object>> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatConnector && this.equalTo((ChatConnector)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatConnector other) {
        return this.id.equals(other.id) && this.userAccessToken.equals(other.userAccessToken) && this.continueOnFailure.equals(other.continueOnFailure) && this.options.equals(other.options);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userAccessToken, this.continueOnFailure, this.options);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Map<String, Object>> options = Optional.empty();
        private Optional<Boolean> continueOnFailure = Optional.empty();
        private Optional<String> userAccessToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatConnector other) {
            this.id(other.getId());
            this.userAccessToken(other.getUserAccessToken());
            this.continueOnFailure(other.getContinueOnFailure());
            this.options(other.getOptions());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage options(Map<String, Object> options) {
            this.options = Optional.of(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(Optional<Map<String, Object>> options) {
            this.options = options;
            return this;
        }

        @Override
        public _FinalStage continueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = Optional.of(continueOnFailure);
            return this;
        }

        @Override
        @JsonSetter(value="continue_on_failure", nulls=Nulls.SKIP)
        public _FinalStage continueOnFailure(Optional<Boolean> continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        @Override
        public _FinalStage userAccessToken(String userAccessToken) {
            this.userAccessToken = Optional.of(userAccessToken);
            return this;
        }

        @Override
        @JsonSetter(value="user_access_token", nulls=Nulls.SKIP)
        public _FinalStage userAccessToken(Optional<String> userAccessToken) {
            this.userAccessToken = userAccessToken;
            return this;
        }

        @Override
        public ChatConnector build() {
            return new ChatConnector(this.id, this.userAccessToken, this.continueOnFailure, this.options, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatConnector build();

        public _FinalStage userAccessToken(Optional<String> var1);

        public _FinalStage userAccessToken(String var1);

        public _FinalStage continueOnFailure(Optional<Boolean> var1);

        public _FinalStage continueOnFailure(Boolean var1);

        public _FinalStage options(Optional<Map<String, Object>> var1);

        public _FinalStage options(Map<String, Object> var1);
    }

    public static interface IdStage {
        public _FinalStage id(String var1);

        public Builder from(ChatConnector var1);
    }
}

