/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.IChatStreamEvent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatDebugEvent
implements IChatStreamEvent {
    private final Optional<String> prompt;
    private final Map<String, Object> additionalProperties;

    private ChatDebugEvent(Optional<String> prompt, Map<String, Object> additionalProperties) {
        this.prompt = prompt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="prompt")
    public Optional<String> getPrompt() {
        return this.prompt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatDebugEvent && this.equalTo((ChatDebugEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatDebugEvent other) {
        return this.prompt.equals(other.prompt);
    }

    public int hashCode() {
        return Objects.hash(this.prompt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> prompt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatDebugEvent other) {
            this.prompt(other.getPrompt());
            return this;
        }

        @JsonSetter(value="prompt", nulls=Nulls.SKIP)
        public Builder prompt(Optional<String> prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder prompt(String prompt) {
            this.prompt = Optional.of(prompt);
            return this;
        }

        public ChatDebugEvent build() {
            return new ChatDebugEvent(this.prompt, this.additionalProperties);
        }
    }
}

