/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolCall;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatMessage {
    private final String message;
    private final Optional<List<ToolCall>> toolCalls;
    private final Map<String, Object> additionalProperties;

    private ChatMessage(String message, Optional<List<ToolCall>> toolCalls, Map<String, Object> additionalProperties) {
        this.message = message;
        this.toolCalls = toolCalls;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="tool_calls")
    public Optional<List<ToolCall>> getToolCalls() {
        return this.toolCalls;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatMessage && this.equalTo((ChatMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatMessage other) {
        return this.message.equals(other.message) && this.toolCalls.equals(other.toolCalls);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.toolCalls);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageStage,
    _FinalStage {
        private String message;
        private Optional<List<ToolCall>> toolCalls = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatMessage other) {
            this.message(other.getMessage());
            this.toolCalls(other.getToolCalls());
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = Optional.of(toolCalls);
            return this;
        }

        @Override
        @JsonSetter(value="tool_calls", nulls=Nulls.SKIP)
        public _FinalStage toolCalls(Optional<List<ToolCall>> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @Override
        public ChatMessage build() {
            return new ChatMessage(this.message, this.toolCalls, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatMessage build();

        public _FinalStage toolCalls(Optional<List<ToolCall>> var1);

        public _FinalStage toolCalls(List<ToolCall> var1);
    }

    public static interface MessageStage {
        public _FinalStage message(String var1);

        public Builder from(ChatMessage var1);
    }
}

