/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatFinishReason;
import com.cohere.api.types.Usage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatMessageEndEventDelta {
    private final Optional<ChatFinishReason> finishReason;
    private final Optional<Usage> usage;
    private final Map<String, Object> additionalProperties;

    private ChatMessageEndEventDelta(Optional<ChatFinishReason> finishReason, Optional<Usage> usage, Map<String, Object> additionalProperties) {
        this.finishReason = finishReason;
        this.usage = usage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="finish_reason")
    public Optional<ChatFinishReason> getFinishReason() {
        return this.finishReason;
    }

    @JsonProperty(value="usage")
    public Optional<Usage> getUsage() {
        return this.usage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatMessageEndEventDelta && this.equalTo((ChatMessageEndEventDelta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatMessageEndEventDelta other) {
        return this.finishReason.equals(other.finishReason) && this.usage.equals(other.usage);
    }

    public int hashCode() {
        return Objects.hash(this.finishReason, this.usage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ChatFinishReason> finishReason = Optional.empty();
        private Optional<Usage> usage = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatMessageEndEventDelta other) {
            this.finishReason(other.getFinishReason());
            this.usage(other.getUsage());
            return this;
        }

        @JsonSetter(value="finish_reason", nulls=Nulls.SKIP)
        public Builder finishReason(Optional<ChatFinishReason> finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public Builder finishReason(ChatFinishReason finishReason) {
            this.finishReason = Optional.of(finishReason);
            return this;
        }

        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public Builder usage(Optional<Usage> usage) {
            this.usage = usage;
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = Optional.of(usage);
            return this;
        }

        public ChatMessageEndEventDelta build() {
            return new ChatMessageEndEventDelta(this.finishReason, this.usage, this.additionalProperties);
        }
    }
}

