/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.AssistantMessageResponse;
import com.cohere.api.types.ChatFinishReason;
import com.cohere.api.types.LogprobItem;
import com.cohere.api.types.Usage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ChatResponse {
    private final String id;
    private final ChatFinishReason finishReason;
    private final Optional<String> prompt;
    private final AssistantMessageResponse message;
    private final Optional<Usage> usage;
    private final Optional<List<LogprobItem>> logprobs;
    private final Map<String, Object> additionalProperties;

    private ChatResponse(String id, ChatFinishReason finishReason, Optional<String> prompt, AssistantMessageResponse message, Optional<Usage> usage, Optional<List<LogprobItem>> logprobs, Map<String, Object> additionalProperties) {
        this.id = id;
        this.finishReason = finishReason;
        this.prompt = prompt;
        this.message = message;
        this.usage = usage;
        this.logprobs = logprobs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="finish_reason")
    public ChatFinishReason getFinishReason() {
        return this.finishReason;
    }

    @JsonProperty(value="prompt")
    public Optional<String> getPrompt() {
        return this.prompt;
    }

    @JsonProperty(value="message")
    public AssistantMessageResponse getMessage() {
        return this.message;
    }

    @JsonProperty(value="usage")
    public Optional<Usage> getUsage() {
        return this.usage;
    }

    @JsonProperty(value="logprobs")
    public Optional<List<LogprobItem>> getLogprobs() {
        return this.logprobs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatResponse && this.equalTo((ChatResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatResponse other) {
        return this.id.equals(other.id) && this.finishReason.equals((Object)other.finishReason) && this.prompt.equals(other.prompt) && this.message.equals(other.message) && this.usage.equals(other.usage) && this.logprobs.equals(other.logprobs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.finishReason, this.prompt, this.message, this.usage, this.logprobs});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    FinishReasonStage,
    MessageStage,
    _FinalStage {
        private String id;
        private ChatFinishReason finishReason;
        private AssistantMessageResponse message;
        private Optional<List<LogprobItem>> logprobs = Optional.empty();
        private Optional<Usage> usage = Optional.empty();
        private Optional<String> prompt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatResponse other) {
            this.id(other.getId());
            this.finishReason(other.getFinishReason());
            this.prompt(other.getPrompt());
            this.message(other.getMessage());
            this.usage(other.getUsage());
            this.logprobs(other.getLogprobs());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public FinishReasonStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="finish_reason")
        public MessageStage finishReason(ChatFinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(AssistantMessageResponse message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage logprobs(List<LogprobItem> logprobs) {
            this.logprobs = Optional.of(logprobs);
            return this;
        }

        @Override
        @JsonSetter(value="logprobs", nulls=Nulls.SKIP)
        public _FinalStage logprobs(Optional<List<LogprobItem>> logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @Override
        public _FinalStage usage(Usage usage) {
            this.usage = Optional.of(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(Optional<Usage> usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public _FinalStage prompt(String prompt) {
            this.prompt = Optional.of(prompt);
            return this;
        }

        @Override
        @JsonSetter(value="prompt", nulls=Nulls.SKIP)
        public _FinalStage prompt(Optional<String> prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public ChatResponse build() {
            return new ChatResponse(this.id, this.finishReason, this.prompt, this.message, this.usage, this.logprobs, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatResponse build();

        public _FinalStage prompt(Optional<String> var1);

        public _FinalStage prompt(String var1);

        public _FinalStage usage(Optional<Usage> var1);

        public _FinalStage usage(Usage var1);

        public _FinalStage logprobs(Optional<List<LogprobItem>> var1);

        public _FinalStage logprobs(List<LogprobItem> var1);
    }

    public static interface MessageStage {
        public _FinalStage message(AssistantMessageResponse var1);
    }

    public static interface FinishReasonStage {
        public MessageStage finishReason(ChatFinishReason var1);
    }

    public static interface IdStage {
        public FinishReasonStage id(String var1);

        public Builder from(ChatResponse var1);
    }
}

